package com.flurry.android;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.inmobi.androidsdk.IMAdInterstitial;
import com.inmobi.androidsdk.IMAdRequest;
import com.inmobi.androidsdk.IMAdView;

/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public final class aa extends AdNetworkView {
    private static boolean e;

    /* JADX INFO: Access modifiers changed from: package-private */
    public aa(Context context, be beVar, bb bbVar, AdCreative adCreative) {
        super(context, beVar, bbVar, adCreative);
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        } catch (PackageManager.NameNotFoundException e2) {
            Log.d("FlurryAgent", "Cannot find manifest for app");
        }
        Bundle bundle = applicationInfo.metaData;
        sAdNetworkApiKey = bundle.getString("com.flurry.inmobi.MY_APP_ID");
        e = bundle.getBoolean("com.flurry.inmobi.test");
        if (sAdNetworkApiKey == null) {
            Log.d("FlurryAgent", "com.flurry.inmobi.MY_APP_ID not set in manifest");
        }
        setFocusable(true);
    }

    @Override // com.flurry.android.o
    public final void initLayout(Context context) {
        int i;
        if (this.fAdCreative.getFormat().equals(AdCreative.kFormatTakeover)) {
            IMAdInterstitial iMAdInterstitial = new IMAdInterstitial((Activity) context, sAdNetworkApiKey);
            iMAdInterstitial.setImAdInterstitialListener(new l(this));
            IMAdRequest iMAdRequest = new IMAdRequest();
            if (e) {
                Log.d("FlurryAgent", "InMobi Interstitial set to Test Mode.");
                iMAdRequest.setTestMode(true);
            }
            iMAdInterstitial.loadNewAd(iMAdRequest);
            return;
        }
        int height = this.fAdCreative.getHeight();
        int width = this.fAdCreative.getWidth();
        if (width >= 728 && height >= 90) {
            Log.d("FlurryAgent", "Determined InMobi AdSize as 728x90");
            i = 11;
        } else if (width >= 468 && height >= 60) {
            Log.d("FlurryAgent", "Determined InMobi AdSize as 468x60");
            i = 12;
        } else if (width >= 320 && height >= 50) {
            Log.d("FlurryAgent", "Determined InMobi AdSize as 320x50");
            i = 15;
        } else if (width >= 300 && height >= 250) {
            Log.d("FlurryAgent", "Determined InMobi AdSize as 300x250");
            i = 10;
        } else if (width < 120 || height < 600) {
            Log.d("FlurryAgent", "Could not find InMobi AdSize that matches size");
            i = -1;
        } else {
            Log.d("FlurryAgent", "Determined InMobi AdSize as 120x600");
            i = 13;
        }
        if (i != -1) {
            IMAdView iMAdView = new IMAdView((Activity) context, i, sAdNetworkApiKey);
            iMAdView.setIMAdListener(new ab(this));
            addView(iMAdView);
            IMAdRequest iMAdRequest2 = new IMAdRequest();
            if (e) {
                Log.d("FlurryAgent", "InMobi AdView set to Test Mode.");
                iMAdRequest2.setTestMode(true);
            }
            iMAdView.setIMAdRequest(iMAdRequest2);
            iMAdView.setRefreshInterval(-1);
            iMAdView.loadNewAd();
            return;
        }
        Log.d("FlurryAgent", "**********Could not load InMobi Ad");
    }
}
