package com.customise.features;

import android.app.Activity;
import android.app.Dialog;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class CustomiseFeature {
    private static CustomiseFeature _instance;
    public Activity _activity;
    private Field _unityPlayerActivityField;
    private Class<?> _unityPlayerClass;
    private Method _unitySendMessageMethod;
    public boolean isAmazonAppStore = false;

    public static CustomiseFeature instance() {
        if (_instance == null) {
            _instance = new CustomiseFeature();
        }
        return _instance;
    }

    public CustomiseFeature() {
        try {
            this._unityPlayerClass = Class.forName("com.unity3d.player.UnityPlayer");
            this._unityPlayerActivityField = this._unityPlayerClass.getField("currentActivity");
            this._unitySendMessageMethod = this._unityPlayerClass.getMethod("UnitySendMessage", String.class, String.class, String.class);
        } catch (ClassNotFoundException e) {
            Log.i("CustomiseFeature", "could not find UnityPlayer class: " + e.getMessage());
        } catch (NoSuchFieldException e2) {
            Log.i("CustomiseFeature", "could not find UnityPlayer class: " + e2.getMessage());
        } catch (Exception e3) {
            Log.i("CustomiseFeature", "could not find UnityPlayer class: " + e3.getMessage());
        }
    }

    /* JADX INFO: Access modifiers changed from: private */
    public Activity getActivity() {
        if (this._unityPlayerActivityField != null) {
            try {
                return (Activity) this._unityPlayerActivityField.get(this._unityPlayerClass);
            } catch (Exception e) {
                Log.i("CustomiseFeature", "error getting currentActivity: " + e.getMessage());
            }
        }
        return this._activity;
    }

    public void UnitySendMessage(String go, String m, String p) {
        if (this._unitySendMessageMethod != null) {
            try {
                this._unitySendMessageMethod.invoke(null, go, m, p);
                return;
            } catch (IllegalAccessException e) {
                Log.i("CustomiseFeature", "could not find UnitySendMessage method: " + e.getMessage());
                return;
            } catch (IllegalArgumentException e2) {
                Log.i("CustomiseFeature", "could not find UnitySendMessage method: " + e2.getMessage());
                return;
            } catch (InvocationTargetException e3) {
                Log.i("CustomiseFeature", "could not find UnitySendMessage method: " + e3.getMessage());
                return;
            }
        }
        Log.i("CustomiseFeature", "UnitySendMessage: " + go + ", " + m + ", " + p);
    }

    public void customAskForReview(int launchesUntilPrompt, int hoursUntilFirstPrompt, int hoursBetweenPrompts, String title, String message, String yesLabel, String remindLabel, String refuseLabel, String appPackageName) {
        SharedPreferences prefs = getActivity().getSharedPreferences("RTA", 0);
        if (!prefs.getBoolean("RTADontShowAgain", false)) {
            SharedPreferences.Editor editor = prefs.edit();
            long launchCount = prefs.getLong("RTALaunchCount", 0L) + 1;
            editor.putLong("RTALaunchCount", launchCount);
            Long firstLaunchDate = Long.valueOf(prefs.getLong("RTAFirstLaunchDate", 0L));
            if (firstLaunchDate.longValue() == 0) {
                Log.i("CustomiseFeature", "first launch date not set in prefs. setting it now");
                firstLaunchDate = Long.valueOf(System.currentTimeMillis());
                editor.putLong("RTAFirstLaunchDate", firstLaunchDate.longValue());
            }
            if (launchCount >= launchesUntilPrompt) {
                Log.i("CustomiseFeature", "launch count > launchesUntilPrompt. checking to see if first launch was greater than hoursUntilPrompt");
                if (System.currentTimeMillis() >= firstLaunchDate.longValue() + (hoursUntilFirstPrompt * 60 * 60 * 1000)) {
                    Log.i("CustomiseFeature", "hoursUntilFirstPrompt have expired so we are clear to proceed");
                    Long lastPromptDate = Long.valueOf(prefs.getLong("RTALastTimeAsked", 0L));
                    if (lastPromptDate.longValue() == 0 || System.currentTimeMillis() >= lastPromptDate.longValue() + (hoursBetweenPrompts * 60 * 60 * 1000)) {
                        Log.i("CustomiseFeature", "lastPromptDate is either 0 or enough time has elapsed to prompt again");
                        editor.putLong("RTALastTimeAsked", System.currentTimeMillis());
                        customAskForReview(title, message, appPackageName, yesLabel, remindLabel, refuseLabel);
                    }
                }
            }
            editor.commit();
        }
    }

    private void customAskForReview(final String title, final String message, final String appPackageName, final String yesLabel, final String remindLabel, final String refuseLabel) {
        final SharedPreferences prefs = getActivity().getSharedPreferences("RTA", 0);
        if (!prefs.getBoolean("RTADontShowAgain", false)) {
            getActivity().runOnUiThread(new Runnable() { // from class: com.customise.features.CustomiseFeature.1
                @Override // java.lang.Runnable
                public void run() {
                    final Dialog dialog = new Dialog(CustomiseFeature.this.getActivity());
                    dialog.setTitle(title);
                    LinearLayout ll = new LinearLayout(CustomiseFeature.this.getActivity());
                    ll.setPadding(5, 0, 5, 0);
                    ll.setOrientation(1);
                    TextView textView = new TextView(CustomiseFeature.this.getActivity());
                    textView.setIncludeFontPadding(true);
                    textView.setText(message);
                    textView.setWidth(500);
                    ll.addView(textView);
                    View view = new View(CustomiseFeature.this.getActivity());
                    view.setLayoutParams(new ViewGroup.LayoutParams(10, 10));
                    ll.addView(view);
                    Button b1 = new Button(CustomiseFeature.this.getActivity());
                    b1.setText(yesLabel == "" ? "Yes, rate it!" : yesLabel);
                    final SharedPreferences sharedPreferences = prefs;
                    final String str = appPackageName;
                    b1.setOnClickListener(new View.OnClickListener() { // from class: com.customise.features.CustomiseFeature.1.1
                        @Override // android.view.View.OnClickListener
                        public void onClick(View v) {
                            SharedPreferences.Editor editor = sharedPreferences.edit();
                            editor.putBoolean("RTADontShowAgain", true);
                            editor.commit();
                            String prefix = "market://";
                            if (Build.VERSION.SDK_INT >= 11) {
                                Log.i("CustomiseFeature", "we have Honeycomb so redirect to the webpage instead of the Market");
                                prefix = "https://market.android.com/";
                            }
                            if (!CustomiseFeature.this.isAmazonAppStore) {
                                CustomiseFeature.this.getActivity().startActivity(new Intent("android.intent.action.VIEW", Uri.parse(String.valueOf(prefix) + "details?id=" + str)));
                            } else {
                                CustomiseFeature.this.getActivity().startActivity(new Intent("android.intent.action.VIEW", Uri.parse(String.valueOf("amzn://apps/android?p=") + str)));
                            }
                            dialog.dismiss();
                        }
                    });
                    ll.addView(b1);
                    Button b2 = new Button(CustomiseFeature.this.getActivity());
                    b2.setText(remindLabel == "" ? "Remind me later" : remindLabel);
                    b2.setOnClickListener(new View.OnClickListener() { // from class: com.customise.features.CustomiseFeature.1.2
                        @Override // android.view.View.OnClickListener
                        public void onClick(View v) {
                            dialog.dismiss();
                        }
                    });
                    ll.addView(b2);
                    Button b3 = new Button(CustomiseFeature.this.getActivity());
                    b3.setText(refuseLabel == "" ? "Don't ask again" : refuseLabel);
                    final SharedPreferences sharedPreferences2 = prefs;
                    b3.setOnClickListener(new View.OnClickListener() { // from class: com.customise.features.CustomiseFeature.1.3
                        @Override // android.view.View.OnClickListener
                        public void onClick(View v) {
                            SharedPreferences.Editor editor = sharedPreferences2.edit();
                            editor.putBoolean("RTADontShowAgain", true);
                            editor.commit();
                            dialog.dismiss();
                        }
                    });
                    ll.addView(b3);
                    dialog.setContentView(ll);
                    dialog.show();
                    int screenWidth = CustomiseFeature.this.getActivity().getWindowManager().getDefaultDisplay().getWidth();
                    float width = screenWidth * 0.8f;
                    if (Build.VERSION.SDK_INT >= 11) {
                        width = 450.0f;
                    }
                    WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
                    lp.copyFrom(dialog.getWindow().getAttributes());
                    lp.width = (int) width;
                    dialog.getWindow().setAttributes(lp);
                }
            });
        }
    }
}
