package com.arellomobile.android.push.utils.notification;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class V11NotificationCreator {
    public static Notification generateNotification(Context context, Bundle data, String title) {
        int simpleIcon = tryToGetIconFormStringOrGetFromApplication(data.getString("i"), context);
        Bitmap bitmap = tryToGetBitmapFromInternet(data.getString("ii"), context);
        Notification.Builder notificationBuilder = new Notification.Builder(context);
        notificationBuilder.setTicker(title);
        notificationBuilder.setContentTitle(title);
        notificationBuilder.setWhen(System.currentTimeMillis());
        if (bitmap != null) {
            notificationBuilder.setLargeIcon(bitmap);
        }
        notificationBuilder.setSmallIcon(simpleIcon);
        return notificationBuilder.getNotification();
    }

    private static int tryToGetIconFormStringOrGetFromApplication(String iconName, Context context) {
        int customId;
        int iconId = context.getApplicationInfo().icon;
        if (iconName != null && (customId = context.getResources().getIdentifier(iconName, "drawable", context.getPackageName())) != 0) {
            return customId;
        }
        return iconId;
    }

    private static Bitmap tryToGetBitmapFromInternet(String bitmapUrl, Context context) {
        if (bitmapUrl != null) {
            InputStream inputStream = null;
            try {
                URL url = new URL(bitmapUrl);
                URLConnection connection = url.openConnection();
                connection.connect();
                inputStream = connection.getInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while (true) {
                    int read = inputStream.read(buffer);
                    if (read == -1) {
                        break;
                    }
                    byteArrayOutputStream.write(buffer, 0, read);
                }
                inputStream.close();
                byteArrayOutputStream.close();
                byte[] buffer2 = byteArrayOutputStream.toByteArray();
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeByteArray(buffer2, 0, buffer2.length, options);
                int maxSize = Math.max(options.outWidth, options.outHeight);
                float newImageScale = maxSize / (40.0f * context.getResources().getDisplayMetrics().density);
                options.inJustDecodeBounds = false;
                options.inSampleSize = Math.round(newImageScale);
                Bitmap decodeByteArray = BitmapFactory.decodeByteArray(buffer2, 0, buffer2.length, options);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    } catch (IOException e) {
                    }
                }
                System.gc();
                return decodeByteArray;
            } catch (Throwable th) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    } catch (IOException e2) {
                    }
                }
                System.gc();
            }
        }
        return null;
    }
}
