package com.arellomobile.android.push.utils.notification;

import android.app.Notification;
import android.content.Context;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.arellomobile.android.push.preference.SoundType;
import com.arellomobile.android.push.preference.VibrateType;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class NotificationFactory {
    public static Notification generateNotification(Context context, Bundle data, CharSequence appName, SoundType soundType, VibrateType vibrateType) {
        Notification notification;
        String newMessageString = ": new message";
        int resId = context.getResources().getIdentifier("new_push_message", "string", context.getPackageName());
        if (resId != 0) {
            newMessageString = context.getString(resId);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            notification = V11NotificationCreator.generateNotification(context, data, ((Object) appName) + newMessageString);
        } else {
            notification = NotificationCreator.generateNotification(context, data, ((Object) appName) + newMessageString);
        }
        notification.flags |= 16;
        String sound = (String) data.get("s");
        AudioManager am = (AudioManager) context.getSystemService("audio");
        if (soundType == SoundType.ALWAYS || (am.getRingerMode() == 2 && soundType == SoundType.DEFAULT_MODE)) {
            playPushNotificationSound(context, notification, sound);
        }
        if ((vibrateType == VibrateType.ALWAYS || (am.getRingerMode() == 1 && vibrateType == VibrateType.DEFAULT_MODE)) && phoneHaveVibratePermission(context)) {
            notification.defaults |= 2;
        }
        return notification;
    }

    private static void playPushNotificationSound(Context context, Notification notification, String sound) {
        int soundId;
        if (sound != null && sound.length() != 0 && (soundId = context.getResources().getIdentifier(sound, "raw", context.getPackageName())) != 0) {
            notification.sound = Uri.parse("android.resource://" + context.getPackageName() + "/" + soundId);
        } else {
            notification.defaults |= 1;
        }
    }

    private static boolean phoneHaveVibratePermission(Context context) {
        int result;
        PackageManager packageManager = context.getPackageManager();
        try {
            result = packageManager.checkPermission("android.permission.VIBRATE", context.getPackageName());
        } catch (Exception e) {
            Log.e("PushWoosh", "error in checking permission", e);
        }
        if (result == 0) {
            return true;
        }
        return false;
    }
}
