package com.arellomobile.android.push.utils.notification;

import android.app.Notification;
import android.content.Context;
import android.os.Bundle;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class NotificationCreator {
    public static Notification generateNotification(Context context, Bundle data, String title) {
        return new Notification(tryToGetIconFormStringOrGetFromApplication(data.getString("i"), context), title, System.currentTimeMillis());
    }

    private static int tryToGetIconFormStringOrGetFromApplication(String iconName, Context context) {
        int customId;
        int iconId = context.getApplicationInfo().icon;
        if (iconName != null && (customId = context.getResources().getIdentifier(iconName, "drawable", context.getPackageName())) != 0) {
            return customId;
        }
        return iconId;
    }
}
