package com.arellomobile.android.push.utils;

import android.content.Context;
import android.content.SharedPreferences;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class PreferenceUtils {
    private static final String LAST_REGISTRATION = "last_registration_change";
    private static final String PREFERENCE = "com.google.android.c2dm";

    public static String getSenderId(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCE, 0);
        return prefs.getString("dm_sender_id", "");
    }

    public static void setSenderId(Context context, String senderId) {
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCE, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("dm_sender_id", senderId);
        editor.commit();
    }

    public static long getLastRegistration(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCE, 0);
        return prefs.getLong(LAST_REGISTRATION, 0L);
    }

    public static void setLastRegistration(Context context, long lastRegistrationTime) {
        SharedPreferences.Editor editor = context.getSharedPreferences(PREFERENCE, 0).edit();
        editor.putLong(LAST_REGISTRATION, lastRegistrationTime);
        editor.commit();
    }

    public static void resetLastRegistration(Context context) {
        SharedPreferences.Editor editor = context.getSharedPreferences(PREFERENCE, 0).edit();
        editor.remove(LAST_REGISTRATION);
        editor.commit();
    }

    public static void setApplicationId(Context context, String applicationId) {
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCE, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("dm_pwapp", applicationId);
        editor.commit();
    }

    public static String getApplicationId(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREFERENCE, 0);
        String applicationId = prefs.getString("dm_pwapp", "");
        return applicationId;
    }
}
