package com.arellomobile.android.push.utils;

import android.util.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class NetworkUtils {
    public static final String BASE_URL = "https://cp.pushwoosh.com/json/1.3/";
    public static final int MAX_TRIES = 5;
    public static final String PUSH_VERSION = "1.3";
    private static final String TAG = "PushWoosh: NetworkUtils";

    public static NetworkResult makeRequest(Map<String, Object> data, String urlString) throws Exception {
        InputStream inputStream;
        NetworkResult result = new NetworkResult(500, null);
        OutputStream connectionOutput = null;
        InputStream inputStream2 = null;
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.setDoOutput(true);
            JSONObject innerRequestJson = new JSONObject();
            for (String key : data.keySet()) {
                innerRequestJson.put(key, data.get(key));
            }
            JSONObject requestJson = new JSONObject();
            requestJson.put("request", innerRequestJson);
            connection.setRequestProperty("Content-Length", String.valueOf(requestJson.toString().getBytes().length));
            connectionOutput = connection.getOutputStream();
            connectionOutput.write(requestJson.toString().getBytes());
            connectionOutput.flush();
            connectionOutput.close();
            inputStream = new BufferedInputStream(connection.getInputStream());
        } catch (Throwable th) {
            th = th;
        }
        try {
            ByteArrayOutputStream dataCache = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            while (true) {
                int len = inputStream.read(buff);
                if (len < 0) {
                    break;
                }
                dataCache.write(buff, 0, len);
            }
            dataCache.close();
            String jsonString = new String(dataCache.toByteArray()).trim();
            Log.w(TAG, "PushWooshResult: " + jsonString);
            JSONObject resultJSON = new JSONObject(jsonString);
            result.setData(resultJSON);
            result.setCode(resultJSON.getInt("status_code"));
            if (inputStream != null) {
                inputStream.close();
            }
            if (connectionOutput != null) {
                connectionOutput.close();
            }
            return result;
        } catch (Throwable th2) {
            th = th2;
            inputStream2 = inputStream;
            if (inputStream2 != null) {
                inputStream2.close();
            }
            if (connectionOutput != null) {
                connectionOutput.close();
            }
            throw th;
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static class NetworkResult {
        private int mResultCode;
        private JSONObject mResultData;

        public NetworkResult(int code, JSONObject data) {
            this.mResultCode = code;
            this.mResultData = data;
        }

        public void setCode(int code) {
            this.mResultCode = code;
        }

        public void setData(JSONObject data) {
            this.mResultData = data;
        }

        public int getResultCode() {
            return this.mResultCode;
        }

        public JSONObject getResultData() {
            return this.mResultData;
        }
    }
}
