package com.arellomobile.android.push.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.tapjoy.TapjoyConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class GeneralUtils {
    private static final String SHARED_KEY = "deviceid";
    private static final String SHARED_PREF_NAME = "com.arellomobile.android.push.deviceid";
    private static List<String> sWrongAndroidDevices = new ArrayList();

    static {
        sWrongAndroidDevices.add("9774d56d682e549c");
    }

    public static String getDeviceUUID(Context context) {
        String androidId = Settings.Secure.getString(context.getContentResolver(), TapjoyConstants.TJC_ANDROID_ID);
        if (androidId == null || sWrongAndroidDevices.contains(androidId)) {
            try {
                String deviceId = ((TelephonyManager) context.getSystemService("phone")).getDeviceId();
                if (deviceId != null) {
                    return deviceId;
                }
            } catch (RuntimeException e) {
            }
            SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREF_NAME, 2);
            String deviceId2 = sharedPreferences.getString(SHARED_KEY, null);
            if (deviceId2 == null) {
                String deviceId3 = UUID.randomUUID().toString();
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putString(SHARED_KEY, deviceId3);
                editor.commit();
                return deviceId3;
            }
            return deviceId2;
        }
        return androidId;
    }

    public static boolean isTablet(Context context) {
        Configuration config = context.getResources().getConfiguration();
        return (config.screenLayout & 4) == 4;
    }

    public static void checkNotNullOrEmpty(String reference, String name) {
        checkNotNull(reference, name);
        if (reference.length() == 0) {
            throw new IllegalArgumentException(String.format("Please set the %1$s constant and recompile the app.", name));
        }
    }

    public static void checkNotNull(Object reference, String name) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Please set the %1$s constant and recompile the app.", name));
        }
    }

    public static boolean isAppOnForeground(Context context) {
        ActivityManager activityManager = (ActivityManager) context.getSystemService("activity");
        List<ActivityManager.RunningAppProcessInfo> appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        String packageName = context.getPackageName();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.importance == 100 && appProcess.processName.equals(packageName)) {
                return true;
            }
        }
        return false;
    }
}
