package com.arellomobile.android.push.tags;

import android.content.Context;
import com.arellomobile.android.push.exception.PushWooshException;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class SendPushTagsAsyncTask extends SendPushTagsAbstractAsyncTask {
    private SendPushTagsCallBack mCallBack;

    public SendPushTagsAsyncTask(Context context, SendPushTagsCallBack callBack) {
        super(context);
        this.mCallBack = callBack;
    }

    @Override // com.arellomobile.android.push.tags.SendPushTagsCallBack
    public void taskStarted() {
        if (this.mCallBack != null) {
            this.mCallBack.taskStarted();
        }
    }

    @Override // com.arellomobile.android.push.tags.SendPushTagsCallBack
    public void onSentTagsSuccess(Map<String, String> skippedTags) {
        if (this.mCallBack != null) {
            this.mCallBack.onSentTagsSuccess(skippedTags);
        }
    }

    @Override // com.arellomobile.android.push.tags.SendPushTagsCallBack
    public void onSentTagsError(PushWooshException error) {
        if (this.mCallBack != null) {
            this.mCallBack.onSentTagsError(error);
        }
    }
}
