package com.arellomobile.android.push.tags;

import android.content.Context;
import android.os.AsyncTask;
import com.arellomobile.android.push.PushManager;
import com.arellomobile.android.push.exception.PushWooshException;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public abstract class SendPushTagsAbstractAsyncTask extends AsyncTask<Map<String, Object>, Void, Map<String, String>> implements SendPushTagsCallBack {
    private Context mContext;
    private PushWooshException mError;

    public SendPushTagsAbstractAsyncTask(Context context) {
        this.mContext = context;
    }

    @Override // android.os.AsyncTask
    protected void onPreExecute() {
        super.onPreExecute();
        taskStarted();
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.os.AsyncTask
    public Map<String, String> doInBackground(Map<String, Object>... mapArr) {
        try {
            if (mapArr.length != 1) {
                throw new PushWooshException("Wrong parameters");
            }
            Map<String, String> sendTagsFromBG = PushManager.sendTagsFromBG(this.mContext, mapArr[0]);
            this.mContext = null;
            return sendTagsFromBG;
        } catch (PushWooshException e) {
            this.mError = e;
            this.mContext = null;
            return null;
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // android.os.AsyncTask
    public void onPostExecute(Map<String, String> skippedTags) {
        super.onPostExecute((SendPushTagsAbstractAsyncTask) skippedTags);
        if (this.mError != null) {
            onSentTagsError(this.mError);
        } else {
            onSentTagsSuccess(skippedTags);
        }
    }
}
