package com.arellomobile.android.push.request.versions;

import android.content.Context;
import android.location.Location;
import com.arellomobile.android.push.data.PushZoneLocation;
import com.arellomobile.android.push.utils.GeneralUtils;
import com.arellomobile.android.push.utils.PreferenceUtils;
import com.tapjoy.TapjoyConstants;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class Version__1_3 implements VersionHelper {
    @Override // com.arellomobile.android.push.request.versions.VersionHelper
    public Map<String, Object> getRegistrationUnregistrationData(Context context, String deviceRegistrationID) {
        HashMap<String, Object> data = new HashMap<>();
        data.put("application", PreferenceUtils.getApplicationId(context));
        data.put("hwid", GeneralUtils.getDeviceUUID(context));
        data.put(TapjoyConstants.TJC_DEVICE_NAME, GeneralUtils.isTablet(context) ? "Tablet" : "Phone");
        data.put(TapjoyConstants.TJC_DEVICE_TYPE_NAME, "3");
        data.put("language", Locale.getDefault().getLanguage());
        data.put("timezone", Integer.valueOf(Calendar.getInstance().getTimeZone().getRawOffset() / 1000));
        data.put("push_token", deviceRegistrationID);
        return data;
    }

    @Override // com.arellomobile.android.push.request.versions.VersionHelper
    public Map<String, Object> getSendPushStatData(Context context, String hash) {
        Map<String, Object> data = new HashMap<>();
        data.put("application", PreferenceUtils.getApplicationId(context));
        data.put("hwid", GeneralUtils.getDeviceUUID(context));
        data.put("hash", hash);
        return data;
    }

    @Override // com.arellomobile.android.push.request.versions.VersionHelper
    public Map<String, Object> getSendTagsData(Context context) {
        Map<String, Object> data = new HashMap<>();
        data.put("application", PreferenceUtils.getApplicationId(context));
        data.put("hwid", GeneralUtils.getDeviceUUID(context));
        return data;
    }

    @Override // com.arellomobile.android.push.request.versions.VersionHelper
    public Map<String, Object> getNearestZoneData(Context context, Location location) {
        Map<String, Object> data = new HashMap<>();
        data.put("application", PreferenceUtils.getApplicationId(context));
        data.put("hwid", GeneralUtils.getDeviceUUID(context));
        data.put("lat", Double.valueOf(location.getLatitude()));
        data.put("lng", Double.valueOf(location.getLongitude()));
        return data;
    }

    @Override // com.arellomobile.android.push.request.versions.VersionHelper
    public PushZoneLocation getPushZoneLocationFromData(JSONObject resultData) throws JSONException {
        JSONObject response = resultData.getJSONObject("response");
        PushZoneLocation location = new PushZoneLocation();
        location.setName(response.getString(TapjoyConstants.TJC_EVENT_IAP_NAME));
        location.setLat(response.getDouble("lat"));
        location.setLng(response.getDouble("lng"));
        location.setDistanceTo(response.getLong("distance"));
        return location;
    }
}
