package com.arellomobile.android.push.request.versions;

import android.content.Context;
import android.location.Location;
import com.arellomobile.android.push.data.PushZoneLocation;
import com.arellomobile.android.push.utils.GeneralUtils;
import com.arellomobile.android.push.utils.PreferenceUtils;
import com.tapjoy.TapjoyConstants;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class Version__1_2 implements VersionHelper {
    @Override // com.arellomobile.android.push.request.versions.VersionHelper
    public Map<String, Object> getRegistrationUnregistrationData(Context context, String deviceRegistrationID) {
        HashMap<String, Object> data = new HashMap<>();
        data.put("application", PreferenceUtils.getApplicationId(context));
        data.put("hw_id", GeneralUtils.getDeviceUUID(context));
        data.put(TapjoyConstants.TJC_DEVICE_NAME, GeneralUtils.isTablet(context) ? "Tablet" : "Phone");
        data.put(TapjoyConstants.TJC_DEVICE_TYPE_NAME, "3");
        data.put("language", Locale.getDefault().getLanguage());
        data.put("timezone", Integer.valueOf(Calendar.getInstance().getTimeZone().getRawOffset() / 1000));
        data.put("device_id", deviceRegistrationID);
        return data;
    }

    @Override // com.arellomobile.android.push.request.versions.VersionHelper
    public Map<String, Object> getSendPushStatData(Context context, String hash) {
        throw new UnsupportedOperationException("This feature requires 1.3 api");
    }

    @Override // com.arellomobile.android.push.request.versions.VersionHelper
    public Map<String, Object> getSendTagsData(Context context) {
        throw new UnsupportedOperationException("This feature requires 1.3 api");
    }

    @Override // com.arellomobile.android.push.request.versions.VersionHelper
    public Map<String, Object> getNearestZoneData(Context context, Location location) {
        throw new UnsupportedOperationException("This feature requires 1.3 api");
    }

    @Override // com.arellomobile.android.push.request.versions.VersionHelper
    public PushZoneLocation getPushZoneLocationFromData(JSONObject resultData) {
        throw new UnsupportedOperationException("This feature requires 1.3 api");
    }
}
