package com.arellomobile.android.push.request;

import android.content.Context;
import android.location.Location;
import com.arellomobile.android.push.data.PushZoneLocation;
import com.arellomobile.android.push.request.versions.VersionHelper;
import com.arellomobile.android.push.request.versions.Version__1_2;
import com.arellomobile.android.push.request.versions.Version__1_3;
import com.arellomobile.android.push.utils.NetworkUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class RequestHelper {
    private static final Map<String, VersionHelper> sVersionHelpers = new HashMap();

    static {
        sVersionHelpers.put("1.1", new Version__1_2());
        sVersionHelpers.put("1.2", new Version__1_2());
        sVersionHelpers.put(NetworkUtils.PUSH_VERSION, new Version__1_3());
    }

    public static Map<String, Object> getRegistrationUnregistrationData(Context context, String deviceRegistrationID, String pushVersion) {
        VersionHelper versionHelper = getVersionHelper(pushVersion);
        return versionHelper.getRegistrationUnregistrationData(context, deviceRegistrationID);
    }

    public static Map<String, Object> getSendPushStatData(Context context, String hash, String pushVersion) {
        VersionHelper versionHelper = getVersionHelper(pushVersion);
        return versionHelper.getSendPushStatData(context, hash);
    }

    public static Map<String, Object> getSendTagsData(Context context, String pushVersion) {
        VersionHelper versionHelper = sVersionHelpers.get(pushVersion);
        return versionHelper.getSendTagsData(context);
    }

    public static Map<String, Object> getNearestZoneData(Context context, Location location, String pushVersion) {
        VersionHelper versionHelper = sVersionHelpers.get(pushVersion);
        return versionHelper.getNearestZoneData(context, location);
    }

    public static PushZoneLocation getPushZoneLocationFromData(JSONObject resultData, String pushVersion) throws Exception {
        VersionHelper versionHelper = sVersionHelpers.get(pushVersion);
        return versionHelper.getPushZoneLocationFromData(resultData);
    }

    private static VersionHelper getVersionHelper(String pushVersion) {
        VersionHelper versionHelper = sVersionHelpers.get(pushVersion);
        if (versionHelper == null) {
            throw new RuntimeException("No Version Request Helper sent to version ‚Ññ" + pushVersion);
        }
        return versionHelper;
    }
}
