package com.arellomobile.android.push;

import android.content.Context;
import com.google.android.gcm.GCMRegistrar;
import com.unity3d.player.UnityPlayer;
import java.util.HashMap;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class PushwooshProxy {
    static PushwooshProxy INSTANCE = null;
    Context context;
    String listenerName;

    public PushwooshProxy() {
        INSTANCE = this;
    }

    public static PushwooshProxy instance() {
        if (INSTANCE == null) {
            INSTANCE = new PushwooshProxy();
        }
        return INSTANCE;
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public void setListenerName(String name) {
        this.listenerName = name;
    }

    public void onPushReceiveEvent(String string) {
        if (this.listenerName != null) {
            UnityPlayer.UnitySendMessage(this.listenerName, "onPushNotificationsReceived", string);
        }
    }

    public void onRegisterEvent(String string) {
        if (this.listenerName != null) {
            UnityPlayer.UnitySendMessage(this.listenerName, "onRegisteredForPushNotifications", string);
        }
    }

    public void onUnRegisterEvent(String string) {
    }

    public void onRegisterErrorEvent(String string) {
        if (this.listenerName != null) {
            UnityPlayer.UnitySendMessage(this.listenerName, "onFailedToRegisteredForPushNotifications", string);
        }
    }

    public void onUnRegisterErrorEvent(String string) {
    }

    public void setIntTag(String name, int value) {
        Map<String, Object> tags = new HashMap<>();
        tags.put(name, new Integer(value));
        PushManager.sendTags(this.context, tags, null);
    }

    public void setStringTag(String name, String value) {
        Map<String, Object> tags = new HashMap<>();
        tags.put(name, value);
        PushManager.sendTags(this.context, tags, null);
    }

    public String getPushToken() {
        return GCMRegistrar.getRegistrationId(this.context);
    }
}
