package com.arellomobile.android.push;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import com.arellomobile.android.push.utils.GeneralUtils;
import com.arellomobile.android.push.utils.notification.NotificationFactory;
import com.flurry.android.Constants;
import com.google.android.gcm.GCMBaseIntentService;
import org.json.JSONException;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class PushGCMIntentService extends GCMBaseIntentService {
    private static final String TAG = "GCMIntentService";
    private static boolean mSimpleNotification = true;
    private Handler mHandler;

    public PushGCMIntentService() {
        String senderId = PushManager.mSenderId;
        Boolean simpleNotification = PushManager.sSimpleNotification;
        if (simpleNotification != null) {
            mSimpleNotification = simpleNotification.booleanValue();
        }
        this.mSenderId = senderId == null ? "" : senderId;
        this.mHandler = new Handler();
    }

    protected void onRegistered(Context context, String registrationId) {
        Log.i(TAG, "Device registered: regId = " + registrationId);
        DeviceRegistrar.registerWithServer(context, registrationId);
    }

    protected void onUnregistered(Context context, String registrationId) {
        Log.i(TAG, "Device unregistered");
        DeviceRegistrar.unregisterWithServer(context, registrationId);
    }

    protected void onMessage(Context context, Intent intent) {
        Log.i(TAG, "Received message");
        generateNotification(context, intent, this.mHandler);
    }

    protected void onDeletedMessages(Context context, int total) {
        Log.i(TAG, "Received deleted messages notification");
    }

    protected void onError(Context context, String errorId) {
        Log.e(TAG, "Messaging registration error: " + errorId);
        PushEventsTransmitter.onRegisterError(context, errorId);
    }

    protected boolean onRecoverableError(Context context, String errorId) {
        Log.i(TAG, "Received recoverable error: " + errorId);
        return super.onRecoverableError(context, errorId);
    }

    private static void generateNotification(Context context, Intent intent, Handler handler) {
        Intent notifyIntent;
        Bundle extras = intent.getExtras();
        if (extras != null) {
            extras.putBoolean("foregroud", GeneralUtils.isAppOnForeground(context));
            String title = (String) extras.get("title");
            String link = (String) extras.get(Constants.ALIGN_LEFT);
            if (link != null) {
                notifyIntent = new Intent("android.intent.action.VIEW", Uri.parse(link));
                notifyIntent.addFlags(268435456);
            } else {
                notifyIntent = new Intent(context, PushHandlerActivity.class);
                notifyIntent.addFlags(603979776);
                notifyIntent.putExtra("pushBundle", extras);
            }
            CharSequence appName = context.getPackageManager().getApplicationLabel(context.getApplicationInfo());
            if (appName == null) {
                appName = "";
            }
            NotificationManager manager = (NotificationManager) context.getSystemService("notification");
            Notification notification = NotificationFactory.generateNotification(context, extras, appName, PushManager.sSoundType, PushManager.sVibrateType);
            if (mSimpleNotification) {
                createSimpleNotification(context, notifyIntent, notification, appName, title, manager);
            } else {
                createMultyNotification(context, notifyIntent, notification, appName, title, manager);
            }
            generateBroadcast(context, extras);
        }
    }

    private static void generateBroadcast(Context context, Bundle extras) {
        Intent broadcastIntent = new Intent();
        broadcastIntent.setAction(String.valueOf(context.getPackageName()) + ".action.PUSH_MESSAGE_RECEIVE");
        new Bundle();
        JSONObject dataObject = new JSONObject();
        try {
            if (extras.containsKey("title")) {
                dataObject.put("title", extras.get("title"));
            }
            if (extras.containsKey("u")) {
                dataObject.put("userdata", new JSONObject(extras.getString("u")));
            }
        } catch (JSONException e) {
        }
        broadcastIntent.putExtra("data", dataObject.toString());
        context.sendBroadcast(broadcastIntent, String.valueOf(context.getPackageName()) + ".permission.C2D_MESSAGE");
    }

    private static void createSimpleNotification(Context context, Intent notifyIntent, Notification notification, CharSequence appName, String title, NotificationManager manager) {
        PendingIntent contentIntent = PendingIntent.getActivity(context, 0, notifyIntent, 268435456);
        notification.setLatestEventInfo(context, appName, title, contentIntent);
        manager.notify(PushManager.MESSAGE_ID, notification);
    }

    private static void createMultyNotification(Context context, Intent notifyIntent, Notification notification, CharSequence appName, String title, NotificationManager manager) {
        PendingIntent contentIntent = PendingIntent.getActivity(context, PushManager.MESSAGE_ID, notifyIntent, 134217728);
        notification.setLatestEventInfo(context, appName, title, contentIntent);
        int i = PushManager.MESSAGE_ID;
        PushManager.MESSAGE_ID = i + 1;
        manager.notify(i, notification);
    }
}
