package com.arellomobile.android.push;

import android.content.Context;
import android.content.Intent;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class PushEventsTransmitter {
    private static void transmit(Context context, String stringToShow, String messageKey) {
        Intent notifyIntent = new Intent(context, MessageActivity.class);
        notifyIntent.putExtra(messageKey, stringToShow);
        notifyIntent.setFlags(268435456);
        context.startActivity(notifyIntent);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void onRegistered(Context context, String registrationId) {
        String str = "Registered. RegistrationId is " + registrationId;
        transmit(context, registrationId, PushManager.REGISTER_EVENT);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void onRegisterError(Context context, String errorId) {
        String str = "Register error. Error message is " + errorId;
        transmit(context, errorId, PushManager.REGISTER_ERROR_EVENT);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void onUnregistered(Context context, String registrationId) {
        String str = "Unregistered. RegistrationId is " + registrationId;
        transmit(context, registrationId, PushManager.UNREGISTER_EVENT);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void onUnregisteredError(Context context, String errorId) {
        transmit(context, errorId, PushManager.UNREGISTER_ERROR_EVENT);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void onMessageReceive(Context context, String message) {
        transmit(context, message, PushManager.PUSH_RECEIVE_EVENT);
    }
}
