package com.arellomobile.android.push;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import java.util.logging.Logger;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class MessageActivity extends Activity {
    @Override // android.app.Activity
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        startPushMessageHandlerActivity();
        finish();
    }

    private void startPushMessageHandlerActivity() {
        String[] classNames = {".MESSAGE_OLD", ".MESSAGE_NEW"};
        boolean supportsNative = Build.VERSION.SDK_INT >= 9;
        String MESSAGE_HANDLER_KEY = classNames[supportsNative ? (char) 1 : (char) 0];
        Intent notifyIntent = new Intent();
        String intentAction = String.valueOf(getApplicationContext().getPackageName()) + MESSAGE_HANDLER_KEY;
        notifyIntent.setAction(intentAction);
        notifyIntent.setFlags(603979776);
        notifyIntent.putExtras(getIntent().getExtras());
        try {
            startActivity(notifyIntent);
        } catch (ActivityNotFoundException e) {
            Logger.getLogger(getClass().getSimpleName()).severe("Can't launch activity. Are you sure you have an activity with '" + intentAction + "' action in your manifest?");
        }
    }
}
