package com.arellomobile.android.push;

import android.content.Context;
import android.util.Log;
import com.arellomobile.android.push.request.RequestHelper;
import com.arellomobile.android.push.utils.NetworkUtils;
import com.arellomobile.android.push.utils.PreferenceUtils;
import com.google.android.gcm.GCMRegistrar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class DeviceRegistrar {
    private static final String REGISTER_PATH = "registerDevice";
    private static final String TAG = "DeviceRegistrar";
    private static final String UNREGISTER_PATH = "unregisterDevice";

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void registerWithServer(Context context, String deviceRegistrationID) {
        Log.w(TAG, "Try To Registered for pushes");
        NetworkUtils.NetworkResult res = null;
        Exception exception = new Exception();
        for (int i = 0; i < 5; i++) {
            try {
                res = makeRequest(context, deviceRegistrationID, REGISTER_PATH);
            } catch (Exception e) {
                exception = e;
            }
            if (200 == res.getResultCode() || 103 == res.getResultCode()) {
                GCMRegistrar.setRegisteredOnServer(context, true);
                PushEventsTransmitter.onRegistered(context, deviceRegistrationID);
                PreferenceUtils.setLastRegistration(context, new Date().getTime());
                Log.w(TAG, "Registered for pushes: " + deviceRegistrationID);
                return;
            }
        }
        PushEventsTransmitter.onRegisterError(context, "status code is " + res + "\n error: " + exception.getMessage());
        Log.e(TAG, "Registration error " + exception.getMessage(), exception);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void unregisterWithServer(Context context, String deviceRegistrationID) {
        NetworkUtils.NetworkResult res;
        Log.w(TAG, "Try To Unregistered for pushes");
        GCMRegistrar.setRegisteredOnServer(context, false);
        Exception exception = new Exception();
        for (int i = 0; i < 5; i++) {
            try {
                res = makeRequest(context, deviceRegistrationID, UNREGISTER_PATH);
            } catch (Exception e) {
                exception = e;
            }
            if (200 == res.getResultCode() || 104 == res.getResultCode()) {
                PushEventsTransmitter.onUnregistered(context, deviceRegistrationID);
                Log.w(TAG, "Unregistered for pushes: " + deviceRegistrationID);
                PreferenceUtils.resetLastRegistration(context);
                return;
            }
        }
        PushEventsTransmitter.onUnregisteredError(context, exception.getMessage());
        Log.e(TAG, "Unregistration error " + exception.getMessage(), exception);
    }

    private static NetworkUtils.NetworkResult makeRequest(Context context, String deviceRegistrationID, String urlPath) throws Exception {
        Map<String, Object> data = new HashMap<>();
        data.putAll(RequestHelper.getRegistrationUnregistrationData(context, deviceRegistrationID, NetworkUtils.PUSH_VERSION));
        return NetworkUtils.makeRequest(data, NetworkUtils.BASE_URL + urlPath);
    }
}
