package com.arellomobile.android.push;

import android.content.Context;
import android.location.Location;
import android.util.Log;
import com.arellomobile.android.push.data.PushZoneLocation;
import com.arellomobile.android.push.request.RequestHelper;
import com.arellomobile.android.push.utils.NetworkUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class DeviceFeature2_5 {
    private static final String NEAREST_ZONE = "getNearestZone";
    private static final String PUSH_STAT = "pushStat";
    private static final String TAG = "PushWoosh DeviceFeature2_5";
    private static final String TAGS_PATH = "setTags";

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void sendPushStat(Context context, String hash) {
        Map<String, Object> data = new HashMap<>();
        data.putAll(RequestHelper.getSendPushStatData(context, hash, NetworkUtils.PUSH_VERSION));
        Log.w(TAG, "Try To sent PushStat");
        NetworkUtils.NetworkResult res = new NetworkUtils.NetworkResult(-1, null);
        Exception exception = new Exception();
        for (int i = 0; i < 5; i++) {
            try {
                res = NetworkUtils.makeRequest(data, "https://cp.pushwoosh.com/json/1.3/pushStat");
            } catch (Exception e) {
                exception = e;
            }
            if (200 != res.getResultCode()) {
                continue;
            } else {
                Log.w(TAG, "Send PushStat success");
                return;
            }
        }
        Log.e(TAG, "ERROR: Try To sent PushStat " + exception.getMessage() + ". Response = " + res.getResultData(), exception);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static JSONArray sendTags(Context context, Map<String, Object> tags) throws Exception {
        Map<String, Object> data = new HashMap<>();
        data.putAll(RequestHelper.getSendTagsData(context, NetworkUtils.PUSH_VERSION));
        JSONObject tagsObject = new JSONObject();
        for (String key : tags.keySet()) {
            Object value = tags.get(key);
            if ((value instanceof String) || (value instanceof Integer)) {
                tagsObject.put(key, value);
            } else if (value instanceof List) {
                JSONArray values = new JSONArray();
                for (Object item : (List) value) {
                    if ((item instanceof String) || (item instanceof Integer)) {
                        values.put(String.valueOf(item));
                    } else {
                        throw new RuntimeException("wrong type for tag: " + key);
                    }
                }
                tagsObject.put(key, values);
            } else {
                throw new RuntimeException("wrong type for tag: " + key);
            }
        }
        data.put("tags", tagsObject);
        Log.w(TAG, "Try To sent Tags");
        NetworkUtils.NetworkResult res = new NetworkUtils.NetworkResult(-1, null);
        Exception exception = new Exception();
        for (int i = 0; i < 5; i++) {
            try {
                res = NetworkUtils.makeRequest(data, "https://cp.pushwoosh.com/json/1.3/setTags");
            } catch (Exception e) {
                exception = e;
            }
            if (200 != res.getResultCode()) {
                continue;
            } else {
                Log.w(TAG, "Send Tags success");
                return res.getResultData().getJSONObject("response").getJSONArray("skipped");
            }
        }
        Log.e(TAG, "ERROR: sent Tags " + exception.getMessage() + ". Response = " + res, exception);
        throw exception;
    }

    public static PushZoneLocation getNearestZone(Context context, Location location) throws Exception {
        Map<String, Object> data = new HashMap<>();
        data.putAll(RequestHelper.getNearestZoneData(context, location, NetworkUtils.PUSH_VERSION));
        Log.w(TAG, "Try To Sent Nearest Zone");
        NetworkUtils.NetworkResult res = new NetworkUtils.NetworkResult(-1, null);
        Exception exception = new Exception();
        for (int i = 0; i < 5; i++) {
            try {
                res = NetworkUtils.makeRequest(data, "https://cp.pushwoosh.com/json/1.3/getNearestZone");
            } catch (Exception e) {
                exception = e;
            }
            if (200 != res.getResultCode()) {
                continue;
            } else {
                Log.w(TAG, "Send Nearest Zone success");
                return RequestHelper.getPushZoneLocationFromData(res.getResultData(), NetworkUtils.PUSH_VERSION);
            }
        }
        Log.e(TAG, "ERROR: sent Nearest Zon " + exception.getMessage() + ". Response = " + res, exception);
        throw exception;
    }
}
