#include "../Include/TextData.h"

// Add generic fttools / spbcMain parse logic

TextData::TextData()
{
    TextData::DefaultPath = "t_passfail.txt";
}
TextData::TextData(std::string sFileName)
{
    TextData::DefaultPath = "t_passfail.txt";
    TextData::Open(sFileName, std::ios::out);
}
TextData::~TextData()
{
    TextData::Close();
}
void TextData::Close()
{
    if(TextData::fsFileOut.is_open())
    {
      TextData::fsFileOut.close();
    }
}

void TextData::ReadFile(std::string sFileName, std::list<std::string> &lLineArr)
{
	std::string::size_type sST;
	std::string sLine;
	std::ifstream dataFile;
	int iFileExist = TextData::checkFileExists(sFileName);

	if (iFileExist == 1)
	{
		dataFile.open(sFileName, std::ios_base::in);
		while (!dataFile.eof())
		{
			std::getline(dataFile, sLine);
			if (sLine.length() > 1)
			{
				lLineArr.push_back(sLine);
			}
		}
	}
	else
	{
		std::cout << std::endl << "No " << sFileName << "found!" << std::endl;
	}
	dataFile.close();
}

void TextData::ReadFile(std::string sFileName, int *iDecimalValue)
{
	std::string::size_type sST;
	std::string sLine;
	int iz = 0;

	std::ifstream dataFile(sFileName, std::ios_base::in);
	while (!dataFile.eof())
	{
		std::getline(dataFile, sLine);
		if (sLine.length() > 1)
		{
			iDecimalValue[iz] = std::stoi(sLine, &sST);
		}

		//std::cout << "string to integer conversion " << iDecimalValue[iz]+1 << std::endl;
		iz++;
	}
	dataFile.close();
	iDecimalValue[iz] = 0;
}


void TextData::Open(std::string sFileName, std::ios::openmode mode)
{
    if(sFileName.length() < 1)
    {
        sFileName = TextData::DefaultPath;
    }
    TextData::fsFileOut.open(sFileName.c_str(), mode);

}
void TextData::Open(std::string sPath, ModulePassFail& mpf, std::ios::openmode mode)
{
   if (sPath.empty())
   {
       if (mpf.Message.getMessageStatus().length() < 1)
       {
           sPath = "t_passfail.txt";
       }               
       sPath = mpf.Message.getMessageStatus() + ".txt";
   }
   TextData::Open(sPath, mode);
}
std::string TextData::ReadLine()
{
    std::string sText = "";
    char* buffer = new char[MAX_LINE_LEN];
    if(TextData::fsFileOut.is_open())
	{
        TextData::fsFileOut.getline(buffer, MAX_LINE_LEN);
        sText = buffer;
	}
    delete[] buffer;
    return sText;
}
void TextData::Write(std::string sText)
{
    if(TextData::fsFileOut.is_open())
	{
		TextData::fsFileOut << sText;
	}
}

void TextData::WriteLine(std::string sText)
{
    if(TextData::fsFileOut.is_open())
	{
        TextData::fsFileOut << sText << std::endl;
	}
}
void TextData::PersistData(ModulePassFail& mpf)
 {            
   std::string sbOutput;
   
   sbOutput += mpf.getModuleName() + " " + mpf.getModuleVersion() + " !!! --- " + ToUpper(mpf.Message.getMessageStatus()) + " --- !!!\n";
   sbOutput += mpf.Message.getMessageText() + "\n";
   sbOutput += mpf.getModuleDateTime() + "\n";
   if(TextData::fsFileOut.is_open())
   {
     TextData::Write(sbOutput);
   }
}
void TextData::WriteToFileNoEndL(std::string sFileName, std::string sLineEntry)
{
	std::ofstream resultsFile(sFileName, std::ios_base::out | std::ios_base::app);
	resultsFile << sLineEntry;
	resultsFile.close();
}
void TextData::WriteToFile(std::string sFileName, std::string sLineEntry)
{
	std::ofstream resultsFile(sFileName, std::ios_base::out | std::ios_base::app);
	resultsFile << sLineEntry << std::endl;
	resultsFile.close();
}

void TextData::WriteToFile(std::string sFileName, int iy)
{
	std::ofstream resultsFile(sFileName, std::ios_base::out | std::ios_base::app);
	resultsFile << iy << std::endl;
	resultsFile.close();
}

void TextData::WriteToFile(std::string sFileName, std::string  sMessage, std::string sLineEntry)
{
	std::ofstream resultsFile(sFileName, std::ios_base::out | std::ios_base::app);
	resultsFile << sMessage << " " << sLineEntry << std::endl;
	resultsFile.close();
}

void TextData::WriteToFile(std::string sFileName, std::string  sMessage, int iy)
{
	std::ofstream resultsFile(sFileName, std::ios_base::out | std::ios_base::app);
	resultsFile << sMessage << " " << iy << std::endl;
	resultsFile.close();
}

int TextData::checkFileExists(std::string ssFileName)
{
	fTxtLogFile = fopen(ssFileName.c_str(), "r");
	if (fTxtLogFile == NULL)
	{		
		return 0;//FALSE;
	}
	else
	{
		fclose(fTxtLogFile);		
		return 1;//TRUE;
	}
}

void TextData::RemoveFile(std::string sFileName)
{
	iCheckFile = 99;
	iCheckFile = checkFileExists(sFileName.c_str());

	switch (iCheckFile)
	{
	case 0:
		//std::cout << "..did not find file --> " << sFileName << std::endl;
		break;
	case 1:
		//std::cout << "..found file --> " << sFileName << std::endl;
		if (remove(sFileName.c_str()) != 0)
		{
			//std::cout << "..Error removing File.." << sFileName << std::endl;
		}
		else
		{
			//std::cout << "..Successfully removed File --> " <<  sFileName << std::endl;
		}
		break;
	default:
		std::cout << "...Successfully removed file(s)..." << std::endl;
	}
}

