#ifndef __GOLDMODULEMAIN_H
#define __GOLDMODULEMAIN_H

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <iostream>
#include <sstream>
#include <list>
#include <csignal>
#include <chrono>
#include <thread>
#include <ctime>
#include <future>
#include <regex>

#include <iomanip>
#include <string>
#include <math.h>
#include <cstdio>

#include "../Include/OSDef.h"
#include "../Include/XMLParser.h"
#include "../Include/TextData.h"
#include "../Include/MDFUtil.h"
//#include "../Include/GlobalConfig.h"
#include "../Include/LocalConfig.h"


//unsigned long int ulRetEAX = 0;
//unsigned long int ulRetEDX = 0;
//DWORD ulRetEAX = 0;
//DWORD ulRetEDX = 0;
unsigned long ulRetEAX = 0;
unsigned long ulRetEDX = 0;

XMLParser xd;
XMLParser xdLocal;


// Declare config object
LocalConfig gLocalConfig;
TextData td;

//std::time_t tCurrentTime = std::time(nullptr);
std::time_t tStartTime;
std::time_t tEndTime;
std::time_t tTotalTime;

enum ReturnValueDef
{
	Success = 0,
	Fail,
	Indeterminate,
	NoCompare,
	InvalidArgs,
	ConfigMismatch
};

enum TextColor
{
	Red = 0,
	Green,
	Yellow
};

enum VarType
{
	vtINT = 0,
	vtSTRING,
	vtFLOAT,
	vtMEMSIZEARG
};

std::string sgGoldModuleResultsFile = "IMC_Results.txt";
int igPassFailStatus = 0;  // Default with success
int igPrintConfig = 0;
int igPauseApp = 0;
int igDefaultLoadTimeInMins = 0;
int iColorText = 0;
int iDebugFlag = 0;
int iPrintVersionFlag = 1;
int iPrintSuccessFlag = 1;

std::string sgTestModuleVersion; 

int iSec;
int iMin;
int iHour;
int iOptionValid;
int iRun;
int iArgIndex;

// Prototypes
void Init(void);
void PrintColorMsg(std::string sMsg, TextColor iColor);
void PauseWQuit(void);
void PrintVersion(void);
void SignalFun(int iSigNum);
void CleanUp(void);
void WriteResultsFile(int iPassFailStatus);
void HelpUseage(void);
bool is_integer(const std::string & s);
bool isOptionValid(int iArgLocal, int argcLocal, char *argvLocal[], VarType vt);

class IMCStressTest
{
private:
	void** lpvAddr;
	unsigned long lockSize;
	int chunkAmount;
	long _startClock;
	int _endClock;
	bool CheckTimeout(long endClock);
public:
	static unsigned long long GetFreeMemorySize();
	static bool SetProcessSize(int size);
	int Allocate(int chunkSize, int chunkTotal, bool NoCache);
	bool Test1Write();
	bool Test1Verify();
	bool Test2Write();
	bool Test2Verify();
	bool Test3Write();
	bool Test3Verify();
	bool Release();
};
#endif  