#ifndef __TEXTDATA_H
#define __TEXTDATA_H

#include <string>
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <sstream>
#include <fstream>
#include <cstdlib>
#include <cctype>
#include <limits>
#include <list>
#include "ModulePassFailMsg.h"
#include "MDFUtil.h"

const int MAX_LINE_LEN = 256;
class TextData
{

  private:
    std::fstream fsFileOut;
    std::string DefaultPath;
	int iCheckFile;

  public:

  // ---------------------------------------------------------------------------
  //  Constructors
  // ---------------------------------------------------------------------------
    TextData();
    TextData(std::string sFileName);
    ~TextData();  
    void Close();
	void ReadFile(std::string sFileName, int *iDecimalValue);
    void Open(std::string sPath, ModulePassFail& mpf, std::ios::openmode mode);
    void Open(std::string sFileName, std::ios::openmode mode);
    void Write(std::string sText);
    void WriteLine(std::string sText);
    std::string ReadLine();
    void PersistData(ModulePassFail& mpf);
	void WriteToFileNoEndL(std::string sFileName, std::string sLineEntry);
	void WriteToFile(std::string sFileName, std::string sLineEntry);
	void WriteToFile(std::string sFileName, int iy);
	void WriteToFile(std::string sFileName, std::string  sMessage, int iy);
	void WriteToFile(std::string sFileName, std::string  sMessage, std::string sLineEntry);
	void RemoveFile(std::string sFileName);
	int checkFileExists(std::string ssFileName);
	void ParseTextFile(std::string sFileName);
	void ReadFile(std::string sFileName, std::list<std::string> &lLineArr);

	FILE *fTxtLogFile;
	std::string sLine;
};

#endif // __TEXTDATA_H
