//..
//..Frequency Module ..
//..developed by GTS..
//..
//..Intel(R) Corporation (C) 2019
//..

//..
//..utils.cpp
//..

#include "..\include\utils.h"


//..Parse Stamped Frequency from BrandString
std::string ParseFrequency(int iLength, std::string sName)
{
	int i=0;

	//..find position of last white space occurrence in CPU brand string
	for (i = iLength; i > 1; i--)	//start at the end of the CPU Brand String and cycle backwards
	{
		if ((sName[i - 1] == ' ') && (!bLastSpaceFound))
		{
			iLastSpaceFound = i;
			bLastSpaceFound = true;
			//cout << endl << "..character in string --> " << BS1.sReturnedBS[i-1] <<  "..position of 'i' --> " << i << endl;
			break;
		}
	}

	//..parse stamped expected CPU Frequency
	for (i; i < iLength; i++)
	{
		sParsedFrequency = sParsedFrequency + sName[i];
		//cout << endl << "..sCPUFreq contents -- > " << sCPUFreq << endl;
		if ((sName[i] == 'G') || (sName[i] == 'M'))
		{
			sParsedFrequency.erase(sParsedFrequency.end() - 1);
			//cout << endl << "..Expected CPU Frequency --> " << sCPUFreq << endl;
			break;
		}
	}

	return sParsedFrequency;
}

//..UtilConvert Int Value to String
std::string ConvertInt2String (int number)
{
     std::ostringstream tempbuffer;
     tempbuffer << std::hex << number;
     return tempbuffer.str();
}

bool CheckFloat(const std::string& s)
{
	std::istringstream iss(s);
	float dummy = 0.0f;
	iss >> std::skipws >> dummy;
	return (iss && iss.eof());
}

bool RemoveFile(std::string sFileName)
{
	if (std::filesystem::exists(sFileName))
	{
		if (std::filesystem::remove(sFileName))
		{
			//std::cout << "..Successfully Removed File --> " << sFileName << std::endl;
		}
		else
		{
			//std::cout << "..File Does Not Exist --> " << sFileName << std::endl;
		}
		return true;
	}
	else
	{
		//std::cout << "..File Does Not Exist --> " << sFileName << std::endl;
		return false;
	}
}

//..Function to Output Text in Color to Console
void PrintColorMsg(std::string sMsg, TextColor iColor)
{
	if (iColorText == 0)
	{
		std::cout << std::endl << sMsg << std::endl;
	}
	else
	{
		if (iColor == TextColor::Red)
		{
			HANDLE hCommandWindowTextColor = GetStdHandle(STD_OUTPUT_HANDLE);
			SetConsoleTextAttribute(hCommandWindowTextColor, (FOREGROUND_RED | FOREGROUND_INTENSITY));
			std::cout << std::endl << sMsg << std::endl;
			SetConsoleTextAttribute(hCommandWindowTextColor, (FOREGROUND_RED | FOREGROUND_BLUE | FOREGROUND_GREEN));
		}
		if (iColor == TextColor::Green)
		{
			HANDLE hCommandWindowTextColor = GetStdHandle(STD_OUTPUT_HANDLE);
			SetConsoleTextAttribute(hCommandWindowTextColor, (FOREGROUND_GREEN | FOREGROUND_INTENSITY));
			std::cout << std::endl << sMsg << std::endl;
			SetConsoleTextAttribute(hCommandWindowTextColor, (FOREGROUND_RED | FOREGROUND_BLUE | FOREGROUND_GREEN));
		}
		if (iColor == TextColor::Yellow)
		{
			HANDLE hCommandWindowTextColor = GetStdHandle(STD_OUTPUT_HANDLE);
			SetConsoleTextAttribute(hCommandWindowTextColor, (FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_INTENSITY));
			std::cout << std::endl << sMsg << std::endl;
			SetConsoleTextAttribute(hCommandWindowTextColor, (FOREGROUND_RED | FOREGROUND_BLUE | FOREGROUND_GREEN));
		}
	}
}

void WriteLogFileNoEndL(std::string sFileName, std::string sLineEntry)
{
	std::ofstream fResultsFile(sFileName, std::ios_base::out | std::ios_base::app);
	fResultsFile << sLineEntry;
	fResultsFile.close();
}
void WriteLogFile(std::string sFileName, std::string sLineEntry)
{
	std::ofstream fResultsFile(sFileName, std::ios_base::out | std::ios_base::app);
	fResultsFile << sLineEntry << std::endl;
	fResultsFile.close();
}

void WriteLogFile(std::string sFileName, int iy)
{
	std::ofstream fResultsFile(sFileName, std::ios_base::out | std::ios_base::app);
	fResultsFile << iy << std::endl;
	fResultsFile.close();
}

void WriteLogFile(std::string sFileName, std::string  sMessage, std::string sLineEntry)
{
	std::ofstream fResultsFile(sFileName, std::ios_base::out | std::ios_base::app);
	fResultsFile << sMessage << " " << sLineEntry << std::endl;
	fResultsFile.close();
}

void WriteLogFile(std::string sFileName, std::string  sMessage, int iy)
{
	std::ofstream fResultsFile(sFileName, std::ios_base::out | std::ios_base::app);
	fResultsFile << sMessage << " " << iy << std::endl;
	fResultsFile.close();
}

std::string DateTime(std::string sTemp, time_t tempTime)
{
	struct tm nt;
	errno_t errTemp;
	char charTemp[30];

	localtime_s(&nt, &tempTime);	
	errTemp = asctime_s(charTemp, sizeof(charTemp), &nt);
	sTemp.append(charTemp);
	return sTemp;
}

bool CheckString(std::string s, std::string f)
{
	std::size_t szt_find = s.find(f);
	if (szt_find != std::string::npos)
	{
		return true;
	}
	else
	{
		return false;
	}
}