//..
//..Frequency Module ..
//..developed by GTS..
//..
//..Intel(R) Corporation (C) 2019
//..

//..
//..brandstr.cpp
//..

//.includes..
#include <iostream>
#include <string>
#include "..\include\brandstr.h"


//..Read Processor Brand String from registers
std::string BrandString::getCPUBrandString()
{
	char sCPUname[iBSmax];

    __asm
	{
		//Get First Part of the Brand String
		mov EAX, 0x80000002
		CPUID

		//Get all byte stored in EAX
		mov sCPUname[0], al
		mov sCPUname[1], ah
		shr EAX, 16
		mov sCPUname[2], al
		mov sCPUname[3], ah

		//Get all byte stored in EBX
		mov sCPUname[4], bl
		mov sCPUname[5], bh
		shr EBX, 16
		mov sCPUname[6], bl
		mov sCPUname[7], bh

		//Get all byte stored in ECX
		mov sCPUname[8], cl
		mov sCPUname[9], ch
		shr ECX, 16
		mov sCPUname[10], cl
		mov sCPUname[11], ch

		//Get all byte stored in EDX
		mov sCPUname[12], dl
		mov sCPUname[13], dh
		shr EDX, 16
		mov sCPUname[14], dl
		mov sCPUname[15], dh

		//Get Second Part of the Brand String
		mov EAX, 0x80000003
		CPUID

		//Get all byte stored in EAX
		mov sCPUname[16], al
		mov sCPUname[17], ah
		shr EAX, 16
		mov sCPUname[18], al
		mov sCPUname[19], ah

		//Get all byte stored in EBX
		mov sCPUname[20], bl
		mov sCPUname[21], bh
		shr EBX, 16
		mov sCPUname[22], bl
		mov sCPUname[23], bh

		//Get all byte stored in ECX
		mov sCPUname[24], cl
		mov sCPUname[25], ch
		shr ECX, 16
		mov sCPUname[26], cl
		mov sCPUname[27], ch

		//Get all byte stored in EDX
		mov sCPUname[28], dl
		mov sCPUname[29], dh
		shr EDX, 16
		mov sCPUname[30], dl
		mov sCPUname[31], dh

		//Get Third Part of the Brand String
		mov EAX, 0x80000004
		CPUID

		//Get all byte stored in EAX
		mov sCPUname[32], al
		mov sCPUname[33], ah
		shr EAX, 16
		mov sCPUname[34], al
		mov sCPUname[35], ah

		//Get all byte stored in EBX
		mov sCPUname[36], bl
		mov sCPUname[37], bh
		shr EBX, 16
		mov sCPUname[38], bl
		mov sCPUname[39], bh

		//Get all byte stored in ECX
		mov sCPUname[40], cl
		mov sCPUname[41], ch
		shr ECX, 16
		mov sCPUname[42], cl
		mov sCPUname[43], ch

		//Get all byte stored in EDX
		mov sCPUname[44], dl
		mov sCPUname[45], dh
		shr EDX, 16
		mov sCPUname[46], dl
		mov sCPUname[47], dh
	}
	sBS.assign(sCPUname);
	
	return sBS;
}

//..get Brand String Length for Parsing
void BrandString::BrandStringLength()
{
	std::string sReturnedBS = getCPUBrandString();
	iBrandLength = sReturnedBS.length();
}

//..call dtor
BrandString::~BrandString()
{
}
