#ifndef __GOLDMODULEMAIN_H
#define __GOLDMODULEMAIN_H

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <iostream>
#include <sstream>
#include <list>
#include <csignal>
#include <chrono>
#include <thread>
#include <ctime>
#include <immintrin.h>
#include <future>
#include <regex>

#include "OSDef.h"
#include "XMLParser.h"
#include "TextData.h"
#include "MDFUtil.h"
#include "GlobalConfig.h"
#include "GlobalDefs.h"

#ifdef __WIN_OS__
#include <Windows.h>
#else
#include <sys/time.h>
#endif 

unsigned long int ulRetEAX = 0;
unsigned long int ulRetEDX = 0;

XMLParser xd;

// Declare config object
TextData td;

//std::time_t tCurrentTime = std::time(nullptr);
std::time_t tStartTime;
std::time_t tEndTime;
std::time_t tTotalTime;

clock_t start;
clock_t timeElapsed;
unsigned msElapsed;
unsigned msTarget;


std::string sgGoldModuleResultsFile = "DGEMM_Results.txt";
int igPassFailStatus = 0;  // Default with success
int igPrintConfig = 0;
int igPauseApp = 0;
int iColorText = 0;
int iDebugFlag = 0;
int iPrintVersionFlag = 1;
int iPrintSuccessFlag = 1;
int igSSEmaxMatrixSize = 0;
int igSSEminMatrixSize = 0;
int igAVXmaxMatrixSize = 0;
int igAVXminMatrixSize = 0;
int igAVX2maxMatrixSize = 0;
int igAVX2minMatrixSize = 0;
int igAVX512maxMatrixSize = 0;
int igAVX512minMatrixSize = 0;
int iSSEmaxMatrixSize = 0;
int iSSEminMatrixSize = 0;
int iAVXmaxMatrixSize = 0;
int iAVXminMatrixSize = 0;
int iAVX2maxMatrixSize = 0;
int iAVX2minMatrixSize = 0;
int iAVX512maxMatrixSize = 0;
int iAVX512minMatrixSize = 0;
int maxMatrixSize = 0;
int minMatrixSize = 0;

int iSec;
int iMin;
int iHour;
int iOptionValid;
int iRun;
int iArgIndex;
//Default time for DGEMM test is 40 seconds
long iAVXtimer = 40;

std::string sgGoldModuleVersion;
std::string strPFOut;


// Prototypes
void Init(void);
void PrintSuccess(void);
void handleArgs(int argc, char *argv[]);
bool is_integer(const std::string & s);
bool isOptionValid(int iArgLocal, int argcLocal, char *argvLocal[], VarType vt);
void PrintColorMsg(std::string sMsg, TextColor iColor);
void PauseWQuit(void);
void PrintVersion(void);
void SignalFun(int iSigNum);
void CleanUp(void);
void WriteResultsFile(int iPassFailStatus);
void HelpUseage(void);
void ReadLocalConfig(void);
bool testdgemm(int maxMatrixSize, int minMatrixSize);

#endif  //__GLOBALCONFIG_H
