#ifndef __GOLDMODULEMAIN_H
#define __GOLDMODULEMAIN_H

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <iostream>
#include <sstream>
#include <list>
#include <csignal>
#include <chrono>
#include <thread>
#include <ctime>
#include <future>
#include <regex>



#include "../Include/OSDef.h"
#include "../Include/XMLParser.h"
#include "../Include/TextData.h"
#include "../Include/MDFUtil.h"
#include "../Include/GlobalConfig.h"


unsigned long int ulRetEAX = 0;
unsigned long int ulRetEDX = 0;

XMLParser xd;

// Declare config object
GlobalConfig gGlobalConfig;
TextData td;

#define CLOCKS_PER_MS (CLOCKS_PER_SEC / 1000)

//std::time_t tCurrentTime = std::time(nullptr);
std::time_t tStartTime;
std::time_t tEndTime;
std::time_t tTotalTime;

clock_t start;
clock_t timeElapsed;
unsigned msElapsed;
unsigned msTarget;

enum ReturnValueDef
{
	Success = 0,
	Fail,
	Indeterminate,
	NoCompare,
	InvalidArgs,
	ConfigMismatch
};

enum TextColor
{
	Red = 0,
	Green,
	Yellow
};

enum VarType
{
	vtINT = 0,
	vtSTRING
};

vector<string> vsBrandStringElements;
vector<string> vsStringPartElements;
vector<string> vsComparedStringElements;
vector<string> vsNotComparedStringElements;
//vector<string> vsSampleStringParts;

char cDelimiterSpace = ' ';
char cDelimiterPipe = '|';

char sCPUname[48] = { 0 };

std::string sDelimiterSpace = " ";
std::string sDelimiterPipe = "|";

std::string sgGoldModuleResultsFile = "BrandString_Results.txt";
std::string sBSLocalConfigFile = "BrandString_LocalConfig.xml";
std::string sBSLocalConfigFileMsg = "..!!..Could not Find/Open/Read BrandString_LocalConfig.xml..!!..";
std::string sExitMsg = "..!!..Exiting..!!..";
std::string sBS = "";
std::string s3Hash = "###";
std::string svStringParts = "";
std::string sStringParts = "";
std::string sExpectedString = "";
std::string sMsg = "";
std::string sMsg2 = "";
std::string sBrandVal = "";
std::string sBrandValTrim = "";
std::string sgGoldModuleVersion = "";
std::string sSampleStringParts = "";
std::string sCoreStringParts = "";
std::string sCoreEvoStringParts = "";
std::string sXeonStringParts = "";
std::string sXeonPhiStringParts = "";
std::string sAtomStringParts = "";
std::string sPentiumStringParts = "";
std::string sCeleronStringParts = "";
std::string sComparedStringList = "";

int igPassFailStatus = 0;  // Default with success
int igStringFound = 0;		// string not found default
int igPrintConfig = 0;
int igPauseApp = 0;
int igDefaultLoadTimeInMins = 0;
int iColorText = 0;
int iDebugFlag = 0;
int iPrintVersionFlag = 1;
int iPrintSuccessFlag = 1;
int iDebug = 0;

int iSec;
int iMin;
int iHour;
int iOptionValid;
int iRun;
int iArgIndex;

bool bNoCompare = false;
bool bSampleBrandString = false;
bool bCheckBrandString = false;
bool bStringPartsFound = false;


// Prototypes
void Init(void);
void PrintSuccess(void);
void handleArgs(int argc, char *argv[]);
bool is_integer(const std::string & s);
bool isOptionValid(int iArgLocal, int argcLocal, char *argvLocal[], VarType vt);
void PrintColorMsg(std::string sMsg, TextColor iColor);
void PauseWQuit(void);
void PrintVersion(void);
void SignalFun(int iSigNum);
void CleanUp(void);
void WriteResultsFile(int iPassFailStatus, string sBV, string sMessage, string sMessage2);
void HelpUseage(void);
void ReadLocalConfig(void);
void PrintVector(vector<string> & vs);


#endif  //__GLOBALCONFIG_H