#include <SFML/Copyright.hpp> // LICENSE AND COPYRIGHT (C) INFORMATION

////////////////////////////////////////////////////////////
// Headers
////////////////////////////////////////////////////////////
#include "SFML/Window/Mouse.hpp"
#import <SFML/Window/macOS/SFOpenGLView.h>

#import <AppKit/AppKit.h>
#include "SFML/Base/Optional.hpp"


////////////////////////////////////////////////////////////
/// Here are defined a few private messages for mouse
/// handling in SFOpenGLView.
///
////////////////////////////////////////////////////////////


@interface SFOpenGLView (mouse_priv)

////////////////////////////////////////////////////////////
/// \brief Update the mouse state (in or out)
///
/// Fire an event if its state has changed.
///
////////////////////////////////////////////////////////////
- (void)updateMouseState;

////////////////////////////////////////////////////////////
/// \brief handle mouse down event
///
////////////////////////////////////////////////////////////
- (void)handleMouseDown:(NSEvent*)theEvent;

////////////////////////////////////////////////////////////
/// \brief handle mouse up event
///
////////////////////////////////////////////////////////////
- (void)handleMouseUp:(NSEvent*)theEvent;

////////////////////////////////////////////////////////////
/// \brief handle mouse move event
///
////////////////////////////////////////////////////////////
- (void)handleMouseMove:(NSEvent*)theEvent;

////////////////////////////////////////////////////////////
/// \brief Check whether the cursor is grabbed or not
///
/// The cursor is grabbed if the window is active (key) and
/// the user wants to grab it.
///
////////////////////////////////////////////////////////////
- (BOOL)isCursorCurrentlyGrabbed;

////////////////////////////////////////////////////////////
/// \brief (Dis)connect the cursor's movements from/to the system
///        and project the cursor into the view
///
////////////////////////////////////////////////////////////
- (void)updateCursorGrabbed;

////////////////////////////////////////////////////////////
/// \brief Move the cursor to the given location
///
/// \param loc location expressed in SFML coordinate system
///
////////////////////////////////////////////////////////////
- (void)moveCursorTo:(NSPoint)loc;

////////////////////////////////////////////////////////////
/// \brief Get the display identifier on which the view is
///
////////////////////////////////////////////////////////////
- (CGDirectDisplayID)displayId;

////////////////////////////////////////////////////////////
/// \brief Try to convert the NSEvent mouse button type to SFML type
///
/// \param event a mouse button event
///
/// \return Left, Right, ..., or `base::nullOpt` if the button is unknown
///
////////////////////////////////////////////////////////////
+ (base::Optional<sf::Mouse::Button>)mouseButtonFromEvent:(NSEvent*)event;

@end
