#include <SFML/Copyright.hpp> // LICENSE AND COPYRIGHT (C) INFORMATION

////////////////////////////////////////////////////////////
// Headers
////////////////////////////////////////////////////////////
#import <AppKit/AppKit.h>
#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////
/// \brief Event processing & Menu bar initialization
///
////////////////////////////////////////////////////////////
@interface SFApplication : NSApplication


////////////////////////////////////////////////////////////
/// \brief Event processing
///
////////////////////////////////////////////////////////////
+ (void)processEvent;


////////////////////////////////////////////////////////////
/// \brief Set up the menu bar and its items
///
////////////////////////////////////////////////////////////
+ (void)setUpMenuBar;


////////////////////////////////////////////////////////////
/// \brief Dispatch events
///
/// This overload of -[NSApplication sendEvent:] is used to
/// fix KeyRelease events when the command key is down.
///
////////////////////////////////////////////////////////////
- (void)sendEvent:(NSEvent*)anEvent;


@end
