#pragma once
#include <SFML/Copyright.hpp> // LICENSE AND COPYRIGHT (C) INFORMATION

////////////////////////////////////////////////////////////
/// Predefine OBJ-C classes
////////////////////////////////////////////////////////////
#ifdef __OBJC__

@class NSAutoreleasePool;
using NSAutoreleasePoolRef = NSAutoreleasePool*;

#else // If C++

using NSAutoreleasePoolRef = void*;

#endif

namespace sf
{

////////////////////////////////////////////////////////////
/// \brief Wraps an NSAutoreleasePool that is created when the object is
///        constructed and is drained when the object is destroyed.
///
////////////////////////////////////////////////////////////
class AutoreleasePool
{
public:
    ////////////////////////////////////////////////////////////
    /// \brief Construct a new NSAutoreleasePool.
    ///
    ////////////////////////////////////////////////////////////
    AutoreleasePool();

    ////////////////////////////////////////////////////////////
    /// \brief Drain the autorelease pool.
    ///
    ////////////////////////////////////////////////////////////
    ~AutoreleasePool();

private:
    ////////////////////////////////////////////////////////////
    // Member data
    ////////////////////////////////////////////////////////////
    NSAutoreleasePoolRef m_pool; ///< The autorelease pool.
};

} // namespace sf
