#pragma once
#include <SFML/Copyright.hpp> // LICENSE AND COPYRIGHT (C) INFORMATION

////////////////////////////////////////////////////////////
// Headers
////////////////////////////////////////////////////////////
#include <UIKit/UIKit.h>


////////////////////////////////////////////////////////////
/// \brief The view controller handles the view's orientation
///
////////////////////////////////////////////////////////////
@interface SFViewController : UIViewController

////////////////////////////////////////////////////////////
/// \brief Tells if the controller supports auto-rotation (iOS < 6)
///
/// \param interfaceOrientation Orientation to check
///
/// \return True if auto-rotation is supported, false otherwise
///
////////////////////////////////////////////////////////////
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation;

////////////////////////////////////////////////////////////
/// \brief Tells if the controller supports auto-rotation (iOS >= 6)
///
/// \return True if auto-rotation is supported, false otherwise
///
////////////////////////////////////////////////////////////
- (BOOL)shouldAutorotate;

////////////////////////////////////////////////////////////
// Member data
////////////////////////////////////////////////////////////
@property(nonatomic) bool orientationCanChange; ///< Tells whether the controller's view can rotate or not

@end
