#pragma once
#include <SFML/Copyright.hpp> // LICENSE AND COPYRIGHT (C) INFORMATION

////////////////////////////////////////////////////////////
// Headers
////////////////////////////////////////////////////////////
#include "SFML/Window/iOS/EaglContext.hpp"

#include <UIKit/UIKit.h>


////////////////////////////////////////////////////////////
/// \brief Our custom implementation of the window's view
///        (supports OpenGL and reports events)
///
////////////////////////////////////////////////////////////
@interface SFView : UIView <UIKeyInput>

////////////////////////////////////////////////////////////
/// \brief Construct the view with its initial size
///
/// \param frame Dimensions of the view
///
/// \return Id of the view
///
////////////////////////////////////////////////////////////
- (id)initWithFrame:(CGRect)frame andContentScaleFactor:(CGFloat)factor;

////////////////////////////////////////////////////////////
// Member data
////////////////////////////////////////////////////////////
@property(nonatomic) sf::priv::EaglContext* context; ///< The attached EAGL context

@end
