#pragma once
#include <SFML/Copyright.hpp> // LICENSE AND COPYRIGHT (C) INFORMATION


namespace sf::priv
{
////////////////////////////////////////////////////////////
/// \brief Automatic wrapper for saving and restoring the current texture binding
///
////////////////////////////////////////////////////////////
class TextureSaver
{
public:
    ////////////////////////////////////////////////////////////
    /// \brief Default constructor
    ///
    /// The current texture binding is saved.
    ///
    ////////////////////////////////////////////////////////////
    TextureSaver();

    ////////////////////////////////////////////////////////////
    /// \brief Destructor
    ///
    /// The previous texture binding is restored.
    ///
    ////////////////////////////////////////////////////////////
    ~TextureSaver();

private:
    ////////////////////////////////////////////////////////////
    // Member data
    ////////////////////////////////////////////////////////////
    int m_textureBinding{}; //!< Texture binding to restore
};

} // namespace sf::priv
