/**
 * Loader generated by glad 2.0.0-beta on Wed Jul 17 02:25:47 2019
 *
 * Generator: C/C++
 * Specification: glx
 * Extensions: 9
 *
 * APIs:
 *  - glx=1.4
 *
 * Options:
 *  - MX_GLOBAL = False
 *  - ON_DEMAND = False
 *  - LOADER = True
 *  - ALIAS = True
 *  - HEADER_ONLY = True
 *  - DEBUG = False
 *  - MX = False
 *
 * Commandline:
 *    --api='glx=1.4' --extensions='GLX_ARB_create_context,GLX_ARB_create_context_profile,GLX_ARB_framebuffer_sRGB,GLX_ARB_multisample,GLX_EXT_framebuffer_sRGB,GLX_EXT_swap_control,GLX_MESA_swap_control,GLX_SGIX_pbuffer,GLX_SGI_swap_control' c --loader --alias --header-only
 *
 * Online:
 *    http://glad.sh/#api=glx%3D1.4&extensions=GLX_ARB_create_context%2CGLX_ARB_create_context_profile%2CGLX_ARB_framebuffer_sRGB%2CGLX_ARB_multisample%2CGLX_EXT_framebuffer_sRGB%2CGLX_EXT_swap_control%2CGLX_MESA_swap_control%2CGLX_SGIX_pbuffer%2CGLX_SGI_swap_control&generator=c&options=LOADER%2CALIAS%2CHEADER_ONLY
 *
 */

#ifndef GLAD_GLX_H_
#define GLAD_GLX_H_

#ifdef GLX_H
    #error GLX header already included (API: glx), remove previous include!
#endif
#define GLX_H 1


#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <glad/gl.h>

#define GLAD_GLX
#define GLAD_OPTION_GLX_LOADER
#define GLAD_OPTION_GLX_ALIAS
#define GLAD_OPTION_GLX_HEADER_ONLY

#ifdef __cplusplus
extern "C" {
#endif

#ifndef GLAD_PLATFORM_H_
#define GLAD_PLATFORM_H_

#ifndef GLAD_PLATFORM_WIN32
  #if defined(_WIN32) || defined(__WIN32__) || defined(WIN32) || defined(__MINGW32__)
    #define GLAD_PLATFORM_WIN32 1
  #else
    #define GLAD_PLATFORM_WIN32 0
  #endif
#endif

#ifndef GLAD_PLATFORM_APPLE
  #ifdef __APPLE__
    #define GLAD_PLATFORM_APPLE 1
  #else
    #define GLAD_PLATFORM_APPLE 0
  #endif
#endif

#ifndef GLAD_PLATFORM_EMSCRIPTEN
  #ifdef __EMSCRIPTEN__
    #define GLAD_PLATFORM_EMSCRIPTEN 1
  #else
    #define GLAD_PLATFORM_EMSCRIPTEN 0
  #endif
#endif

#ifndef GLAD_PLATFORM_UWP
  #if defined(_MSC_VER) && !defined(GLAD_INTERNAL_HAVE_WINAPIFAMILY)
    #ifdef __has_include
      #if __has_include(<winapifamily.h>)
        #define GLAD_INTERNAL_HAVE_WINAPIFAMILY 1
      #endif
    #elif _MSC_VER >= 1700 && !_USING_V110_SDK71_
      #define GLAD_INTERNAL_HAVE_WINAPIFAMILY 1
    #endif
  #endif

  #ifdef GLAD_INTERNAL_HAVE_WINAPIFAMILY
    #include <winapifamily.h>
    #if !WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_DESKTOP) && WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP)
      #define GLAD_PLATFORM_UWP 1
    #endif
  #endif

  #ifndef GLAD_PLATFORM_UWP
    #define GLAD_PLATFORM_UWP 0
  #endif
#endif

#ifdef __GNUC__
  #define GLAD_GNUC_EXTENSION __extension__
#else
  #define GLAD_GNUC_EXTENSION
#endif

#ifndef GLAD_API_CALL
  #if defined(GLAD_API_CALL_EXPORT)
    #if GLAD_PLATFORM_WIN32 || defined(__CYGWIN__)
      #if defined(GLAD_API_CALL_EXPORT_BUILD)
        #if defined(__GNUC__)
          #define GLAD_API_CALL __attribute__ ((dllexport)) extern
        #else
          #define GLAD_API_CALL __declspec(dllexport) extern
        #endif
      #else
        #if defined(__GNUC__)
          #define GLAD_API_CALL __attribute__ ((dllimport)) extern
        #else
          #define GLAD_API_CALL __declspec(dllimport) extern
        #endif
      #endif
    #elif defined(__GNUC__) && defined(GLAD_API_CALL_EXPORT_BUILD)
      #define GLAD_API_CALL __attribute__ ((visibility ("default"))) extern
    #else
      #define GLAD_API_CALL extern
    #endif
  #else
    #define GLAD_API_CALL extern
  #endif
#endif

#ifdef APIENTRY
  #define GLAD_API_PTR APIENTRY
#elif GLAD_PLATFORM_WIN32
  #define GLAD_API_PTR __stdcall
#else
  #define GLAD_API_PTR
#endif

#ifndef GLAPI
#define GLAPI GLAD_API_CALL
#endif

#ifndef GLAPIENTRY
#define GLAPIENTRY GLAD_API_PTR
#endif

#define GLAD_MAKE_VERSION(major, minor) (major * 10000 + minor)
#define GLAD_VERSION_MAJOR(version) (version / 10000)
#define GLAD_VERSION_MINOR(version) (version % 10000)

#define GLAD_GENERATOR_VERSION "2.0.0-beta"

typedef void (*GLADapiproc)(void);

typedef GLADapiproc (*GLADloadfunc)(const char *name);
typedef GLADapiproc (*GLADuserptrloadfunc)(void *userptr, const char *name);

typedef void (*GLADprecallback)(const char *name, GLADapiproc apiproc, int len_args, ...);
typedef void (*GLADpostcallback)(void *ret, const char *name, GLADapiproc apiproc, int len_args, ...);

#endif /* GLAD_PLATFORM_H_ */

#define GLX_ACCUM_ALPHA_SIZE 17
#define GLX_ACCUM_BLUE_SIZE 16
#define GLX_ACCUM_BUFFER_BIT 0x00000080
#define GLX_ACCUM_BUFFER_BIT_SGIX 0x00000080
#define GLX_ACCUM_GREEN_SIZE 15
#define GLX_ACCUM_RED_SIZE 14
#define GLX_ALPHA_SIZE 11
#define GLX_AUX_BUFFERS 7
#define GLX_AUX_BUFFERS_BIT 0x00000010
#define GLX_AUX_BUFFERS_BIT_SGIX 0x00000010
#define GLX_BACK_LEFT_BUFFER_BIT 0x00000004
#define GLX_BACK_LEFT_BUFFER_BIT_SGIX 0x00000004
#define GLX_BACK_RIGHT_BUFFER_BIT 0x00000008
#define GLX_BACK_RIGHT_BUFFER_BIT_SGIX 0x00000008
#define GLX_BAD_ATTRIBUTE 2
#define GLX_BAD_CONTEXT 5
#define GLX_BAD_ENUM 7
#define GLX_BAD_SCREEN 1
#define GLX_BAD_VALUE 6
#define GLX_BAD_VISUAL 4
#define GLX_BLUE_SIZE 10
#define GLX_BUFFER_CLOBBER_MASK_SGIX 0x08000000
#define GLX_BUFFER_SIZE 2
#define GLX_BufferSwapComplete 1
#define GLX_COLOR_INDEX_BIT 0x00000002
#define GLX_COLOR_INDEX_TYPE 0x8015
#define GLX_CONFIG_CAVEAT 0x20
#define GLX_CONTEXT_COMPATIBILITY_PROFILE_BIT_ARB 0x00000002
#define GLX_CONTEXT_CORE_PROFILE_BIT_ARB 0x00000001
#define GLX_CONTEXT_DEBUG_BIT_ARB 0x00000001
#define GLX_CONTEXT_FLAGS_ARB 0x2094
#define GLX_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB 0x00000002
#define GLX_CONTEXT_MAJOR_VERSION_ARB 0x2091
#define GLX_CONTEXT_MINOR_VERSION_ARB 0x2092
#define GLX_CONTEXT_PROFILE_MASK_ARB 0x9126
#define GLX_DAMAGED 0x8020
#define GLX_DAMAGED_SGIX 0x8020
#define GLX_DEPTH_BUFFER_BIT 0x00000020
#define GLX_DEPTH_BUFFER_BIT_SGIX 0x00000020
#define GLX_DEPTH_SIZE 12
#define GLX_DIRECT_COLOR 0x8003
#define GLX_DONT_CARE 0xFFFFFFFF
#define GLX_DOUBLEBUFFER 5
#define GLX_DRAWABLE_TYPE 0x8010
#define GLX_EVENT_MASK 0x801F
#define GLX_EVENT_MASK_SGIX 0x801F
#define GLX_EXTENSIONS 0x3
#define GLX_EXTENSION_NAME "GLX"
#define GLX_FBCONFIG_ID 0x8013
#define GLX_FRAMEBUFFER_SRGB_CAPABLE_ARB 0x20B2
#define GLX_FRAMEBUFFER_SRGB_CAPABLE_EXT 0x20B2
#define GLX_FRONT_LEFT_BUFFER_BIT 0x00000001
#define GLX_FRONT_LEFT_BUFFER_BIT_SGIX 0x00000001
#define GLX_FRONT_RIGHT_BUFFER_BIT 0x00000002
#define GLX_FRONT_RIGHT_BUFFER_BIT_SGIX 0x00000002
#define GLX_GRAY_SCALE 0x8006
#define GLX_GREEN_SIZE 9
#define GLX_HEIGHT 0x801E
#define GLX_HEIGHT_SGIX 0x801E
#define GLX_LARGEST_PBUFFER 0x801C
#define GLX_LARGEST_PBUFFER_SGIX 0x801C
#define GLX_LEVEL 3
#define GLX_MAX_PBUFFER_HEIGHT 0x8017
#define GLX_MAX_PBUFFER_HEIGHT_SGIX 0x8017
#define GLX_MAX_PBUFFER_PIXELS 0x8018
#define GLX_MAX_PBUFFER_PIXELS_SGIX 0x8018
#define GLX_MAX_PBUFFER_WIDTH 0x8016
#define GLX_MAX_PBUFFER_WIDTH_SGIX 0x8016
#define GLX_MAX_SWAP_INTERVAL_EXT 0x20F2
#define GLX_NONE 0x8000
#define GLX_NON_CONFORMANT_CONFIG 0x800D
#define GLX_NO_EXTENSION 3
#define GLX_OPTIMAL_PBUFFER_HEIGHT_SGIX 0x801A
#define GLX_OPTIMAL_PBUFFER_WIDTH_SGIX 0x8019
#define GLX_PBUFFER 0x8023
#define GLX_PBUFFER_BIT 0x00000004
#define GLX_PBUFFER_BIT_SGIX 0x00000004
#define GLX_PBUFFER_CLOBBER_MASK 0x08000000
#define GLX_PBUFFER_HEIGHT 0x8040
#define GLX_PBUFFER_SGIX 0x8023
#define GLX_PBUFFER_WIDTH 0x8041
#define GLX_PIXMAP_BIT 0x00000002
#define GLX_PRESERVED_CONTENTS 0x801B
#define GLX_PRESERVED_CONTENTS_SGIX 0x801B
#define GLX_PSEUDO_COLOR 0x8004
#define GLX_PbufferClobber 0
#define GLX_RED_SIZE 8
#define GLX_RENDER_TYPE 0x8011
#define GLX_RGBA 4
#define GLX_RGBA_BIT 0x00000001
#define GLX_RGBA_TYPE 0x8014
#define GLX_SAMPLES 100001
#define GLX_SAMPLES_ARB 100001
#define GLX_SAMPLE_BUFFERS 100000
#define GLX_SAMPLE_BUFFERS_ARB 100000
#define GLX_SAMPLE_BUFFERS_BIT_SGIX 0x00000100
#define GLX_SAVED 0x8021
#define GLX_SAVED_SGIX 0x8021
#define GLX_SCREEN 0x800C
#define GLX_SLOW_CONFIG 0x8001
#define GLX_STATIC_COLOR 0x8005
#define GLX_STATIC_GRAY 0x8007
#define GLX_STENCIL_BUFFER_BIT 0x00000040
#define GLX_STENCIL_BUFFER_BIT_SGIX 0x00000040
#define GLX_STENCIL_SIZE 13
#define GLX_STEREO 6
#define GLX_SWAP_INTERVAL_EXT 0x20F1
#define GLX_TRANSPARENT_ALPHA_VALUE 0x28
#define GLX_TRANSPARENT_BLUE_VALUE 0x27
#define GLX_TRANSPARENT_GREEN_VALUE 0x26
#define GLX_TRANSPARENT_INDEX 0x8009
#define GLX_TRANSPARENT_INDEX_VALUE 0x24
#define GLX_TRANSPARENT_RED_VALUE 0x25
#define GLX_TRANSPARENT_RGB 0x8008
#define GLX_TRANSPARENT_TYPE 0x23
#define GLX_TRUE_COLOR 0x8002
#define GLX_USE_GL 1
#define GLX_VENDOR 0x1
#define GLX_VERSION 0x2
#define GLX_VISUAL_ID 0x800B
#define GLX_WIDTH 0x801D
#define GLX_WIDTH_SGIX 0x801D
#define GLX_WINDOW 0x8022
#define GLX_WINDOW_BIT 0x00000001
#define GLX_WINDOW_SGIX 0x8022
#define GLX_X_RENDERABLE 0x8012
#define GLX_X_VISUAL_TYPE 0x22
#define __GLX_NUMBER_EVENTS 17


#ifndef GLEXT_64_TYPES_DEFINED
/* This code block is duplicated in glext.h, so must be protected */
#define GLEXT_64_TYPES_DEFINED
/* Define int32_t, int64_t, and uint64_t types for UST/MSC */
/* (as used in the GLX_OML_sync_control extension). */
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
#elif defined(__sun__) || defined(__digital__)
#include <inttypes.h>
#if defined(__STDC__)
#if defined(__arch64__) || defined(_LP64)
typedef long int int64_t;
typedef unsigned long int uint64_t;
#else
typedef long long int int64_t;
typedef unsigned long long int uint64_t;
#endif /* __arch64__ */
#endif /* __STDC__ */
#elif defined( __VMS ) || defined(__sgi)
#include <inttypes.h>
#elif defined(__SCO__) || defined(__USLC__)
#include <stdint.h>
#elif defined(__UNIXOS2__) || defined(__SOL64__)
typedef long int int32_t;
typedef long long int int64_t;
typedef unsigned long long int uint64_t;
#elif defined(_WIN32) && defined(__GNUC__)
#include <stdint.h>
#elif defined(_WIN32)
typedef __int32 int32_t;
typedef __int64 int64_t;
typedef unsigned __int64 uint64_t;
#else
/* Fallback if nothing above works */
#include <inttypes.h>
#endif
#endif
















#if defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && (__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ > 1060)

#else

#endif

#if defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && (__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ > 1060)

#else

#endif







typedef XID GLXFBConfigID;
typedef struct __GLXFBConfigRec *GLXFBConfig;
typedef XID GLXContextID;
typedef struct __GLXcontextRec *GLXContext;
typedef XID GLXPixmap;
typedef XID GLXDrawable;
typedef XID GLXWindow;
typedef XID GLXPbuffer;
typedef void ( *__GLXextFuncPtr)(void);
typedef XID GLXVideoCaptureDeviceNV;
typedef unsigned int GLXVideoDeviceNV;
typedef XID GLXVideoSourceSGIX;
typedef XID GLXFBConfigIDSGIX;
typedef struct __GLXFBConfigRec *GLXFBConfigSGIX;
typedef XID GLXPbufferSGIX;
typedef struct {
    int event_type;             /* GLX_DAMAGED or GLX_SAVED */
    int draw_type;              /* GLX_WINDOW or GLX_PBUFFER */
    unsigned long serial;       /* # of last request processed by server */
    Bool send_event;            /* true if this came for SendEvent request */
    Display *display;           /* display the event was read from */
    GLXDrawable drawable;       /* XID of Drawable */
    unsigned int buffer_mask;   /* mask indicating which buffers are affected */
    unsigned int aux_buffer;    /* which aux buffer was affected */
    int x, y;
    int width, height;
    int count;                  /* if nonzero, at least this many more */
} GLXPbufferClobberEvent;
typedef struct {
    int type;
    unsigned long serial;       /* # of last request processed by server */
    Bool send_event;            /* true if this came from a SendEvent request */
    Display *display;           /* Display the event was read from */
    GLXDrawable drawable;       /* drawable on which event was requested in event mask */
    int event_type;
    int64_t ust;
    int64_t msc;
    int64_t sbc;
} GLXBufferSwapComplete;
typedef union __GLXEvent {
    GLXPbufferClobberEvent glxpbufferclobber;
    GLXBufferSwapComplete glxbufferswapcomplete;
    long pad[24];
} GLXEvent;
typedef struct {
    int type;
    unsigned long serial;
    Bool send_event;
    Display *display;
    int extension;
    int evtype;
    GLXDrawable window;
    Bool stereo_tree;
} GLXStereoNotifyEventEXT;
typedef struct {
    int type;
    unsigned long serial;   /* # of last request processed by server */
    Bool send_event;        /* true if this came for SendEvent request */
    Display *display;       /* display the event was read from */
    GLXDrawable drawable;   /* i.d. of Drawable */
    int event_type;         /* GLX_DAMAGED_SGIX or GLX_SAVED_SGIX */
    int draw_type;          /* GLX_WINDOW_SGIX or GLX_PBUFFER_SGIX */
    unsigned int mask;      /* mask indicating which buffers are affected*/
    int x, y;
    int width, height;
    int count;              /* if nonzero, at least this many more */
} GLXBufferClobberEventSGIX;
typedef struct {
    char    pipeName[80]; /* Should be [GLX_HYPERPIPE_PIPE_NAME_LENGTH_SGIX] */
    int     networkId;
} GLXHyperpipeNetworkSGIX;
typedef struct {
    char    pipeName[80]; /* Should be [GLX_HYPERPIPE_PIPE_NAME_LENGTH_SGIX] */
    int     channel;
    unsigned int participationType;
    int     timeSlice;
} GLXHyperpipeConfigSGIX;
typedef struct {
    char pipeName[80]; /* Should be [GLX_HYPERPIPE_PIPE_NAME_LENGTH_SGIX] */
    int srcXOrigin, srcYOrigin, srcWidth, srcHeight;
    int destXOrigin, destYOrigin, destWidth, destHeight;
} GLXPipeRect;
typedef struct {
    char pipeName[80]; /* Should be [GLX_HYPERPIPE_PIPE_NAME_LENGTH_SGIX] */
    int XOrigin, YOrigin, maxHeight, maxWidth;
} GLXPipeRectLimits;


#define GLX_VERSION_1_0 1
GLAD_API_CALL int GLAD_GLX_VERSION_1_0;
#define GLX_VERSION_1_1 1
GLAD_API_CALL int GLAD_GLX_VERSION_1_1;
#define GLX_VERSION_1_2 1
GLAD_API_CALL int GLAD_GLX_VERSION_1_2;
#define GLX_VERSION_1_3 1
GLAD_API_CALL int GLAD_GLX_VERSION_1_3;
#define GLX_VERSION_1_4 1
GLAD_API_CALL int GLAD_GLX_VERSION_1_4;
#define GLX_ARB_create_context 1
GLAD_API_CALL int GLAD_GLX_ARB_create_context;
#define GLX_ARB_create_context_profile 1
GLAD_API_CALL int GLAD_GLX_ARB_create_context_profile;
#define GLX_ARB_framebuffer_sRGB 1
GLAD_API_CALL int GLAD_GLX_ARB_framebuffer_sRGB;
#define GLX_ARB_multisample 1
GLAD_API_CALL int GLAD_GLX_ARB_multisample;
#define GLX_EXT_framebuffer_sRGB 1
GLAD_API_CALL int GLAD_GLX_EXT_framebuffer_sRGB;
#define GLX_EXT_swap_control 1
GLAD_API_CALL int GLAD_GLX_EXT_swap_control;
#define GLX_MESA_swap_control 1
GLAD_API_CALL int GLAD_GLX_MESA_swap_control;
#define GLX_SGIX_pbuffer 1
GLAD_API_CALL int GLAD_GLX_SGIX_pbuffer;
#define GLX_SGI_swap_control 1
GLAD_API_CALL int GLAD_GLX_SGI_swap_control;


typedef GLXFBConfig * (GLAD_API_PTR *PFNGLXCHOOSEFBCONFIGPROC)(Display * dpy, int screen, const int * attrib_list, int * nelements);
typedef XVisualInfo * (GLAD_API_PTR *PFNGLXCHOOSEVISUALPROC)(Display * dpy, int screen, int * attribList);
typedef void (GLAD_API_PTR *PFNGLXCOPYCONTEXTPROC)(Display * dpy, GLXContext src, GLXContext dst, unsigned long mask);
typedef GLXContext (GLAD_API_PTR *PFNGLXCREATECONTEXTPROC)(Display * dpy, XVisualInfo * vis, GLXContext shareList, Bool direct);
typedef GLXContext (GLAD_API_PTR *PFNGLXCREATECONTEXTATTRIBSARBPROC)(Display * dpy, GLXFBConfig config, GLXContext share_context, Bool direct, const int * attrib_list);
typedef GLXPbufferSGIX (GLAD_API_PTR *PFNGLXCREATEGLXPBUFFERSGIXPROC)(Display * dpy, GLXFBConfigSGIX config, unsigned int width, unsigned int height, int * attrib_list);
typedef GLXPixmap (GLAD_API_PTR *PFNGLXCREATEGLXPIXMAPPROC)(Display * dpy, XVisualInfo * visual, Pixmap pixmap);
typedef GLXContext (GLAD_API_PTR *PFNGLXCREATENEWCONTEXTPROC)(Display * dpy, GLXFBConfig config, int render_type, GLXContext share_list, Bool direct);
typedef GLXPbuffer (GLAD_API_PTR *PFNGLXCREATEPBUFFERPROC)(Display * dpy, GLXFBConfig config, const int * attrib_list);
typedef GLXPixmap (GLAD_API_PTR *PFNGLXCREATEPIXMAPPROC)(Display * dpy, GLXFBConfig config, Pixmap pixmap, const int * attrib_list);
typedef GLXWindow (GLAD_API_PTR *PFNGLXCREATEWINDOWPROC)(Display * dpy, GLXFBConfig config, Window win, const int * attrib_list);
typedef void (GLAD_API_PTR *PFNGLXDESTROYCONTEXTPROC)(Display * dpy, GLXContext ctx);
typedef void (GLAD_API_PTR *PFNGLXDESTROYGLXPBUFFERSGIXPROC)(Display * dpy, GLXPbufferSGIX pbuf);
typedef void (GLAD_API_PTR *PFNGLXDESTROYGLXPIXMAPPROC)(Display * dpy, GLXPixmap pixmap);
typedef void (GLAD_API_PTR *PFNGLXDESTROYPBUFFERPROC)(Display * dpy, GLXPbuffer pbuf);
typedef void (GLAD_API_PTR *PFNGLXDESTROYPIXMAPPROC)(Display * dpy, GLXPixmap pixmap);
typedef void (GLAD_API_PTR *PFNGLXDESTROYWINDOWPROC)(Display * dpy, GLXWindow win);
typedef const char * (GLAD_API_PTR *PFNGLXGETCLIENTSTRINGPROC)(Display * dpy, int name);
typedef int (GLAD_API_PTR *PFNGLXGETCONFIGPROC)(Display * dpy, XVisualInfo * visual, int attrib, int * value);
typedef GLXContext (GLAD_API_PTR *PFNGLXGETCURRENTCONTEXTPROC)(void);
typedef Display * (GLAD_API_PTR *PFNGLXGETCURRENTDISPLAYPROC)(void);
typedef GLXDrawable (GLAD_API_PTR *PFNGLXGETCURRENTDRAWABLEPROC)(void);
typedef GLXDrawable (GLAD_API_PTR *PFNGLXGETCURRENTREADDRAWABLEPROC)(void);
typedef int (GLAD_API_PTR *PFNGLXGETFBCONFIGATTRIBPROC)(Display * dpy, GLXFBConfig config, int attribute, int * value);
typedef GLXFBConfig * (GLAD_API_PTR *PFNGLXGETFBCONFIGSPROC)(Display * dpy, int screen, int * nelements);
typedef __GLXextFuncPtr (GLAD_API_PTR *PFNGLXGETPROCADDRESSPROC)(const GLubyte * procName);
typedef void (GLAD_API_PTR *PFNGLXGETSELECTEDEVENTPROC)(Display * dpy, GLXDrawable draw, unsigned long * event_mask);
typedef void (GLAD_API_PTR *PFNGLXGETSELECTEDEVENTSGIXPROC)(Display * dpy, GLXDrawable drawable, unsigned long * mask);
typedef int (GLAD_API_PTR *PFNGLXGETSWAPINTERVALMESAPROC)(void);
typedef XVisualInfo * (GLAD_API_PTR *PFNGLXGETVISUALFROMFBCONFIGPROC)(Display * dpy, GLXFBConfig config);
typedef Bool (GLAD_API_PTR *PFNGLXISDIRECTPROC)(Display * dpy, GLXContext ctx);
typedef Bool (GLAD_API_PTR *PFNGLXMAKECONTEXTCURRENTPROC)(Display * dpy, GLXDrawable draw, GLXDrawable read, GLXContext ctx);
typedef Bool (GLAD_API_PTR *PFNGLXMAKECURRENTPROC)(Display * dpy, GLXDrawable drawable, GLXContext ctx);
typedef int (GLAD_API_PTR *PFNGLXQUERYCONTEXTPROC)(Display * dpy, GLXContext ctx, int attribute, int * value);
typedef void (GLAD_API_PTR *PFNGLXQUERYDRAWABLEPROC)(Display * dpy, GLXDrawable draw, int attribute, unsigned int * value);
typedef Bool (GLAD_API_PTR *PFNGLXQUERYEXTENSIONPROC)(Display * dpy, int * errorb, int * event);
typedef const char * (GLAD_API_PTR *PFNGLXQUERYEXTENSIONSSTRINGPROC)(Display * dpy, int screen);
typedef void (GLAD_API_PTR *PFNGLXQUERYGLXPBUFFERSGIXPROC)(Display * dpy, GLXPbufferSGIX pbuf, int attribute, unsigned int * value);
typedef const char * (GLAD_API_PTR *PFNGLXQUERYSERVERSTRINGPROC)(Display * dpy, int screen, int name);
typedef Bool (GLAD_API_PTR *PFNGLXQUERYVERSIONPROC)(Display * dpy, int * maj, int * min);
typedef void (GLAD_API_PTR *PFNGLXSELECTEVENTPROC)(Display * dpy, GLXDrawable draw, unsigned long event_mask);
typedef void (GLAD_API_PTR *PFNGLXSELECTEVENTSGIXPROC)(Display * dpy, GLXDrawable drawable, unsigned long mask);
typedef void (GLAD_API_PTR *PFNGLXSWAPBUFFERSPROC)(Display * dpy, GLXDrawable drawable);
typedef void (GLAD_API_PTR *PFNGLXSWAPINTERVALEXTPROC)(Display * dpy, GLXDrawable drawable, int interval);
typedef int (GLAD_API_PTR *PFNGLXSWAPINTERVALMESAPROC)(unsigned int interval);
typedef int (GLAD_API_PTR *PFNGLXSWAPINTERVALSGIPROC)(int interval);
typedef void (GLAD_API_PTR *PFNGLXUSEXFONTPROC)(Font font, int first, int count, int list);
typedef void (GLAD_API_PTR *PFNGLXWAITGLPROC)(void);
typedef void (GLAD_API_PTR *PFNGLXWAITXPROC)(void);

GLAD_API_CALL PFNGLXCHOOSEFBCONFIGPROC sf_glad_glXChooseFBConfig;
#define glXChooseFBConfig sf_glad_glXChooseFBConfig
GLAD_API_CALL PFNGLXCHOOSEVISUALPROC sf_glad_glXChooseVisual;
#define glXChooseVisual sf_glad_glXChooseVisual
GLAD_API_CALL PFNGLXCOPYCONTEXTPROC sf_glad_glXCopyContext;
#define glXCopyContext sf_glad_glXCopyContext
GLAD_API_CALL PFNGLXCREATECONTEXTPROC sf_glad_glXCreateContext;
#define glXCreateContext sf_glad_glXCreateContext
GLAD_API_CALL PFNGLXCREATECONTEXTATTRIBSARBPROC sf_glad_glXCreateContextAttribsARB;
#define glXCreateContextAttribsARB sf_glad_glXCreateContextAttribsARB
GLAD_API_CALL PFNGLXCREATEGLXPBUFFERSGIXPROC sf_glad_glXCreateGLXPbufferSGIX;
#define glXCreateGLXPbufferSGIX sf_glad_glXCreateGLXPbufferSGIX
GLAD_API_CALL PFNGLXCREATEGLXPIXMAPPROC sf_glad_glXCreateGLXPixmap;
#define glXCreateGLXPixmap sf_glad_glXCreateGLXPixmap
GLAD_API_CALL PFNGLXCREATENEWCONTEXTPROC sf_glad_glXCreateNewContext;
#define glXCreateNewContext sf_glad_glXCreateNewContext
GLAD_API_CALL PFNGLXCREATEPBUFFERPROC sf_glad_glXCreatePbuffer;
#define glXCreatePbuffer sf_glad_glXCreatePbuffer
GLAD_API_CALL PFNGLXCREATEPIXMAPPROC sf_glad_glXCreatePixmap;
#define glXCreatePixmap sf_glad_glXCreatePixmap
GLAD_API_CALL PFNGLXCREATEWINDOWPROC sf_glad_glXCreateWindow;
#define glXCreateWindow sf_glad_glXCreateWindow
GLAD_API_CALL PFNGLXDESTROYCONTEXTPROC sf_glad_glXDestroyContext;
#define glXDestroyContext sf_glad_glXDestroyContext
GLAD_API_CALL PFNGLXDESTROYGLXPBUFFERSGIXPROC sf_glad_glXDestroyGLXPbufferSGIX;
#define glXDestroyGLXPbufferSGIX sf_glad_glXDestroyGLXPbufferSGIX
GLAD_API_CALL PFNGLXDESTROYGLXPIXMAPPROC sf_glad_glXDestroyGLXPixmap;
#define glXDestroyGLXPixmap sf_glad_glXDestroyGLXPixmap
GLAD_API_CALL PFNGLXDESTROYPBUFFERPROC sf_glad_glXDestroyPbuffer;
#define glXDestroyPbuffer sf_glad_glXDestroyPbuffer
GLAD_API_CALL PFNGLXDESTROYPIXMAPPROC sf_glad_glXDestroyPixmap;
#define glXDestroyPixmap sf_glad_glXDestroyPixmap
GLAD_API_CALL PFNGLXDESTROYWINDOWPROC sf_glad_glXDestroyWindow;
#define glXDestroyWindow sf_glad_glXDestroyWindow
GLAD_API_CALL PFNGLXGETCLIENTSTRINGPROC sf_glad_glXGetClientString;
#define glXGetClientString sf_glad_glXGetClientString
GLAD_API_CALL PFNGLXGETCONFIGPROC sf_glad_glXGetConfig;
#define glXGetConfig sf_glad_glXGetConfig
GLAD_API_CALL PFNGLXGETCURRENTCONTEXTPROC sf_glad_glXGetCurrentContext;
#define glXGetCurrentContext sf_glad_glXGetCurrentContext
GLAD_API_CALL PFNGLXGETCURRENTDISPLAYPROC sf_glad_glXGetCurrentDisplay;
#define glXGetCurrentDisplay sf_glad_glXGetCurrentDisplay
GLAD_API_CALL PFNGLXGETCURRENTDRAWABLEPROC sf_glad_glXGetCurrentDrawable;
#define glXGetCurrentDrawable sf_glad_glXGetCurrentDrawable
GLAD_API_CALL PFNGLXGETCURRENTREADDRAWABLEPROC sf_glad_glXGetCurrentReadDrawable;
#define glXGetCurrentReadDrawable sf_glad_glXGetCurrentReadDrawable
GLAD_API_CALL PFNGLXGETFBCONFIGATTRIBPROC sf_glad_glXGetFBConfigAttrib;
#define glXGetFBConfigAttrib sf_glad_glXGetFBConfigAttrib
GLAD_API_CALL PFNGLXGETFBCONFIGSPROC sf_glad_glXGetFBConfigs;
#define glXGetFBConfigs sf_glad_glXGetFBConfigs
GLAD_API_CALL PFNGLXGETPROCADDRESSPROC sf_glad_glXGetProcAddress;
#define glXGetProcAddress sf_glad_glXGetProcAddress
GLAD_API_CALL PFNGLXGETSELECTEDEVENTPROC sf_glad_glXGetSelectedEvent;
#define glXGetSelectedEvent sf_glad_glXGetSelectedEvent
GLAD_API_CALL PFNGLXGETSELECTEDEVENTSGIXPROC sf_glad_glXGetSelectedEventSGIX;
#define glXGetSelectedEventSGIX sf_glad_glXGetSelectedEventSGIX
GLAD_API_CALL PFNGLXGETSWAPINTERVALMESAPROC sf_glad_glXGetSwapIntervalMESA;
#define glXGetSwapIntervalMESA sf_glad_glXGetSwapIntervalMESA
GLAD_API_CALL PFNGLXGETVISUALFROMFBCONFIGPROC sf_glad_glXGetVisualFromFBConfig;
#define glXGetVisualFromFBConfig sf_glad_glXGetVisualFromFBConfig
GLAD_API_CALL PFNGLXISDIRECTPROC sf_glad_glXIsDirect;
#define glXIsDirect sf_glad_glXIsDirect
GLAD_API_CALL PFNGLXMAKECONTEXTCURRENTPROC sf_glad_glXMakeContextCurrent;
#define glXMakeContextCurrent sf_glad_glXMakeContextCurrent
GLAD_API_CALL PFNGLXMAKECURRENTPROC sf_glad_glXMakeCurrent;
#define glXMakeCurrent sf_glad_glXMakeCurrent
GLAD_API_CALL PFNGLXQUERYCONTEXTPROC sf_glad_glXQueryContext;
#define glXQueryContext sf_glad_glXQueryContext
GLAD_API_CALL PFNGLXQUERYDRAWABLEPROC sf_glad_glXQueryDrawable;
#define glXQueryDrawable sf_glad_glXQueryDrawable
GLAD_API_CALL PFNGLXQUERYEXTENSIONPROC sf_glad_glXQueryExtension;
#define glXQueryExtension sf_glad_glXQueryExtension
GLAD_API_CALL PFNGLXQUERYEXTENSIONSSTRINGPROC sf_glad_glXQueryExtensionsString;
#define glXQueryExtensionsString sf_glad_glXQueryExtensionsString
GLAD_API_CALL PFNGLXQUERYGLXPBUFFERSGIXPROC sf_glad_glXQueryGLXPbufferSGIX;
#define glXQueryGLXPbufferSGIX sf_glad_glXQueryGLXPbufferSGIX
GLAD_API_CALL PFNGLXQUERYSERVERSTRINGPROC sf_glad_glXQueryServerString;
#define glXQueryServerString sf_glad_glXQueryServerString
GLAD_API_CALL PFNGLXQUERYVERSIONPROC sf_glad_glXQueryVersion;
#define glXQueryVersion sf_glad_glXQueryVersion
GLAD_API_CALL PFNGLXSELECTEVENTPROC sf_glad_glXSelectEvent;
#define glXSelectEvent sf_glad_glXSelectEvent
GLAD_API_CALL PFNGLXSELECTEVENTSGIXPROC sf_glad_glXSelectEventSGIX;
#define glXSelectEventSGIX sf_glad_glXSelectEventSGIX
GLAD_API_CALL PFNGLXSWAPBUFFERSPROC sf_glad_glXSwapBuffers;
#define glXSwapBuffers sf_glad_glXSwapBuffers
GLAD_API_CALL PFNGLXSWAPINTERVALEXTPROC sf_glad_glXSwapIntervalEXT;
#define glXSwapIntervalEXT sf_glad_glXSwapIntervalEXT
GLAD_API_CALL PFNGLXSWAPINTERVALMESAPROC sf_glad_glXSwapIntervalMESA;
#define glXSwapIntervalMESA sf_glad_glXSwapIntervalMESA
GLAD_API_CALL PFNGLXSWAPINTERVALSGIPROC sf_glad_glXSwapIntervalSGI;
#define glXSwapIntervalSGI sf_glad_glXSwapIntervalSGI
GLAD_API_CALL PFNGLXUSEXFONTPROC sf_glad_glXUseXFont;
#define glXUseXFont sf_glad_glXUseXFont
GLAD_API_CALL PFNGLXWAITGLPROC sf_glad_glXWaitGL;
#define glXWaitGL sf_glad_glXWaitGL
GLAD_API_CALL PFNGLXWAITXPROC sf_glad_glXWaitX;
#define glXWaitX sf_glad_glXWaitX





#ifdef __cplusplus
}
#endif
#endif

/* Source */
#ifdef GLAD_GLX_IMPLEMENTATION
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef GLAD_IMPL_UTIL_C_
#define GLAD_IMPL_UTIL_C_

#ifdef _MSC_VER
#define GLAD_IMPL_UTIL_SSCANF sscanf_s
#else
#define GLAD_IMPL_UTIL_SSCANF sscanf
#endif

#endif /* GLAD_IMPL_UTIL_C_ */


int GLAD_GLX_VERSION_1_0 = 0;
int GLAD_GLX_VERSION_1_1 = 0;
int GLAD_GLX_VERSION_1_2 = 0;
int GLAD_GLX_VERSION_1_3 = 0;
int GLAD_GLX_VERSION_1_4 = 0;
int GLAD_GLX_ARB_create_context = 0;
int GLAD_GLX_ARB_create_context_profile = 0;
int GLAD_GLX_ARB_framebuffer_sRGB = 0;
int GLAD_GLX_ARB_multisample = 0;
int GLAD_GLX_EXT_framebuffer_sRGB = 0;
int GLAD_GLX_EXT_swap_control = 0;
int GLAD_GLX_MESA_swap_control = 0;
int GLAD_GLX_SGIX_pbuffer = 0;
int GLAD_GLX_SGI_swap_control = 0;



PFNGLXCHOOSEFBCONFIGPROC sf_glad_glXChooseFBConfig = NULL;
PFNGLXCHOOSEVISUALPROC sf_glad_glXChooseVisual = NULL;
PFNGLXCOPYCONTEXTPROC sf_glad_glXCopyContext = NULL;
PFNGLXCREATECONTEXTPROC sf_glad_glXCreateContext = NULL;
PFNGLXCREATECONTEXTATTRIBSARBPROC sf_glad_glXCreateContextAttribsARB = NULL;
PFNGLXCREATEGLXPBUFFERSGIXPROC sf_glad_glXCreateGLXPbufferSGIX = NULL;
PFNGLXCREATEGLXPIXMAPPROC sf_glad_glXCreateGLXPixmap = NULL;
PFNGLXCREATENEWCONTEXTPROC sf_glad_glXCreateNewContext = NULL;
PFNGLXCREATEPBUFFERPROC sf_glad_glXCreatePbuffer = NULL;
PFNGLXCREATEPIXMAPPROC sf_glad_glXCreatePixmap = NULL;
PFNGLXCREATEWINDOWPROC sf_glad_glXCreateWindow = NULL;
PFNGLXDESTROYCONTEXTPROC sf_glad_glXDestroyContext = NULL;
PFNGLXDESTROYGLXPBUFFERSGIXPROC sf_glad_glXDestroyGLXPbufferSGIX = NULL;
PFNGLXDESTROYGLXPIXMAPPROC sf_glad_glXDestroyGLXPixmap = NULL;
PFNGLXDESTROYPBUFFERPROC sf_glad_glXDestroyPbuffer = NULL;
PFNGLXDESTROYPIXMAPPROC sf_glad_glXDestroyPixmap = NULL;
PFNGLXDESTROYWINDOWPROC sf_glad_glXDestroyWindow = NULL;
PFNGLXGETCLIENTSTRINGPROC sf_glad_glXGetClientString = NULL;
PFNGLXGETCONFIGPROC sf_glad_glXGetConfig = NULL;
PFNGLXGETCURRENTCONTEXTPROC sf_glad_glXGetCurrentContext = NULL;
PFNGLXGETCURRENTDISPLAYPROC sf_glad_glXGetCurrentDisplay = NULL;
PFNGLXGETCURRENTDRAWABLEPROC sf_glad_glXGetCurrentDrawable = NULL;
PFNGLXGETCURRENTREADDRAWABLEPROC sf_glad_glXGetCurrentReadDrawable = NULL;
PFNGLXGETFBCONFIGATTRIBPROC sf_glad_glXGetFBConfigAttrib = NULL;
PFNGLXGETFBCONFIGSPROC sf_glad_glXGetFBConfigs = NULL;
PFNGLXGETPROCADDRESSPROC sf_glad_glXGetProcAddress = NULL;
PFNGLXGETSELECTEDEVENTPROC sf_glad_glXGetSelectedEvent = NULL;
PFNGLXGETSELECTEDEVENTSGIXPROC sf_glad_glXGetSelectedEventSGIX = NULL;
PFNGLXGETSWAPINTERVALMESAPROC sf_glad_glXGetSwapIntervalMESA = NULL;
PFNGLXGETVISUALFROMFBCONFIGPROC sf_glad_glXGetVisualFromFBConfig = NULL;
PFNGLXISDIRECTPROC sf_glad_glXIsDirect = NULL;
PFNGLXMAKECONTEXTCURRENTPROC sf_glad_glXMakeContextCurrent = NULL;
PFNGLXMAKECURRENTPROC sf_glad_glXMakeCurrent = NULL;
PFNGLXQUERYCONTEXTPROC sf_glad_glXQueryContext = NULL;
PFNGLXQUERYDRAWABLEPROC sf_glad_glXQueryDrawable = NULL;
PFNGLXQUERYEXTENSIONPROC sf_glad_glXQueryExtension = NULL;
PFNGLXQUERYEXTENSIONSSTRINGPROC sf_glad_glXQueryExtensionsString = NULL;
PFNGLXQUERYGLXPBUFFERSGIXPROC sf_glad_glXQueryGLXPbufferSGIX = NULL;
PFNGLXQUERYSERVERSTRINGPROC sf_glad_glXQueryServerString = NULL;
PFNGLXQUERYVERSIONPROC sf_glad_glXQueryVersion = NULL;
PFNGLXSELECTEVENTPROC sf_glad_glXSelectEvent = NULL;
PFNGLXSELECTEVENTSGIXPROC sf_glad_glXSelectEventSGIX = NULL;
PFNGLXSWAPBUFFERSPROC sf_glad_glXSwapBuffers = NULL;
PFNGLXSWAPINTERVALEXTPROC sf_glad_glXSwapIntervalEXT = NULL;
PFNGLXSWAPINTERVALMESAPROC sf_glad_glXSwapIntervalMESA = NULL;
PFNGLXSWAPINTERVALSGIPROC sf_glad_glXSwapIntervalSGI = NULL;
PFNGLXUSEXFONTPROC sf_glad_glXUseXFont = NULL;
PFNGLXWAITGLPROC sf_glad_glXWaitGL = NULL;
PFNGLXWAITXPROC sf_glad_glXWaitX = NULL;


static void glad_glx_load_GLX_VERSION_1_0( GLADuserptrloadfunc load, void* userptr) {
    if(!GLAD_GLX_VERSION_1_0) return;
    sf_glad_glXChooseVisual = (PFNGLXCHOOSEVISUALPROC) load(userptr, "glXChooseVisual");
    sf_glad_glXCopyContext = (PFNGLXCOPYCONTEXTPROC) load(userptr, "glXCopyContext");
    sf_glad_glXCreateContext = (PFNGLXCREATECONTEXTPROC) load(userptr, "glXCreateContext");
    sf_glad_glXCreateGLXPixmap = (PFNGLXCREATEGLXPIXMAPPROC) load(userptr, "glXCreateGLXPixmap");
    sf_glad_glXDestroyContext = (PFNGLXDESTROYCONTEXTPROC) load(userptr, "glXDestroyContext");
    sf_glad_glXDestroyGLXPixmap = (PFNGLXDESTROYGLXPIXMAPPROC) load(userptr, "glXDestroyGLXPixmap");
    sf_glad_glXGetConfig = (PFNGLXGETCONFIGPROC) load(userptr, "glXGetConfig");
    sf_glad_glXGetCurrentContext = (PFNGLXGETCURRENTCONTEXTPROC) load(userptr, "glXGetCurrentContext");
    sf_glad_glXGetCurrentDrawable = (PFNGLXGETCURRENTDRAWABLEPROC) load(userptr, "glXGetCurrentDrawable");
    sf_glad_glXIsDirect = (PFNGLXISDIRECTPROC) load(userptr, "glXIsDirect");
    sf_glad_glXMakeCurrent = (PFNGLXMAKECURRENTPROC) load(userptr, "glXMakeCurrent");
    sf_glad_glXQueryExtension = (PFNGLXQUERYEXTENSIONPROC) load(userptr, "glXQueryExtension");
    sf_glad_glXQueryVersion = (PFNGLXQUERYVERSIONPROC) load(userptr, "glXQueryVersion");
    sf_glad_glXSwapBuffers = (PFNGLXSWAPBUFFERSPROC) load(userptr, "glXSwapBuffers");
    sf_glad_glXUseXFont = (PFNGLXUSEXFONTPROC) load(userptr, "glXUseXFont");
    sf_glad_glXWaitGL = (PFNGLXWAITGLPROC) load(userptr, "glXWaitGL");
    sf_glad_glXWaitX = (PFNGLXWAITXPROC) load(userptr, "glXWaitX");
}
static void glad_glx_load_GLX_VERSION_1_1( GLADuserptrloadfunc load, void* userptr) {
    if(!GLAD_GLX_VERSION_1_1) return;
    sf_glad_glXGetClientString = (PFNGLXGETCLIENTSTRINGPROC) load(userptr, "glXGetClientString");
    sf_glad_glXQueryExtensionsString = (PFNGLXQUERYEXTENSIONSSTRINGPROC) load(userptr, "glXQueryExtensionsString");
    sf_glad_glXQueryServerString = (PFNGLXQUERYSERVERSTRINGPROC) load(userptr, "glXQueryServerString");
}
static void glad_glx_load_GLX_VERSION_1_2( GLADuserptrloadfunc load, void* userptr) {
    if(!GLAD_GLX_VERSION_1_2) return;
    sf_glad_glXGetCurrentDisplay = (PFNGLXGETCURRENTDISPLAYPROC) load(userptr, "glXGetCurrentDisplay");
}
static void glad_glx_load_GLX_VERSION_1_3( GLADuserptrloadfunc load, void* userptr) {
    if(!GLAD_GLX_VERSION_1_3) return;
    sf_glad_glXChooseFBConfig = (PFNGLXCHOOSEFBCONFIGPROC) load(userptr, "glXChooseFBConfig");
    sf_glad_glXCreateNewContext = (PFNGLXCREATENEWCONTEXTPROC) load(userptr, "glXCreateNewContext");
    sf_glad_glXCreatePbuffer = (PFNGLXCREATEPBUFFERPROC) load(userptr, "glXCreatePbuffer");
    sf_glad_glXCreatePixmap = (PFNGLXCREATEPIXMAPPROC) load(userptr, "glXCreatePixmap");
    sf_glad_glXCreateWindow = (PFNGLXCREATEWINDOWPROC) load(userptr, "glXCreateWindow");
    sf_glad_glXDestroyPbuffer = (PFNGLXDESTROYPBUFFERPROC) load(userptr, "glXDestroyPbuffer");
    sf_glad_glXDestroyPixmap = (PFNGLXDESTROYPIXMAPPROC) load(userptr, "glXDestroyPixmap");
    sf_glad_glXDestroyWindow = (PFNGLXDESTROYWINDOWPROC) load(userptr, "glXDestroyWindow");
    sf_glad_glXGetCurrentReadDrawable = (PFNGLXGETCURRENTREADDRAWABLEPROC) load(userptr, "glXGetCurrentReadDrawable");
    sf_glad_glXGetFBConfigAttrib = (PFNGLXGETFBCONFIGATTRIBPROC) load(userptr, "glXGetFBConfigAttrib");
    sf_glad_glXGetFBConfigs = (PFNGLXGETFBCONFIGSPROC) load(userptr, "glXGetFBConfigs");
    sf_glad_glXGetSelectedEvent = (PFNGLXGETSELECTEDEVENTPROC) load(userptr, "glXGetSelectedEvent");
    sf_glad_glXGetVisualFromFBConfig = (PFNGLXGETVISUALFROMFBCONFIGPROC) load(userptr, "glXGetVisualFromFBConfig");
    sf_glad_glXMakeContextCurrent = (PFNGLXMAKECONTEXTCURRENTPROC) load(userptr, "glXMakeContextCurrent");
    sf_glad_glXQueryContext = (PFNGLXQUERYCONTEXTPROC) load(userptr, "glXQueryContext");
    sf_glad_glXQueryDrawable = (PFNGLXQUERYDRAWABLEPROC) load(userptr, "glXQueryDrawable");
    sf_glad_glXSelectEvent = (PFNGLXSELECTEVENTPROC) load(userptr, "glXSelectEvent");
}
static void glad_glx_load_GLX_VERSION_1_4( GLADuserptrloadfunc load, void* userptr) {
    if(!GLAD_GLX_VERSION_1_4) return;
    sf_glad_glXGetProcAddress = (PFNGLXGETPROCADDRESSPROC) load(userptr, "glXGetProcAddress");
}
static void glad_glx_load_GLX_ARB_create_context( GLADuserptrloadfunc load, void* userptr) {
    if(!GLAD_GLX_ARB_create_context) return;
    sf_glad_glXCreateContextAttribsARB = (PFNGLXCREATECONTEXTATTRIBSARBPROC) load(userptr, "glXCreateContextAttribsARB");
}
static void glad_glx_load_GLX_EXT_swap_control( GLADuserptrloadfunc load, void* userptr) {
    if(!GLAD_GLX_EXT_swap_control) return;
    sf_glad_glXSwapIntervalEXT = (PFNGLXSWAPINTERVALEXTPROC) load(userptr, "glXSwapIntervalEXT");
}
static void glad_glx_load_GLX_MESA_swap_control( GLADuserptrloadfunc load, void* userptr) {
    if(!GLAD_GLX_MESA_swap_control) return;
    sf_glad_glXGetSwapIntervalMESA = (PFNGLXGETSWAPINTERVALMESAPROC) load(userptr, "glXGetSwapIntervalMESA");
    sf_glad_glXSwapIntervalMESA = (PFNGLXSWAPINTERVALMESAPROC) load(userptr, "glXSwapIntervalMESA");
}
static void glad_glx_load_GLX_SGIX_pbuffer( GLADuserptrloadfunc load, void* userptr) {
    if(!GLAD_GLX_SGIX_pbuffer) return;
    sf_glad_glXCreateGLXPbufferSGIX = (PFNGLXCREATEGLXPBUFFERSGIXPROC) load(userptr, "glXCreateGLXPbufferSGIX");
    sf_glad_glXDestroyGLXPbufferSGIX = (PFNGLXDESTROYGLXPBUFFERSGIXPROC) load(userptr, "glXDestroyGLXPbufferSGIX");
    sf_glad_glXGetSelectedEventSGIX = (PFNGLXGETSELECTEDEVENTSGIXPROC) load(userptr, "glXGetSelectedEventSGIX");
    sf_glad_glXQueryGLXPbufferSGIX = (PFNGLXQUERYGLXPBUFFERSGIXPROC) load(userptr, "glXQueryGLXPbufferSGIX");
    sf_glad_glXSelectEventSGIX = (PFNGLXSELECTEVENTSGIXPROC) load(userptr, "glXSelectEventSGIX");
}
static void glad_glx_load_GLX_SGI_swap_control( GLADuserptrloadfunc load, void* userptr) {
    if(!GLAD_GLX_SGI_swap_control) return;
    sf_glad_glXSwapIntervalSGI = (PFNGLXSWAPINTERVALSGIPROC) load(userptr, "glXSwapIntervalSGI");
}


static void glad_glx_resolve_aliases(void) {
}

static int glad_glx_has_extension(Display *display, int screen, const char *ext) {
#ifndef GLX_VERSION_1_1
    (void) display;
    (void) screen;
    (void) ext;
#else
    const char *terminator;
    const char *loc;
    const char *extensions;

    if (glXQueryExtensionsString == NULL) {
        return 0;
    }

    extensions = glXQueryExtensionsString(display, screen);

    if(extensions == NULL || ext == NULL) {
        return 0;
    }

    while(1) {
        loc = strstr(extensions, ext);
        if(loc == NULL)
            break;

        terminator = loc + strlen(ext);
        if((loc == extensions || *(loc - 1) == ' ') &&
            (*terminator == ' ' || *terminator == '\0')) {
            return 1;
        }
        extensions = terminator;
    }
#endif

    return 0;
}

static GLADapiproc glad_glx_get_proc_from_userptr(void *userptr, const char* name) {
    return (GLAD_GNUC_EXTENSION (GLADapiproc (*)(const char *name)) userptr)(name);
}

static int glad_glx_find_extensions(Display *display, int screen) {
    GLAD_GLX_ARB_create_context = glad_glx_has_extension(display, screen, "GLX_ARB_create_context");
    GLAD_GLX_ARB_create_context_profile = glad_glx_has_extension(display, screen, "GLX_ARB_create_context_profile");
    GLAD_GLX_ARB_framebuffer_sRGB = glad_glx_has_extension(display, screen, "GLX_ARB_framebuffer_sRGB");
    GLAD_GLX_ARB_multisample = glad_glx_has_extension(display, screen, "GLX_ARB_multisample");
    GLAD_GLX_EXT_framebuffer_sRGB = glad_glx_has_extension(display, screen, "GLX_EXT_framebuffer_sRGB");
    GLAD_GLX_EXT_swap_control = glad_glx_has_extension(display, screen, "GLX_EXT_swap_control");
    GLAD_GLX_MESA_swap_control = glad_glx_has_extension(display, screen, "GLX_MESA_swap_control");
    GLAD_GLX_SGIX_pbuffer = glad_glx_has_extension(display, screen, "GLX_SGIX_pbuffer");
    GLAD_GLX_SGI_swap_control = glad_glx_has_extension(display, screen, "GLX_SGI_swap_control");
    return 1;
}

static int glad_glx_find_core_glx(Display **display, int *screen) {
    int major = 0, minor = 0;
    if(*display == NULL) {
#ifdef GLAD_GLX_NO_X11
        (void) screen;
        return 0;
#else
        *display = XOpenDisplay(0);
        if (*display == NULL) {
            return 0;
        }
        *screen = XScreenNumberOfScreen(XDefaultScreenOfDisplay(*display));
#endif
    }
    glXQueryVersion(*display, &major, &minor);
    GLAD_GLX_VERSION_1_0 = (major == 1 && minor >= 0) || major > 1;
    GLAD_GLX_VERSION_1_1 = (major == 1 && minor >= 1) || major > 1;
    GLAD_GLX_VERSION_1_2 = (major == 1 && minor >= 2) || major > 1;
    GLAD_GLX_VERSION_1_3 = (major == 1 && minor >= 3) || major > 1;
    GLAD_GLX_VERSION_1_4 = (major == 1 && minor >= 4) || major > 1;
    return GLAD_MAKE_VERSION(major, minor);
}

static int gladLoadGLXUserPtr(Display *display, int screen, GLADuserptrloadfunc load, void *userptr) {
    int version;
    glXQueryVersion = (PFNGLXQUERYVERSIONPROC) load(userptr, "glXQueryVersion");
    if(glXQueryVersion == NULL) return 0;
    version = glad_glx_find_core_glx(&display, &screen);

    glad_glx_load_GLX_VERSION_1_0(load, userptr);
    glad_glx_load_GLX_VERSION_1_1(load, userptr);
    glad_glx_load_GLX_VERSION_1_2(load, userptr);
    glad_glx_load_GLX_VERSION_1_3(load, userptr);
    glad_glx_load_GLX_VERSION_1_4(load, userptr);

    if (!glad_glx_find_extensions(display, screen)) return 0;
    glad_glx_load_GLX_ARB_create_context(load, userptr);
    glad_glx_load_GLX_EXT_swap_control(load, userptr);
    glad_glx_load_GLX_MESA_swap_control(load, userptr);
    glad_glx_load_GLX_SGIX_pbuffer(load, userptr);
    glad_glx_load_GLX_SGI_swap_control(load, userptr);

    return version;
}

static int gladLoadGLX(Display *display, int screen, GLADloadfunc load) {
    return gladLoadGLXUserPtr(display, screen, glad_glx_get_proc_from_userptr, GLAD_GNUC_EXTENSION (void*) load);
}



#ifdef GLAD_GLX

#ifndef GLAD_LOADER_LIBRARY_C_
#define GLAD_LOADER_LIBRARY_C_

#include <stddef.h>
#include <stdlib.h>

#if GLAD_PLATFORM_WIN32
#include <windows.h>
#else
#include <dlfcn.h>
#endif


static void* glad_get_dlopen_handle(const char *lib_names[], int length) {
    void *handle = NULL;
    int i;

    for (i = 0; i < length; ++i) {
#if GLAD_PLATFORM_WIN32
  #if GLAD_PLATFORM_UWP
        size_t buffer_size = (strlen(lib_names[i]) + 1) * sizeof(WCHAR);
        LPWSTR buffer = (LPWSTR) malloc(buffer_size);
        if (buffer != NULL) {
            int ret = MultiByteToWideChar(CP_ACP, 0, lib_names[i], -1, buffer, buffer_size);
            if (ret != 0) {
                handle = (void*) LoadPackagedLibrary(buffer, 0);
            }
            free((void*) buffer);
        }
  #else
        handle = (void*) LoadLibraryA(lib_names[i]);
  #endif
#else
        handle = dlopen(lib_names[i], RTLD_LAZY | RTLD_LOCAL);
#endif
        if (handle != NULL) {
            return handle;
        }
    }

    return NULL;
}

static void glad_close_dlopen_handle(void* handle) {
    if (handle != NULL) {
#if GLAD_PLATFORM_WIN32
        FreeLibrary((HMODULE) handle);
#else
        dlclose(handle);
#endif
    }
}

static GLADapiproc glad_dlsym_handle(void* handle, const char *name) {
    if (handle == NULL) {
        return NULL;
    }

#if GLAD_PLATFORM_WIN32
    return (GLADapiproc) GetProcAddress((HMODULE) handle, name);
#else
    return GLAD_GNUC_EXTENSION (GLADapiproc) dlsym(handle, name);
#endif
}

#endif /* GLAD_LOADER_LIBRARY_C_ */

typedef void* (GLAD_API_PTR *GLADglxprocaddrfunc)(const char*);

static GLADapiproc glad_glx_get_proc(void *userptr, const char *name) {
    return GLAD_GNUC_EXTENSION ((GLADapiproc (*)(const char *name)) userptr)(name);
}

static void* _glx_handle;

static void* glad_glx_dlopen_handle(void) {
    static const char *NAMES[] = {
#if defined __CYGWIN__
        "libGL-1.so",
#endif
        "libGL.so.1",
        "libGL.so"
    };

    if (_glx_handle == NULL) {
        _glx_handle = glad_get_dlopen_handle(NAMES, sizeof(NAMES) / sizeof(NAMES[0]));
    }

    return _glx_handle;
}

static void gladLoaderUnloadGLX() {
    if (_glx_handle != NULL) {
        glad_close_dlopen_handle(_glx_handle);
        _glx_handle = NULL;
    }
}

static int gladLoaderLoadGLX(Display *display, int screen) {
    int version = 0;
    void *handle = NULL;
    int did_load = 0;
    GLADglxprocaddrfunc loader;

    did_load = _glx_handle == NULL;
    handle = glad_glx_dlopen_handle();
    if (handle != NULL) {
        loader = (GLADglxprocaddrfunc) glad_dlsym_handle(handle, "glXGetProcAddressARB");
        if (loader != NULL) {
            version = gladLoadGLXUserPtr(display, screen, glad_glx_get_proc, GLAD_GNUC_EXTENSION (void*) loader);
        }

        if (!version && did_load) {
            gladLoaderUnloadGLX();
        }
    }

    return version;
}

#endif /* GLAD_GLX */

#endif /* GLAD_GLX_IMPLEMENTATION */
