#!/bin/bash

script_dir=$(dirname "$(readlink -f "$0")")

source "$script_dir"/sources.sh

utils=("cbfstool.tar.gz" "flashrom.tar.gz" "gbb_utility.tar.gz")
downloads=("$seabios_link" "$seabios_hswbdw_box" "$seabios_hswbdw_book" "$seabios_baytrail" "$seabios_braswell" "$seabios_skylake" "$seabios_apl" "$seabios_kbl" "$seabios_kbl_18" "$rwl_altfw_stoney" "$rwl_altfw_whl" "$rwl_altfw_cml" "$rwl_altfw_drallion" "$rwl_altfw_glk" "$rwl_altfw_jsl" "$rwl_altfw_pco" "$rwl_altfw_tgl" "$rwl_altfw_adl" "$rwl_altfw_adl_n" "$rwl_altfw_mdn" "$rwl_altfw_czn")

mkdir -p "$offline_source"

for i in "${utils[@]}"; do
	wget -P "$offline_source" "https://www.mrchromebox.tech/files/util/$i"
done

for i in "${downloads[@]}"; do
	wget -P "$offline_source" "https://www.mrchromebox.tech/files/firmware/rw_legacy/$i"
done
