"use strict";const lib={};lib.assert=function(condition){if(globalThis.chai){lib.assert=globalThis.chai.assert}else{lib.assert=function(condition){}}lib.assert(condition)};lib.notNull=function(value){lib.assert(value!==null);return value};lib.notUndefined=function(value){lib.assert(value!==undefined);return value};lib.polyfill={};lib.codec={};lib.codec.codeUnitArrayToString=function(array){let ret="";for(let i=0;i<array.length;++i){ret+=String.fromCharCode(array[i])}return ret};lib.codec.stringToCodeUnitArray=function(str,ret=new Uint8Array(str.length)){for(let i=0;i<str.length;++i){ret[i]=str.charCodeAt(i)}return ret};lib.colors={};lib.colors.re_={hex16:/^#([a-f0-9])([a-f0-9])([a-f0-9])([a-f0-9])?$/i,hex24:/^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})?$/i,rgb:new RegExp(("^/s*rgb/s*/(/s*(/d{1,3})/s*,/s*(/d{1,3})/s*,"+"/s*(/d{1,3})/s*/)/s*$").replace(/\//g,"\\"),"i"),rgba:new RegExp(("^/s*rgba/s*"+"/(/s*(/d{1,3})/s*,/s*(/d{1,3})/s*,/s*(/d{1,3})/s*"+"(?:,/s*(/d+(?:/./d+)?)/s*)/)/s*$").replace(/\//g,"\\"),"i"),rgbx:new RegExp(("^/s*rgba?/s*"+"/(/s*(/d{1,3})/s*,/s*(/d{1,3})/s*,/s*(/d{1,3})/s*"+"(?:,/s*(/d+(?:/./d+)?)/s*)?/)/s*$").replace(/\//g,"\\"),"i"),hsl:new RegExp(("^/s*hsl/s*"+"/(/s*(/d{1,3})/s*,/s*(/d{1,3})/s*%/s*,/s*(/d{1,3})/s*%/s*/)/s*$").replace(/\//g,"\\"),"i"),hsla:new RegExp(("^/s*hsla/s*"+"/(/s*(/d{1,3})/s*,/s*(/d{1,3})/s*%/s*,/s*(/d{1,3})/s*%/s*"+"(?:,/s*(/d+(?:/./d+)?)/s*)/)/s*$").replace(/\//g,"\\"),"i"),hslx:new RegExp(("^/s*hsla?/s*"+"/(/s*(/d{1,3})/s*,/s*(/d{1,3})/s*%/s*,/s*(/d{1,3})/s*%/s*"+"(?:,/s*(/d+(?:/./d+)?)/s*)?/)/s*$").replace(/\//g,"\\"),"i"),x11rgb:/^\s*rgb:([a-f0-9]{1,4})\/([a-f0-9]{1,4})\/([a-f0-9]{1,4})\s*$/i,name:/[a-z][a-z0-9\s]+/};lib.colors.rgbToX11=function(value){function scale(v){v=(Math.min(v,255)*257).toString(16);return lib.f.zpad(v,4)}const ary=value.match(lib.colors.re_.rgbx);if(!ary){return null}return"rgb:"+scale(ary[1])+"/"+scale(ary[2])+"/"+scale(ary[3])};lib.colors.x11HexToCSS=function(v){if(!v.startsWith("#")){return null}v=v.substr(1);if([3,6,9,12].indexOf(v.length)==-1){return null}if(v.match(/[^a-f0-9]/i)){return null}const size=v.length/3;const r=v.substr(0,size);const g=v.substr(size,size);const b=v.substr(size+size,size);function norm16(v){v=parseInt(v,16);return size==2?v:size==1?v<<4:v>>4*(size-2)}return lib.colors.arrayToRGBA([r,g,b].map(norm16))};lib.colors.x11ToCSS=function(v){function scale(v){if(v.length==1){return parseInt(v+v,16)}if(v.length==2){return parseInt(v,16)}if(v.length==3){v=v+v.substr(2)}return Math.round(parseInt(v,16)/257)}const ary=v.match(lib.colors.re_.x11rgb);if(!ary){if(v.startsWith("#")){return lib.colors.x11HexToCSS(v)}else{return lib.colors.nameToRGB(v)}}ary.splice(0,1);return lib.colors.arrayToRGBA(ary.map(scale))};lib.colors.hexToRGB=function(hex){const hex16=lib.colors.re_.hex16;const hex24=lib.colors.re_.hex24;if(hex16.test(hex)){hex=`#${hex.match(/[a-f0-9]/gi).map(x=>`${x}${x}`).join("")}`}const ary=hex.match(hex24);if(!ary){return null}const val=index=>parseInt(ary[index+1],16);return ary[4]===undefined||val(3)===255?`rgb(${val(0)}, ${val(1)}, ${val(2)})`:`rgba(${val(0)}, ${val(1)}, ${val(2)}, ${val(3)/255})`};lib.colors.rgbToHex=function(rgb){const ary=lib.colors.crackRGB(rgb);if(!ary){return null}const hex="#"+lib.f.zpad((parseInt(ary[0],10)<<16|parseInt(ary[1],10)<<8|parseInt(ary[2],10)<<0).toString(16),6);if(ary[3]===undefined||ary[3]==="1"){return hex}else{const alpha=Math.round(255*parseFloat(ary[3])).toString(16);return`${hex}${lib.f.zpad(alpha,2)}`}};lib.colors.crackHSL=function(color){if(color.startsWith("hsla")){const ary=color.match(lib.colors.re_.hsla);if(ary){ary.shift();return Array.from(ary)}}else{const ary=color.match(lib.colors.re_.hsl);if(ary){ary.shift();ary.push("1");return Array.from(ary)}}console.error(`Couldn't crack: ${color}`);return null};lib.colors.hslxArrayToRgbaArray=function(hslx){const hue=parseInt(hslx[0],10)/60;const sat=parseInt(hslx[1],10)/100;const light=parseInt(hslx[2],10)/100;const hueToRgb=(t1,t2,hue)=>{if(hue<0){hue+=6}if(hue>=6){hue-=6}if(hue<1){return(t2-t1)*hue+t1}else if(hue<3){return t2}else if(hue<4){return(t2-t1)*(4-hue)+t1}else{return t1}};const t2=light<=.5?light*(sat+1):light+sat-light*sat;const t1=light*2-t2;return[255*hueToRgb(t1,t2,hue+2),255*hueToRgb(t1,t2,hue),255*hueToRgb(t1,t2,hue-2),hslx[3]!==undefined?+hslx[3]:1]};lib.colors.hsvxArrayToHslaArray=function(hsvx){const clamp=x=>lib.f.clamp(x,0,100);const[hue,saturation,value]=hsvx.map(parseFloat);const hslLightness=clamp(value*(100-saturation/2)/100);let hslSaturation=0;if(hslLightness!==0&&hslLightness!==100){hslSaturation=clamp((value-hslLightness)/Math.min(hslLightness,100-hslLightness)*100)}return[hue,hslSaturation,hslLightness,hsvx.length===4?+hsvx[3]:1]};lib.colors.hslxArrayToHsvaArray=function(hslx){const clamp=x=>lib.f.clamp(x,0,100);const[hue,saturation,lightness]=hslx.map(parseFloat);const hsvValue=clamp(lightness+saturation*Math.min(lightness,100-lightness)/100);let hsvSaturation=0;if(hsvValue!==0){hsvSaturation=clamp(200*(1-lightness/hsvValue))}return[hue,hsvSaturation,hsvValue,hslx.length===4?+hslx[3]:1]};lib.colors.hslToRGB=function(hsl){const ary=lib.colors.crackHSL(hsl);if(!ary){return null}const[r,g,b,a]=lib.colors.hslxArrayToRgbaArray(ary);const rgb=[r,g,b].map(Math.round).join(", ");return a===1?`rgb(${rgb})`:`rgba(${rgb}, ${a})`};lib.colors.rgbxArrayToHslaArray=function(rgbx){const r=parseInt(rgbx[0],10)/255;const g=parseInt(rgbx[1],10)/255;const b=parseInt(rgbx[2],10)/255;const min=Math.min(r,g,b);const max=Math.max(r,g,b);const spread=max-min;const l=(max+min)/2;if(spread==0){return[0,0,100*l,rgbx[3]!==undefined?+rgbx[3]:1]}let h=(()=>{switch(max){case r:return(g-b)/spread%6;case g:return(b-r)/spread+2;case b:return(r-g)/spread+4}})();h*=60;if(h<0){h+=360}const s=spread/(1-Math.abs(2*l-1));return[h,100*s,100*l,rgbx[3]!==undefined?+rgbx[3]:1]};lib.colors.rgbToHsl=function(rgb){const ary=lib.colors.crackRGB(rgb);if(!ary){return null}let[h,s,l,a]=lib.colors.rgbxArrayToHslaArray(ary);h=Math.round(h);s=Math.round(s);l=Math.round(l);return a===1?`hsl(${h}, ${s}%, ${l}%)`:`hsla(${h}, ${s}%, ${l}%, ${a})`};lib.colors.normalizeCSS=function(def){if(def.startsWith("#")){return lib.colors.hexToRGB(def)}if(lib.colors.re_.rgbx.test(def)){return def}if(lib.colors.re_.hslx.test(def)){return lib.colors.hslToRGB(def)}return lib.colors.nameToRGB(def)};lib.colors.normalizeCSSToHSL=function(def){if(lib.colors.re_.hslx.test(def)){return def}const rgb=lib.colors.normalizeCSS(def);if(!rgb){return rgb}return lib.colors.rgbToHsl(rgb)};lib.colors.arrayToRGBA=function(ary){if(ary.length==3){return`rgb(${ary[0]}, ${ary[1]}, ${ary[2]})`}return`rgba(${ary[0]}, ${ary[1]}, ${ary[2]}, ${ary[3]})`};lib.colors.arrayToHSLA=function(ary){const alpha=ary.length>3?ary[3]:1;return`hsla(${Math.round(ary[0])}, ${Math.round(ary[1])}%, `+`${Math.round(ary[2])}%, ${alpha})`};lib.colors.setAlpha=function(rgb,alpha){const ary=lib.colors.crackRGB(rgb);ary[3]=alpha.toString();return lib.colors.arrayToRGBA(ary)};lib.colors.mix=function(base,tint,percent){const ary1=lib.colors.crackRGB(base);const ary2=lib.colors.crackRGB(tint);for(let i=0;i<4;++i){const basecol=parseInt(ary1[i],10);const tintcol=parseInt(ary2[i],10);const diff=tintcol-basecol;ary1[i]=Math.round(base+diff*percent).toString()}return lib.colors.arrayToRGBA(ary1)};lib.colors.crackRGB=function(color){if(color.startsWith("rgba")){const ary=color.match(lib.colors.re_.rgba);if(ary){ary.shift();return Array.from(ary)}}else{const ary=color.match(lib.colors.re_.rgb);if(ary){ary.shift();ary.push("1");return Array.from(ary)}}console.error("Couldn't crack: "+color);return null};lib.colors.nameToRGB=function(name){if(name in lib.colors.colorNames){return lib.colors.colorNames[name]}name=name.toLowerCase();if(name in lib.colors.colorNames){return lib.colors.colorNames[name]}name=name.replace(/\s+/g,"");if(name in lib.colors.colorNames){return lib.colors.colorNames[name]}return null};lib.colors.luminance=function(r,g,b){const[rr,gg,bb]=[r,g,b].map(value=>{value/=255;if(value<=.03928){return value/12.92}else{return Math.pow((value+.055)/1.055,2.4)}});return.2126*rr+.7152*gg+.0722*bb};lib.colors.contrastRatio=function(l1,l2){return(Math.max(l1,l2)+.05)/(Math.min(l1,l2)+.05)};lib.colors.stockPalette=["#000000","#CC0000","#4E9A06","#C4A000","#3465A4","#75507B","#06989A","#D3D7CF","#555753","#EF2929","#00BA13","#FCE94F","#729FCF","#F200CB","#00B5BD","#EEEEEC","#000000","#00005F","#000087","#0000AF","#0000D7","#0000FF","#005F00","#005F5F","#005F87","#005FAF","#005FD7","#005FFF","#008700","#00875F","#008787","#0087AF","#0087D7","#0087FF","#00AF00","#00AF5F","#00AF87","#00AFAF","#00AFD7","#00AFFF","#00D700","#00D75F","#00D787","#00D7AF","#00D7D7","#00D7FF","#00FF00","#00FF5F","#00FF87","#00FFAF","#00FFD7","#00FFFF","#5F0000","#5F005F","#5F0087","#5F00AF","#5F00D7","#5F00FF","#5F5F00","#5F5F5F","#5F5F87","#5F5FAF","#5F5FD7","#5F5FFF","#5F8700","#5F875F","#5F8787","#5F87AF","#5F87D7","#5F87FF","#5FAF00","#5FAF5F","#5FAF87","#5FAFAF","#5FAFD7","#5FAFFF","#5FD700","#5FD75F","#5FD787","#5FD7AF","#5FD7D7","#5FD7FF","#5FFF00","#5FFF5F","#5FFF87","#5FFFAF","#5FFFD7","#5FFFFF","#870000","#87005F","#870087","#8700AF","#8700D7","#8700FF","#875F00","#875F5F","#875F87","#875FAF","#875FD7","#875FFF","#878700","#87875F","#878787","#8787AF","#8787D7","#8787FF","#87AF00","#87AF5F","#87AF87","#87AFAF","#87AFD7","#87AFFF","#87D700","#87D75F","#87D787","#87D7AF","#87D7D7","#87D7FF","#87FF00","#87FF5F","#87FF87","#87FFAF","#87FFD7","#87FFFF","#AF0000","#AF005F","#AF0087","#AF00AF","#AF00D7","#AF00FF","#AF5F00","#AF5F5F","#AF5F87","#AF5FAF","#AF5FD7","#AF5FFF","#AF8700","#AF875F","#AF8787","#AF87AF","#AF87D7","#AF87FF","#AFAF00","#AFAF5F","#AFAF87","#AFAFAF","#AFAFD7","#AFAFFF","#AFD700","#AFD75F","#AFD787","#AFD7AF","#AFD7D7","#AFD7FF","#AFFF00","#AFFF5F","#AFFF87","#AFFFAF","#AFFFD7","#AFFFFF","#D70000","#D7005F","#D70087","#D700AF","#D700D7","#D700FF","#D75F00","#D75F5F","#D75F87","#D75FAF","#D75FD7","#D75FFF","#D78700","#D7875F","#D78787","#D787AF","#D787D7","#D787FF","#D7AF00","#D7AF5F","#D7AF87","#D7AFAF","#D7AFD7","#D7AFFF","#D7D700","#D7D75F","#D7D787","#D7D7AF","#D7D7D7","#D7D7FF","#D7FF00","#D7FF5F","#D7FF87","#D7FFAF","#D7FFD7","#D7FFFF","#FF0000","#FF005F","#FF0087","#FF00AF","#FF00D7","#FF00FF","#FF5F00","#FF5F5F","#FF5F87","#FF5FAF","#FF5FD7","#FF5FFF","#FF8700","#FF875F","#FF8787","#FF87AF","#FF87D7","#FF87FF","#FFAF00","#FFAF5F","#FFAF87","#FFAFAF","#FFAFD7","#FFAFFF","#FFD700","#FFD75F","#FFD787","#FFD7AF","#FFD7D7","#FFD7FF","#FFFF00","#FFFF5F","#FFFF87","#FFFFAF","#FFFFD7","#FFFFFF","#080808","#121212","#1C1C1C","#262626","#303030","#3A3A3A","#444444","#4E4E4E","#585858","#626262","#6C6C6C","#767676","#808080","#8A8A8A","#949494","#9E9E9E","#A8A8A8","#B2B2B2","#BCBCBC","#C6C6C6","#D0D0D0","#DADADA","#E4E4E4","#EEEEEE"].map(lib.colors.hexToRGB);lib.colors.colorNames={aliceblue:"rgb(240, 248, 255)",antiquewhite:"rgb(250, 235, 215)",antiquewhite1:"rgb(255, 239, 219)",antiquewhite2:"rgb(238, 223, 204)",antiquewhite3:"rgb(205, 192, 176)",antiquewhite4:"rgb(139, 131, 120)",aquamarine:"rgb(127, 255, 212)",aquamarine1:"rgb(127, 255, 212)",aquamarine2:"rgb(118, 238, 198)",aquamarine3:"rgb(102, 205, 170)",aquamarine4:"rgb(69, 139, 116)",azure:"rgb(240, 255, 255)",azure1:"rgb(240, 255, 255)",azure2:"rgb(224, 238, 238)",azure3:"rgb(193, 205, 205)",azure4:"rgb(131, 139, 139)",beige:"rgb(245, 245, 220)",bisque:"rgb(255, 228, 196)",bisque1:"rgb(255, 228, 196)",bisque2:"rgb(238, 213, 183)",bisque3:"rgb(205, 183, 158)",bisque4:"rgb(139, 125, 107)",black:"rgb(0, 0, 0)",blanchedalmond:"rgb(255, 235, 205)",blue:"rgb(0, 0, 255)",blue1:"rgb(0, 0, 255)",blue2:"rgb(0, 0, 238)",blue3:"rgb(0, 0, 205)",blue4:"rgb(0, 0, 139)",blueviolet:"rgb(138, 43, 226)",brown:"rgb(165, 42, 42)",brown1:"rgb(255, 64, 64)",brown2:"rgb(238, 59, 59)",brown3:"rgb(205, 51, 51)",brown4:"rgb(139, 35, 35)",burlywood:"rgb(222, 184, 135)",burlywood1:"rgb(255, 211, 155)",burlywood2:"rgb(238, 197, 145)",burlywood3:"rgb(205, 170, 125)",burlywood4:"rgb(139, 115, 85)",cadetblue:"rgb(95, 158, 160)",cadetblue1:"rgb(152, 245, 255)",cadetblue2:"rgb(142, 229, 238)",cadetblue3:"rgb(122, 197, 205)",cadetblue4:"rgb(83, 134, 139)",chartreuse:"rgb(127, 255, 0)",chartreuse1:"rgb(127, 255, 0)",chartreuse2:"rgb(118, 238, 0)",chartreuse3:"rgb(102, 205, 0)",chartreuse4:"rgb(69, 139, 0)",chocolate:"rgb(210, 105, 30)",chocolate1:"rgb(255, 127, 36)",chocolate2:"rgb(238, 118, 33)",chocolate3:"rgb(205, 102, 29)",chocolate4:"rgb(139, 69, 19)",coral:"rgb(255, 127, 80)",coral1:"rgb(255, 114, 86)",coral2:"rgb(238, 106, 80)",coral3:"rgb(205, 91, 69)",coral4:"rgb(139, 62, 47)",cornflowerblue:"rgb(100, 149, 237)",cornsilk:"rgb(255, 248, 220)",cornsilk1:"rgb(255, 248, 220)",cornsilk2:"rgb(238, 232, 205)",cornsilk3:"rgb(205, 200, 177)",cornsilk4:"rgb(139, 136, 120)",cyan:"rgb(0, 255, 255)",cyan1:"rgb(0, 255, 255)",cyan2:"rgb(0, 238, 238)",cyan3:"rgb(0, 205, 205)",cyan4:"rgb(0, 139, 139)",darkblue:"rgb(0, 0, 139)",darkcyan:"rgb(0, 139, 139)",darkgoldenrod:"rgb(184, 134, 11)",darkgoldenrod1:"rgb(255, 185, 15)",darkgoldenrod2:"rgb(238, 173, 14)",darkgoldenrod3:"rgb(205, 149, 12)",darkgoldenrod4:"rgb(139, 101, 8)",darkgray:"rgb(169, 169, 169)",darkgreen:"rgb(0, 100, 0)",darkgrey:"rgb(169, 169, 169)",darkkhaki:"rgb(189, 183, 107)",darkmagenta:"rgb(139, 0, 139)",darkolivegreen:"rgb(85, 107, 47)",darkolivegreen1:"rgb(202, 255, 112)",darkolivegreen2:"rgb(188, 238, 104)",darkolivegreen3:"rgb(162, 205, 90)",darkolivegreen4:"rgb(110, 139, 61)",darkorange:"rgb(255, 140, 0)",darkorange1:"rgb(255, 127, 0)",darkorange2:"rgb(238, 118, 0)",darkorange3:"rgb(205, 102, 0)",darkorange4:"rgb(139, 69, 0)",darkorchid:"rgb(153, 50, 204)",darkorchid1:"rgb(191, 62, 255)",darkorchid2:"rgb(178, 58, 238)",darkorchid3:"rgb(154, 50, 205)",darkorchid4:"rgb(104, 34, 139)",darkred:"rgb(139, 0, 0)",darksalmon:"rgb(233, 150, 122)",darkseagreen:"rgb(143, 188, 143)",darkseagreen1:"rgb(193, 255, 193)",darkseagreen2:"rgb(180, 238, 180)",darkseagreen3:"rgb(155, 205, 155)",darkseagreen4:"rgb(105, 139, 105)",darkslateblue:"rgb(72, 61, 139)",darkslategray:"rgb(47, 79, 79)",darkslategray1:"rgb(151, 255, 255)",darkslategray2:"rgb(141, 238, 238)",darkslategray3:"rgb(121, 205, 205)",darkslategray4:"rgb(82, 139, 139)",darkslategrey:"rgb(47, 79, 79)",darkturquoise:"rgb(0, 206, 209)",darkviolet:"rgb(148, 0, 211)",debianred:"rgb(215, 7, 81)",deeppink:"rgb(255, 20, 147)",deeppink1:"rgb(255, 20, 147)",deeppink2:"rgb(238, 18, 137)",deeppink3:"rgb(205, 16, 118)",deeppink4:"rgb(139, 10, 80)",deepskyblue:"rgb(0, 191, 255)",deepskyblue1:"rgb(0, 191, 255)",deepskyblue2:"rgb(0, 178, 238)",deepskyblue3:"rgb(0, 154, 205)",deepskyblue4:"rgb(0, 104, 139)",dimgray:"rgb(105, 105, 105)",dimgrey:"rgb(105, 105, 105)",dodgerblue:"rgb(30, 144, 255)",dodgerblue1:"rgb(30, 144, 255)",dodgerblue2:"rgb(28, 134, 238)",dodgerblue3:"rgb(24, 116, 205)",dodgerblue4:"rgb(16, 78, 139)",firebrick:"rgb(178, 34, 34)",firebrick1:"rgb(255, 48, 48)",firebrick2:"rgb(238, 44, 44)",firebrick3:"rgb(205, 38, 38)",firebrick4:"rgb(139, 26, 26)",floralwhite:"rgb(255, 250, 240)",forestgreen:"rgb(34, 139, 34)",gainsboro:"rgb(220, 220, 220)",ghostwhite:"rgb(248, 248, 255)",gold:"rgb(255, 215, 0)",gold1:"rgb(255, 215, 0)",gold2:"rgb(238, 201, 0)",gold3:"rgb(205, 173, 0)",gold4:"rgb(139, 117, 0)",goldenrod:"rgb(218, 165, 32)",goldenrod1:"rgb(255, 193, 37)",goldenrod2:"rgb(238, 180, 34)",goldenrod3:"rgb(205, 155, 29)",goldenrod4:"rgb(139, 105, 20)",gray:"rgb(190, 190, 190)",gray0:"rgb(0, 0, 0)",gray1:"rgb(3, 3, 3)",gray10:"rgb(26, 26, 26)",gray100:"rgb(255, 255, 255)",gray11:"rgb(28, 28, 28)",gray12:"rgb(31, 31, 31)",gray13:"rgb(33, 33, 33)",gray14:"rgb(36, 36, 36)",gray15:"rgb(38, 38, 38)",gray16:"rgb(41, 41, 41)",gray17:"rgb(43, 43, 43)",gray18:"rgb(46, 46, 46)",gray19:"rgb(48, 48, 48)",gray2:"rgb(5, 5, 5)",gray20:"rgb(51, 51, 51)",gray21:"rgb(54, 54, 54)",gray22:"rgb(56, 56, 56)",gray23:"rgb(59, 59, 59)",gray24:"rgb(61, 61, 61)",gray25:"rgb(64, 64, 64)",gray26:"rgb(66, 66, 66)",gray27:"rgb(69, 69, 69)",gray28:"rgb(71, 71, 71)",gray29:"rgb(74, 74, 74)",gray3:"rgb(8, 8, 8)",gray30:"rgb(77, 77, 77)",gray31:"rgb(79, 79, 79)",gray32:"rgb(82, 82, 82)",gray33:"rgb(84, 84, 84)",gray34:"rgb(87, 87, 87)",gray35:"rgb(89, 89, 89)",gray36:"rgb(92, 92, 92)",gray37:"rgb(94, 94, 94)",gray38:"rgb(97, 97, 97)",gray39:"rgb(99, 99, 99)",gray4:"rgb(10, 10, 10)",gray40:"rgb(102, 102, 102)",gray41:"rgb(105, 105, 105)",gray42:"rgb(107, 107, 107)",gray43:"rgb(110, 110, 110)",gray44:"rgb(112, 112, 112)",gray45:"rgb(115, 115, 115)",gray46:"rgb(117, 117, 117)",gray47:"rgb(120, 120, 120)",gray48:"rgb(122, 122, 122)",gray49:"rgb(125, 125, 125)",gray5:"rgb(13, 13, 13)",gray50:"rgb(127, 127, 127)",gray51:"rgb(130, 130, 130)",gray52:"rgb(133, 133, 133)",gray53:"rgb(135, 135, 135)",gray54:"rgb(138, 138, 138)",gray55:"rgb(140, 140, 140)",gray56:"rgb(143, 143, 143)",gray57:"rgb(145, 145, 145)",gray58:"rgb(148, 148, 148)",gray59:"rgb(150, 150, 150)",gray6:"rgb(15, 15, 15)",gray60:"rgb(153, 153, 153)",gray61:"rgb(156, 156, 156)",gray62:"rgb(158, 158, 158)",gray63:"rgb(161, 161, 161)",gray64:"rgb(163, 163, 163)",gray65:"rgb(166, 166, 166)",gray66:"rgb(168, 168, 168)",gray67:"rgb(171, 171, 171)",gray68:"rgb(173, 173, 173)",gray69:"rgb(176, 176, 176)",gray7:"rgb(18, 18, 18)",gray70:"rgb(179, 179, 179)",gray71:"rgb(181, 181, 181)",gray72:"rgb(184, 184, 184)",gray73:"rgb(186, 186, 186)",gray74:"rgb(189, 189, 189)",gray75:"rgb(191, 191, 191)",gray76:"rgb(194, 194, 194)",gray77:"rgb(196, 196, 196)",gray78:"rgb(199, 199, 199)",gray79:"rgb(201, 201, 201)",gray8:"rgb(20, 20, 20)",gray80:"rgb(204, 204, 204)",gray81:"rgb(207, 207, 207)",gray82:"rgb(209, 209, 209)",gray83:"rgb(212, 212, 212)",gray84:"rgb(214, 214, 214)",gray85:"rgb(217, 217, 217)",gray86:"rgb(219, 219, 219)",gray87:"rgb(222, 222, 222)",gray88:"rgb(224, 224, 224)",gray89:"rgb(227, 227, 227)",gray9:"rgb(23, 23, 23)",gray90:"rgb(229, 229, 229)",gray91:"rgb(232, 232, 232)",gray92:"rgb(235, 235, 235)",gray93:"rgb(237, 237, 237)",gray94:"rgb(240, 240, 240)",gray95:"rgb(242, 242, 242)",gray96:"rgb(245, 245, 245)",gray97:"rgb(247, 247, 247)",gray98:"rgb(250, 250, 250)",gray99:"rgb(252, 252, 252)",green:"rgb(0, 255, 0)",green1:"rgb(0, 255, 0)",green2:"rgb(0, 238, 0)",green3:"rgb(0, 205, 0)",green4:"rgb(0, 139, 0)",greenyellow:"rgb(173, 255, 47)",grey:"rgb(190, 190, 190)",grey0:"rgb(0, 0, 0)",grey1:"rgb(3, 3, 3)",grey10:"rgb(26, 26, 26)",grey100:"rgb(255, 255, 255)",grey11:"rgb(28, 28, 28)",grey12:"rgb(31, 31, 31)",grey13:"rgb(33, 33, 33)",grey14:"rgb(36, 36, 36)",grey15:"rgb(38, 38, 38)",grey16:"rgb(41, 41, 41)",grey17:"rgb(43, 43, 43)",grey18:"rgb(46, 46, 46)",grey19:"rgb(48, 48, 48)",grey2:"rgb(5, 5, 5)",grey20:"rgb(51, 51, 51)",grey21:"rgb(54, 54, 54)",grey22:"rgb(56, 56, 56)",grey23:"rgb(59, 59, 59)",grey24:"rgb(61, 61, 61)",grey25:"rgb(64, 64, 64)",grey26:"rgb(66, 66, 66)",grey27:"rgb(69, 69, 69)",grey28:"rgb(71, 71, 71)",grey29:"rgb(74, 74, 74)",grey3:"rgb(8, 8, 8)",grey30:"rgb(77, 77, 77)",grey31:"rgb(79, 79, 79)",grey32:"rgb(82, 82, 82)",grey33:"rgb(84, 84, 84)",grey34:"rgb(87, 87, 87)",grey35:"rgb(89, 89, 89)",grey36:"rgb(92, 92, 92)",grey37:"rgb(94, 94, 94)",grey38:"rgb(97, 97, 97)",grey39:"rgb(99, 99, 99)",grey4:"rgb(10, 10, 10)",grey40:"rgb(102, 102, 102)",grey41:"rgb(105, 105, 105)",grey42:"rgb(107, 107, 107)",grey43:"rgb(110, 110, 110)",grey44:"rgb(112, 112, 112)",grey45:"rgb(115, 115, 115)",grey46:"rgb(117, 117, 117)",grey47:"rgb(120, 120, 120)",grey48:"rgb(122, 122, 122)",grey49:"rgb(125, 125, 125)",grey5:"rgb(13, 13, 13)",grey50:"rgb(127, 127, 127)",grey51:"rgb(130, 130, 130)",grey52:"rgb(133, 133, 133)",grey53:"rgb(135, 135, 135)",grey54:"rgb(138, 138, 138)",grey55:"rgb(140, 140, 140)",grey56:"rgb(143, 143, 143)",grey57:"rgb(145, 145, 145)",grey58:"rgb(148, 148, 148)",grey59:"rgb(150, 150, 150)",grey6:"rgb(15, 15, 15)",grey60:"rgb(153, 153, 153)",grey61:"rgb(156, 156, 156)",grey62:"rgb(158, 158, 158)",grey63:"rgb(161, 161, 161)",grey64:"rgb(163, 163, 163)",grey65:"rgb(166, 166, 166)",grey66:"rgb(168, 168, 168)",grey67:"rgb(171, 171, 171)",grey68:"rgb(173, 173, 173)",grey69:"rgb(176, 176, 176)",grey7:"rgb(18, 18, 18)",grey70:"rgb(179, 179, 179)",grey71:"rgb(181, 181, 181)",grey72:"rgb(184, 184, 184)",grey73:"rgb(186, 186, 186)",grey74:"rgb(189, 189, 189)",grey75:"rgb(191, 191, 191)",grey76:"rgb(194, 194, 194)",grey77:"rgb(196, 196, 196)",grey78:"rgb(199, 199, 199)",grey79:"rgb(201, 201, 201)",grey8:"rgb(20, 20, 20)",grey80:"rgb(204, 204, 204)",grey81:"rgb(207, 207, 207)",grey82:"rgb(209, 209, 209)",grey83:"rgb(212, 212, 212)",grey84:"rgb(214, 214, 214)",grey85:"rgb(217, 217, 217)",grey86:"rgb(219, 219, 219)",grey87:"rgb(222, 222, 222)",grey88:"rgb(224, 224, 224)",grey89:"rgb(227, 227, 227)",grey9:"rgb(23, 23, 23)",grey90:"rgb(229, 229, 229)",grey91:"rgb(232, 232, 232)",grey92:"rgb(235, 235, 235)",grey93:"rgb(237, 237, 237)",grey94:"rgb(240, 240, 240)",grey95:"rgb(242, 242, 242)",grey96:"rgb(245, 245, 245)",grey97:"rgb(247, 247, 247)",grey98:"rgb(250, 250, 250)",grey99:"rgb(252, 252, 252)",honeydew:"rgb(240, 255, 240)",honeydew1:"rgb(240, 255, 240)",honeydew2:"rgb(224, 238, 224)",honeydew3:"rgb(193, 205, 193)",honeydew4:"rgb(131, 139, 131)",hotpink:"rgb(255, 105, 180)",hotpink1:"rgb(255, 110, 180)",hotpink2:"rgb(238, 106, 167)",hotpink3:"rgb(205, 96, 144)",hotpink4:"rgb(139, 58, 98)",indianred:"rgb(205, 92, 92)",indianred1:"rgb(255, 106, 106)",indianred2:"rgb(238, 99, 99)",indianred3:"rgb(205, 85, 85)",indianred4:"rgb(139, 58, 58)",ivory:"rgb(255, 255, 240)",ivory1:"rgb(255, 255, 240)",ivory2:"rgb(238, 238, 224)",ivory3:"rgb(205, 205, 193)",ivory4:"rgb(139, 139, 131)",khaki:"rgb(240, 230, 140)",khaki1:"rgb(255, 246, 143)",khaki2:"rgb(238, 230, 133)",khaki3:"rgb(205, 198, 115)",khaki4:"rgb(139, 134, 78)",lavender:"rgb(230, 230, 250)",lavenderblush:"rgb(255, 240, 245)",lavenderblush1:"rgb(255, 240, 245)",lavenderblush2:"rgb(238, 224, 229)",lavenderblush3:"rgb(205, 193, 197)",lavenderblush4:"rgb(139, 131, 134)",lawngreen:"rgb(124, 252, 0)",lemonchiffon:"rgb(255, 250, 205)",lemonchiffon1:"rgb(255, 250, 205)",lemonchiffon2:"rgb(238, 233, 191)",lemonchiffon3:"rgb(205, 201, 165)",lemonchiffon4:"rgb(139, 137, 112)",lightblue:"rgb(173, 216, 230)",lightblue1:"rgb(191, 239, 255)",lightblue2:"rgb(178, 223, 238)",lightblue3:"rgb(154, 192, 205)",lightblue4:"rgb(104, 131, 139)",lightcoral:"rgb(240, 128, 128)",lightcyan:"rgb(224, 255, 255)",lightcyan1:"rgb(224, 255, 255)",lightcyan2:"rgb(209, 238, 238)",lightcyan3:"rgb(180, 205, 205)",lightcyan4:"rgb(122, 139, 139)",lightgoldenrod:"rgb(238, 221, 130)",lightgoldenrod1:"rgb(255, 236, 139)",lightgoldenrod2:"rgb(238, 220, 130)",lightgoldenrod3:"rgb(205, 190, 112)",lightgoldenrod4:"rgb(139, 129, 76)",lightgoldenrodyellow:"rgb(250, 250, 210)",lightgray:"rgb(211, 211, 211)",lightgreen:"rgb(144, 238, 144)",lightgrey:"rgb(211, 211, 211)",lightpink:"rgb(255, 182, 193)",lightpink1:"rgb(255, 174, 185)",lightpink2:"rgb(238, 162, 173)",lightpink3:"rgb(205, 140, 149)",lightpink4:"rgb(139, 95, 101)",lightsalmon:"rgb(255, 160, 122)",lightsalmon1:"rgb(255, 160, 122)",lightsalmon2:"rgb(238, 149, 114)",lightsalmon3:"rgb(205, 129, 98)",lightsalmon4:"rgb(139, 87, 66)",lightseagreen:"rgb(32, 178, 170)",lightskyblue:"rgb(135, 206, 250)",lightskyblue1:"rgb(176, 226, 255)",lightskyblue2:"rgb(164, 211, 238)",lightskyblue3:"rgb(141, 182, 205)",lightskyblue4:"rgb(96, 123, 139)",lightslateblue:"rgb(132, 112, 255)",lightslategray:"rgb(119, 136, 153)",lightslategrey:"rgb(119, 136, 153)",lightsteelblue:"rgb(176, 196, 222)",lightsteelblue1:"rgb(202, 225, 255)",lightsteelblue2:"rgb(188, 210, 238)",lightsteelblue3:"rgb(162, 181, 205)",lightsteelblue4:"rgb(110, 123, 139)",lightyellow:"rgb(255, 255, 224)",lightyellow1:"rgb(255, 255, 224)",lightyellow2:"rgb(238, 238, 209)",lightyellow3:"rgb(205, 205, 180)",lightyellow4:"rgb(139, 139, 122)",limegreen:"rgb(50, 205, 50)",linen:"rgb(250, 240, 230)",magenta:"rgb(255, 0, 255)",magenta1:"rgb(255, 0, 255)",magenta2:"rgb(238, 0, 238)",magenta3:"rgb(205, 0, 205)",magenta4:"rgb(139, 0, 139)",maroon:"rgb(176, 48, 96)",maroon1:"rgb(255, 52, 179)",maroon2:"rgb(238, 48, 167)",maroon3:"rgb(205, 41, 144)",maroon4:"rgb(139, 28, 98)",mediumaquamarine:"rgb(102, 205, 170)",mediumblue:"rgb(0, 0, 205)",mediumorchid:"rgb(186, 85, 211)",mediumorchid1:"rgb(224, 102, 255)",mediumorchid2:"rgb(209, 95, 238)",mediumorchid3:"rgb(180, 82, 205)",mediumorchid4:"rgb(122, 55, 139)",mediumpurple:"rgb(147, 112, 219)",mediumpurple1:"rgb(171, 130, 255)",mediumpurple2:"rgb(159, 121, 238)",mediumpurple3:"rgb(137, 104, 205)",mediumpurple4:"rgb(93, 71, 139)",mediumseagreen:"rgb(60, 179, 113)",mediumslateblue:"rgb(123, 104, 238)",mediumspringgreen:"rgb(0, 250, 154)",mediumturquoise:"rgb(72, 209, 204)",mediumvioletred:"rgb(199, 21, 133)",midnightblue:"rgb(25, 25, 112)",mintcream:"rgb(245, 255, 250)",mistyrose:"rgb(255, 228, 225)",mistyrose1:"rgb(255, 228, 225)",mistyrose2:"rgb(238, 213, 210)",mistyrose3:"rgb(205, 183, 181)",mistyrose4:"rgb(139, 125, 123)",moccasin:"rgb(255, 228, 181)",navajowhite:"rgb(255, 222, 173)",navajowhite1:"rgb(255, 222, 173)",navajowhite2:"rgb(238, 207, 161)",navajowhite3:"rgb(205, 179, 139)",navajowhite4:"rgb(139, 121, 94)",navy:"rgb(0, 0, 128)",navyblue:"rgb(0, 0, 128)",oldlace:"rgb(253, 245, 230)",olivedrab:"rgb(107, 142, 35)",olivedrab1:"rgb(192, 255, 62)",olivedrab2:"rgb(179, 238, 58)",olivedrab3:"rgb(154, 205, 50)",olivedrab4:"rgb(105, 139, 34)",orange:"rgb(255, 165, 0)",orange1:"rgb(255, 165, 0)",orange2:"rgb(238, 154, 0)",orange3:"rgb(205, 133, 0)",orange4:"rgb(139, 90, 0)",orangered:"rgb(255, 69, 0)",orangered1:"rgb(255, 69, 0)",orangered2:"rgb(238, 64, 0)",orangered3:"rgb(205, 55, 0)",orangered4:"rgb(139, 37, 0)",orchid:"rgb(218, 112, 214)",orchid1:"rgb(255, 131, 250)",orchid2:"rgb(238, 122, 233)",orchid3:"rgb(205, 105, 201)",orchid4:"rgb(139, 71, 137)",palegoldenrod:"rgb(238, 232, 170)",palegreen:"rgb(152, 251, 152)",palegreen1:"rgb(154, 255, 154)",palegreen2:"rgb(144, 238, 144)",palegreen3:"rgb(124, 205, 124)",palegreen4:"rgb(84, 139, 84)",paleturquoise:"rgb(175, 238, 238)",paleturquoise1:"rgb(187, 255, 255)",paleturquoise2:"rgb(174, 238, 238)",paleturquoise3:"rgb(150, 205, 205)",paleturquoise4:"rgb(102, 139, 139)",palevioletred:"rgb(219, 112, 147)",palevioletred1:"rgb(255, 130, 171)",palevioletred2:"rgb(238, 121, 159)",palevioletred3:"rgb(205, 104, 137)",palevioletred4:"rgb(139, 71, 93)",papayawhip:"rgb(255, 239, 213)",peachpuff:"rgb(255, 218, 185)",peachpuff1:"rgb(255, 218, 185)",peachpuff2:"rgb(238, 203, 173)",peachpuff3:"rgb(205, 175, 149)",peachpuff4:"rgb(139, 119, 101)",peru:"rgb(205, 133, 63)",pink:"rgb(255, 192, 203)",pink1:"rgb(255, 181, 197)",pink2:"rgb(238, 169, 184)",pink3:"rgb(205, 145, 158)",pink4:"rgb(139, 99, 108)",plum:"rgb(221, 160, 221)",plum1:"rgb(255, 187, 255)",plum2:"rgb(238, 174, 238)",plum3:"rgb(205, 150, 205)",plum4:"rgb(139, 102, 139)",powderblue:"rgb(176, 224, 230)",purple:"rgb(160, 32, 240)",purple1:"rgb(155, 48, 255)",purple2:"rgb(145, 44, 238)",purple3:"rgb(125, 38, 205)",purple4:"rgb(85, 26, 139)",red:"rgb(255, 0, 0)",red1:"rgb(255, 0, 0)",red2:"rgb(238, 0, 0)",red3:"rgb(205, 0, 0)",red4:"rgb(139, 0, 0)",rosybrown:"rgb(188, 143, 143)",rosybrown1:"rgb(255, 193, 193)",rosybrown2:"rgb(238, 180, 180)",rosybrown3:"rgb(205, 155, 155)",rosybrown4:"rgb(139, 105, 105)",royalblue:"rgb(65, 105, 225)",royalblue1:"rgb(72, 118, 255)",royalblue2:"rgb(67, 110, 238)",royalblue3:"rgb(58, 95, 205)",royalblue4:"rgb(39, 64, 139)",saddlebrown:"rgb(139, 69, 19)",salmon:"rgb(250, 128, 114)",salmon1:"rgb(255, 140, 105)",salmon2:"rgb(238, 130, 98)",salmon3:"rgb(205, 112, 84)",salmon4:"rgb(139, 76, 57)",sandybrown:"rgb(244, 164, 96)",seagreen:"rgb(46, 139, 87)",seagreen1:"rgb(84, 255, 159)",seagreen2:"rgb(78, 238, 148)",seagreen3:"rgb(67, 205, 128)",seagreen4:"rgb(46, 139, 87)",seashell:"rgb(255, 245, 238)",seashell1:"rgb(255, 245, 238)",seashell2:"rgb(238, 229, 222)",seashell3:"rgb(205, 197, 191)",seashell4:"rgb(139, 134, 130)",sienna:"rgb(160, 82, 45)",sienna1:"rgb(255, 130, 71)",sienna2:"rgb(238, 121, 66)",sienna3:"rgb(205, 104, 57)",sienna4:"rgb(139, 71, 38)",skyblue:"rgb(135, 206, 235)",skyblue1:"rgb(135, 206, 255)",skyblue2:"rgb(126, 192, 238)",skyblue3:"rgb(108, 166, 205)",skyblue4:"rgb(74, 112, 139)",slateblue:"rgb(106, 90, 205)",slateblue1:"rgb(131, 111, 255)",slateblue2:"rgb(122, 103, 238)",slateblue3:"rgb(105, 89, 205)",slateblue4:"rgb(71, 60, 139)",slategray:"rgb(112, 128, 144)",slategray1:"rgb(198, 226, 255)",slategray2:"rgb(185, 211, 238)",slategray3:"rgb(159, 182, 205)",slategray4:"rgb(108, 123, 139)",slategrey:"rgb(112, 128, 144)",snow:"rgb(255, 250, 250)",snow1:"rgb(255, 250, 250)",snow2:"rgb(238, 233, 233)",snow3:"rgb(205, 201, 201)",snow4:"rgb(139, 137, 137)",springgreen:"rgb(0, 255, 127)",springgreen1:"rgb(0, 255, 127)",springgreen2:"rgb(0, 238, 118)",springgreen3:"rgb(0, 205, 102)",springgreen4:"rgb(0, 139, 69)",steelblue:"rgb(70, 130, 180)",steelblue1:"rgb(99, 184, 255)",steelblue2:"rgb(92, 172, 238)",steelblue3:"rgb(79, 148, 205)",steelblue4:"rgb(54, 100, 139)",tan:"rgb(210, 180, 140)",tan1:"rgb(255, 165, 79)",tan2:"rgb(238, 154, 73)",tan3:"rgb(205, 133, 63)",tan4:"rgb(139, 90, 43)",thistle:"rgb(216, 191, 216)",thistle1:"rgb(255, 225, 255)",thistle2:"rgb(238, 210, 238)",thistle3:"rgb(205, 181, 205)",thistle4:"rgb(139, 123, 139)",tomato:"rgb(255, 99, 71)",tomato1:"rgb(255, 99, 71)",tomato2:"rgb(238, 92, 66)",tomato3:"rgb(205, 79, 57)",tomato4:"rgb(139, 54, 38)",turquoise:"rgb(64, 224, 208)",turquoise1:"rgb(0, 245, 255)",turquoise2:"rgb(0, 229, 238)",turquoise3:"rgb(0, 197, 205)",turquoise4:"rgb(0, 134, 139)",violet:"rgb(238, 130, 238)",violetred:"rgb(208, 32, 144)",violetred1:"rgb(255, 62, 150)",violetred2:"rgb(238, 58, 140)",violetred3:"rgb(205, 50, 120)",violetred4:"rgb(139, 34, 82)",wheat:"rgb(245, 222, 179)",wheat1:"rgb(255, 231, 186)",wheat2:"rgb(238, 216, 174)",wheat3:"rgb(205, 186, 150)",wheat4:"rgb(139, 126, 102)",white:"rgb(255, 255, 255)",whitesmoke:"rgb(245, 245, 245)",yellow:"rgb(255, 255, 0)",yellow1:"rgb(255, 255, 0)",yellow2:"rgb(238, 238, 0)",yellow3:"rgb(205, 205, 0)",yellow4:"rgb(139, 139, 0)",yellowgreen:"rgb(154, 205, 50)"};lib.Event=function(){const ep=function(...args){ep.observers.forEach(callback=>callback.apply(null,args))};ep.addListener=function(callback){ep.observers.push(callback)};ep.removeListener=function(callback){ep.observers=ep.observers.filter(cb=>cb!==callback)};ep.observers=[];return ep};lib.f={};lib.f.replaceVars=function(str,vars){return str.replace(/%([a-z]*)\(([^)]+)\)/gi,function(match,fn,varname){if(typeof vars[varname]=="undefined"){throw new Error(`Unknown variable: ${varname}`)}let rv=vars[varname];if(fn in lib.f.replaceVars.functions){rv=lib.f.replaceVars.functions[fn](rv)}else if(fn){throw new Error(`Unknown escape function: ${fn}`)}return rv})};lib.f.replaceVars.functions={encodeURI:encodeURI,encodeURIComponent:encodeURIComponent,escapeHTML:function(str){const map={"<":"&lt;",">":"&gt;","&":"&amp;",'"':"&quot;","'":"&#39;"};return str.replace(/[<>&"']/g,m=>map[m])}};lib.f.getURL=function(path){if(lib.f.getURL.chromeSupported()){return chrome.runtime.getURL(path)}if(path.startsWith("/")){return globalThis.location.origin+path}return path};lib.f.getURL.chromeSupported=function(){return!!globalThis.chrome?.runtime?.getURL};lib.f.clamp=function(v,min,max){if(v<min){return min}if(v>max){return max}return v};lib.f.zpad=function(number,length){return String(number).padStart(length,"0")};lib.f.longestCommonPrefix=function(elements,start=0){if(elements.length===0){return start}while(true){const c=elements[0][start];if(c===undefined){break}if(!elements.slice(1).every(ele=>ele[start]===c)){break}++start}return start};lib.f.getStack=function(ignoreFrames=0,count=undefined){const stackArray=(new Error).stack.split("\n");ignoreFrames+=2;const max=stackArray.length-ignoreFrames;if(count===undefined){count=max}else{count=lib.f.clamp(count,0,max)}const stackObject=new Array;for(let i=ignoreFrames;i<count+ignoreFrames;++i){stackObject.push(stackArray[i].replace(/^\s*at\s+/,""))}return stackObject};lib.f.smartFloorDivide=function(numerator,denominator){const val=numerator/denominator;const ceiling=Math.ceil(val);if(ceiling-val<1e-4){return ceiling}else{return Math.floor(val)}};lib.f.randomInt=function(min,max){return Math.floor(Math.random()*(max-min+1))+min};lib.f.getOs=function(){if(globalThis.browser?.runtime?.getPlatformInfo){return browser.runtime.getPlatformInfo().then(info=>info.os)}if(globalThis.chrome?.runtime?.getPlatformInfo){return new Promise((resolve,reject)=>{return chrome.runtime.getPlatformInfo(info=>resolve(info.os))})}if(globalThis.navigator?.userAgent){const ua=navigator.userAgent;if(ua.includes("Mac OS X")){return Promise.resolve("mac")}else if(ua.includes("CrOS")){return Promise.resolve("cros")}else if(ua.includes("Linux")){return Promise.resolve("linux")}else if(ua.includes("Android")){return Promise.resolve("android")}else if(ua.includes("Windows")){return Promise.resolve("windows")}}if(typeof process!="undefined"){return Promise.resolve("node")}return Promise.reject(null)};lib.f.getChromeMilestone=function(){if(globalThis.navigator?.userAgent){const ary=navigator.userAgent.match(/\sChrome\/(\d+)/);if(ary){return parseInt(ary[1],10)}}return NaN};lib.f.lastError=function(defaultMsg=null){let lastError;if(globalThis.browser?.runtime){lastError=browser.runtime.lastError}else if(globalThis.chrome?.runtime){lastError=chrome.runtime.lastError}if(lastError&&lastError.message){return lastError.message}else{return defaultMsg}};lib.f.openWindow=function(url,name=undefined,features=undefined){if(globalThis.open===undefined){if(name==="_blank"){chrome.tabs.create({url:url})}else{let type=chrome.windows.CreateType.NORMAL;if(features!==undefined&&features.includes("chrome=no")){type=chrome.windows.CreateType.POPUP}chrome.windows.create({focused:true,type:type,url:url})}return undefined}const win=globalThis.open(undefined,name,features);if(win!==null){win.opener=null;if(url){win.location=url}}return win};lib.i18n={};lib.i18n.browser_=globalThis.browser?.i18n?browser.i18n:globalThis.chrome?.i18n?chrome.i18n:null;lib.i18n.browserSupported=function(){return lib.i18n.browser_!==null};lib.i18n.getAcceptLanguages=function(){if(lib.i18n.browser_){return new Promise(resolve=>{lib.i18n.browser_.getAcceptLanguages(languages=>{if(!languages){console.error("getAcceptLanguages failed",lib.f.lastError());languages=["en"]}resolve(languages)})})}else{const languages=navigator.languages||[navigator.language];return Promise.resolve(languages)}};lib.i18n.getMessage=function(msgname,substitutions=[],fallback=""){if(lib.i18n.browser_){const message=lib.i18n.browser_.getMessage(msgname,substitutions);if(message){return message}}return lib.i18n.replaceReferences(fallback,substitutions)};lib.i18n.replaceReferences=function(msg,args=[]){if(args===null){args=[]}if(!(args instanceof Array)){args=[args]}return msg.replace(/\$(\d+)/g,(m,index)=>{return index<=args.length?args[index-1]:""})};lib.i18n.resolveLanguage=function(language){const[lang,region]=language.toLowerCase().split(/[-_]/,2);if(lang=="es"){if([undefined,"es"].includes(region)){return["es"]}return["es_419"]}if(lang=="pt"){if([undefined,"br"].includes(region)){return["pt_BR"]}return["pt_PT"]}if(lang=="zh"){if(["tw","hk","mo"].includes(region)){return["zh_TW"]}return["zh_CN"]}if(lang=="en"){if([undefined,"us","lr","ph"].includes(region)){return["en"]}return["en_GB","en"]}if(region){return[language.replace(/-/g,"_"),lang]}else{return[lang]}};lib.MessageManager=function(languages,useCrlf=false){this.languages_=[];let stop=false;for(let i=0;i<languages.length&&!stop;i++){for(const lang of lib.i18n.resolveLanguage(languages[i])){if(lang=="en"){stop=true;break}if(!this.languages_.includes(lang)){this.languages_.push(lang)}}}this.languages_.push("en");this.useCrlf=useCrlf;this.messages_={}};lib.MessageManager.Messages;lib.MessageManager.prototype.addMessages=function(defs){for(const key in defs){const def=defs[key];if(!def.placeholders){this.messages_[key.toUpperCase()]=def.message}else{this.messages_[key.toUpperCase()]=def.message.replace(/\$([a-z][^\s$]+)\$/gi,function(m,name){return defs[key].placeholders[name.toUpperCase()].content})}}};lib.MessageManager.prototype.findAndLoadMessages=async function(pattern){if(lib.i18n.browserSupported()){return}for(let i=this.languages_.length-1;i>=0;i--){const lang=this.languages_[i];const url=lib.i18n.replaceReferences(pattern,lang);try{await this.loadMessages(url)}catch(e){console.warn(`Error fetching ${lang} messages at ${url}`,e,"Trying all languages in reverse order:",this.languages_)}}};lib.MessageManager.prototype.loadMessages=function(url){return new Promise((resolve,reject)=>{const xhr=new XMLHttpRequest;xhr.onload=()=>{try{this.addMessages(JSON.parse(xhr.responseText));resolve()}catch(e){reject(e)}};xhr.onerror=()=>reject(xhr);xhr.open("GET",url);xhr.send()})};lib.MessageManager.prototype.get=function(msgname,args,fallback){let message=lib.i18n.getMessage(msgname,args);if(!message){message=this.messages_[msgname];if(!message){console.warn("Unknown message: "+msgname);message=fallback===undefined?msgname:fallback;this.messages_[msgname]=message}message=lib.i18n.replaceReferences(message,args)}if(this.useCrlf){message=message.replace(/\n/g,"\r\n")}return message};lib.MessageManager.prototype.processI18nAttributes=function(node){const nodes=node.querySelectorAll("[i18n]");for(let i=0;i<nodes.length;i++){this.processI18nAttribute(nodes[i])}};lib.MessageManager.prototype.processI18nAttribute=function(node){const thunk=str=>str.replace(/-/g,"_").toUpperCase();let i18n=node.getAttribute("i18n");if(!i18n){return}try{i18n=JSON.parse(i18n)}catch(ex){console.error("Can't parse "+node.tagName+"#"+node.id+": "+i18n);throw ex}for(let key in i18n){const attr=key;let msgname=i18n[key];if(msgname.startsWith("=")){key=msgname.substr(1);msgname=i18n[key]}if(msgname.startsWith("$")){msgname=thunk(node.getAttribute(msgname.substr(1))+"_"+key)}const msg=this.get(msgname);if(attr=="_"){node.textContent=msg}else{node.setAttribute(attr,msg)}}};lib.PreferenceManager=function(storage,prefix="/"){this.storage=storage;this.storageObserver_=this.onStorageChange_.bind(this);this.storage.addObserver(this.storageObserver_);this.trace=false;if(!prefix.endsWith("/")){prefix+="/"}this.prefix=prefix;this.isImportingJson_=false;this.prefRecords_={};this.globalObservers_=[];this.prefixObservers_=[];this.childFactories_={};this.childLists_={}};lib.PreferenceManager.prototype.DEFAULT_VALUE=Symbol("DEFAULT_VALUE");lib.PreferenceManager.Record=function(name,defaultValue){this.name=name;this.defaultValue=defaultValue;this.currentValue=this.DEFAULT_VALUE;this.observers=[]};lib.PreferenceManager.Record.prototype.DEFAULT_VALUE=lib.PreferenceManager.prototype.DEFAULT_VALUE;lib.PreferenceManager.Record.prototype.addObserver=function(observer){this.observers.push(observer)};lib.PreferenceManager.Record.prototype.removeObserver=function(observer){const i=this.observers.indexOf(observer);if(i>=0){this.observers.splice(i,1)}};lib.PreferenceManager.Record.prototype.get=function(){const result=this.currentValue===this.DEFAULT_VALUE?this.defaultValue:this.currentValue;if(typeof this.defaultValue==="object"){return JSON.parse(JSON.stringify(result))}return result};lib.PreferenceManager.prototype.setPrefix=function(prefix,callback){if(!prefix.endsWith("/")){prefix+="/"}if(prefix===this.prefix){if(callback){callback()}return}this.prefix=prefix;for(const name in this.prefRecords_){this.prefRecords_[name].currentValue=this.DEFAULT_VALUE}this.readStorage(()=>{for(const o of this.prefixObservers_){o(this.prefix,this)}this.notifyAll();if(callback){callback()}})};lib.PreferenceManager.prototype.readStorage=function(callback=undefined){let pendingChildren=0;function onChildComplete(){if(--pendingChildren==0&&callback){callback()}}const keys=Object.keys(this.prefRecords_).map(el=>this.prefix+el);if(this.trace){console.log("Preferences read: "+this.prefix)}this.storage.getItems(keys).then(items=>{const prefixLength=this.prefix.length;for(const key in items){const value=items[key];const name=key.substr(prefixLength);const needSync=name in this.childLists_&&JSON.stringify(value)!=JSON.stringify(this.prefRecords_[name].currentValue);this.prefRecords_[name].currentValue=value;if(needSync){pendingChildren++;this.syncChildList(name,onChildComplete)}}if(pendingChildren==0&&callback){setTimeout(callback)}})};lib.PreferenceManager.prototype.definePreference=function(name,value,onChange=undefined){let record=this.prefRecords_[name];if(record){this.changeDefault(name,value)}else{record=this.prefRecords_[name]=new lib.PreferenceManager.Record(name,value)}if(onChange){record.addObserver(onChange)}};lib.PreferenceManager.prototype.definePreferences=function(defaults){for(let i=0;i<defaults.length;i++){this.definePreference(defaults[i][0],defaults[i][1],defaults[i][2])}};lib.PreferenceManager.prototype.defineChildren=function(listName,childFactory){this.definePreference(listName,[],this.onChildListChange_.bind(this,listName));this.childFactories_[listName]=childFactory;this.childLists_[listName]={}};lib.PreferenceManager.prototype.addPrefixObserver=function(observer){this.prefixObservers_.push(observer)};lib.PreferenceManager.prototype.removePrefixObserver=function(observer){const i=this.prefixObservers_.indexOf(observer);if(i>=0){this.prefixObservers_.splice(i,1)}};lib.PreferenceManager.prototype.addObserver=function(name,observer){if(!(name in this.prefRecords_)){throw new Error(`Unknown preference: ${name}`)}this.prefRecords_[name].addObserver(observer)};lib.PreferenceManager.prototype.addObservers=function(global,map){if(global&&typeof global!="function"){throw new Error("Invalid param: globals")}if(global){this.globalObservers_.push(global)}if(!map){return}for(const name in map){this.addObserver(name,map[name])}};lib.PreferenceManager.prototype.removeObserver=function(name,observer){if(!(name in this.prefRecords_)){throw new Error(`Unknown preference: ${name}`)}this.prefRecords_[name].removeObserver(observer)};lib.PreferenceManager.prototype.notifyAll=function(){for(const name in this.prefRecords_){this.notifyChange_(name)}};lib.PreferenceManager.prototype.notifyChange_=function(name){const record=this.prefRecords_[name];if(!record){throw new Error("Unknown preference: "+name)}const currentValue=record.get();for(let i=0;i<this.globalObservers_.length;i++){this.globalObservers_[i](name,currentValue)}for(let i=0;i<record.observers.length;i++){record.observers[i](currentValue,name,this)}};lib.PreferenceManager.newRandomId=function(existingIds=[],prefix=undefined){while(true){let id=lib.f.randomInt(1,65535).toString(16);id=lib.f.zpad(id,4);if(prefix){id=`${prefix}:${id}`}if(existingIds.indexOf(id)===-1){return id}}};lib.PreferenceManager.prototype.createChild=function(listName,prefix=undefined,id=undefined){const ids=this.get(listName);if(id){if(ids.indexOf(id)!=-1){throw new Error("Duplicate child: "+listName+": "+id)}}else{id=lib.PreferenceManager.newRandomId(ids,prefix)}const childManager=this.childFactories_[listName](this,id);childManager.trace=this.trace;childManager.resetAll();this.childLists_[listName][id]=childManager;ids.push(id);this.set(listName,ids,undefined,!this.isImportingJson_);return childManager};lib.PreferenceManager.prototype.removeChild=function(listName,id){const prefs=this.getChild(listName,id);prefs.resetAll();const ids=this.get(listName);const i=ids.indexOf(id);if(i!=-1){ids.splice(i,1);this.set(listName,ids,undefined,!this.isImportingJson_)}delete this.childLists_[listName][id]};lib.PreferenceManager.prototype.getChild=function(listName,id,defaultValue=undefined){if(!(listName in this.childLists_)){throw new Error("Unknown child list: "+listName)}const childList=this.childLists_[listName];if(!(id in childList)){if(defaultValue===undefined){throw new Error('Unknown "'+listName+'" child: '+id)}return defaultValue}return childList[id]};lib.PreferenceManager.prototype.syncChildList=function(listName,callback=undefined){let pendingChildren=0;function onChildStorage(){if(--pendingChildren==0&&callback){callback()}}const currentIds=this.get(listName);const oldIds=Object.keys(this.childLists_[listName]);for(let i=0;i<currentIds.length;i++){const id=currentIds[i];const managerIndex=oldIds.indexOf(id);if(managerIndex>=0){oldIds.splice(managerIndex,1)}if(!this.childLists_[listName][id]){const childManager=this.childFactories_[listName](this,id);if(!childManager){console.warn("Unable to restore child: "+listName+": "+id);continue}childManager.trace=this.trace;this.childLists_[listName][id]=childManager;pendingChildren++;childManager.readStorage(onChildStorage)}}for(let i=0;i<oldIds.length;i++){delete this.childLists_[listName][oldIds[i]]}if(!pendingChildren&&callback){setTimeout(callback)}};lib.PreferenceManager.prototype.reset=function(name){const record=this.prefRecords_[name];if(!record){throw new Error("Unknown preference: "+name)}this.storage.removeItem(this.prefix+name);if(record.currentValue!==this.DEFAULT_VALUE){record.currentValue=this.DEFAULT_VALUE;this.notifyChange_(name)}};lib.PreferenceManager.prototype.resetAll=function(){const changed=[];for(const listName in this.childLists_){const childList=this.childLists_[listName];for(const id in childList){childList[id].resetAll()}}for(const name in this.prefRecords_){if(this.prefRecords_[name].currentValue!==this.DEFAULT_VALUE){this.prefRecords_[name].currentValue=this.DEFAULT_VALUE;changed.push(name)}}const keys=Object.keys(this.prefRecords_).map(function(el){return this.prefix+el}.bind(this));this.storage.removeItems(keys);changed.forEach(this.notifyChange_.bind(this))};lib.PreferenceManager.prototype.diff=function(a,b){if(typeof a!==typeof b){return true}if(!/^(undefined|boolean|number|string)$/.test(typeof a)){if(a===null&&b===null){return false}else{return JSON.stringify(a)!==JSON.stringify(b)}}return a!==b};lib.PreferenceManager.prototype.changeDefault=function(name,newValue){const record=this.prefRecords_[name];if(!record){throw new Error("Unknown preference: "+name)}if(!this.diff(record.defaultValue,newValue)){return}if(record.currentValue!==this.DEFAULT_VALUE){record.defaultValue=newValue;return}record.defaultValue=newValue;this.notifyChange_(name)};lib.PreferenceManager.prototype.changeDefaults=function(map){for(const key in map){this.changeDefault(key,map[key])}};lib.PreferenceManager.prototype.set=function(name,newValue,onComplete=undefined,saveToStorage=true){const record=this.prefRecords_[name];if(!record){throw new Error("Unknown preference: "+name)}const oldValue=record.get();if(!this.diff(oldValue,newValue)){return Promise.resolve()}if(this.diff(record.defaultValue,newValue)){record.currentValue=newValue;if(saveToStorage){this.storage.setItem(this.prefix+name,newValue).then(onComplete)}}else{record.currentValue=this.DEFAULT_VALUE;if(saveToStorage){this.storage.removeItem(this.prefix+name).then(onComplete)}}return Promise.resolve().then(()=>{this.notifyChange_(name)})};lib.PreferenceManager.prototype.get=function(name){const record=this.prefRecords_[name];if(!record){throw new Error("Unknown preference: "+name)}return record.get()};lib.PreferenceManager.prototype.getDefault=function(name){const record=this.prefRecords_[name];if(!record){throw new Error(`Unknown preference: ${name}`)}return record.defaultValue};lib.PreferenceManager.prototype.getBoolean=function(name){const result=this.get(name);lib.assert(typeof result=="boolean");return result};lib.PreferenceManager.prototype.getNumber=function(name){const result=this.get(name);lib.assert(typeof result=="number");return result};lib.PreferenceManager.prototype.getString=function(name){const result=this.get(name);lib.assert(typeof result=="string");return result};lib.PreferenceManager.prototype.exportAsJson=function(){const rv={};for(const name in this.prefRecords_){if(name in this.childLists_){rv[name]=[];const childIds=this.get(name);for(let i=0;i<childIds.length;i++){const id=childIds[i];rv[name].push({id:id,json:this.getChild(name,id).exportAsJson()})}}else{const record=this.prefRecords_[name];if(record.currentValue!=this.DEFAULT_VALUE){rv[name]=record.currentValue}}}return rv};lib.PreferenceManager.prototype.importFromJson=async function(json){this.isImportingJson_=true;for(const listName in this.childLists_){const childList=this.childLists_[listName];for(const id in childList){this.removeChild(listName,id)}}this.resetAll();for(const name in json){if(name in this.childLists_){const childList=json[name];const ids=[];for(let i=0;i<childList.length;i++){const id=childList[i].id;ids.push(id);let childPrefManager=this.childLists_[name][id];if(!childPrefManager){childPrefManager=this.createChild(name,null,id)}await childPrefManager.importFromJson(childList[i].json)}await this.set(name,ids)}else{await this.set(name,json[name])}}this.isImportingJson_=false};lib.PreferenceManager.prototype.onChildListChange_=function(listName){this.syncChildList(listName)};lib.PreferenceManager.prototype.onStorageChange_=function(map){for(const key in map){if(this.prefix){if(key.lastIndexOf(this.prefix,0)!=0){continue}}const name=key.substr(this.prefix.length);if(!(name in this.prefRecords_)){continue}const record=this.prefRecords_[name];const newValue=map[key].newValue;let currentValue=record.currentValue;if(currentValue===record.DEFAULT_VALUE){currentValue=undefined}if(this.diff(currentValue,newValue)){if(typeof newValue=="undefined"||newValue===null){record.currentValue=record.DEFAULT_VALUE}else{record.currentValue=newValue}this.notifyChange_(name)}}};lib.resource={};lib.resource.resources_={};lib.resource.ResourceRecord;lib.resource.add=function(name,type,data){lib.resource.resources_[name]={type:type,name:name,data:data}};lib.resource.get=function(name,defaultValue){if(!(name in lib.resource.resources_)){lib.assert(defaultValue!==undefined);return defaultValue}return lib.resource.resources_[name]};lib.resource.getText=function(name){const resource=lib.resource.resources_[name];if(resource===undefined){throw new Error(`Error: Resource "${name}" does not exist`)}if(!resource.type.startsWith("text/")&&!resource.type.startsWith("image/svg")){throw new Error(`Error: Resource "${name}" is not of type string`)}return String(lib.resource.resources_[name].data)};lib.resource.getData=function(name,defaultValue){if(!(name in lib.resource.resources_)){return defaultValue}return lib.resource.resources_[name].data};lib.resource.getDataUrl=function(name,defaultValue){const resource=lib.resource.get(name,defaultValue);return"data:"+resource.type+","+resource.data};lib.Storage=function(){};lib.Storage.prototype.addObserver=function(callback){};lib.Storage.prototype.removeObserver=function(callback){};lib.Storage.prototype.clear=async function(){};lib.Storage.prototype.getItem=async function(key){};lib.Storage.prototype.getItems=async function(keys){};lib.Storage.prototype.setItem=async function(key,value){};lib.Storage.prototype.setItems=async function(obj){};lib.Storage.prototype.removeItem=async function(key){};lib.Storage.prototype.removeItems=async function(keys){};lib.Storage.generateStorageChanges=function(oldStorage,newStorage){const changes={};for(const key in newStorage){const newValue=newStorage[key];if(oldStorage.hasOwnProperty(key)){const oldValue=oldStorage[key];if(oldValue!==newValue){changes[key]={oldValue:oldValue,newValue:newValue}}}else{changes[key]={newValue:newValue}}}for(const key in oldStorage){if(!newStorage.hasOwnProperty(key)){changes[key]={oldValue:oldStorage[key]}}}return changes};lib.Storage.Chrome=function(storage){this.storage_=storage;this.observers_=[];storage.onChanged.addListener(this.onChanged_.bind(this))};lib.Storage.Chrome.prototype.onChanged_=function(changes){this.observers_.forEach(o=>o(changes))};lib.Storage.Chrome.prototype.addObserver=function(callback){this.observers_.push(callback)};lib.Storage.Chrome.prototype.removeObserver=function(callback){const i=this.observers_.indexOf(callback);if(i!=-1){this.observers_.splice(i,1)}};lib.Storage.Chrome.prototype.clear=async function(){return new Promise(resolve=>{this.storage_.clear(resolve)})};lib.Storage.Chrome.prototype.getItem=async function(key){return this.getItems([key]).then(items=>items[key])};lib.Storage.Chrome.prototype.getItems=async function(keys){return new Promise(resolve=>{this.storage_.get(keys,resolve)})};lib.Storage.Chrome.prototype.setItem=async function(key,value){return new Promise(resolve=>{const onComplete=()=>{const err=lib.f.lastError();if(err){if(err.indexOf("MAX_WRITE_OPERATIONS")){console.warn(`Will retry '${key}' save after exceeding quota:`,err);setTimeout(()=>this.setItem(key,value).then(onComplete),1e3);return}else{console.error(`Unknown runtime error: ${err}`)}}resolve()};this.setItems({[key]:value}).then(onComplete)})};lib.Storage.Chrome.prototype.setItems=async function(obj){return new Promise(resolve=>{this.storage_.set(obj,resolve)})};lib.Storage.Chrome.prototype.removeItem=async function(key){return this.removeItems([key])};lib.Storage.Chrome.prototype.removeItems=async function(keys){return new Promise(resolve=>{this.storage_.remove(keys,resolve)})};lib.Storage.Local=function(storage=undefined){this.observers_=[];this.storage_=storage?storage:lib.notNull(globalThis.localStorage);globalThis.addEventListener("storage",this.onStorage_.bind(this))};lib.Storage.Local.prototype.parseJson_=function(jsonString){if(jsonString!==null){try{return JSON.parse(jsonString)}catch(e){}}return jsonString};lib.Storage.Local.prototype.onStorage_=function(e){if(e.storageArea!=this.storage_){return}const o={};o[e.key]={oldValue:this.parseJson_(e.oldValue),newValue:this.parseJson_(e.newValue)};for(let i=0;i<this.observers_.length;i++){this.observers_[i](o)}};lib.Storage.Local.prototype.addObserver=function(callback){this.observers_.push(callback)};lib.Storage.Local.prototype.removeObserver=function(callback){const i=this.observers_.indexOf(callback);if(i!=-1){this.observers_.splice(i,1)}};lib.Storage.Local.prototype.clear=async function(){this.storage_.clear();await 0};lib.Storage.Local.prototype.getItem=async function(key){return this.getItems([key]).then(items=>items[key])};lib.Storage.Local.prototype.getItems=async function(keys){const rv={};if(!keys){keys=[];for(let i=0;i<this.storage_.length;i++){keys.push(this.storage_.key(i))}}for(const key of keys){const value=this.storage_.getItem(key);if(typeof value=="string"){rv[key]=this.parseJson_(value)}}await 0;return rv};lib.Storage.Local.prototype.setItem=async function(key,value){return this.setItems({[key]:value})};lib.Storage.Local.prototype.setItems=async function(obj){for(const key in obj){this.storage_.setItem(key,JSON.stringify(obj[key]))}await 0};lib.Storage.Local.prototype.removeItem=async function(key){return this.removeItems([key])};lib.Storage.Local.prototype.removeItems=async function(keys){for(let i=0;i<keys.length;i++){this.storage_.removeItem(keys[i])}await 0};lib.Storage.Memory=function(){this.observers_=[];this.storage_={}};lib.Storage.Memory.prototype.addObserver=function(callback){this.observers_.push(callback)};lib.Storage.Memory.prototype.removeObserver=function(callback){const i=this.observers_.indexOf(callback);if(i!=-1){this.observers_.splice(i,1)}};lib.Storage.Memory.prototype.update_=async function(newStorage){const changes=lib.Storage.generateStorageChanges(this.storage_,newStorage);this.storage_=newStorage;await 0;if(Object.keys(changes).length){this.observers_.forEach(o=>o(changes))}};lib.Storage.Memory.prototype.clear=async function(){return this.update_({})};lib.Storage.Memory.prototype.getItem=async function(key){return this.getItems([key]).then(items=>items[key])};lib.Storage.Memory.prototype.getItems=async function(keys){const rv={};if(!keys){keys=Object.keys(this.storage_)}keys.forEach(key=>{if(this.storage_.hasOwnProperty(key)){rv[key]=this.storage_[key]}});await 0;return rv};lib.Storage.Memory.prototype.setItem=async function(key,value){return this.setItems({[key]:value})};lib.Storage.Memory.prototype.setItems=async function(obj){const newStorage=Object.assign({},this.storage_);for(const key in obj){newStorage[key]=JSON.parse(JSON.stringify(obj[key]))}return this.update_(newStorage)};lib.Storage.Memory.prototype.removeItem=async function(key){return this.removeItems([key])};lib.Storage.Memory.prototype.removeItems=async function(keys){const newStorage=Object.assign({},this.storage_);keys.forEach(key=>delete newStorage[key]);return this.update_(newStorage)};lib.Storage.TerminalPrivate=function(prefPath="crostini.terminal_settings",storage=chrome.terminalPrivate){this.prefPath_=lib.notUndefined(prefPath);this.observers_=[];this.prefValue_={};this.prefValueWriteToResolve_=[];this.prefsLoaded_=false;this.storage_=storage;this.storage_.onPrefChanged.addListener(this.onPrefChanged_.bind(this))};lib.Storage.TerminalPrivate.prototype.initCache_=function(){return new Promise(resolve=>{if(this.prefsLoaded_){resolve();return}this.storage_.getPrefs([this.prefPath_],prefs=>{const err=lib.f.lastError();if(err){console.error(err)}else{this.prefValue_=lib.notNull(prefs[this.prefPath_])}this.prefsLoaded_=true;resolve()})})};lib.Storage.TerminalPrivate.prototype.onPrefChanged_=function(prefs){const pref=prefs[this.prefPath_];if(!pref||typeof pref!=="object"){return}const changes=lib.Storage.generateStorageChanges(this.prefValue_,pref);this.prefValue_=pref;if(Object.keys(changes).length){setTimeout(()=>{this.observers_.forEach(o=>o(changes))})}};lib.Storage.TerminalPrivate.prototype.setPref_=function(){lib.assert(this.prefsLoaded_);return new Promise(resolve=>{this.prefValueWriteToResolve_.push(resolve);if(this.prefValueWriteToResolve_.length>1){return}setTimeout(()=>{this.storage_.setPrefs({[this.prefPath_]:this.prefValue_},()=>{const err=lib.f.lastError();if(err){console.error(err)}this.prefValueWriteToResolve_.forEach(r=>r());this.prefValueWriteToResolve_=[]})})})};lib.Storage.TerminalPrivate.prototype.addObserver=function(callback){this.observers_.push(callback)};lib.Storage.TerminalPrivate.prototype.removeObserver=function(callback){const i=this.observers_.indexOf(callback);if(i!==-1){this.observers_.splice(i,1)}};lib.Storage.TerminalPrivate.prototype.update_=async function(newStorage){const changes=lib.Storage.generateStorageChanges(this.prefValue_,newStorage);this.prefValue_=newStorage;await this.setPref_();if(Object.keys(changes).length){this.observers_.forEach(o=>o(changes))}};lib.Storage.TerminalPrivate.prototype.clear=async function(){await this.initCache_();return this.update_({})};lib.Storage.TerminalPrivate.prototype.getItem=async function(key){await this.initCache_();return this.prefValue_[key]};lib.Storage.TerminalPrivate.prototype.getItems=async function(keys){await this.initCache_();const rv={};if(!keys){keys=Object.keys(this.prefValue_)}for(const key of keys){if(this.prefValue_.hasOwnProperty(key)){rv[key]=this.prefValue_[key]}}return rv};lib.Storage.TerminalPrivate.prototype.setItem=async function(key,value){return this.setItems({[key]:value})};lib.Storage.TerminalPrivate.prototype.setItems=async function(obj){await this.initCache_();return this.update_(Object.assign({},this.prefValue_,obj))};lib.Storage.TerminalPrivate.prototype.removeItem=async function(key){return this.removeItems([key])};lib.Storage.TerminalPrivate.prototype.removeItems=async function(keys){await this.initCache_();const newStorage=Object.assign({},this.prefValue_);keys.forEach(key=>delete newStorage[key]);return this.update_(newStorage)};lib.resource.add("libdot/changelog/version","text/plain","9.0.0");lib.resource.add("libdot/changelog/date","text/plain","2022-02-24");const hterm={};hterm.windowType=null;hterm.initWindowType_=async function(){if(globalThis.chrome?.tabs?.getCurrent){const tab=await new Promise(resolve=>{chrome.tabs.getCurrent(resolve)});if(tab&&globalThis.chrome?.windows?.get){const win=await new Promise(resolve=>{chrome.windows.get(tab.windowId,null,resolve)});hterm.windowType=win.type}else{hterm.windowType="normal"}}else{hterm.windowType="normal"}};hterm.os=null;hterm.initOs_=function(){const initOs=os=>{hterm.os=os};return lib.f.getOs().then(initOs).catch(initOs)};hterm.desktopNotificationTitle="♪ %(title) ♪";hterm.messageManager=null;hterm.init_=async function(){await hterm.initWindowType_();await hterm.initOs_();return lib.i18n.getAcceptLanguages().then(languages=>{if(!hterm.messageManager){hterm.messageManager=new lib.MessageManager(languages)}})};hterm.initPromise=hterm.init_();hterm.sanitizeHtml=function(html){if(globalThis.trustedTypes?.createPolicy){if(!hterm.sanitizeHtml.policy){hterm.sanitizeHtml.policy=trustedTypes.createPolicy("default",{createHTML:source=>source})}return hterm.sanitizeHtml.policy.createHTML(html)}return html};hterm.copySelectionToClipboard=function(document,str){const requestPermission=()=>{if(navigator.permissions&&navigator.permissions.query){return navigator.permissions.query({name:"clipboard-write"}).then(status=>{const checkState=(resolve,reject)=>{switch(status.state){case"granted":return resolve();case"denied":return reject();default:return new Promise((resolve,reject)=>{status.onchange=()=>checkState(resolve,reject)})}};return new Promise(checkState)}).catch(()=>Promise.resolve())}else{return Promise.resolve()}};const writeClipboard=()=>{if(navigator.clipboard&&navigator.clipboard.writeText){return navigator.clipboard.writeText(str).catch(execCommand)}else{return execCommand()}};const execCommand=()=>{const copySource=document.createElement("pre");copySource.id="hterm:copy-to-clipboard-source";copySource.textContent=str;copySource.style.cssText="user-select: text;"+"position: absolute;"+"top: -99px";document.body.appendChild(copySource);const selection=document.getSelection();const anchorNode=selection.anchorNode;const anchorOffset=selection.anchorOffset;const focusNode=selection.focusNode;const focusOffset=selection.focusOffset;try{selection.selectAllChildren(copySource)}catch(ex){}try{document.execCommand("copy")}catch(firefoxException){}if(selection.extend){if(anchorNode){selection.collapse(anchorNode,anchorOffset)}if(focusNode){selection.extend(focusNode,focusOffset)}}copySource.remove();return Promise.resolve()};return requestPermission().then(writeClipboard)};hterm.msg=function(name,args=[],string=""){return hterm.messageManager.get("HTERM_"+name,args,string)};hterm.notify=function(params){const def=(curr,fallback)=>curr!==undefined?curr:fallback;if(params===undefined||params===null){params={}}const options={body:params.body,icon:def(params.icon,lib.resource.getDataUrl("hterm/images/icon-96"))};let title=def(params.title,globalThis.document.title);if(!title){title="hterm"}title=lib.f.replaceVars(hterm.desktopNotificationTitle,{title:title});const n=new Notification(title,options);n.onclick=function(){globalThis.focus();n.close()};return n};hterm.openUrl=function(url){if(globalThis.chrome?.browser?.openTab){chrome.browser.openTab({url:url})}else{const win=lib.f.openWindow(url,"_blank");if(win){win.focus()}}};hterm.Size=class{constructor(width,height){this.width=width;this.height=height}resize(width,height){this.width=width;this.height=height}clone(){return new this.constructor(this.width,this.height)}setTo(that){this.width=that.width;this.height=that.height}equals(that){return this.width==that.width&&this.height==that.height}toString(){return`[hterm.Size: ${this.width}, ${this.height}]`}};hterm.RowCol=class{constructor(row,column,overflow=false){this.row=row;this.column=column;this.overflow=!!overflow}move(row,column,overflow=false){this.row=row;this.column=column;this.overflow=!!overflow}clone(){return new this.constructor(this.row,this.column,this.overflow)}setTo(that){this.row=that.row;this.column=that.column;this.overflow=that.overflow}equals(that){return this.row==that.row&&this.column==that.column&&this.overflow==that.overflow}toString(){return`[hterm.RowCol: ${this.row}, ${this.column}, ${this.overflow}]`}};hterm.AccessibilityReader=function(div){this.document_=div.ownerDocument;const liveRegion=this.document_.createElement("div");liveRegion.id="hterm:accessibility-live-region";liveRegion.style.cssText=`position: absolute;
                              width: 0; height: 0;
                              overflow: hidden;
                              left: -1000px; top: -1000px;`;div.appendChild(liveRegion);this.accessibilityEnabled=false;this.liveElement_=this.document_.createElement("p");this.liveElement_.setAttribute("aria-live","polite");liveRegion.appendChild(this.liveElement_);this.assertiveLiveElement_=this.document_.createElement("p");this.assertiveLiveElement_.setAttribute("aria-live","assertive");liveRegion.appendChild(this.assertiveLiveElement_);this.queue_=[];this.nextReadTimer_=null;this.cursorIsChanging_=false;this.cursorChangeQueue_=[];this.lastCursorRowString_=null;this.lastCursorRow_=null;this.lastCursorColumn_=null;this.hasUserGesture=false};hterm.AccessibilityReader.DELAY=50;hterm.AccessibilityReader.prototype.setAccessibilityEnabled=function(enabled){if(!enabled){this.clear()}this.accessibilityEnabled=enabled};hterm.AccessibilityReader.prototype.decorate=function(doc){const handlers=["keydown","keypress","keyup","textInput"];handlers.forEach(handler=>{doc.addEventListener(handler,()=>{this.hasUserGesture=true})})};hterm.AccessibilityReader.prototype.beforeCursorChange=function(cursorRowString,cursorRow,cursorColumn){if(!this.accessibilityEnabled){return}if(!this.hasUserGesture||this.cursorIsChanging_){return}this.cursorIsChanging_=true;this.lastCursorRowString_=cursorRowString;this.lastCursorRow_=cursorRow;this.lastCursorColumn_=cursorColumn};hterm.AccessibilityReader.prototype.afterCursorChange=function(cursorRowString,cursorRow,cursorColumn){if(!this.cursorIsChanging_){return}this.cursorIsChanging_=false;if(!this.announceAction_(cursorRowString,cursorRow,cursorColumn)){for(let i=0;i<this.cursorChangeQueue_.length;++i){this.announce(this.cursorChangeQueue_[i])}}this.cursorChangeQueue_=[];this.lastCursorRowString_=null;this.lastCursorRow_=null;this.lastCursorColumn_=null;this.hasUserGesture=false};hterm.AccessibilityReader.prototype.announce=function(str){if(!this.accessibilityEnabled){return}if(this.cursorIsChanging_){this.cursorChangeQueue_.push(str);return}if(str=="\n"&&this.queue_.length>0){this.queue_.push("");return}if(this.queue_.length==0){this.queue_.push(str)}else{let padding="";if(this.queue_[this.queue_.length-1].length!=0){padding=" "}this.queue_[this.queue_.length-1]+=padding+str}if(this.nextReadTimer_){return}if(this.queue_.length==1){this.nextReadTimer_=setTimeout(this.addToLiveRegion_.bind(this),hterm.AccessibilityReader.DELAY)}else{throw new Error("Expected only one item in queue_ or nextReadTimer_ to be running.")}};hterm.AccessibilityReader.prototype.assertiveAnnounce=function(str){if(this.hasUserGesture&&str==" "){str=hterm.msg("SPACE_CHARACTER",[],"Space")}str=str.trim();if(str==this.assertiveLiveElement_.innerText){str="\n"+str}this.clear();this.assertiveLiveElement_.innerText=str};hterm.AccessibilityReader.prototype.newLine=function(){this.announce("\n")};hterm.AccessibilityReader.prototype.clear=function(){this.liveElement_.innerText="";this.assertiveLiveElement_.innerText="";clearTimeout(this.nextReadTimer_);this.nextReadTimer_=null;this.queue_=[];this.cursorIsChanging_=false;this.cursorChangeQueue_=[];this.lastCursorRowString_=null;this.lastCursorRow_=null;this.lastCursorColumn_=null;this.hasUserGesture=false};hterm.AccessibilityReader.prototype.announceAction_=function(cursorRowString,cursorRow,cursorColumn){if(this.lastCursorRow_!=cursorRow){return false}if(lib.notNull(this.lastCursorRowString_)===cursorRowString){if(lib.notNull(this.lastCursorColumn_)!==cursorColumn&&this.cursorChangeQueue_.join("").trim()==""){const start=Math.min(this.lastCursorColumn_,cursorColumn);const len=Math.abs(cursorColumn-this.lastCursorColumn_);this.assertiveAnnounce(hterm.wc.substr(this.lastCursorRowString_,start,len));return true}return false}if(this.lastCursorRowString_!=cursorRowString){if(this.lastCursorColumn_+1==cursorColumn){if(hterm.wc.substr(cursorRowString,cursorColumn-1,1)==" "&&this.cursorChangeQueue_.length>0&&this.cursorChangeQueue_[0]==" "){this.assertiveAnnounce(" ");return true}}const cursorDeleted=cursorColumn;if(hterm.wc.strWidth(cursorRowString)<=hterm.wc.strWidth(this.lastCursorRowString_)&&hterm.wc.substr(this.lastCursorRowString_,0,cursorDeleted)==hterm.wc.substr(cursorRowString,0,cursorDeleted)){let lengthOfCurrentRow=hterm.wc.strWidth(cursorRowString);for(;lengthOfCurrentRow>0;--lengthOfCurrentRow){if(lengthOfCurrentRow==cursorDeleted||hterm.wc.substr(cursorRowString,lengthOfCurrentRow-1,1)!=" "){break}}const numCharsDeleted=hterm.wc.strWidth(this.lastCursorRowString_)-lengthOfCurrentRow;const lengthOfEndOfString=lengthOfCurrentRow-cursorDeleted;const endOfLastRowString=hterm.wc.substr(this.lastCursorRowString_,cursorDeleted+numCharsDeleted,lengthOfEndOfString);const endOfCurrentRowString=hterm.wc.substr(cursorRowString,cursorDeleted,lengthOfEndOfString);if(endOfLastRowString==endOfCurrentRowString){const deleted=hterm.wc.substr(this.lastCursorRowString_,cursorDeleted,numCharsDeleted);if(deleted!=""){this.assertiveAnnounce(deleted);return true}}}return false}return false};hterm.AccessibilityReader.prototype.addToLiveRegion_=function(){this.nextReadTimer_=null;let str=this.queue_.join("\n").trim();if(str==this.liveElement_.innerText){str="\n"+str}this.liveElement_.innerText=str;this.queue_=[]};hterm.ContextMenu=function(){this.document_=null;this.element_=null;this.menu_=[]};hterm.ContextMenu.Item;hterm.ContextMenu.SEPARATOR=Symbol("-");hterm.ContextMenu.prototype.setDocument=function(document){if(this.element_){this.element_.remove();this.element_=null}this.document_=document;this.regenerate_();this.document_.body.appendChild(this.element_)};hterm.ContextMenu.prototype.regenerate_=function(){if(!this.element_){this.element_=this.document_.createElement("menu");this.element_.id="hterm:context-menu"}else{this.hide()}while(this.element_.firstChild){this.element_.removeChild(this.element_.firstChild)}this.menu_.forEach(({name,action})=>{const menuitem=this.document_.createElement("menuitem");if(name===hterm.ContextMenu.SEPARATOR){menuitem.innerHTML=hterm.sanitizeHtml("<hr>");menuitem.className="separator"}else{menuitem.innerText=name;menuitem.addEventListener("mousedown",function(e){e.preventDefault();action(e)})}this.element_.appendChild(menuitem)})};hterm.ContextMenu.prototype.setItems=function(items){this.menu_=items;this.regenerate_()};hterm.ContextMenu.prototype.show=function(e,terminal){if(this.menu_.length==0){return}if(terminal){this.element_.style.fontSize=terminal.getFontSize();this.element_.style.fontFamily=terminal.getFontFamily()}this.element_.style.top=`${e.clientY}px`;this.element_.style.left=`${e.clientX}px`;const docSize=this.document_.body.getBoundingClientRect();this.element_.style.display="block";const eleSize=this.element_.getBoundingClientRect();const minY=Math.max(0,docSize.height-eleSize.height);const minX=Math.max(0,docSize.width-eleSize.width);if(minY<e.clientY){this.element_.style.top=`${minY}px`}if(minX<e.clientX){this.element_.style.left=`${minX}px`}};hterm.ContextMenu.prototype.hide=function(){if(!this.element_){return}this.element_.style.display="none"};hterm.FindBar=function(terminal){this.terminal_=terminal;this.scrollPort_=terminal.getScrollPort();this.findBar_=null;this.input_=null;this.hasFocus=false;this.upArrowButton_=null;this.downArrowButton_=null;this.closeButton_=null;this.counterLabel_=null;this.results_={};this.pendingFind_=null;this.pendingRedraw_=null;this.pendingNotifyChanges_=null;this.changedRows_=new Set;this.searchText_="";this.batchRow_=0;this.batchNum_=0;this.batchCallbacksForTest_={};this.batchSize=500;this.isVisible=false;this.visibleRows_=[];this.onScroll_=this.scheduleRedraw_.bind(this);this.selectedRowNum_=0;this.selectedRowIndex_=0;this.selectedOrdinal_=-1;this.resultCount_=0;this.selectedResult_=null;this.matchingRowsIndex_=[];this.selectedResultKnown_=true};hterm.FindBar.RowResult;hterm.FindBar.Result;hterm.FindBar.prototype.decorate=function(document){this.findBar_=document.createElement("div");this.findBar_.id="hterm:find-bar";this.findBar_.setAttribute("aria-hidden","true");this.findBar_.innerHTML=hterm.sanitizeHtml(lib.resource.getText("hterm/html/find_bar"));this.input_=this.findBar_.querySelector("input");this.upArrowButton_=this.findBar_.querySelector("#hterm\\:find-bar-up");this.downArrowButton_=this.findBar_.querySelector("#hterm\\:find-bar-down");this.closeButton_=this.findBar_.querySelector("#hterm\\:find-bar-close");this.counterLabel_=this.findBar_.querySelector("#hterm\\:find-bar-count");this.upArrowButton_.innerHTML=hterm.sanitizeHtml(lib.resource.getText("hterm/images/keyboard_arrow_up"));this.downArrowButton_.innerHTML=hterm.sanitizeHtml(lib.resource.getText("hterm/images/keyboard_arrow_down"));this.closeButton_.innerHTML=hterm.sanitizeHtml(lib.resource.getText("hterm/images/close"));this.upArrowButton_.setAttribute("aria-label",hterm.msg("BUTTON_PREVIOUS"));this.downArrowButton_.setAttribute("aria-label",hterm.msg("BUTTON_NEXT"));this.input_.setAttribute("aria-label",hterm.msg("BUTTON_FIND"));this.closeButton_.setAttribute("aria-label",hterm.msg("BUTTON_CLOSE"));const el=e=>e.bind(this);this.input_.addEventListener("input",el(this.onInput_));this.input_.addEventListener("keydown",el(this.onKeyDown_));this.input_.addEventListener("keypress",el(this.onKeyPressed_));this.input_.addEventListener("textInput",el(this.onInputText_));this.input_.addEventListener("focus",el(()=>{this.hasFocus=true}));this.input_.addEventListener("blur",el(()=>{this.hasFocus=false}));this.closeButton_.addEventListener("click",el(this.close));this.upArrowButton_.addEventListener("click",el(this.onPrevious_));this.downArrowButton_.addEventListener("click",el(this.onNext_));document.body.appendChild(this.findBar_);this.resultScreen_=document.createElement("div");this.resultScreen_.id="hterm:find-result-screen";this.resultScreen_.innerHTML=hterm.sanitizeHtml(lib.resource.getText("hterm/html/find_screen"));this.resultScreen_.style.display="none";document.body.appendChild(this.resultScreen_)};hterm.FindBar.prototype.display=function(){this.scrollPort_.subscribe("scroll",this.onScroll_);this.findBar_.classList.add("enabled");this.findBar_.removeAttribute("aria-hidden");this.input_.focus();this.resultScreen_.style.display="";this.isVisible=true;this.input_.dispatchEvent(new Event("input"))};hterm.FindBar.prototype.close=function(){this.resultScreen_.style.display="none";this.scrollPort_.unsubscribe("scroll",this.onScroll_);this.findBar_.classList.remove("enabled");this.findBar_.setAttribute("aria-hidden","true");this.terminal_.focus();this.isVisible=false;this.stopSearch();this.results_={};this.resultCount_=0};hterm.FindBar.prototype.stopSearch=function(){if(this.pendingFind_!==null){clearTimeout(this.pendingFind_);this.pendingFind_=null}this.runBatchCallbackForTest_(0)};hterm.FindBar.prototype.syncResults_=function(){this.batchRow_=0;this.batchNum_=0;this.results_={};this.resultCount_=0;this.matchingRowsIndex_.length=0;this.redraw_();this.updateCounterLabel_();if(!this.searchText_){return}const rowCount=this.terminal_.getRowCount();const runNextBatch=()=>{const batchEnd=Math.min(this.batchRow_+this.batchSize,rowCount);while(this.batchRow_<batchEnd){if(this.findInRow_(this.batchRow_)){this.matchingRowsIndex_.push(this.batchRow_)}this.batchRow_++}if(this.batchRow_<rowCount){this.pendingFind_=setTimeout(runNextBatch)}else{this.stopSearch()}++this.batchNum_;this.runBatchCallbackForTest_(this.batchNum_);this.updateCounterLabel_()};runNextBatch()};hterm.FindBar.prototype.findInRow_=function(rowNum,update=false){if(!this.searchText_){return false}const prev=this.results_[rowNum];if(prev&&!update){return true}const rowText=this.terminal_.getRowText(rowNum).toLowerCase();const rowResult=[];let i;let startIndex=0;while((i=rowText.indexOf(this.searchText_,startIndex))!=-1){rowResult.push({index:i,highlighter:null});startIndex=i+this.searchText_.length}if(rowResult.length){this.results_[rowNum]={findRow:null,rowResult:rowResult};if(this.resultCount_===0){this.selectedRowNum_=rowNum;this.selectedOrdinal_=0;this.upArrowButton_.classList.add("enabled");this.downArrowButton_.classList.add("enabled");this.scrollToResult_()}}else{delete this.results_[rowNum]}const diff=rowResult.length-(prev?prev.rowResult.length:0);this.resultCount_+=diff;if(rowNum<this.selectedRowNum_){this.selectedOrdinal_+=diff}return rowResult.length>0};hterm.FindBar.prototype.onInput_=function(event){this.searchText_=event.target.value.toLowerCase();clearTimeout(this.pendingFind_);this.pendingFind_=setTimeout(()=>this.syncResults_())};hterm.FindBar.prototype.onKeyPressed_=function(event){event.stopPropagation()};hterm.FindBar.prototype.onInputText_=function(event){event.stopPropagation()};hterm.FindBar.prototype.onKeyDown_=function(event){if(event.metaKey||event.altKey){event.stopPropagation();return}if(event.key=="Escape"){this.close()}if(event.key=="Enter"){if(event.shiftKey){this.onPrevious_()}else{this.onNext_()}}if(event.ctrlKey&&event.keyCode==71){if(event.shiftKey){this.onPrevious_()}else{this.onNext_()}event.preventDefault()}if(event.ctrlKey&&event.keyCode==70){event.preventDefault()}event.stopPropagation()};hterm.FindBar.prototype.setFindResultColor=function(color){if(color===undefined){color=this.terminal_.getPrefs().getString("find-result-color")}this.terminal_.setCssVar("find-result-color",color)};hterm.FindBar.prototype.setFindResultSelectedColor=function(color=undefined){if(color===undefined){color=this.terminal_.getPrefs().getString("find-result-selected-color")}this.terminal_.setCssVar("find-result-selected-color",color)};hterm.FindBar.prototype.setBatchCallbackForTest=function(batchNum,callback){this.batchCallbacksForTest_[batchNum]=callback};hterm.FindBar.prototype.redraw_=function(){const topRowIndex=this.scrollPort_.getTopRowIndex();const bottomRowIndex=this.scrollPort_.getBottomRowIndex(topRowIndex);this.visibleRows_.forEach(row=>{row.remove()});this.visibleRows_=[];for(let rowNum=topRowIndex;rowNum<=bottomRowIndex;rowNum++){const newRow=this.fetchRowNode_(rowNum);this.resultScreen_.appendChild(newRow);this.visibleRows_.push(newRow)}delete this.pendingRedraw_;this.highlightSelectedResult_()};hterm.FindBar.prototype.fetchRowNode_=function(rowNum){if(rowNum>=this.batchRow_){this.findInRow_(rowNum)}const row=this.results_[rowNum];if(row&&row.findRow){return row.findRow}const findRow=this.terminal_.getDocument().createElement("find-row");if(!row){return findRow}row.rowResult.forEach(result=>{const highlighter=this.terminal_.getDocument().createElement("div");highlighter.classList.add("find-highlighter");highlighter.style.left=`calc(var(--hterm-charsize-width) * ${result.index})`;highlighter.style.width=`calc(var(--hterm-charsize-width) * ${this.searchText_.length})`;result.highlighter=highlighter;findRow.appendChild(highlighter)});return row.findRow=findRow};hterm.FindBar.prototype.scheduleRedraw_=function(){if(this.pendingRedraw_){return}this.pendingRedraw_=setTimeout(()=>{this.redraw_()})};hterm.FindBar.prototype.runBatchCallbackForTest_=function(batchNum){const callback=this.batchCallbacksForTest_[batchNum];if(callback){callback();delete this.batchCallbacksForTest_[batchNum]}};hterm.FindBar.prototype.updateCounterLabel_=function(){if(this.resultCount_===0){this.selectedRowNum_=0;this.selectedRowIndex_=0;this.selectedOrdinal_=-1;this.selectedResultKnown_=true;this.upArrowButton_.classList.remove("enabled");this.downArrowButton_.classList.remove("enabled")}if(this.selectedResultKnown_){this.counterLabel_.textContent=hterm.msg("FIND_COUNTER_LABEL",[this.selectedOrdinal_+1,this.resultCount_])}else{this.counterLabel_.textContent=hterm.msg("FIND_RESULT_COUNT",[this.resultCount_])}this.highlightSelectedResult_()};hterm.FindBar.indexOf=function(arr,value){let index=-1;let low=0;let high=arr.length-1;while(low<=high){const mid=Math.floor((low+high)/2);if(arr[mid]<=value){index=mid;low=mid+1}else{high=mid-1}}return index};hterm.FindBar.prototype.canUseMatchingRowsIndex_=function(step){const topRowIndex=this.scrollPort_.getTopRowIndex();const bottomRowIndex=this.scrollPort_.getBottomRowIndex(topRowIndex);const index=this.matchingRowsIndex_;const current=this.selectedRowNum_;return this.batchRow_>bottomRowIndex||step>0&&current<index[index.length-1]||step<0&&current<this.batchRow_&&current>index[0]};hterm.FindBar.prototype.selectNext_=function(step){const circularStep=(i,s,len)=>(i+s+len)%len;const stepOnce=(prev,next)=>step>0?prev:next;const row=this.results_[this.selectedRowNum_];if(row&&row.rowResult[this.selectedRowIndex_+step]!==undefined){this.selectedRowIndex_+=step}else{let topRowIndex=this.scrollPort_.getTopRowIndex();const bottomRowIndex=this.scrollPort_.getBottomRowIndex(topRowIndex);const index=this.matchingRowsIndex_;const current=this.selectedRowNum_;if(this.canUseMatchingRowsIndex_(step)){let i=hterm.FindBar.indexOf(index,current);if(!this.selectedResultKnown_&&step<0){i++}this.selectedRowNum_=index[circularStep(i,step,index.length)]}else{let start=current+step;topRowIndex=Math.max(topRowIndex,this.batchRow_);if(current<topRowIndex||current>bottomRowIndex){start=stepOnce(topRowIndex,bottomRowIndex)}const end=stepOnce(bottomRowIndex+1,topRowIndex-1);if(index.length>0){this.selectedRowNum_=index[stepOnce(0,index.length-1)]}for(let i=start;i!=end;i+=step){if(this.results_[i]){this.selectedRowNum_=i;break}}}const row=this.results_[this.selectedRowNum_];this.selectedRowIndex_=stepOnce(0,row.rowResult.length-1)}const s=!this.selectedResultKnown_&&step>0?0:step;this.selectedOrdinal_=circularStep(this.selectedOrdinal_,s,this.resultCount_);this.selectedResultKnown_=true;this.scrollToResult_();this.updateCounterLabel_()};hterm.FindBar.prototype.onNext_=function(){if(!this.downArrowButton_.classList.contains("enabled")){return}this.selectNext_(1)};hterm.FindBar.prototype.onPrevious_=function(){if(!this.upArrowButton_.classList.contains("enabled")){return}this.selectNext_(-1)};hterm.FindBar.prototype.scrollToResult_=function(){const topRowIndex=this.scrollPort_.getTopRowIndex();const bottomRowIndex=this.scrollPort_.getBottomRowIndex(topRowIndex);if(this.selectedRowNum_<topRowIndex||this.selectedRowNum_>bottomRowIndex){this.scrollPort_.scrollRowToMiddle(this.selectedRowNum_)}};hterm.FindBar.prototype.highlightSelectedResult_=function(){if(this.selectedResult_){this.selectedResult_.classList.remove("selected");this.selectedResult_=null}if(this.resultCount_&&this.selectedResultKnown_){this.selectedResult_=this.results_[this.selectedRowNum_].rowResult[this.selectedRowIndex_].highlighter;if(this.selectedResult_){this.selectedResult_.classList.add("selected")}}};hterm.FindBar.prototype.scheduleNotifyChanges=function(rowNum){if(!this.isVisible){return}this.changedRows_.add(rowNum);if(this.pendingNotifyChanges_){return}this.pendingNotifyChanges_=setTimeout(()=>{this.notifyChanges_()})};hterm.FindBar.prototype.notifyChanges_=function(){this.changedRows_.forEach(rowNum=>{rowNum+=this.scrollPort_.getTopRowIndex();const prev=this.results_[rowNum];const found=this.findInRow_(rowNum,true);if(this.selectedRowNum_==rowNum){this.selectedOrdinal_-=this.selectedRowIndex_;this.selectedRowIndex_=0;this.selectedResultKnown_=found}if(!!prev!==found){const i=hterm.FindBar.indexOf(this.matchingRowsIndex_,rowNum);if(found){this.matchingRowsIndex_.splice(i+1,0,rowNum)}else{this.matchingRowsIndex_.splice(i,1)}}});this.updateCounterLabel_();this.redraw_();this.changedRows_.clear();delete this.pendingNotifyChanges_};hterm.Frame=function(terminal,url,options={}){this.terminal_=terminal;this.div_=terminal.div_;this.url=url;this.options=options;this.iframe_=null;this.container_=null;this.messageChannel_=null};hterm.Frame.prototype.onMessage_=function(e){switch(e.data.name){case"ipc-init-ok":this.sendTerminalInfo_();return;case"terminal-info-ok":this.container_.style.display="flex";this.postMessage("visible");this.messageChannel_.port1.onmessage=this.onMessage.bind(this);this.onLoad();return;default:console.log("Unknown message from frame:",e.data)}};hterm.Frame.prototype.onMessage=function(){};hterm.Frame.prototype.onLoad_=function(){this.messageChannel_=new MessageChannel;this.messageChannel_.port1.onmessage=this.onMessage_.bind(this);this.messageChannel_.port1.start();this.iframe_.contentWindow.postMessage({name:"ipc-init",argv:[{messagePort:this.messageChannel_.port2}]},this.url,[this.messageChannel_.port2])};hterm.Frame.prototype.onLoad=function(){};hterm.Frame.prototype.sendTerminalInfo_=function(){lib.i18n.getAcceptLanguages().then(languages=>{this.postMessage("terminal-info",[{acceptLanguages:languages,foregroundColor:this.terminal_.getForegroundColor(),backgroundColor:this.terminal_.getBackgroundColor(),cursorColor:this.terminal_.getCursorColor(),fontSize:this.terminal_.getFontSize(),fontFamily:this.terminal_.getFontFamily(),baseURL:lib.f.getURL("/")}])})};hterm.Frame.prototype.onCloseClicked_=function(){this.close()};hterm.Frame.prototype.close=function(){if(!this.container_||!this.container_.parentNode){return}this.container_.remove();this.onClose()};hterm.Frame.prototype.onClose=function(){};hterm.Frame.prototype.postMessage=function(name,argv){if(!this.messageChannel_){throw new Error("Message channel is not set up.")}this.messageChannel_.port1.postMessage({name:name,argv:argv})};hterm.Frame.prototype.show=function(){if(this.container_&&this.container_.parentNode){console.error("Frame already visible");return}const document=this.terminal_.document_;const container=this.container_=document.createElement("div");container.style.cssText="position: absolute;"+"display: none;"+"flex-direction: column;"+"top: 10%;"+"left: 4%;"+"width: 90%;"+"height: 80%;"+"min-height: 20%;"+"max-height: 80%;"+"box-shadow: 0 0 2px "+this.terminal_.getForegroundColor()+";"+"border: 2px "+this.terminal_.getForegroundColor()+" solid;";const iframe=this.iframe_=document.createElement("iframe");iframe.onload=this.onLoad_.bind(this);iframe.style.cssText="display: flex;"+"flex: 1;"+"width: 100%";iframe.setAttribute("src",this.url);iframe.setAttribute("seamless",true);container.appendChild(iframe);this.div_.appendChild(container)};hterm.Keyboard=function(terminal){this.terminal=terminal;this.keyboardElement_=null;this.handlers_=[["focusout",this.onFocusOut_.bind(this)],["keydown",this.onKeyDown_.bind(this)],["keypress",this.onKeyPress_.bind(this)],["keyup",this.onKeyUp_.bind(this)],["textInput",this.onTextInput_.bind(this)]];this.keyMap=new hterm.Keyboard.KeyMap(this);this.bindings=new hterm.Keyboard.Bindings;this.altGrMode="none";this.shiftInsertPaste=true;this.homeKeysScroll=false;this.pageKeysScroll=false;this.ctrlPlusMinusZeroZoom=true;this.ctrlCCopy=false;this.ctrlVPaste=false;this.applicationKeypad=false;this.applicationCursor=false;this.backspaceSendsBackspace=false;this.metaSendsEscape=true;this.passMetaV=true;this.altSendsWhat="escape";this.altIsMeta=false;this.altBackspaceIsMetaBackspace=false;this.altKeyPressed=0;this.mediaKeysAreFKeys=false;this.previousAltSendsWhat_=null};hterm.Keyboard.KeyActions={CANCEL:Symbol("CANCEL"),DEFAULT:Symbol("DEFAULT"),PASS:Symbol("PASS"),STRIP:Symbol("STRIP")};hterm.Keyboard.KeyAction;hterm.Keyboard.prototype.installKeyboard=function(element){if(element==this.keyboardElement_){return}if(element&&this.keyboardElement_){this.installKeyboard(null)}for(let i=0;i<this.handlers_.length;i++){const handler=this.handlers_[i];if(element){element.addEventListener(handler[0],handler[1])}else{this.keyboardElement_.removeEventListener(handler[0],handler[1])}}this.keyboardElement_=element};hterm.Keyboard.prototype.uninstallKeyboard=function(){this.installKeyboard(null)};hterm.Keyboard.prototype.onTextInput_=function(e){if(!e.data){return}this.terminal.onVTKeystroke(e.data)};hterm.Keyboard.prototype.onKeyPress_=function(e){const key=String.fromCharCode(e.which).toLowerCase();if((e.ctrlKey||e.metaKey)&&(key=="c"||key=="v")){return}if(e.keyCode==9){return}let ch;if(e.altKey&&this.altSendsWhat=="browser-key"&&e.charCode==0){ch=String.fromCharCode(e.keyCode);if(!e.shiftKey){ch=ch.toLowerCase()}}else if(e.charCode>=32){ch=String.fromCharCode(e.charCode)}if(ch){this.terminal.onVTKeystroke(ch)}e.preventDefault();e.stopPropagation()};hterm.Keyboard.prototype.onFocusOut_=function(e){this.altKeyPressed=0};hterm.Keyboard.prototype.onKeyUp_=function(e){if(e.keyCode==18){this.altKeyPressed=this.altKeyPressed&~(1<<e.location-1)}};hterm.Keyboard.prototype.onKeyDown_=function(e){if(e.keyCode==18){this.altKeyPressed=this.altKeyPressed|1<<e.location-1}let keyDef=this.keyMap.keyDefs[e.keyCode];if(!keyDef){console.warn(`No definition for key ${e.key} (keyCode ${e.keyCode})`);keyDef=this.keyMap.keyDefs[0];this.keyMap.addKeyDef(e.keyCode,keyDef)}let resolvedActionType=null;const getKeyDefAction=name=>{resolvedActionType=name;let action=keyDef[name];if(typeof action=="function"){action=action.call(this.keyMap,e,keyDef)}if(action===DEFAULT&&name!="normal"){action=getKeyDefAction("normal")}return action};const CANCEL=hterm.Keyboard.KeyActions.CANCEL;const DEFAULT=hterm.Keyboard.KeyActions.DEFAULT;const PASS=hterm.Keyboard.KeyActions.PASS;const STRIP=hterm.Keyboard.KeyActions.STRIP;let control=e.ctrlKey;let shift=e.shiftKey;let alt=this.altIsMeta?false:e.altKey;let meta=this.altIsMeta?e.altKey||e.metaKey:e.metaKey;const isPrintable=!/^\[\w+\]$/.test(keyDef.keyCap);switch(this.altGrMode){case"ctrl-alt":if(isPrintable&&control&&alt){control=false;alt=false}break;case"right-alt":if(isPrintable&&this.terminal.keyboard.altKeyPressed&2){control=false;alt=false}break;case"left-alt":if(isPrintable&&this.terminal.keyboard.altKeyPressed&1){control=false;alt=false}break}const keyDown={keyCode:e.keyCode,shift:e.shiftKey,ctrl:control,alt:alt,meta:meta};let action;const binding=this.bindings.getBinding(keyDown);if(binding){shift=control=alt=meta=false;resolvedActionType="normal";if(typeof binding.action=="function"){const bindingFn=binding.action;action=bindingFn.call(this,this.terminal,keyDown)}else{action=binding.action}}else{if(control){action=getKeyDefAction("control")}else if(alt){action=getKeyDefAction("alt")}else if(meta){action=getKeyDefAction("meta")}else{action=getKeyDefAction("normal")}shift=!e.maskShiftKey&&e.shiftKey}if(typeof action=="function"){action=action.call(this.keyMap,e,keyDef)}if(alt&&this.altSendsWhat=="browser-key"&&action==DEFAULT){action=PASS}if(action!==PASS){this.terminal.contextMenu.hide()}if(action===PASS||action===DEFAULT&&!(control||alt||meta)){return}if(action===STRIP){alt=control=false;action=keyDef.normal;if(typeof action=="function"){action=action.call(this.keyMap,e,keyDef)}if(action==DEFAULT&&keyDef.keyCap.length==2){action=keyDef.keyCap.substr(shift?1:0,1)}}e.preventDefault();e.stopPropagation();if(action===CANCEL){return}if(action!==DEFAULT&&typeof action!="string"){console.warn("Invalid action: "+JSON.stringify(action));return}if(resolvedActionType=="control"){control=false}else if(resolvedActionType=="alt"){alt=false}else if(resolvedActionType=="meta"){meta=false}if(typeof action=="string"&&action.substr(0,2)=="["&&(alt||control||shift||meta)){let imod=1;if(shift){imod+=1}if(alt){imod+=2}if(control){imod+=4}if(meta){imod+=8}const mod=";"+imod;if(action.length==3){action="[1"+mod+action.substr(2,1)}else{action=action.substr(0,action.length-1)+mod+action.substr(action.length-1)}}else{if(action===DEFAULT){action=keyDef.keyCap.substr(shift?1:0,1);if(control){const unshifted=keyDef.keyCap.substr(0,1);const code=unshifted.charCodeAt(0);if(code>=64&&code<=95){action=String.fromCharCode(code-64)}}}if(alt&&this.altSendsWhat=="8-bit"&&action.length==1){const code=action.charCodeAt(0)+128;action=String.fromCharCode(code)}if(alt&&this.altSendsWhat=="escape"||meta&&this.metaSendsEscape){action=""+action}}this.terminal.onVTKeystroke(action)};hterm.Keyboard.KeyDown;hterm.Keyboard.KeyBindingFunction;hterm.Keyboard.KeyBindingAction;hterm.Keyboard.KeyBinding;hterm.Keyboard.Bindings=function(){this.bindings_={}};hterm.Keyboard.Bindings.OsDefaults={android:{},cros:{"Alt+Shift+I":"PASS","Ctrl+Alt+Z":"PASS","Ctrl+Space":"PASS"},linux:{},mac:{"Meta+Left":'"[H"',"Meta+Right":'"[F"'},windows:{}};hterm.Keyboard.Bindings.prototype.clear=function(){this.bindings_={}};hterm.Keyboard.Bindings.prototype.addBinding_=function(keyPattern,action){let binding=null;const list=this.bindings_[keyPattern.keyCode];if(list){for(let i=0;i<list.length;i++){if(list[i].keyPattern.matchKeyPattern(keyPattern)){binding=list[i];break}}}if(binding){binding.action=action}else{binding={keyPattern:keyPattern,action:action};if(!list){this.bindings_[keyPattern.keyCode]=[binding]}else{this.bindings_[keyPattern.keyCode].push(binding);list.sort(function(a,b){return hterm.Keyboard.KeyPattern.sortCompare(a.keyPattern,b.keyPattern)})}}};hterm.Keyboard.Bindings.prototype.addBinding=function(key,action){if(typeof key!="string"){this.addBinding_(key,action);return}const p=new hterm.Parser;p.reset(key);let sequence;try{sequence=p.parseKeySequence()}catch(ex){console.error(ex);return}if(!p.isComplete()){console.error(p.error("Expected end of sequence: "+sequence));return}if(typeof action=="string"){p.reset(action);try{action=p.parseKeyAction()}catch(ex){console.error(ex);return}}if(!p.isComplete()){console.error(p.error("Expected end of sequence: "+sequence));return}this.addBinding_(new hterm.Keyboard.KeyPattern(sequence),action)};hterm.Keyboard.Bindings.prototype.addBindings=function(map,addOsDefaults=false){if(addOsDefaults){this.addBindings(hterm.Keyboard.Bindings.OsDefaults[hterm.os]||{})}for(const key in map){this.addBinding(key,map[key])}};hterm.Keyboard.Bindings.prototype.getBinding=function(keyDown){const list=this.bindings_[keyDown.keyCode];if(!list){return null}for(let i=0;i<list.length;i++){const binding=list[i];if(binding.keyPattern.matchKeyDown(keyDown)){return binding}}return null};hterm.Keyboard.KeyDef;hterm.Keyboard.KeyDefFunction;hterm.Keyboard.KeyDefFunctionProvider;hterm.Keyboard.KeyDefAction;hterm.Keyboard.KeyMap=function(keyboard){this.keyboard=keyboard;this.keyDefs={};this.reset()};hterm.Keyboard.KeyMap.prototype.addKeyDef=function(keyCode,def){if(keyCode in this.keyDefs){console.warn("Duplicate keyCode: "+keyCode)}this.keyDefs[keyCode]=def};hterm.Keyboard.KeyMap.prototype.reset=function(){this.keyDefs={};const CANCEL=hterm.Keyboard.KeyActions.CANCEL;const DEFAULT=hterm.Keyboard.KeyActions.DEFAULT;const PASS=hterm.Keyboard.KeyActions.PASS;const STRIP=hterm.Keyboard.KeyActions.STRIP;const resolve=(action,e,k)=>{if(typeof action=="function"){const keyDefFn=action;return keyDefFn.call(this,e,k)}return action};const ac=(a,b)=>{return(e,k)=>{const action=e.shiftKey||e.ctrlKey||e.altKey||e.metaKey||!this.keyboard.applicationCursor?a:b;return resolve(action,e,k)}};const bs=(a,b)=>{return(e,k)=>{const action=!this.keyboard.backspaceSendsBackspace?a:b;return resolve(action,e,k)}};const sh=(a,b)=>{return(e,k)=>{const action=!e.shiftKey?a:b;e.maskShiftKey=true;return resolve(action,e,k)}};const alt=(a,b)=>{return(e,k)=>{const action=!e.altKey?a:b;return resolve(action,e,k)}};const mod=(a,b)=>{return(e,k)=>{const action=!(e.shiftKey||e.ctrlKey||e.altKey||e.metaKey)?a:b;return resolve(action,e,k)}};const ctl=ch=>String.fromCharCode(ch.charCodeAt(0)-64);const c=m=>{return(e,k)=>this[m](e,k)};const med=fn=>{return(e,k)=>{if(!this.keyboard.mediaKeysAreFKeys){return e.keyCode==166||e.keyCode==167||e.keyCode==168?CANCEL:PASS}return resolve(fn,e,k)}};const add=(keyCode,keyCap,normal,control,alt,meta)=>{this.addKeyDef(keyCode,{keyCap:keyCap,normal:normal,control:control,alt:alt,meta:meta})};let keycapSC;let keycapEP;let keycapMU;if(globalThis.navigator?.userAgent&&globalThis.navigator.userAgent.includes("Firefox")){keycapSC=59;keycapEP=61;keycapMU=173;add(171,"+*",DEFAULT,c("onZoom_"),DEFAULT,c("onZoom_"))}else{keycapSC=186;keycapEP=187;keycapMU=189}const ESC="";const CSI="[";const SS3="O";add(0,"[UNKNOWN]",PASS,PASS,PASS,PASS);add(27,"[ESC]",ESC,DEFAULT,DEFAULT,DEFAULT);add(112,"[F1]",mod(SS3+"P",CSI+"P"),DEFAULT,CSI+"23~",DEFAULT);add(113,"[F2]",mod(SS3+"Q",CSI+"Q"),DEFAULT,CSI+"24~",DEFAULT);add(114,"[F3]",mod(SS3+"R",CSI+"R"),DEFAULT,CSI+"25~",DEFAULT);add(115,"[F4]",mod(SS3+"S",CSI+"S"),DEFAULT,CSI+"26~",DEFAULT);add(116,"[F5]",CSI+"15~",DEFAULT,CSI+"28~",DEFAULT);add(117,"[F6]",CSI+"17~",DEFAULT,CSI+"29~",DEFAULT);add(118,"[F7]",CSI+"18~",DEFAULT,CSI+"31~",DEFAULT);add(119,"[F8]",CSI+"19~",DEFAULT,CSI+"32~",DEFAULT);add(120,"[F9]",CSI+"20~",DEFAULT,CSI+"33~",DEFAULT);add(121,"[F10]",CSI+"21~",DEFAULT,CSI+"34~",DEFAULT);add(122,"[F11]",c("onF11_"),DEFAULT,CSI+"42~",DEFAULT);add(123,"[F12]",CSI+"24~",DEFAULT,CSI+"43~",DEFAULT);add(192,"`~",DEFAULT,sh(ctl("@"),ctl("^")),DEFAULT,PASS);add(49,"1!",DEFAULT,c("onCtrlNum_"),c("onAltNum_"),c("onMetaNum_"));add(50,"2@",DEFAULT,c("onCtrlNum_"),c("onAltNum_"),c("onMetaNum_"));add(51,"3#",DEFAULT,c("onCtrlNum_"),c("onAltNum_"),c("onMetaNum_"));add(52,"4$",DEFAULT,c("onCtrlNum_"),c("onAltNum_"),c("onMetaNum_"));add(53,"5%",DEFAULT,c("onCtrlNum_"),c("onAltNum_"),c("onMetaNum_"));add(54,"6^",DEFAULT,c("onCtrlNum_"),c("onAltNum_"),c("onMetaNum_"));add(55,"7&",DEFAULT,c("onCtrlNum_"),c("onAltNum_"),c("onMetaNum_"));add(56,"8*",DEFAULT,c("onCtrlNum_"),c("onAltNum_"),c("onMetaNum_"));add(57,"9(",DEFAULT,c("onCtrlNum_"),c("onAltNum_"),c("onMetaNum_"));add(48,"0)",DEFAULT,c("onZoom_"),c("onAltNum_"),c("onZoom_"));add(keycapMU,"-_",DEFAULT,c("onZoom_"),DEFAULT,c("onZoom_"));add(keycapEP,"=+",DEFAULT,c("onZoom_"),DEFAULT,c("onZoom_"));add(8,"[BKSP]",bs("","\b"),bs("\b",""),DEFAULT,DEFAULT);add(9,"[TAB]",sh("\t",CSI+"Z"),c("onCtrlTab_"),PASS,DEFAULT);add(81,"qQ",DEFAULT,ctl("Q"),DEFAULT,DEFAULT);add(87,"wW",DEFAULT,c("onCtrlW_"),DEFAULT,DEFAULT);add(69,"eE",DEFAULT,ctl("E"),DEFAULT,DEFAULT);add(82,"rR",DEFAULT,ctl("R"),DEFAULT,DEFAULT);add(84,"tT",DEFAULT,c("onCtrlT_"),DEFAULT,DEFAULT);add(89,"yY",DEFAULT,ctl("Y"),DEFAULT,DEFAULT);add(85,"uU",DEFAULT,ctl("U"),DEFAULT,DEFAULT);add(73,"iI",DEFAULT,ctl("I"),DEFAULT,DEFAULT);add(79,"oO",DEFAULT,ctl("O"),DEFAULT,DEFAULT);add(80,"pP",DEFAULT,ctl("P"),DEFAULT,DEFAULT);add(219,"[{",DEFAULT,ctl("["),DEFAULT,DEFAULT);add(221,"]}",DEFAULT,ctl("]"),DEFAULT,DEFAULT);add(220,"\\|",DEFAULT,ctl("\\"),DEFAULT,DEFAULT);add(20,"[CAPS]",PASS,PASS,PASS,DEFAULT);add(65,"aA",DEFAULT,sh(ctl("A"),c("onCtrlShiftA_")),DEFAULT,DEFAULT);add(83,"sS",DEFAULT,ctl("S"),DEFAULT,DEFAULT);add(68,"dD",DEFAULT,ctl("D"),DEFAULT,DEFAULT);add(70,"fF",DEFAULT,sh(ctl("F"),c("onCtrlShiftF_")),DEFAULT,DEFAULT);add(71,"gG",DEFAULT,ctl("G"),DEFAULT,DEFAULT);add(72,"hH",DEFAULT,ctl("H"),DEFAULT,DEFAULT);add(74,"jJ",DEFAULT,sh(ctl("J"),PASS),DEFAULT,DEFAULT);add(75,"kK",DEFAULT,sh(ctl("K"),c("onClear_")),DEFAULT,DEFAULT);add(76,"lL",DEFAULT,sh(ctl("L"),PASS),DEFAULT,DEFAULT);add(keycapSC,";:",DEFAULT,STRIP,DEFAULT,DEFAULT);add(222,"'\"",DEFAULT,STRIP,DEFAULT,DEFAULT);add(13,"[ENTER]","\r",DEFAULT,DEFAULT,DEFAULT);add(16,"[SHIFT]",PASS,PASS,PASS,DEFAULT);add(90,"zZ",DEFAULT,ctl("Z"),DEFAULT,DEFAULT);add(88,"xX",DEFAULT,ctl("X"),DEFAULT,DEFAULT);add(67,"cC",DEFAULT,c("onCtrlC_"),DEFAULT,c("onMetaC_"));add(86,"vV",DEFAULT,c("onCtrlV_"),DEFAULT,c("onMetaV_"));add(66,"bB",DEFAULT,ctl("B"),DEFAULT,DEFAULT);add(78,"nN",DEFAULT,c("onCtrlN_"),DEFAULT,c("onMetaN_"));add(77,"mM",DEFAULT,ctl("M"),DEFAULT,DEFAULT);add(188,",<",DEFAULT,alt(STRIP,PASS),DEFAULT,DEFAULT);add(190,".>",DEFAULT,alt(STRIP,PASS),DEFAULT,DEFAULT);add(191,"/?",DEFAULT,sh(ctl("_"),ctl("?")),DEFAULT,DEFAULT);add(17,"[CTRL]",PASS,PASS,PASS,PASS);add(18,"[ALT]",PASS,PASS,PASS,PASS);add(91,"[LAPL]",PASS,PASS,PASS,PASS);add(32," ",DEFAULT,ctl("@"),DEFAULT,DEFAULT);add(92,"[RAPL]",PASS,PASS,PASS,PASS);add(93,"[RMENU]",PASS,PASS,PASS,PASS);add(42,"[PRTSCR]",PASS,PASS,PASS,PASS);add(145,"[SCRLK]",PASS,PASS,PASS,PASS);add(19,"[BREAK]",PASS,PASS,PASS,PASS);add(45,"[INSERT]",c("onKeyInsert_"),DEFAULT,DEFAULT,DEFAULT);add(36,"[HOME]",c("onKeyHome_"),DEFAULT,DEFAULT,DEFAULT);add(33,"[PGUP]",c("onKeyPageUp_"),DEFAULT,DEFAULT,DEFAULT);add(46,"[DEL]",c("onKeyDel_"),DEFAULT,DEFAULT,DEFAULT);add(35,"[END]",c("onKeyEnd_"),DEFAULT,DEFAULT,DEFAULT);add(34,"[PGDOWN]",c("onKeyPageDown_"),DEFAULT,DEFAULT,DEFAULT);add(38,"[UP]",c("onKeyArrowUp_"),DEFAULT,DEFAULT,DEFAULT);add(40,"[DOWN]",c("onKeyArrowDown_"),DEFAULT,DEFAULT,DEFAULT);add(39,"[RIGHT]",ac(CSI+"C",SS3+"C"),DEFAULT,DEFAULT,DEFAULT);add(37,"[LEFT]",ac(CSI+"D",SS3+"D"),DEFAULT,DEFAULT,DEFAULT);add(144,"[NUMLOCK]",PASS,PASS,PASS,PASS);add(12,"[CLEAR]",PASS,PASS,PASS,PASS);add(96,"[KP0]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(97,"[KP1]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(98,"[KP2]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(99,"[KP3]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(100,"[KP4]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(101,"[KP5]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(102,"[KP6]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(103,"[KP7]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(104,"[KP8]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(105,"[KP9]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(107,"[KP+]",DEFAULT,c("onZoom_"),DEFAULT,c("onZoom_"));add(109,"[KP-]",DEFAULT,c("onZoom_"),DEFAULT,c("onZoom_"));add(106,"[KP*]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(111,"[KP/]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(110,"[KP.]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);if(hterm.os=="cros"){add(166,"[BACK]",med(mod(SS3+"P",CSI+"P")),DEFAULT,CSI+"23~",DEFAULT);add(167,"[FWD]",med(mod(SS3+"Q",CSI+"Q")),DEFAULT,CSI+"24~",DEFAULT);add(168,"[RELOAD]",med(mod(SS3+"R",CSI+"R")),DEFAULT,CSI+"25~",DEFAULT);add(183,"[FSCR]",med(mod(SS3+"S",CSI+"S")),DEFAULT,CSI+"26~",DEFAULT);add(182,"[WINS]",med(CSI+"15~"),DEFAULT,CSI+"28~",DEFAULT);add(216,"[BRIT-]",med(CSI+"17~"),DEFAULT,CSI+"29~",DEFAULT);add(217,"[BRIT+]",med(CSI+"18~"),DEFAULT,CSI+"31~",DEFAULT);add(173,"[MUTE]",med(CSI+"19~"),DEFAULT,CSI+"32~",DEFAULT);add(174,"[VOL-]",med(CSI+"20~"),DEFAULT,CSI+"33~",DEFAULT);add(175,"[VOL+]",med(CSI+"21~"),DEFAULT,CSI+"34~",DEFAULT);add(152,"[POWER]",DEFAULT,DEFAULT,DEFAULT,DEFAULT);add(179,"[PLAY]",med(CSI+"18~"),DEFAULT,CSI+"31~",DEFAULT);add(154,"[DOGS]",med(CSI+"23~"),DEFAULT,CSI+"42~",DEFAULT);add(153,"[ASSIST]",DEFAULT,DEFAULT,DEFAULT,DEFAULT)}};hterm.Keyboard.KeyMap.prototype.onKeyInsert_=function(e){if(this.keyboard.shiftInsertPaste&&e.shiftKey){return hterm.Keyboard.KeyActions.PASS}return"[2~"};hterm.Keyboard.KeyMap.prototype.onKeyHome_=function(e){if(this.keyboard.homeKeysScroll===e.shiftKey){if(e.altKey||e.ctrlKey||e.shiftKey||!this.keyboard.applicationCursor){return"[H"}return"OH"}this.keyboard.terminal.scrollHome();return hterm.Keyboard.KeyActions.CANCEL};hterm.Keyboard.KeyMap.prototype.onKeyEnd_=function(e){if(this.keyboard.homeKeysScroll===e.shiftKey){if(e.altKey||e.ctrlKey||e.shiftKey||!this.keyboard.applicationCursor){return"[F"}return"OF"}this.keyboard.terminal.scrollEnd();return hterm.Keyboard.KeyActions.CANCEL};hterm.Keyboard.KeyMap.prototype.onKeyPageUp_=function(e){if(this.keyboard.pageKeysScroll===e.shiftKey){return"[5~"}this.keyboard.terminal.scrollPageUp();return hterm.Keyboard.KeyActions.CANCEL};hterm.Keyboard.KeyMap.prototype.onKeyDel_=function(e){if(this.keyboard.altBackspaceIsMetaBackspace&&this.keyboard.altKeyPressed&&!e.altKey){return""}return"[3~"};hterm.Keyboard.KeyMap.prototype.onKeyPageDown_=function(e){if(this.keyboard.pageKeysScroll===e.shiftKey){return"[6~"}this.keyboard.terminal.scrollPageDown();return hterm.Keyboard.KeyActions.CANCEL};hterm.Keyboard.KeyMap.prototype.onKeyArrowUp_=function(e){if(!this.keyboard.applicationCursor&&e.shiftKey){this.keyboard.terminal.scrollLineUp();return hterm.Keyboard.KeyActions.CANCEL}return e.shiftKey||e.ctrlKey||e.altKey||e.metaKey||!this.keyboard.applicationCursor?"[A":"OA"};hterm.Keyboard.KeyMap.prototype.onKeyArrowDown_=function(e){if(!this.keyboard.applicationCursor&&e.shiftKey){this.keyboard.terminal.scrollLineDown();return hterm.Keyboard.KeyActions.CANCEL}return e.shiftKey||e.ctrlKey||e.altKey||e.metaKey||!this.keyboard.applicationCursor?"[B":"OB"};hterm.Keyboard.KeyMap.prototype.onClear_=function(e){this.keyboard.terminal.wipeContents();return hterm.Keyboard.KeyActions.CANCEL};hterm.Keyboard.KeyMap.prototype.onF11_=function(e){if(hterm.windowType!=="popup"&&hterm.windowType!=="app"&&!e.shiftKey){return hterm.Keyboard.KeyActions.PASS}else{return"[23~"}};hterm.Keyboard.KeyMap.prototype.onCtrlNum_=function(e,keyDef){function ctl(ch){return String.fromCharCode(ch.charCodeAt(0)-64)}if(this.keyboard.terminal.passCtrlNumber&&!e.shiftKey){return hterm.Keyboard.KeyActions.PASS}switch(keyDef.keyCap.substr(0,1)){case"1":return"1";case"2":return ctl("@");case"3":return ctl("[");case"4":return ctl("\\");case"5":return ctl("]");case"6":return ctl("^");case"7":return ctl("_");case"8":return"";case"9":return"9"}return hterm.Keyboard.KeyActions.PASS};hterm.Keyboard.KeyMap.prototype.onAltNum_=function(e){if(this.keyboard.terminal.passAltNumber&&!e.shiftKey){return hterm.Keyboard.KeyActions.PASS}return hterm.Keyboard.KeyActions.DEFAULT};hterm.Keyboard.KeyMap.prototype.onMetaNum_=function(e){if(this.keyboard.terminal.passMetaNumber&&!e.shiftKey){return hterm.Keyboard.KeyActions.PASS}return hterm.Keyboard.KeyActions.DEFAULT};hterm.Keyboard.KeyMap.prototype.onCtrlTab_=function(e){if(this.keyboard.terminal.passCtrlTab){return hterm.Keyboard.KeyActions.PASS}return hterm.Keyboard.KeyActions.STRIP};hterm.Keyboard.KeyMap.prototype.onCtrlW_=function(e){if(this.keyboard.terminal.passCtrlW){return hterm.Keyboard.KeyActions.PASS}return""};hterm.Keyboard.KeyMap.prototype.onCtrlT_=function(e){if(this.keyboard.terminal.passCtrlT){return hterm.Keyboard.KeyActions.PASS}return""};hterm.Keyboard.KeyMap.prototype.onCtrlShiftA_=function(e){this.keyboard.terminal.getScrollPort().selectAll();return hterm.Keyboard.KeyActions.CANCEL};hterm.Keyboard.KeyMap.prototype.onCtrlShiftF_=function(e){this.keyboard.terminal.findBar.display();return hterm.Keyboard.KeyActions.CANCEL};hterm.Keyboard.KeyMap.prototype.onCtrlC_=function(e){const selection=this.keyboard.terminal.getDocument().getSelection();if(!selection.isCollapsed){if(this.keyboard.ctrlCCopy&&!e.shiftKey){if(this.keyboard.terminal.clearSelectionAfterCopy){setTimeout(selection.collapseToEnd.bind(selection),50)}return hterm.Keyboard.KeyActions.PASS}if(!this.keyboard.ctrlCCopy&&e.shiftKey){if(this.keyboard.terminal.clearSelectionAfterCopy){setTimeout(selection.collapseToEnd.bind(selection),50)}this.keyboard.terminal.copySelectionToClipboard();return hterm.Keyboard.KeyActions.CANCEL}}return""};hterm.Keyboard.KeyMap.prototype.onCtrlN_=function(e){if(this.keyboard.terminal.passCtrlN){return hterm.Keyboard.KeyActions.PASS}if(e.shiftKey){lib.f.openWindow(globalThis.location.href,"","chrome=no,close=yes,resize=yes,scrollbars=yes,"+`minimizable=yes,width=${globalThis.innerWidth}`+`,height=${globalThis.innerHeight}`);return hterm.Keyboard.KeyActions.CANCEL}return""};hterm.Keyboard.KeyMap.prototype.onCtrlV_=function(e){if(!e.shiftKey&&this.keyboard.ctrlVPaste||e.shiftKey&&!this.keyboard.ctrlVPaste){if(this.keyboard.terminal.paste()!==false){return hterm.Keyboard.KeyActions.CANCEL}else{return hterm.Keyboard.KeyActions.PASS}}return""};hterm.Keyboard.KeyMap.prototype.onMetaN_=function(e){if(e.shiftKey){lib.f.openWindow(globalThis.location.href,"","chrome=no,close=yes,resize=yes,scrollbars=yes,"+`minimizable=yes,width=${globalThis.outerWidth}`+`,height=${globalThis.outerHeight}`);return hterm.Keyboard.KeyActions.CANCEL}return hterm.Keyboard.KeyActions.DEFAULT};hterm.Keyboard.KeyMap.prototype.onMetaC_=function(e,keyDef){const document=this.keyboard.terminal.getDocument();if(e.shiftKey||document.getSelection().isCollapsed){return keyDef.keyCap.substr(e.shiftKey?1:0,1)}if(this.keyboard.terminal.clearSelectionAfterCopy){setTimeout(function(){document.getSelection().collapseToEnd()},50)}return hterm.Keyboard.KeyActions.PASS};hterm.Keyboard.KeyMap.prototype.onMetaV_=function(e){if(e.shiftKey){return hterm.Keyboard.KeyActions.PASS}return this.keyboard.passMetaV?hterm.Keyboard.KeyActions.PASS:hterm.Keyboard.KeyActions.DEFAULT};hterm.Keyboard.KeyMap.prototype.onZoom_=function(e,keyDef){if(this.keyboard.ctrlPlusMinusZeroZoom===e.shiftKey){if(keyDef.keyCap=="-_"){return""}return hterm.Keyboard.KeyActions.CANCEL}const cap=keyDef.keyCap.substr(0,1);if(cap=="0"){this.keyboard.terminal.setFontSize(0)}else{let size=this.keyboard.terminal.getFontSize();if(cap=="-"||keyDef.keyCap=="[KP-]"){size-=1}else{size+=1}this.keyboard.terminal.setFontSize(size)}return hterm.Keyboard.KeyActions.CANCEL};hterm.Keyboard.KeyPattern=function(spec){this.wildcardCount=0;this.keyCode=spec.keyCode;hterm.Keyboard.KeyPattern.modifiers.forEach(function(mod){this[mod]=spec[mod]||false;if(this[mod]=="*"){this.wildcardCount++}}.bind(this))};hterm.Keyboard.KeyPattern.modifiers=["shift","ctrl","alt","meta"];hterm.Keyboard.KeyPattern.sortCompare=function(a,b){if(a.wildcardCount<b.wildcardCount){return-1}if(a.wildcardCount>b.wildcardCount){return 1}return 0};hterm.Keyboard.KeyPattern.prototype.match_=function(obj,exactMatch){if(this.keyCode!=obj.keyCode){return false}let rv=true;hterm.Keyboard.KeyPattern.modifiers.forEach(function(mod){const modValue=mod in obj?obj[mod]:false;if(!rv||!exactMatch&&this[mod]=="*"||this[mod]==modValue){return}rv=false}.bind(this));return rv};hterm.Keyboard.KeyPattern.prototype.matchKeyDown=function(keyDown){return this.match_(keyDown,false)};hterm.Keyboard.KeyPattern.prototype.matchKeyPattern=function(keyPattern){return this.match_(keyPattern,true)};hterm.NotificationCenter=class{constructor(parent,reader=undefined){this.parent_=parent;this.reader_=reader;this.container_=this.newContainer_();this.timeout_=null;this.fadeout_=200}newContainer_(){const ele=this.parent_.ownerDocument.createElement("div");ele.setAttribute("role","dialog");ele.style.cssText="color: rgb(var(--hterm-background-color));"+"background-color: rgb(var(--hterm-foreground-color));"+"border-radius: 12px;"+'font: 500 var(--hterm-font-size) "Noto Sans", sans-serif;'+"opacity: 0.75;"+"padding: 0.923em 1.846em;"+"position: absolute;"+"user-select: none;"+"transition: opacity 180ms ease-in;"+"z-index: 10;";ele.addEventListener("mousedown",function(e){e.preventDefault();e.stopPropagation()},true);return ele}show(msg,{timeout=1500}={}){const node=typeof msg==="string"?new Text(msg):msg;if(this.container_.parentNode&&this.timeout_===null&&timeout!==null){return}this.container_.textContent="";this.container_.appendChild(node);this.container_.style.opacity="0.75";if(!this.container_.parentNode){this.parent_.appendChild(this.container_)}const size=this.container_.getBoundingClientRect();this.container_.style.top=`calc(50% - ${size.height/2}px)`;this.container_.style.left=`calc(50% - ${size.width/2}px)`;if(this.reader_){this.reader_.assertiveAnnounce(this.container_.textContent)}if(this.timeout_){clearTimeout(this.timeout_);this.timeout_=null}if(timeout===null){return}this.timeout_=setTimeout(()=>{this.container_.style.opacity="0";this.timeout_=setTimeout(()=>this.hide(),this.fadeout_)},timeout)}hide(){if(this.timeout_){clearTimeout(this.timeout_);this.timeout_=null}this.container_.remove();this.container_.textContent=""}};hterm.Options=function(copy=undefined){this.wraparound=copy?copy.wraparound:true;this.reverseWraparound=copy?copy.reverseWraparound:false;this.originMode=copy?copy.originMode:false;this.autoCarriageReturn=copy?copy.autoCarriageReturn:false;this.cursorVisible=copy?copy.cursorVisible:false;this.cursorBlink=copy?copy.cursorBlink:false;this.insertMode=copy?copy.insertMode:false;this.reverseVideo=copy?copy.reverseVideo:false;this.bracketedPaste=copy?copy.bracketedPaste:false};hterm.Parser=function(){this.source="";this.pos=0;this.ch=null};hterm.Parser.prototype.error=function(message){return new Error("Parse error at "+this.pos+": "+message)};hterm.Parser.prototype.isComplete=function(){return this.pos==this.source.length};hterm.Parser.prototype.reset=function(source,pos=0){this.source=source;this.pos=pos;this.ch=source.substr(0,1)};hterm.Parser.prototype.parseKeySequence=function(){const rv={keyCode:null};for(const k in hterm.Parser.identifiers.modifierKeys){rv[hterm.Parser.identifiers.modifierKeys[k]]=false}while(this.pos<this.source.length){this.skipSpace();const token=this.parseToken();if(token.type=="integer"){rv.keyCode=token.value}else if(token.type=="identifier"){const ucValue=token.value.toUpperCase();if(ucValue in hterm.Parser.identifiers.modifierKeys&&hterm.Parser.identifiers.modifierKeys.hasOwnProperty(ucValue)){const mod=hterm.Parser.identifiers.modifierKeys[ucValue];if(rv[mod]&&rv[mod]!="*"){throw this.error("Duplicate modifier: "+token.value)}rv[mod]=true}else if(ucValue in hterm.Parser.identifiers.keyCodes&&hterm.Parser.identifiers.keyCodes.hasOwnProperty(ucValue)){rv.keyCode=hterm.Parser.identifiers.keyCodes[ucValue]}else{throw this.error("Unknown key: "+token.value)}}else if(token.type=="symbol"){if(token.value=="*"){for(const id in hterm.Parser.identifiers.modifierKeys){const p=hterm.Parser.identifiers.modifierKeys[id];if(!rv[p]){rv[p]="*"}}}else{throw this.error("Unexpected symbol: "+token.value)}}else{throw this.error("Expected integer or identifier")}this.skipSpace();if(this.ch!=="-"&&this.ch!=="+"){break}if(rv.keyCode!=null){throw this.error("Extra definition after target key")}this.advance(1)}if(rv.keyCode==null){throw this.error("Missing target key")}return rv};hterm.Parser.prototype.parseKeyAction=function(){this.skipSpace();const token=this.parseToken();if(token.type=="string"){return token.value}if(token.type=="identifier"){if(token.value in hterm.Parser.identifiers.actions&&hterm.Parser.identifiers.actions.hasOwnProperty(token.value)){return hterm.Parser.identifiers.actions[token.value]}throw this.error("Unknown key action: "+token.value)}throw this.error("Expected string or identifier")};hterm.Parser.prototype.peekString=function(){return this.ch=="'"||this.ch=='"'};hterm.Parser.prototype.peekIdentifier=function(){return!!this.ch.match(/[a-z_]/i)};hterm.Parser.prototype.peekInteger=function(){return!!this.ch.match(/[0-9]/)};hterm.Parser.prototype.parseToken=function(){if(this.ch=="*"){const rv={type:"symbol",value:this.ch};this.advance(1);return rv}if(this.peekIdentifier()){return{type:"identifier",value:this.parseIdentifier()}}if(this.peekString()){return{type:"string",value:this.parseString()}}if(this.peekInteger()){return{type:"integer",value:this.parseInteger()}}throw this.error("Unexpected token")};hterm.Parser.prototype.parseIdentifier=function(){if(!this.peekIdentifier()){throw this.error("Expected identifier")}return this.parsePattern(/[a-z0-9_]+/gi)};hterm.Parser.prototype.parseInteger=function(){if(this.ch=="0"&&this.pos<this.source.length-1&&this.source.substr(this.pos+1,1)=="x"){return parseInt(this.parsePattern(/0x[0-9a-f]+/gi),undefined)}return parseInt(this.parsePattern(/\d+/g),10)};hterm.Parser.prototype.parseString=function(){let result="";const quote=this.ch;if(quote!='"'&&quote!="'"){throw this.error("String expected")}this.advance(1);const re=new RegExp("[\\\\"+quote+"]","g");while(this.pos<this.source.length){re.lastIndex=this.pos;if(!re.exec(this.source)){throw this.error("Unterminated string literal")}result+=this.source.substring(this.pos,re.lastIndex-1);this.advance(re.lastIndex-this.pos-1);if(quote=='"'&&this.ch=="\\"){this.advance(1);result+=this.parseEscape();continue}if(quote=="'"&&this.ch=="\\"){result+=this.ch;this.advance(1);continue}if(this.ch==quote){this.advance(1);return result}}throw this.error("Unterminated string literal")};hterm.Parser.prototype.parseEscape=function(){const map={'"':'"',"'":"'","\\":"\\",a:"",b:"\b",e:"",f:"\f",n:"\n",r:"\r",t:"\t",v:"\v",x:function(){const value=this.parsePattern(/[a-z0-9]{2}/gi);return String.fromCharCode(parseInt(value,16))},u:function(){const value=this.parsePattern(/[a-z0-9]{4}/gi);return String.fromCharCode(parseInt(value,16))}};if(!(this.ch in map&&map.hasOwnProperty(this.ch))){throw this.error("Unknown escape: "+this.ch)}let value=map[this.ch];this.advance(1);if(typeof value=="function"){value=value.call(this)}return value};hterm.Parser.prototype.parsePattern=function(pattern){if(!pattern.global){throw this.error("Internal error: Span patterns must be global")}pattern.lastIndex=this.pos;const ary=pattern.exec(this.source);if(!ary||pattern.lastIndex-ary[0].length!=this.pos){throw this.error("Expected match for: "+pattern)}this.pos=pattern.lastIndex-1;this.advance(1);return ary[0]};hterm.Parser.prototype.advance=function(count){this.pos+=count;this.ch=this.source.substr(this.pos,1)};hterm.Parser.prototype.skipSpace=function(expect=undefined){if(!/\s/.test(this.ch)){return}const re=/\s+/gm;re.lastIndex=this.pos;const source=this.source;if(re.exec(source)){this.pos=re.lastIndex}this.ch=this.source.substr(this.pos,1);if(expect){if(this.ch.indexOf(expect)==-1){throw this.error(`Expected one of ${expect}, found: ${this.ch}`)}}};hterm.Parser.identifiers={};hterm.Parser.identifiers.modifierKeys={SHIFT:"shift",CTRL:"ctrl",CONTROL:"ctrl",ALT:"alt",META:"meta"};hterm.Parser.identifiers.keyCodes={ESCAPE:27,ESC:27,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,ONE:49,TWO:50,THREE:51,FOUR:52,FIVE:53,SIX:54,SEVEN:55,EIGHT:56,NINE:57,ZERO:48,MINUS:189,EQUAL:187,BACKSPACE:8,BKSP:8,BS:8,TAB:9,Q:81,W:87,E:69,R:82,T:84,Y:89,U:85,I:73,O:79,P:80,BRACKET_LEFT:219,BRACKET_RIGHT:221,CAPS_LOCK:20,CAPSLOCK:20,CAPS:20,A:65,S:83,D:68,F:70,G:71,H:72,J:74,K:75,L:76,ENTER:13,ENT:13,RETURN:13,RET:13,Z:90,X:88,C:67,V:86,B:66,N:78,M:77,SPACE:32,SP:32,PRINT_SCREEN:42,PRTSC:42,SCROLL_LOCK:145,SCRLK:145,BREAK:19,BRK:19,INSERT:45,INS:45,HOME:36,PAGE_UP:33,PGUP:33,DELETE:46,DEL:46,END:35,PAGE_DOWN:34,PGDOWN:34,PGDN:34,UP:38,DOWN:40,RIGHT:39,LEFT:37,NUMLOCK:144,KP0:96,KP1:97,KP2:98,KP3:99,KP4:100,KP5:101,KP6:102,KP7:103,KP8:104,KP9:105,KP_PLUS:107,KP_ADD:107,KP_MINUS:109,KP_SUBTRACT:109,KP_STAR:106,KP_MULTIPLY:106,KP_DIVIDE:111,KP_DECIMAL:110,KP_PERIOD:110,NAVIGATE_BACK:166,NAVIGATE_FORWARD:167,RELOAD:168,FULL_SCREEN:183,WINDOW_OVERVIEW:182,BRIGHTNESS_UP:216,BRIGHTNESS_DOWN:217};hterm.Parser.identifiers.actions={CANCEL:hterm.Keyboard.KeyActions.CANCEL,DEFAULT:hterm.Keyboard.KeyActions.DEFAULT,PASS:hterm.Keyboard.KeyActions.PASS,scrollLineUp:function(terminal){terminal.scrollLineUp();return hterm.Keyboard.KeyActions.CANCEL},scrollLineDown:function(terminal){terminal.scrollLineDown();return hterm.Keyboard.KeyActions.CANCEL},scrollPageUp:function(terminal){terminal.scrollPageUp();return hterm.Keyboard.KeyActions.CANCEL},scrollPageDown:function(terminal){terminal.scrollPageDown();return hterm.Keyboard.KeyActions.CANCEL},scrollToTop:function(terminal){terminal.scrollHome();return hterm.Keyboard.KeyActions.CANCEL},scrollToBottom:function(terminal){terminal.scrollEnd();return hterm.Keyboard.KeyActions.CANCEL},selectAll:function(terminal){terminal.getScrollPort().selectAll();return hterm.Keyboard.KeyActions.CANCEL},clearScreen:function(terminal){terminal.clearHome();return hterm.Keyboard.KeyActions.CANCEL},clearScrollback:function(terminal){terminal.clearScrollback();return hterm.Keyboard.KeyActions.CANCEL},clearTerminal:function(terminal){terminal.wipeContents();return hterm.Keyboard.KeyActions.CANCEL},fullReset:function(terminal){terminal.reset();return hterm.Keyboard.KeyActions.CANCEL},softReset:function(terminal){terminal.softReset();return hterm.Keyboard.KeyActions.CANCEL}};hterm.PreferenceManager=function(storage,profileId=hterm.Terminal.DEFAULT_PROFILE_ID){lib.PreferenceManager.call(this,storage,hterm.PreferenceManager.prefix_+profileId);Object.entries(hterm.PreferenceManager.defaultPreferences).forEach(([key,entry])=>{this.definePreference(key,entry["default"])})};hterm.PreferenceManager.prefix_="/hterm/profiles/";hterm.PreferenceManager.listProfiles=function(storage,callback){storage.getItems(null).then(items=>{const profiles={};for(const key of Object.keys(items)){if(key.startsWith(hterm.PreferenceManager.prefix_)){const subKey=key.slice(hterm.PreferenceManager.prefix_.length);profiles[subKey.split("/",1)[0]]=true}}callback(Object.keys(profiles))})};hterm.PreferenceManager.Categories={Keyboard:"Keyboard",Appearance:"Appearance",CopyPaste:"CopyPaste",Sounds:"Sounds",Scrolling:"Scrolling",Encoding:"Encoding",Extensions:"Extensions",Miscellaneous:"Miscellaneous"};hterm.PreferenceManager.categoryDefinitions=[{id:hterm.PreferenceManager.Categories.Appearance,text:"Appearance (fonts, colors, images)"},{id:hterm.PreferenceManager.Categories.CopyPaste,text:"Copy & Paste"},{id:hterm.PreferenceManager.Categories.Encoding,text:"Encoding"},{id:hterm.PreferenceManager.Categories.Keyboard,text:"Keyboard"},{id:hterm.PreferenceManager.Categories.Scrolling,text:"Scrolling"},{id:hterm.PreferenceManager.Categories.Sounds,text:"Sounds"},{id:hterm.PreferenceManager.Categories.Extensions,text:"Extensions"},{id:hterm.PreferenceManager.Categories.Miscellaneous,text:"Miscellaneous"}];hterm.PreferenceManager.definePref_=function(name,category,defaultValue,type,help){return{name:name,category:category,default:defaultValue,type:type,help:help}};hterm.PreferenceManager.defaultPreferences={"alt-gr-mode":hterm.PreferenceManager.definePref_("AltGr key mode",hterm.PreferenceManager.Categories.Keyboard,null,[null,"none","ctrl-alt","left-alt","right-alt"],`Select an AltGr detection heuristic.\n`+`\n`+`'null': Autodetect based on navigator.language:\n`+`      'en-us' => 'none', else => 'right-alt'\n`+`'none': Disable any AltGr emulation.\n`+`'ctrl-alt': Assume Ctrl+Alt means AltGr.\n`+`'left-alt': Assume left Alt means AltGr.\n`+`'right-alt': Assume right Alt means AltGr.`),"alt-backspace-is-meta-backspace":hterm.PreferenceManager.definePref_("Alt+Backspace is Meta+Backspace",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`If set, undoes the ChromeOS Alt+Backspace->Delete remap, so that `+`Alt+Backspace indeed is Alt+Backspace.`),"alt-is-meta":hterm.PreferenceManager.definePref_("Treat Alt key as Meta key",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`Whether the Alt key acts as a Meta key or as a distinct Alt key.`),"alt-sends-what":hterm.PreferenceManager.definePref_("Alt key modifier handling",hterm.PreferenceManager.Categories.Keyboard,"escape",["escape","8-bit","browser-key"],`Controls how the Alt key is handled.\n`+`\n`+`  escape: Send an ESC prefix.\n`+`  8-bit: Add 128 to the typed character as in xterm.\n`+`  browser-key: Wait for the keypress event and see what the browser\n`+`    says. (This won't work well on platforms where the browser\n`+`    performs a default action for some Alt sequences.)`),"audible-bell-sound":hterm.PreferenceManager.definePref_("Alert bell sound (URI)",hterm.PreferenceManager.Categories.Sounds,"lib-resource:hterm/audio/bell","url",`URL of the terminal bell sound. Leave it blank for no audible bell.`),"desktop-notification-bell":hterm.PreferenceManager.definePref_("Create desktop notifications for alert bells",hterm.PreferenceManager.Categories.Sounds,false,"bool",`If true, terminal bells in the background will create a Web `+`Notification. https://www.w3.org/TR/notifications/\n`+`\n`+`Displaying notifications requires permission from the user. When this `+`option is set to true, hterm will attempt to ask the user for `+`permission if necessary. Browsers might not show this permission `+`request if it was not triggered by a user action.\n`+`\n`+`Chrome extensions with the "notifications" permission have permission `+`to display notifications.`),"background-color":hterm.PreferenceManager.definePref_("Background color",hterm.PreferenceManager.Categories.Appearance,"rgb(16, 16, 16)","color",`The background color for text with no other color attributes.`),"background-image":hterm.PreferenceManager.definePref_("Background image",hterm.PreferenceManager.Categories.Appearance,"","string",`CSS value of the background image. Leave it blank for no image.\n`+`\n`+`For example:\n`+`  url(https://goo.gl/anedTK)\n`+`  linear-gradient(top bottom, blue, red)`),"background-size":hterm.PreferenceManager.definePref_("Background image size",hterm.PreferenceManager.Categories.Appearance,"","string",`CSS value of the background image size.`),"background-position":hterm.PreferenceManager.definePref_("Background image position",hterm.PreferenceManager.Categories.Appearance,"","string",`CSS value of the background image position.\n`+`\n`+`For example:\n`+`  10% 10%\n`+`  center`),"backspace-sends-backspace":hterm.PreferenceManager.definePref_("Backspace key behavior",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`If true, the Backspace key will send BS ('\\x08', aka ^H). Otherwise `+`the Backspace key will send '\\x7f'.`),"character-map-overrides":hterm.PreferenceManager.definePref_("Character map overrides",hterm.PreferenceManager.Categories.Appearance,null,"value",`This is specified as an object. It is a sparse array, where each `+`property is the character set code and the value is an object that is `+`a sparse array itself. In that sparse array, each property is the `+`received character and the value is the displayed character.\n`+`\n`+`For example:\n`+`{ "0": {\n`+`  "+": "\\u2192",\n`+`  ",": "\\u2190",\n`+`  "-": "\\u2191",\n`+`  ".": "\\u2193",\n`+`  "0": "\\u2588"\n} }`),"close-on-exit":hterm.PreferenceManager.definePref_("Close window on exit",hterm.PreferenceManager.Categories.Miscellaneous,true,"bool",`Whether to close the window when the command finishes executing.`),"cursor-blink":hterm.PreferenceManager.definePref_("Cursor blink",hterm.PreferenceManager.Categories.Appearance,false,"bool",`Whether the text cursor blinks by default. This can be toggled at `+`runtime via terminal escape sequences.`),"cursor-blink-cycle":hterm.PreferenceManager.definePref_("Cursor blink rate",hterm.PreferenceManager.Categories.Appearance,[1e3,500],"value",`The text cursor blink rate in milliseconds.\n`+`\n`+`A two element array, the first of which is how long the text cursor `+`should be on, second is how long it should be off.`),"cursor-shape":hterm.PreferenceManager.definePref_("Text cursor shape",hterm.PreferenceManager.Categories.Appearance,"BLOCK",["BLOCK","BEAM","UNDERLINE"],`The shape of the visible text cursor. This can be changed at `+`runtime via terminal escape sequences.`),"cursor-color":hterm.PreferenceManager.definePref_("Text cursor color",hterm.PreferenceManager.Categories.Appearance,"rgba(255, 0, 0, 0.5)","color",`The color of the visible text cursor.`),"color-palette-overrides":hterm.PreferenceManager.definePref_("Initial color palette",hterm.PreferenceManager.Categories.Appearance,null,"value",`Override colors in the default palette.\n`+`\n`+`This can be specified as an array or an object. If specified as an `+`object it is assumed to be a sparse array, where each property `+`is a numeric index into the color palette.\n`+`\n`+`Values can be specified as almost any CSS color value. This `+`includes #RGB, #RRGGBB, rgb(...), rgba(...), and any color names `+`that are also part of the standard X11 rgb.txt file.\n`+`\n`+`You can use 'null' to specify that the default value should be not `+`be changed. This is useful for skipping a small number of indices `+`when the value is specified as an array.\n`+`\n`+`For example, these both set color index 1 to blue:\n`+`  {1: "#0000ff"}\n`+`  [null, "#0000ff"]`),"copy-on-select":hterm.PreferenceManager.definePref_("Automatically copy selected content",hterm.PreferenceManager.Categories.CopyPaste,true,"bool",`Automatically copy mouse selection to the clipboard.`),"use-default-window-copy":hterm.PreferenceManager.definePref_("Let the browser handle text copying",hterm.PreferenceManager.Categories.CopyPaste,false,"bool",`Whether to use the default browser/OS's copy behavior.\n`+`\n`+`Allow the browser/OS to handle the copy event directly which might `+`improve compatibility with some systems (where copying doesn't work `+`at all), but makes the text selection less robust.\n`+`\n`+`For example, long lines that were automatically line wrapped will `+`be copied with the newlines still in them.`),"clear-selection-after-copy":hterm.PreferenceManager.definePref_("Automatically clear text selection",hterm.PreferenceManager.Categories.CopyPaste,true,"bool",`Whether to clear the selection after copying.`),"ctrl-plus-minus-zero-zoom":hterm.PreferenceManager.definePref_("Ctrl++/-/0 zoom behavior",hterm.PreferenceManager.Categories.Keyboard,true,"bool",`If true, Ctrl+Plus/Minus/Zero controls zoom.\n`+`If false, Ctrl+Shift+Plus/Minus/Zero controls zoom, Ctrl+Minus sends `+`^_, Ctrl+Plus/Zero do nothing.`),"ctrl-c-copy":hterm.PreferenceManager.definePref_("Ctrl+C copy behavior",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`Ctrl+C copies if true, send ^C to host if false.\n`+`Ctrl+Shift+C sends ^C to host if true, copies if false.`),"ctrl-v-paste":hterm.PreferenceManager.definePref_("Ctrl+V paste behavior",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`Ctrl+V pastes if true, send ^V to host if false.\n`+`Ctrl+Shift+V sends ^V to host if true, pastes if false.`),"east-asian-ambiguous-as-two-column":hterm.PreferenceManager.definePref_("East Asian Ambiguous use two columns",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`Whether East Asian Ambiguous characters have two column width.`),"enable-8-bit-control":hterm.PreferenceManager.definePref_("Support non-UTF-8 C1 control characters",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`True to enable 8-bit control characters, false to ignore them.\n`+`\n`+`We'll respect the two-byte versions of these control characters `+`regardless of this setting.`),"enable-bold":hterm.PreferenceManager.definePref_("Bold text behavior",hterm.PreferenceManager.Categories.Appearance,null,"tristate",`If true, use bold weight font for text with the bold/bright `+`attribute. False to use the normal weight font. Null to autodetect.`),"enable-bold-as-bright":hterm.PreferenceManager.definePref_("Use bright colors with bold text",hterm.PreferenceManager.Categories.Appearance,true,"bool",`If true, use bright colors (8-15 on a 16 color palette) for any text `+`with the bold attribute. False otherwise.`),"enable-blink":hterm.PreferenceManager.definePref_("Enable blinking text",hterm.PreferenceManager.Categories.Appearance,true,"bool",`If true, respect the blink attribute. False to ignore it.`),"enable-clipboard-notice":hterm.PreferenceManager.definePref_("Show notification when copying content",hterm.PreferenceManager.Categories.CopyPaste,true,"bool",`Whether to show a message in the terminal when the host writes to the `+`clipboard.`),"enable-clipboard-write":hterm.PreferenceManager.definePref_("Allow remote clipboard writes",hterm.PreferenceManager.Categories.CopyPaste,true,"bool",`Allow the remote host to write directly to the local system `+`clipboard.\n`+`Read access is never granted regardless of this setting.\n`+`\n`+`This is used to control access to features like OSC-52.`),"enable-dec12":hterm.PreferenceManager.definePref_("Allow changing of text cursor blinking",hterm.PreferenceManager.Categories.Miscellaneous,false,"bool",`Respect the host's attempt to change the text cursor blink status `+`using DEC Private Mode 12.`),"enable-csi-j-3":hterm.PreferenceManager.definePref_("Allow clearing of scrollback buffer (CSI-J-3)",hterm.PreferenceManager.Categories.Miscellaneous,true,"bool",`Whether the Erase Saved Lines function (mode 3) of the Erase Display `+`command (CSI-J) may clear the terminal scrollback buffer.\n`+`\n`+`Enabling this by default is safe.`),environment:hterm.PreferenceManager.definePref_("Environment variables",hterm.PreferenceManager.Categories.Miscellaneous,{NCURSES_NO_UTF8_ACS:"1",TERM:"xterm-256color",COLORTERM:"truecolor"},"value",`The initial set of environment variables, as an object.`),"find-result-color":hterm.PreferenceManager.definePref_("Find results highlight color",hterm.PreferenceManager.Categories.Appearance,"rgba(102, 204, 255, 0.4)","color",`The background color to highlight find results.`),"find-result-selected-color":hterm.PreferenceManager.definePref_("Find results selected highlight color",hterm.PreferenceManager.Categories.Appearance,"rgba(102, 204, 255, 0.8)","color",`The background color to highlight the selected find result.`),"font-family":hterm.PreferenceManager.definePref_("Text font family",hterm.PreferenceManager.Categories.Appearance,'"DejaVu Sans Mono", "Noto Sans Mono", "Everson Mono", FreeMono, '+"Menlo, Terminal, monospace","string",`Default font family for the terminal text.`),"font-size":hterm.PreferenceManager.definePref_("Text font size",hterm.PreferenceManager.Categories.Appearance,15,"int",`The default font size in pixels.`),"font-smoothing":hterm.PreferenceManager.definePref_("Text font smoothing",hterm.PreferenceManager.Categories.Appearance,"antialiased","string",`CSS font-smoothing property.`),"line-height-padding-size":hterm.PreferenceManager.definePref_("Line height padding size",hterm.PreferenceManager.Categories.Appearance,0,"int",`The padding size in pixels between each row of the terminal screen.`),"foreground-color":hterm.PreferenceManager.definePref_("Text color",hterm.PreferenceManager.Categories.Appearance,"rgb(240, 240, 240)","color",`The foreground color for text with no other color attributes.`),"enable-resize-status":hterm.PreferenceManager.definePref_("Show terminal dimensions when resized",hterm.PreferenceManager.Categories.Appearance,false,"bool",`Whether to show terminal dimensions when the terminal changes size.`),"hide-mouse-while-typing":hterm.PreferenceManager.definePref_("Hide mouse cursor while typing",hterm.PreferenceManager.Categories.Keyboard,null,"tristate",`Whether to automatically hide the mouse cursor when typing. `+`By default, autodetect whether the platform/OS handles this.\n`+`\n`+`Note: Your operating system might override this setting and thus you `+`might not be able to always disable it.`),"home-keys-scroll":hterm.PreferenceManager.definePref_("Home/End key scroll behavior",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`If true, Home/End controls the terminal scrollbar and Shift+Home/`+`Shift+End are sent to the remote host. If false, then Home/End are `+`sent to the remote host and Shift+Home/Shift+End scrolls.`),keybindings:hterm.PreferenceManager.definePref_("Keyboard bindings/shortcuts",hterm.PreferenceManager.Categories.Keyboard,null,"value",`A map of key sequence to key actions. Key sequences include zero or `+`more modifier keys followed by a key code. Key codes can be decimal `+`or hexadecimal numbers, or a key identifier. Key actions can be `+`specified as a string to send to the host, or an action identifier. `+`For a full explanation of the format, see https://hterm.org/x/docs/keyboard-bindings.\n`+`\n`+`Sample keybindings:\n`+`{\n`+`  "Ctrl+Alt+K": "clearTerminal",\n`+`  "Ctrl+Shift+L": "PASS",\n`+`  "Ctrl+H": "'Hello World'"\n`+`}`),"keybindings-os-defaults":hterm.PreferenceManager.definePref_("Use default OS Keyboard bindings/shortcuts",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`Whether common OS keyboard bindings should be respected instead of `+`always capturing for hterm's own use.`),"media-keys-are-fkeys":hterm.PreferenceManager.definePref_("Media keys are Fkeys",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`If true, convert media keys to their Fkey equivalent. If false, let `+`the browser handle the keys.`),"meta-sends-escape":hterm.PreferenceManager.definePref_("Meta key modifier handling",hterm.PreferenceManager.Categories.Keyboard,true,"bool",`Send an ESC prefix when pressing a key while holding the Meta key.\n`+`\n`+`For example, when enabled, pressing Meta+K will send ^[k as if you `+`typed Escape then k. When disabled, only k will be sent.`),"mouse-right-click-paste":hterm.PreferenceManager.definePref_("Mouse right clicks paste content",hterm.PreferenceManager.Categories.CopyPaste,true,"bool",`Paste on right mouse button clicks.\n`+`\n`+`This option is independent of the "mouse-paste-button" setting.\n`+`\n`+`Note: The primary & secondary buttons are handled for you with left `+`& right handed mice.`),"mouse-paste-button":hterm.PreferenceManager.definePref_("Mouse button paste",hterm.PreferenceManager.Categories.CopyPaste,null,[null,0,1,2,3,4,5,6],`The mouse button to use for pasting.\n`+`\n`+`For autodetect, we'll use the middle mouse button for non-X11 `+`platforms (including ChromeOS). On X11, we'll use the right mouse `+`button (since the window manager should handle pasting via the middle `+`mouse button).\n`+`\n`+`0 == left (primary) button.\n`+`1 == middle (auxiliary) button.\n`+`2 == right (secondary) button.\n`+`\n`+`This option is independent of the setting for right-click paste.\n`+`\n`+`Note: The primary & secondary buttons are handled for you with left `+`& right handed mice.`),"screen-padding-size":hterm.PreferenceManager.definePref_("Screen padding size",hterm.PreferenceManager.Categories.Appearance,8,"int",`The padding size in pixels around the border of the terminal screen.\n`+`\n`+`This controls the size of the border around the terminal screen so `+`the user can add some visible padding to the edges of the screen.`),"screen-border-size":hterm.PreferenceManager.definePref_("Screen border size",hterm.PreferenceManager.Categories.Appearance,0,"int",`The border size in pixels around the terminal screen.\n`+`\n`+`This controls the size of the border around the terminal screen to `+`create a visible line at the edges of the screen.`),"screen-border-color":hterm.PreferenceManager.definePref_("Screen border color",hterm.PreferenceManager.Categories.Appearance,"rgb(128, 128, 128)","color",`The color for the border around the terminal screen.\n`+`\n`+`This controls the color of the border around the terminal screen to `+`create a visible line at the edges of the screen.`),"word-break-match-left":hterm.PreferenceManager.definePref_("Automatic selection halting (to the left)",hterm.PreferenceManager.Categories.CopyPaste,"[^\\s[\\](){}<>\"'^!@#$%&*,;:`‘“‹«]","string",`Regular expression to halt matching to the left (start) of a `+`selection.\n`+`\n`+`Normally this is a character class to reject specific characters.\n`+`We allow "~" and "." by default as paths frequently start with those.`),"word-break-match-right":hterm.PreferenceManager.definePref_("Automatic selection halting (to the right)",hterm.PreferenceManager.Categories.CopyPaste,"[^\\s[\\](){}<>\"'^!@#$%&*,;:~.`’”›»]","string",`Regular expression to halt matching to the right (end) of a `+`selection.\n`+`\n`+`Normally this is a character class to reject specific characters.`),"word-break-match-middle":hterm.PreferenceManager.definePref_("Word break characters",hterm.PreferenceManager.Categories.CopyPaste,"[^\\s[\\](){}<>\"'^]*","string",`Regular expression to match all the characters in the middle.\n`+`\n`+`Normally this is a character class to reject specific characters.\n`+`\n`+`Used to expand the selection surrounding the starting point.`),"page-keys-scroll":hterm.PreferenceManager.definePref_("Page Up/Down key scroll behavior",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`If true, Page Up/Page Down controls the terminal scrollbar and `+`Shift+Page Up/Shift+Page Down are sent to the remote host. If false, `+`then Page Up/Page Down are sent to the remote host and Shift+Page Up/`+`Shift+Page Down scrolls.`),"pass-alt-number":hterm.PreferenceManager.definePref_("Alt+1..9 switch tab/app behavior",hterm.PreferenceManager.Categories.Keyboard,null,"tristate",`Whether Alt+1..9 is passed to the browser.\n`+`\n`+`This is handy when running hterm in a browser tab, so that you don't `+`lose Chrome's "switch to tab/app" keyboard shortcuts. When not `+`running in a tab it's better to send these keys to the host so they `+`can be used in vim or emacs.\n`+`\n`+`If true, Alt+1..9 will be handled by the browser. If false, Alt+1..9 `+`will be sent to the host. If null, autodetect based on browser `+`platform and window type.`),"pass-ctrl-number":hterm.PreferenceManager.definePref_("Ctrl+1..9 switch tab behavior",hterm.PreferenceManager.Categories.Keyboard,null,"tristate",`Whether Ctrl+1..9 is passed to the browser.\n`+`\n`+`This is handy when running hterm in a browser tab, so that you don't `+`lose Chrome's "switch to tab" keyboard shortcuts. When not running `+`in a tab it's better to send these keys to the host so they can be `+`used in vim or emacs.\n`+`\n`+`If true, Ctrl+1..9 will be handled by the browser. If false, `+`Ctrl+1..9 will be sent to the host. If null, autodetect based on `+`browser platform and window type.`),"pass-ctrl-n":hterm.PreferenceManager.definePref_("Ctrl+N new window behavior",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`Whether Ctrl+N is passed to the browser.\n`+`\n`+`If true, Ctrl+N will be handled by the browser as the "new window" `+`keyboard shortcut. If false, Ctrl+N will be sent to the host.`),"pass-ctrl-t":hterm.PreferenceManager.definePref_("Ctrl+T new tab behavior",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`Whether Ctrl+T is passed to the browser.\n`+`\n`+`If true, Ctrl+T will be handled by the browser as the "new tab" `+`keyboard shortcut. If false, Ctrl+T will be sent to the host.`),"pass-ctrl-tab":hterm.PreferenceManager.definePref_("Ctrl+Tab switch tab behavior",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`Whether Ctrl+Tab and Ctrl+Shift+Tab are passed to the browser.\n`+`\n`+`If true, Ctrl+Tab and Ctrl+Shift+Tab will be handled by the browser `+`as the "next/previous tab" keyboard shortcut. If false, the Tab `+`key is sent to the host without Ctrl or Shift.`),"pass-ctrl-w":hterm.PreferenceManager.definePref_("Ctrl+W close tab behavior",hterm.PreferenceManager.Categories.Keyboard,false,"bool",`Whether Ctrl+W is passed to the browser.\n`+`\n`+`If true, Ctrl+W will be handled by the browser as the "close tab" `+`keyboard shortcut. If false, Ctrl+W will be sent to the host.`),"pass-meta-number":hterm.PreferenceManager.definePref_("Meta+1..9 switch tab behavior",hterm.PreferenceManager.Categories.Keyboard,null,"tristate",`Whether Meta+1..9 is passed to the browser.\n`+`\n`+`This is handy when running hterm in a browser tab, so that you don't `+`lose Chrome's "switch to tab" keyboard shortcuts. When not running `+`in a tab it's better to send these keys to the host so they can be `+`used in vim or emacs.\n`+`\n`+`If true, Meta+1..9 will be handled by the browser. If false, `+`Meta+1..9 will be sent to the host. If null, autodetect based on `+`browser platform and window type.`),"pass-meta-v":hterm.PreferenceManager.definePref_("Meta+V paste behavior",hterm.PreferenceManager.Categories.Keyboard,true,"bool",`Whether Meta+V gets passed to the browser.\n`+`\n`+`On some systems, this is used to paste content.`),"paste-on-drop":hterm.PreferenceManager.definePref_("Allow drag & drop to paste",hterm.PreferenceManager.Categories.CopyPaste,true,"bool",`If true, Drag and dropped text will paste into terminal.\n`+`If false, dropped text will be ignored.`),"scroll-on-keystroke":hterm.PreferenceManager.definePref_("Scroll to bottom after keystroke",hterm.PreferenceManager.Categories.Scrolling,true,"bool",`Whether to scroll to the bottom on any keystroke.`),"scroll-on-output":hterm.PreferenceManager.definePref_("Scroll to bottom after new output",hterm.PreferenceManager.Categories.Scrolling,false,"bool",`Whether to scroll to the bottom on terminal output.`),"scrollbar-visible":hterm.PreferenceManager.definePref_("Scrollbar visibility",hterm.PreferenceManager.Categories.Scrolling,true,"bool",`The vertical scrollbar mode.`),"scroll-wheel-may-send-arrow-keys":hterm.PreferenceManager.definePref_("Emulate arrow keys with scroll wheel",hterm.PreferenceManager.Categories.Scrolling,false,"bool",`When using the alternative screen buffer, and DECCKM (Application `+`Cursor Keys) is active, mouse scroll wheel events will emulate arrow `+`keys.\n`+`\n`+`It can be temporarily disabled by holding the Shift key.\n`+`\n`+`This frequently comes up when using pagers (less) or reading man `+`pages or text editors (vi/nano) or using screen/tmux.`),"scroll-wheel-move-multiplier":hterm.PreferenceManager.definePref_("Mouse scroll wheel multiplier",hterm.PreferenceManager.Categories.Scrolling,1,"int",`The multiplier for mouse scroll wheel events when measured in `+`pixels.\n`+`\n`+`Alters how fast the page scrolls.`),"terminal-encoding":hterm.PreferenceManager.definePref_("Terminal encoding",hterm.PreferenceManager.Categories.Encoding,"utf-8",["iso-2022","utf-8","utf-8-locked"],`The default terminal encoding (DOCS).\n`+`\n`+`ISO-2022 enables character map translations (like graphics maps).\n`+`UTF-8 disables support for those.\n`+`\n`+`The locked variant means the encoding cannot be changed at runtime `+`via terminal escape sequences.\n`+`\n`+`You should stick with UTF-8 unless you notice broken rendering with `+`legacy applications.`),"shift-insert-paste":hterm.PreferenceManager.definePref_("Shift+Insert paste",hterm.PreferenceManager.Categories.Keyboard,true,"bool",`Whether Shift+Insert is used for pasting or is sent to the remote host.`),"user-css":hterm.PreferenceManager.definePref_("Custom CSS (URI)",hterm.PreferenceManager.Categories.Appearance,"","url",`URL of user stylesheet to include in the terminal document.`),"user-css-text":hterm.PreferenceManager.definePref_("Custom CSS (inline text)",hterm.PreferenceManager.Categories.Appearance,"","multiline-string",`Custom CSS text for styling the terminal.`),"allow-images-inline":hterm.PreferenceManager.definePref_("Allow inline image display",hterm.PreferenceManager.Categories.Extensions,null,"tristate",`Whether to allow the remote host to display images in the terminal.\n`+`\n`+`By default, we prompt until a choice is made.`)};hterm.PreferenceManager.prototype=Object.create(lib.PreferenceManager.prototype);hterm.PreferenceManager.constructor=hterm.PreferenceManager;hterm.PreferenceManager.prototype.setProfile=function(profileId,callback){lib.PreferenceManager.prototype.setPrefix.call(this,hterm.PreferenceManager.prefix_+profileId,callback)};hterm.PubSub=function(){this.observers_={}};hterm.PubSub.addBehavior=function(obj){const pubsub=new hterm.PubSub;for(const m in hterm.PubSub.prototype){obj[m]=hterm.PubSub.prototype[m].bind(pubsub)}};hterm.PubSub.prototype.subscribe=function(subject,callback){if(!(subject in this.observers_)){this.observers_[subject]=[]}this.observers_[subject].push(callback)};hterm.PubSub.prototype.unsubscribe=function(subject,callback){const list=this.observers_[subject];if(!list){throw new Error(`Invalid subject: ${subject}`)}const i=list.indexOf(callback);if(i<0){throw new Error(`Not subscribed: ${subject}`)}list.splice(i,1)};hterm.PubSub.prototype.publish=function(subject,e,lastCallback=undefined){function notifyList(i){if(i<list.length-1){setTimeout(notifyList,0,i+1)}list[i](e)}let list=this.observers_[subject];if(list){list=[].concat(list)}if(lastCallback){if(list){list.push(lastCallback)}else{list=[lastCallback]}}if(list){setTimeout(notifyList,0,0)}};hterm.Screen=function(columnCount=0){this.rowsArray=[];this.columnCount_=columnCount;this.textAttributes=new hterm.TextAttributes(globalThis.document);this.cursorPosition=new hterm.RowCol(0,0);this.cursorState_=new hterm.Screen.CursorState(this);this.cursorRowNode_=null;this.cursorNode_=null;this.cursorOffset_=0;this.wordBreakMatchLeft=null;this.wordBreakMatchRight=null;this.wordBreakMatchMiddle=null};hterm.Screen.prototype.getSize=function(){return new hterm.Size(this.columnCount_,this.rowsArray.length)};hterm.Screen.prototype.getHeight=function(){return this.rowsArray.length};hterm.Screen.prototype.getWidth=function(){return this.columnCount_};hterm.Screen.prototype.setColumnCount=function(count){this.columnCount_=count;if(this.cursorPosition.column>=count){this.setCursorPosition(this.cursorPosition.row,count-1)}};hterm.Screen.prototype.shiftRow=function(){return this.shiftRows(1)[0]};hterm.Screen.prototype.shiftRows=function(count){return this.rowsArray.splice(0,count)};hterm.Screen.prototype.unshiftRow=function(row){this.rowsArray.splice(0,0,row)};hterm.Screen.prototype.unshiftRows=function(rows){this.rowsArray.unshift.apply(this.rowsArray,rows)};hterm.Screen.prototype.popRow=function(){return this.popRows(1)[0]};hterm.Screen.prototype.popRows=function(count){return this.rowsArray.splice(this.rowsArray.length-count,count)};hterm.Screen.prototype.pushRow=function(row){this.rowsArray.push(row)};hterm.Screen.prototype.pushRows=function(rows){rows.push.apply(this.rowsArray,rows)};hterm.Screen.prototype.insertRow=function(index,row){this.rowsArray.splice(index,0,row)};hterm.Screen.prototype.insertRows=function(index,rows){for(let i=0;i<rows.length;i++){this.rowsArray.splice(index+i,0,rows[i])}};hterm.Screen.prototype.removeRow=function(index){return this.rowsArray.splice(index,1)[0]};hterm.Screen.prototype.removeRows=function(index,count){return this.rowsArray.splice(index,count)};hterm.Screen.prototype.invalidateCursorPosition=function(){this.cursorPosition.move(0,0);this.cursorRowNode_=null;this.cursorNode_=null;this.cursorOffset_=0};hterm.Screen.prototype.clearCursorRow=function(){this.cursorRowNode_.innerText="";this.cursorRowNode_.removeAttribute("line-overflow");this.cursorOffset_=0;this.cursorPosition.column=0;this.cursorPosition.overflow=false;let text;if(this.textAttributes.isDefault()){text=""}else{text=" ".repeat(this.columnCount_)}const inverse=this.textAttributes.inverse;this.textAttributes.inverse=false;this.textAttributes.syncColors();const node=this.textAttributes.createContainer(text);this.cursorRowNode_.appendChild(node);this.cursorNode_=node;this.textAttributes.inverse=inverse;this.textAttributes.syncColors()};hterm.Screen.prototype.commitLineOverflow=function(){this.cursorRowNode_.setAttribute("line-overflow",true)};hterm.Screen.prototype.setCursorPosition=function(row,column){if(!this.rowsArray.length){console.warn("Attempt to set cursor position on empty screen.");return}if(row>=this.rowsArray.length){console.error("Row out of bounds: "+row);row=this.rowsArray.length-1}else if(row<0){console.error("Row out of bounds: "+row);row=0}if(column>=this.columnCount_){console.error("Column out of bounds: "+column);column=this.columnCount_-1}else if(column<0){console.error("Column out of bounds: "+column);column=0}this.cursorPosition.overflow=false;const rowNode=this.rowsArray[row];let node=rowNode.firstChild;if(!node){node=rowNode.ownerDocument.createTextNode("");rowNode.appendChild(node)}let currentColumn=0;if(rowNode==this.cursorRowNode_){if(column>=this.cursorPosition.column-this.cursorOffset_){node=this.cursorNode_;currentColumn=this.cursorPosition.column-this.cursorOffset_}}else{this.cursorRowNode_=rowNode}this.cursorPosition.move(row,column);while(node){const offset=column-currentColumn;const width=hterm.TextAttributes.nodeWidth(node);if(!node.nextSibling||width>offset){this.cursorNode_=node;this.cursorOffset_=offset;return}currentColumn+=width;node=node.nextSibling}};hterm.Screen.prototype.syncSelectionCaret=function(selection){try{selection.collapse(this.cursorNode_,this.cursorOffset_)}catch(firefoxIgnoredException){}};hterm.Screen.prototype.splitNode_=function(node,offset){const afterNode=node.cloneNode(false);const textContent=node.textContent;node.textContent=hterm.TextAttributes.nodeSubstr(node,0,offset);afterNode.textContent=hterm.wc.substr(textContent,offset);if(afterNode.textContent){node.parentNode.insertBefore(afterNode,node.nextSibling)}if(!node.textContent){node.remove()}};hterm.Screen.prototype.maybeClipCurrentRow=function(){let width=hterm.TextAttributes.nodeWidth(lib.notNull(this.cursorRowNode_));if(width<=this.columnCount_){if(this.cursorPosition.column>=this.columnCount_){this.setCursorPosition(this.cursorPosition.row,this.columnCount_-1);this.cursorPosition.overflow=true}return}const currentColumn=this.cursorPosition.column;this.setCursorPosition(this.cursorPosition.row,this.columnCount_-1);width=hterm.TextAttributes.nodeWidth(lib.notNull(this.cursorNode_));if(this.cursorOffset_<width-1){this.cursorNode_.textContent=hterm.TextAttributes.nodeSubstr(this.cursorNode_,0,this.cursorOffset_+1)}const rowNode=this.cursorRowNode_;let node=this.cursorNode_.nextSibling;while(node){rowNode.removeChild(node);node=this.cursorNode_.nextSibling}if(currentColumn<this.columnCount_){this.setCursorPosition(this.cursorPosition.row,currentColumn)}else{this.cursorPosition.overflow=true}};hterm.Screen.prototype.insertString=function(str,wcwidth=undefined){let cursorNode=this.cursorNode_;let cursorNodeText=cursorNode.textContent;this.cursorRowNode_.removeAttribute("line-overflow");if(wcwidth===undefined){wcwidth=hterm.wc.strWidth(str)}this.cursorPosition.column+=wcwidth;let offset=this.cursorOffset_;let reverseOffset=hterm.TextAttributes.nodeWidth(cursorNode)-offset;if(reverseOffset<0){const ws=" ".repeat(-reverseOffset);if(!(this.textAttributes.underline||this.textAttributes.strikethrough||this.textAttributes.background||this.textAttributes.wcNode||!this.textAttributes.asciiNode||this.textAttributes.tileData!=null)){str=ws+str}else if(cursorNode.nodeType==Node.TEXT_NODE||!(cursorNode.wcNode||!cursorNode.asciiNode||cursorNode.tileNode||cursorNode.style.textDecoration||cursorNode.style.textDecorationStyle||cursorNode.style.textDecorationLine||cursorNode.style.backgroundColor)){cursorNode.textContent=cursorNodeText+=ws}else{const wsNode=cursorNode.ownerDocument.createTextNode(ws);this.cursorRowNode_.insertBefore(wsNode,cursorNode.nextSibling);this.cursorNode_=cursorNode=wsNode;this.cursorOffset_=offset=-reverseOffset;cursorNodeText=ws}reverseOffset=0}if(this.textAttributes.matchesContainer(cursorNode)){if(reverseOffset==0){cursorNode.textContent=cursorNodeText+str}else if(offset==0){cursorNode.textContent=str+cursorNodeText}else{cursorNode.textContent=hterm.TextAttributes.nodeSubstr(cursorNode,0,offset)+str+hterm.TextAttributes.nodeSubstr(cursorNode,offset)}this.cursorOffset_+=wcwidth;return}if(offset==0){const previousSibling=cursorNode.previousSibling;if(previousSibling&&this.textAttributes.matchesContainer(previousSibling)){previousSibling.textContent+=str;this.cursorNode_=previousSibling;this.cursorOffset_=hterm.wc.strWidth(previousSibling.textContent);return}const newNode=this.textAttributes.createContainer(str);this.cursorRowNode_.insertBefore(newNode,cursorNode);this.cursorNode_=newNode;this.cursorOffset_=wcwidth;return}if(reverseOffset==0){const nextSibling=cursorNode.nextSibling;if(nextSibling&&this.textAttributes.matchesContainer(nextSibling)){nextSibling.textContent=str+nextSibling.textContent;this.cursorNode_=nextSibling;this.cursorOffset_=hterm.wc.strWidth(str);return}const newNode=this.textAttributes.createContainer(str);this.cursorRowNode_.insertBefore(newNode,nextSibling);this.cursorNode_=newNode;this.cursorOffset_=hterm.TextAttributes.nodeWidth(newNode);return}this.splitNode_(cursorNode,offset);const newNode=this.textAttributes.createContainer(str);this.cursorRowNode_.insertBefore(newNode,cursorNode.nextSibling);this.cursorNode_=newNode;this.cursorOffset_=wcwidth};hterm.Screen.prototype.overwriteString=function(str,wcwidth=undefined){const maxLength=this.columnCount_-this.cursorPosition.column;if(!maxLength){return}if(wcwidth===undefined){wcwidth=hterm.wc.strWidth(str)}if(this.textAttributes.matchesContainer(lib.notNull(this.cursorNode_))&&this.cursorNode_.textContent.substr(this.cursorOffset_)==str){this.cursorOffset_+=wcwidth;this.cursorPosition.column+=wcwidth;return}this.deleteChars(Math.min(wcwidth,maxLength));this.insertString(str,wcwidth)};hterm.Screen.prototype.deleteChars=function(count){let node=this.cursorNode_;let offset=this.cursorOffset_;const currentCursorColumn=this.cursorPosition.column;count=Math.min(count,this.columnCount_-currentCursorColumn);if(!count){return 0}const rv=count;let startLength,endLength;while(node&&count){if(count<0){console.error(`Deleting ${rv} chars went negative: ${count}`);break}startLength=hterm.TextAttributes.nodeWidth(node);node.textContent=hterm.TextAttributes.nodeSubstr(node,0,offset)+hterm.TextAttributes.nodeSubstr(node,offset+count);endLength=hterm.TextAttributes.nodeWidth(node);if(node.wcNode&&offset<startLength&&(endLength&&startLength==endLength||!endLength&&offset==1)){const spaceNode=this.textAttributes.createContainer(" ");node.parentNode.insertBefore(spaceNode,offset?node:node.nextSibling);node.textContent="";endLength=0;count-=1}else{count-=startLength-endLength}const nextNode=node.nextSibling;if(endLength==0&&node!=this.cursorNode_){node.remove()}node=nextNode;offset=0}if(this.cursorNode_.nodeType!=Node.TEXT_NODE&&!this.cursorNode_.textContent){const cursorNode=this.cursorNode_;if(cursorNode.previousSibling){this.cursorNode_=cursorNode.previousSibling;this.cursorOffset_=hterm.TextAttributes.nodeWidth(cursorNode.previousSibling)}else if(cursorNode.nextSibling){this.cursorNode_=cursorNode.nextSibling;this.cursorOffset_=0}else{const emptyNode=this.cursorRowNode_.ownerDocument.createTextNode("");this.cursorRowNode_.appendChild(emptyNode);this.cursorNode_=emptyNode;this.cursorOffset_=0}this.cursorRowNode_.removeChild(cursorNode)}return rv};hterm.Screen.prototype.getLineStartRow_=function(row){while(row.previousSibling&&row.previousSibling.hasAttribute("line-overflow")){row=row.previousSibling}return row};hterm.Screen.prototype.getLineText_=function(row){let rowText="";let rowOrNull=row;while(rowOrNull){rowText+=rowOrNull.textContent;if(rowOrNull.hasAttribute("line-overflow")){rowOrNull=rowOrNull.nextSibling}else{break}}return rowText};hterm.Screen.prototype.getXRowAncestor_=function(node){let nodeOrNull=node;while(nodeOrNull){if(nodeOrNull.nodeName==="X-ROW"){break}nodeOrNull=nodeOrNull.parentNode}return nodeOrNull};hterm.Screen.prototype.getPositionWithOverflow_=function(row,node,offset){if(!node){return-1}const ancestorRow=this.getXRowAncestor_(node);if(!ancestorRow){return-1}let position=0;while(ancestorRow!=row){position+=hterm.TextAttributes.nodeWidth(row);if(row.hasAttribute("line-overflow")&&row.nextSibling){row=row.nextSibling}else{return-1}}return position+this.getPositionWithinRow_(row,node,offset)};hterm.Screen.prototype.getPositionWithinRow_=function(row,node,offset){if(node.parentNode!=row){if(node.parentNode==null){return-1}return this.getPositionWithinRow_(node.parentNode,node,offset)+this.getPositionWithinRow_(row,node.parentNode,0)}let position=0;for(let i=0;i<row.childNodes.length;i++){const currentNode=row.childNodes[i];if(currentNode==node){return position+offset}position+=hterm.TextAttributes.nodeWidth(currentNode)}return-1};hterm.Screen.prototype.getNodeAndOffsetWithOverflow_=function(row,position){while(row&&position>hterm.TextAttributes.nodeWidth(row)){if(row.hasAttribute("line-overflow")&&row.nextSibling){position-=hterm.TextAttributes.nodeWidth(row);row=row.nextSibling}else{return[null,-1]}}return this.getNodeAndOffsetWithinRow_(row,position)};hterm.Screen.prototype.getNodeAndOffsetWithinRow_=function(row,position){for(let i=0;i<row.childNodes.length;i++){const node=row.childNodes[i];const nodeTextWidth=hterm.TextAttributes.nodeWidth(node);if(position<=nodeTextWidth){if(node.nodeName==="SPAN"){return this.getNodeAndOffsetWithinRow_(node,position)}else{return[node,position]}}position-=nodeTextWidth}return null};hterm.Screen.prototype.setRange_=function(row,start,end,range){const startNodeAndOffset=this.getNodeAndOffsetWithOverflow_(row,start);if(startNodeAndOffset==null){return}const endNodeAndOffset=this.getNodeAndOffsetWithOverflow_(row,end);if(endNodeAndOffset==null){return}range.setStart(startNodeAndOffset[0],startNodeAndOffset[1]);range.setEnd(endNodeAndOffset[0],endNodeAndOffset[1])};hterm.Screen.prototype.expandSelectionWithWordBreakMatches_=function(selection,leftMatch,rightMatch,insideMatch){if(!selection){return}const range=selection.getRangeAt(0);if(!range||range.toString().match(/\s/)){return}const rowElement=this.getXRowAncestor_(lib.notNull(range.startContainer));if(!rowElement){return}const row=this.getLineStartRow_(rowElement);if(!row){return}const startPosition=this.getPositionWithOverflow_(row,lib.notNull(range.startContainer),range.startOffset);if(startPosition==-1){return}const endPosition=this.getPositionWithOverflow_(row,lib.notNull(range.endContainer),range.endOffset);if(endPosition==-1){return}const rowText=this.getLineText_(row);const lineUpToRange=hterm.wc.substring(rowText,0,endPosition);const leftRegularExpression=new RegExp(leftMatch+insideMatch+"$");const expandedStart=lineUpToRange.search(leftRegularExpression);if(expandedStart==-1||expandedStart>startPosition){return}const lineFromRange=hterm.wc.substring(rowText,startPosition,hterm.wc.strWidth(rowText));const rightRegularExpression=new RegExp("^"+insideMatch+rightMatch);const found=lineFromRange.match(rightRegularExpression);if(!found){return}const expandedEnd=startPosition+hterm.wc.strWidth(found[0]);if(expandedEnd==-1||expandedEnd<endPosition){return}this.setRange_(row,expandedStart,expandedEnd,range);selection.addRange(range)};hterm.Screen.prototype.expandSelection=function(selection){this.expandSelectionWithWordBreakMatches_(selection,lib.notNull(this.wordBreakMatchLeft),lib.notNull(this.wordBreakMatchRight),lib.notNull(this.wordBreakMatchMiddle))};hterm.Screen.prototype.expandSelectionForUrl=function(selection){this.expandSelectionWithWordBreakMatches_(selection,"[^\\s[\\](){}<>\"'^!@#$%&*,;:`‘“‹«]","[^\\s[\\](){}<>\"'^!@#$%&*,;:~.`’”›»]","[^\\s[\\](){}<>\"'^]*")};hterm.Screen.prototype.saveCursorAndState=function(vt){this.cursorState_.save(vt)};hterm.Screen.prototype.restoreCursorAndState=function(vt){this.cursorState_.restore(vt)};hterm.Screen.CursorState=function(screen){this.screen_=screen;this.cursor=null;this.textAttributes=null;this.GL=this.GR=this.G0=this.G1=this.G2=this.G3=null};hterm.Screen.CursorState.prototype.save=function(vt){this.cursor=vt.terminal.saveCursor();this.textAttributes=this.screen_.textAttributes.clone();this.GL=vt.GL;this.GR=vt.GR;this.G0=vt.G0;this.G1=vt.G1;this.G2=vt.G2;this.G3=vt.G3};hterm.Screen.CursorState.prototype.restore=function(vt){vt.terminal.restoreCursor(this.cursor);const tattrs=this.textAttributes.clone();tattrs.colorPaletteOverrides=this.screen_.textAttributes.colorPaletteOverrides;tattrs.syncColors();this.screen_.textAttributes=tattrs;vt.GL=this.GL;vt.GR=this.GR;vt.G0=this.G0;vt.G1=this.G1;vt.G2=this.G2;vt.G3=this.G3};hterm.RowProvider=function(){};hterm.RowProvider.prototype.getRowCount=function(){};hterm.RowProvider.prototype.getRowNode=function(index){};hterm.ScrollPort=function(rowProvider){hterm.PubSub.addBehavior(this);this.rowProvider_=rowProvider;this.characterSize=new hterm.Size(10,10);this.ruler_=null;this.selection=new hterm.ScrollPort.Selection(this);this.currentRowNodeCache_=null;this.previousRowNodeCache_={};this.lastScreenWidth_=0;this.lastScreenHeight_=0;this.selectionEnabled_=true;this.lastRowCount_=0;this.scrollWheelMultiplier_=1;this.lastTouch_={};this.screenPaddingSize=0;this.lineHeightPaddingSize=0;this.isScrolledEnd=true;this.currentScrollbarWidthPx=hterm.ScrollPort.DEFAULT_SCROLLBAR_WIDTH;this.ctrlVPaste=false;this.pasteOnDrop=true;this.div_=null;this.document_=null;this.screen_=null;this.timeouts_={};this.observers_={};this.ariaHiddenSelectionRows_=[];this.DEBUG_=false};hterm.ScrollPort.DEFAULT_SCROLLBAR_WIDTH=12;hterm.ScrollPort.Selection=function(scrollPort){this.scrollPort_=scrollPort;this.startRow=null;this.startNode=null;this.startOffset=0;this.endRow=null;this.endNode=null;this.endOffset=0;this.isMultiline=false;this.isCollapsed=true;this.autoScrollOnMouseMoveBound_=this.autoScrollOnMouseMove_.bind(this);this.autoScrollEnabled_=false;this.autoScrollDirection_=1;this.autoScrollInterval_=null;this.autoScrollDelta_=1};hterm.ScrollPort.Selection.prototype.findFirstChild=function(parent,childAry){let node=parent.firstChild;while(node){if(childAry.indexOf(node)!=-1){return node}if(node.childNodes.length){const rv=this.findFirstChild(node,childAry);if(rv){return rv}}node=node.nextSibling}return null};hterm.ScrollPort.Selection.prototype.autoScrollOnMouseMove_=function(e){const screenHeight=this.scrollPort_.lastScreenHeight_;this.autoScrollDirection_=e.pageY*2<screenHeight?-1:1;const padding=this.scrollPort_.screenPaddingSize;if(e.pageY<padding){this.startAutoScroll_()}else if(e.pageY<this.scrollPort_.visibleRowsHeight+padding){this.stopAutoScroll_()}else{this.startAutoScroll_()}};hterm.ScrollPort.Selection.prototype.setAutoScrollEnabled=function(enabled){this.autoScrollEnabled_=enabled;const doc=this.scrollPort_.getDocument();if(enabled){doc.addEventListener("mousemove",this.autoScrollOnMouseMoveBound_)}else{doc.removeEventListener("mousemove",this.autoScrollOnMouseMoveBound_);this.stopAutoScroll_()}};hterm.ScrollPort.Selection.prototype.autoScroll_=function(){this.autoScrollDelta_*=1.2;const delta=Math.floor(this.autoScrollDelta_)*this.autoScrollDirection_;this.scrollPort_.scrollRowToTop(this.scrollPort_.getTopRowIndex()+delta)};hterm.ScrollPort.Selection.prototype.startAutoScroll_=function(){if(this.autoScrollEnabled_&&this.autoScrollInterval_===null){this.autoScrollInterval_=setInterval(this.autoScroll_.bind(this),200)}};hterm.ScrollPort.Selection.prototype.stopAutoScroll_=function(){clearInterval(this.autoScrollInterval_);this.autoScrollInterval_=null;this.autoScrollDelta_=1};hterm.ScrollPort.Selection.prototype.sync=function(){const anchorFirst=()=>{this.startRow=anchorRow;this.startNode=selection.anchorNode;this.startOffset=selection.anchorOffset;this.endRow=focusRow;this.endNode=focusNode;this.endOffset=focusOffset};const focusFirst=()=>{this.startRow=focusRow;this.startNode=focusNode;this.startOffset=focusOffset;this.endRow=anchorRow;this.endNode=selection.anchorNode;this.endOffset=selection.anchorOffset};const selection=this.scrollPort_.getDocument().getSelection();const clear=()=>{this.startRow=null;this.startNode=null;this.startOffset=0;this.endRow=null;this.endNode=null;this.endOffset=0;this.isMultiline=false;this.isCollapsed=true};if(!selection){clear();return}this.isCollapsed=!selection||selection.isCollapsed;let anchorRow=selection.anchorNode;while(anchorRow&&anchorRow.nodeName!="X-ROW"){anchorRow=anchorRow.parentNode}if(!anchorRow){clear();return}let focusRow=selection.focusNode;let focusNode=focusRow;let focusOffset=selection.focusOffset;const focusIsStartOfTopRow=()=>{focusRow=this.scrollPort_.topFold_.nextSibling;focusNode=focusRow;focusOffset=0};const focusIsEndOfBottomRow=()=>{focusRow=this.scrollPort_.bottomFold_.previousSibling;focusNode=focusRow;while(focusNode.lastChild){focusNode=focusNode.lastChild}focusOffset=focusNode.length||0};if(focusRow===this.scrollPort_.topFold_){focusIsStartOfTopRow()}else if(focusRow===this.scrollPort_.bottomFold_){focusIsEndOfBottomRow()}while(focusRow&&focusRow.nodeName!="X-ROW"){focusRow=focusRow.parentNode}if(!focusRow){return}if(this.scrollPort_.autoScrollEnabled_){let node=this.scrollPort_.topFold_;while((node=node.previousSibling)!==null){if(node===focusRow){focusIsStartOfTopRow()}}node=this.scrollPort_.bottomFold_;while((node=node.nextSibling)!==null){if(node===focusRow){focusIsEndOfBottomRow()}}}if(anchorRow.rowIndex<focusRow.rowIndex){anchorFirst()}else if(anchorRow.rowIndex>focusRow.rowIndex){focusFirst()}else if(focusNode==selection.anchorNode){if(selection.anchorOffset<focusOffset){anchorFirst()}else{focusFirst()}}else{const firstNode=this.findFirstChild(anchorRow,[selection.anchorNode,focusNode]);if(!firstNode){throw new Error("Unexpected error syncing selection.")}if(firstNode==selection.anchorNode){anchorFirst()}else{focusFirst()}}this.isMultiline=anchorRow.rowIndex!=focusRow.rowIndex};hterm.ScrollPort.prototype.decorate=function(div,callback){this.div_=div;this.iframe_=div.ownerDocument.createElement("iframe");this.iframe_.style.cssText="border: 0;"+"height: 100%;"+"position: absolute;"+"width: 100%";div.appendChild(this.iframe_);const onLoad=()=>{this.paintIframeContents_();if(callback){callback()}};onLoad()};hterm.ScrollPort.prototype.paintIframeContents_=function(){this.iframe_.contentWindow.addEventListener("resize",this.onResize_.bind(this));const doc=this.document_=this.iframe_.contentDocument;doc.body.style.cssText="margin: 0px;"+"padding: 0px;"+"height: 100%;"+"width: 100%;"+"overflow: hidden;"+"cursor: var(--hterm-mouse-cursor-style);"+"user-select: none;";const metaCharset=doc.createElement("meta");metaCharset.setAttribute("charset","utf-8");doc.head.appendChild(metaCharset);if(this.DEBUG_){this.document_.body.style.paddingTop=this.document_.body.style.paddingBottom="calc(var(--hterm-charsize-height) * 3)"}const style=doc.createElement("style");style.textContent="x-row {"+"  display: block;"+"  height: var(--hterm-charsize-height);"+"  line-height: var(--hterm-charsize-height);"+"}";doc.head.appendChild(style);this.userCssLink_=doc.createElement("link");this.userCssLink_.setAttribute("rel","stylesheet");this.userCssText_=doc.createElement("style");doc.head.appendChild(this.userCssText_);this.screen_=doc.createElement("x-screen");this.screen_.setAttribute("contenteditable","true");this.screen_.setAttribute("spellcheck","false");this.screen_.setAttribute("autocomplete","off");this.screen_.setAttribute("autocorrect","off");this.screen_.setAttribute("autocapitalize","none");this.screen_.setAttribute("role","log");this.screen_.setAttribute("aria-live","off");this.screen_.setAttribute("aria-roledescription","Terminal");this.screen_.setAttribute("aria-readonly","true");this.screen_.setAttribute("tabindex","-1");this.screen_.style.cssText=`
      background-color: rgb(var(--hterm-background-color));
      caret-color: transparent;
      color: rgb(var(--hterm-foreground-color));
      display: block;
      font-family: monospace;
      font-size: 15px;
      font-variant-ligatures: none;
      height: 100%;
      overflow-y: scroll; overflow-x: hidden;
      white-space: pre;
      width: 100%;
      outline: none !important;
  `;const el=f=>f;this.screen_.addEventListener("scroll",el(this.onScroll_.bind(this)));this.screen_.addEventListener("wheel",el(this.onScrollWheel_.bind(this)));this.screen_.addEventListener("touchstart",el(this.onTouch_.bind(this)));this.screen_.addEventListener("touchmove",el(this.onTouch_.bind(this)));this.screen_.addEventListener("touchend",el(this.onTouch_.bind(this)));this.screen_.addEventListener("touchcancel",el(this.onTouch_.bind(this)));this.screen_.addEventListener("copy",el(this.onCopy_.bind(this)));this.screen_.addEventListener("paste",el(this.onPaste_.bind(this)));this.screen_.addEventListener("drop",el(this.onDragAndDrop_.bind(this)));doc.body.addEventListener("keydown",this.onBodyKeyDown_.bind(this));const a11yButtonHeight=30;const a11yButtonBorder=1;const a11yButtonTotalHeight=a11yButtonHeight+2*a11yButtonBorder;const a11yButtonStyle=`
    border-style: solid;
    border-width: ${a11yButtonBorder}px;
    color: rgb(var(--hterm-foreground-color));
    cursor: pointer;
    font-family: monospace;
    font-weight: bold;
    height: ${a11yButtonHeight}px;
    line-height: ${a11yButtonHeight}px;
    padding: 0 8px;
    position: fixed;
    right: var(--hterm-screen-padding-size);
    text-align: center;
    z-index: 1;
  `;this.scrollUpButton_=this.document_.createElement("div");this.scrollUpButton_.id="hterm:a11y:page-up";this.scrollUpButton_.innerText=hterm.msg("BUTTON_PAGE_UP",[],"Page up");this.scrollUpButton_.setAttribute("role","button");this.scrollUpButton_.style.cssText=a11yButtonStyle;this.scrollUpButton_.style.top=`${-a11yButtonTotalHeight}px`;this.scrollUpButton_.addEventListener("click",this.scrollPageUp.bind(this));this.scrollDownButton_=this.document_.createElement("div");this.scrollDownButton_.id="hterm:a11y:page-down";this.scrollDownButton_.innerText=hterm.msg("BUTTON_PAGE_DOWN",[],"Page down");this.scrollDownButton_.setAttribute("role","button");this.scrollDownButton_.style.cssText=a11yButtonStyle;this.scrollDownButton_.style.bottom=`${-a11yButtonTotalHeight}px`;this.scrollDownButton_.addEventListener("click",this.scrollPageDown.bind(this));this.optionsButton_=this.document_.createElement("div");this.optionsButton_.id="hterm:a11y:options";this.optionsButton_.innerText=hterm.msg("OPTIONS_BUTTON_LABEL",[],"Options");this.optionsButton_.setAttribute("role","button");this.optionsButton_.style.cssText=a11yButtonStyle;this.optionsButton_.style.bottom=`${-2*a11yButtonTotalHeight}px`;this.optionsButton_.addEventListener("click",this.publish.bind(this,"options"));doc.body.appendChild(this.scrollUpButton_);doc.body.appendChild(this.screen_);doc.body.appendChild(this.scrollDownButton_);doc.body.appendChild(this.optionsButton_);this.allowA11yButtonsToDisplay_=false;setTimeout(()=>{this.allowA11yButtonsToDisplay_=true},500);this.document_.addEventListener("selectionchange",()=>{this.selection.sync();if(!this.allowA11yButtonsToDisplay_){return}const accessibilityEnabled=this.accessibilityReader_&&this.accessibilityReader_.accessibilityEnabled;const selection=this.document_.getSelection();let selectedElement;if(selection.anchorNode&&selection.anchorNode.parentElement){selectedElement=selection.anchorNode.parentElement}if(accessibilityEnabled&&selectedElement==this.scrollUpButton_){this.scrollUpButton_.style.top=`${this.screenPaddingSize}px`}else{this.scrollUpButton_.style.top=`${-a11yButtonTotalHeight}px`}if(accessibilityEnabled&&selectedElement==this.scrollDownButton_){this.scrollDownButton_.style.bottom=`${this.screenPaddingSize}px`}else{this.scrollDownButton_.style.bottom=`${-a11yButtonTotalHeight}px`}if(accessibilityEnabled&&selectedElement==this.optionsButton_){this.optionsButton_.style.bottom=`${this.screenPaddingSize}px`}else{this.optionsButton_.style.bottom=`${-2*a11yButtonTotalHeight}px`}});this.rowNodes_=doc.createElement("div");this.rowNodes_.id="hterm:row-nodes";this.rowNodes_.style.cssText="display: block;"+"position: fixed;"+"overflow: hidden;"+"user-select: text;";this.screen_.appendChild(this.rowNodes_);this.topSelectBag_=doc.createElement("x-select-bag");this.topSelectBag_.style.cssText="display: block;"+"overflow: hidden;"+"height: var(--hterm-charsize-height);"+"white-space: pre;";this.bottomSelectBag_=this.topSelectBag_.cloneNode();this.topFold_=doc.createElement("x-fold");this.topFold_.id="hterm:top-fold-for-row-selection";this.topFold_.style.cssText=`
    display: block;
    height: var(--hterm-screen-padding-size);
  `;this.rowNodes_.appendChild(this.topFold_);this.bottomFold_=this.topFold_.cloneNode();this.bottomFold_.id="hterm:bottom-fold-for-row-selection";this.rowNodes_.appendChild(this.bottomFold_);this.scrollArea_=doc.createElement("div");this.scrollArea_.id="hterm:scrollarea";this.scrollArea_.style.cssText="visibility: hidden";this.screen_.appendChild(this.scrollArea_);this.pasteTarget_=doc.createElement("textarea");this.pasteTarget_.id="hterm:ctrl-v-paste-target";this.pasteTarget_.setAttribute("tabindex","-1");this.pasteTarget_.setAttribute("aria-hidden","true");this.pasteTarget_.style.cssText="position: absolute;"+"height: 1px;"+"width: 1px;"+"left: 0px; "+"bottom: 0px;"+"opacity: 0";this.pasteTarget_.contentEditable=true;this.screen_.appendChild(this.pasteTarget_);this.pasteTarget_.addEventListener("textInput",this.handlePasteTargetTextInput_.bind(this));this.resize()};hterm.ScrollPort.prototype.setAccessibilityReader=function(accessibilityReader){this.accessibilityReader_=accessibilityReader};hterm.ScrollPort.prototype.scrollPageUp=function(){if(this.getTopRowIndex()==0){return}const i=this.getTopRowIndex();this.scrollRowToTop(i-this.visibleRowCount+1);this.assertiveAnnounce_()};hterm.ScrollPort.prototype.scrollPageDown=function(){if(this.isScrolledEnd){return}const i=this.getTopRowIndex();this.scrollRowToTop(i+this.visibleRowCount-1);this.assertiveAnnounce_()};hterm.ScrollPort.prototype.setFontFamily=function(fontFamily,smoothing=""){this.screen_.style.fontFamily=fontFamily;this.screen_.style.webkitFontSmoothing=smoothing;this.syncCharacterSize()};hterm.ScrollPort.prototype.getFontFamily=function(){return this.screen_.style.fontFamily};hterm.ScrollPort.prototype.setUserCssUrl=function(url){if(url){this.userCssLink_.setAttribute("href",url);if(!this.userCssLink_.parentNode){this.document_.head.appendChild(this.userCssLink_)}}else if(this.userCssLink_.parentNode){this.document_.head.removeChild(this.userCssLink_)}};hterm.ScrollPort.prototype.setUserCssText=function(text){this.userCssText_.textContent=text};hterm.ScrollPort.prototype.focus=function(){this.iframe_.focus();this.screen_.focus();this.publish("focus")};hterm.ScrollPort.prototype.blur=function(){this.screen_.blur()};hterm.ScrollPort.prototype.setBackgroundImage=function(image){this.screen_.style.backgroundImage=image};hterm.ScrollPort.prototype.setBackgroundSize=function(size){this.screen_.style.backgroundSize=size};hterm.ScrollPort.prototype.setBackgroundPosition=function(position){this.screen_.style.backgroundPosition=position};hterm.ScrollPort.prototype.setScreenPaddingSize=function(size){this.screenPaddingSize=size;this.resize()};hterm.ScrollPort.prototype.setLineHeightPaddingSize=function(size){this.lineHeightPaddingSize=size;this.syncCharacterSize()};hterm.ScrollPort.prototype.setCtrlVPaste=function(ctrlVPaste){this.ctrlVPaste=ctrlVPaste};hterm.ScrollPort.prototype.setPasteOnDrop=function(pasteOnDrop){this.pasteOnDrop=pasteOnDrop};hterm.ScrollPort.prototype.getScreenSize=function(){const size=this.screen_.getBoundingClientRect();const rightPadding=Math.max(this.screenPaddingSize,this.currentScrollbarWidthPx);return{height:size.height-2*this.screenPaddingSize,width:size.width-this.screenPaddingSize-rightPadding}};hterm.ScrollPort.prototype.getScreenWidth=function(){return this.getScreenSize().width};hterm.ScrollPort.prototype.getScreenHeight=function(){return this.getScreenSize().height};hterm.ScrollPort.prototype.getScrollbarX=function(){return this.screen_.getBoundingClientRect().width-this.currentScrollbarWidthPx};hterm.ScrollPort.prototype.getDocument=function(){return this.document_};hterm.ScrollPort.prototype.getScreenNode=function(){return this.screen_};hterm.ScrollPort.prototype.resetCache=function(){this.currentRowNodeCache_=null;this.previousRowNodeCache_={}};hterm.ScrollPort.prototype.setRowProvider=function(rowProvider){this.resetCache();this.rowProvider_=rowProvider;this.scheduleRedraw()};hterm.ScrollPort.prototype.invalidate=function(){let node=this.topFold_.nextSibling;while(node!=this.bottomFold_){const nextSibling=node.nextSibling;node.remove();node=nextSibling}this.previousRowNodeCache_=null;const topRowIndex=this.getTopRowIndex();const bottomRowIndex=this.getBottomRowIndex(topRowIndex);this.drawVisibleRows_(topRowIndex,bottomRowIndex)};hterm.ScrollPort.prototype.scheduleInvalidate=function(){if(this.timeouts_.invalidate){return}this.timeouts_.invalidate=setTimeout(()=>{delete this.timeouts_.invalidate;this.invalidate()})};hterm.ScrollPort.prototype.setFontSize=function(px){this.screen_.style.fontSize=px+"px";this.syncCharacterSize()};hterm.ScrollPort.prototype.getFontSize=function(){return parseInt(this.screen_.style.fontSize,10)};hterm.ScrollPort.prototype.measureCharacterSize=function(weight=""){let ruler=this.ruler_;if(!ruler){ruler=this.ruler_=this.document_.createElement("canvas")}const context=ruler.getContext("2d");context.font=`${weight} ${this.getFontSize()}px ${this.getFontFamily()}`;const heightBox=context.measureText("X█");const ascent=heightBox.actualBoundingBoxAscent||heightBox.fontBoundingBoxAscent;const descent=heightBox.actualBoundingBoxDescent||heightBox.fontBoundingBoxDescent;const widthBox=context.measureText("X");return new hterm.Size(widthBox.width,ascent+descent+this.lineHeightPaddingSize)};hterm.ScrollPort.prototype.syncCharacterSize=function(){this.characterSize=this.measureCharacterSize();this.resize()};hterm.ScrollPort.prototype.resize=function(){this.syncScrollbarWidth_();this.syncScrollHeight();this.syncRowNodesDimensions_();this.publish("resize",{scrollPort:this},()=>this.scheduleRedraw())};hterm.ScrollPort.prototype.assertiveAnnounce_=function(){if(!this.accessibilityReader_){return}const topRow=this.getTopRowIndex();const bottomRow=this.getBottomRowIndex(topRow);let percentScrolled=100*topRow/Math.max(1,this.rowProvider_.getRowCount()-this.visibleRowCount);percentScrolled=Math.min(100,Math.round(percentScrolled));let currentScreenContent=hterm.msg("ANNOUNCE_CURRENT_SCREEN_HEADER",[percentScrolled],"$1% scrolled,");currentScreenContent+="\n";for(let i=topRow;i<=bottomRow;++i){const node=this.fetchRowNode_(i);currentScreenContent+=node.textContent+"\n"}this.accessibilityReader_.assertiveAnnounce(currentScreenContent)};hterm.ScrollPort.prototype.syncRowNodesDimensions_=function(){const screenSize=this.getScreenSize();this.lastScreenWidth_=screenSize.width;this.lastScreenHeight_=screenSize.height;this.visibleRowCount=lib.f.smartFloorDivide(screenSize.height,this.characterSize.height);this.visibleRowsHeight=this.visibleRowCount*this.characterSize.height;this.visibleRowTopMargin=0;this.visibleRowBottomMargin=screenSize.height-this.visibleRowsHeight;this.topFold_.style.marginBottom=this.visibleRowTopMargin+"px";let topFoldOffset=0;let node=this.topFold_.previousSibling;while(node){topFoldOffset+=node.getBoundingClientRect().height;node=node.previousSibling}this.rowNodes_.style.width=screenSize.width+"px";this.rowNodes_.style.height=this.visibleRowsHeight+topFoldOffset+this.screenPaddingSize+"px";this.rowNodes_.style.left=this.screen_.offsetLeft+this.screenPaddingSize+"px";this.rowNodes_.style.top=this.screen_.offsetTop-topFoldOffset+"px"};hterm.ScrollPort.prototype.syncScrollbarWidth_=function(){const width=this.screen_.getBoundingClientRect().width-this.screen_.clientWidth;if(width>0){this.currentScrollbarWidthPx=width}};hterm.ScrollPort.prototype.syncScrollHeight=function(){this.lastRowCount_=this.rowProvider_.getRowCount();this.scrollArea_.style.height=this.characterSize.height*this.lastRowCount_+2*this.screenPaddingSize+this.visibleRowTopMargin+this.visibleRowBottomMargin+"px"};hterm.ScrollPort.prototype.scheduleRedraw=function(){if(this.timeouts_.redraw){return}this.timeouts_.redraw=setTimeout(()=>{delete this.timeouts_.redraw;this.redraw_()})};hterm.ScrollPort.prototype.updateScrollButtonState_=function(){const setButton=(button,disabled)=>{button.setAttribute("aria-disabled",disabled?"true":"false");button.style.opacity=disabled?.5:1};setButton(this.scrollUpButton_,this.getTopRowIndex()==0);setButton(this.scrollDownButton_,this.isScrolledEnd)};hterm.ScrollPort.prototype.redraw_=function(){this.resetSelectBags_();this.selection.sync();this.syncScrollHeight();this.currentRowNodeCache_={};const topRowIndex=this.getTopRowIndex();const bottomRowIndex=this.getBottomRowIndex(topRowIndex);this.drawTopFold_(topRowIndex);this.drawBottomFold_(bottomRowIndex);this.drawVisibleRows_(topRowIndex,bottomRowIndex);this.ariaHideOffscreenSelectionRows_(topRowIndex,bottomRowIndex);this.syncRowNodesDimensions_();this.previousRowNodeCache_=this.currentRowNodeCache_;this.currentRowNodeCache_=null;this.isScrolledEnd=this.getTopRowIndex()+this.visibleRowCount>=this.lastRowCount_;this.updateScrollButtonState_()};hterm.ScrollPort.prototype.drawTopFold_=function(topRowIndex){if(!this.selection.startRow||this.selection.startRow.rowIndex>=topRowIndex){if(this.rowNodes_.firstChild!=this.topFold_){this.rowNodes_.insertBefore(this.topFold_,this.rowNodes_.firstChild)}return}if(!this.selection.isMultiline||this.selection.endRow.rowIndex>=topRowIndex){if(this.selection.startRow.nextSibling!=this.topFold_){this.rowNodes_.insertBefore(this.topFold_,this.selection.startRow.nextSibling)}}else{if(this.selection.endRow.nextSibling!=this.topFold_){this.rowNodes_.insertBefore(this.topFold_,this.selection.endRow.nextSibling)}while(this.selection.startRow.nextSibling!=this.selection.endRow){this.rowNodes_.removeChild(this.selection.startRow.nextSibling)}}while(this.rowNodes_.firstChild!=this.selection.startRow){this.rowNodes_.removeChild(this.rowNodes_.firstChild)}};hterm.ScrollPort.prototype.drawBottomFold_=function(bottomRowIndex){if(!this.selection.endRow||this.selection.endRow.rowIndex<=bottomRowIndex){if(this.rowNodes_.lastChild!=this.bottomFold_){this.rowNodes_.appendChild(this.bottomFold_)}return}if(!this.selection.isMultiline||this.selection.startRow.rowIndex<=bottomRowIndex){if(this.bottomFold_.nextSibling!=this.selection.endRow){this.rowNodes_.insertBefore(this.bottomFold_,this.selection.endRow)}}else{if(this.bottomFold_.nextSibling!=this.selection.startRow){this.rowNodes_.insertBefore(this.bottomFold_,this.selection.startRow)}while(this.selection.startRow.nextSibling!=this.selection.endRow){this.rowNodes_.removeChild(this.selection.startRow.nextSibling)}}while(this.rowNodes_.lastChild!=this.selection.endRow){this.rowNodes_.removeChild(this.rowNodes_.lastChild)}};hterm.ScrollPort.prototype.drawVisibleRows_=function(topRowIndex,bottomRowIndex){const removeUntilNode=(currentNode,targetNode)=>{while(currentNode!=targetNode){if(!currentNode){throw new Error("Did not encounter target node")}if(currentNode==this.bottomFold_){throw new Error("Encountered bottom fold before target node")}const deadNode=currentNode;currentNode=currentNode.nextSibling;deadNode.remove()}};const selectionStartRow=this.selection.startRow;const selectionEndRow=this.selection.endRow;const bottomFold=this.bottomFold_;let node=this.topFold_.nextSibling;const targetDrawCount=Math.min(this.visibleRowCount,this.rowProvider_.getRowCount());for(let drawCount=0;drawCount<targetDrawCount;drawCount++){const rowIndex=topRowIndex+drawCount;if(node==bottomFold){const newNode=this.fetchRowNode_(rowIndex);if(!newNode){console.log("Couldn't fetch row index: "+rowIndex);break}this.rowNodes_.insertBefore(newNode,node);continue}if(node.rowIndex==rowIndex){node=node.nextSibling;continue}if(selectionStartRow&&selectionStartRow.rowIndex==rowIndex){removeUntilNode(node,selectionStartRow);node=selectionStartRow.nextSibling;continue}if(selectionEndRow&&selectionEndRow.rowIndex==rowIndex){removeUntilNode(node,selectionEndRow);node=selectionEndRow.nextSibling;continue}if(node==selectionStartRow||node==selectionEndRow){const newNode=this.fetchRowNode_(rowIndex);if(!newNode){console.log("Couldn't fetch row index: "+rowIndex);break}this.rowNodes_.insertBefore(newNode,node);continue}const newNode=this.fetchRowNode_(rowIndex);if(!newNode){console.log("Couldn't fetch row index: "+rowIndex);break}if(node==newNode){node=node.nextSibling;continue}this.rowNodes_.insertBefore(newNode,node);this.rowNodes_.removeChild(node);node=newNode.nextSibling}if(node!=this.bottomFold_){removeUntilNode(node,bottomFold)}};hterm.ScrollPort.prototype.ariaHideOffscreenSelectionRows_=function(topRowIndex,bottomRowIndex){const hiddenRows=this.ariaHiddenSelectionRows_;let row;while(row=hiddenRows.pop()){row.removeAttribute("aria-hidden")}function checkRow(row){if(row&&(row.rowIndex<topRowIndex||row.rowIndex>bottomRowIndex)){row.setAttribute("aria-hidden","true");hiddenRows.push(row)}}checkRow(this.selection.startRow);checkRow(this.selection.endRow)};hterm.ScrollPort.prototype.resetSelectBags_=function(){if(this.topSelectBag_.parentNode){this.topSelectBag_.textContent="";this.topSelectBag_.remove()}if(this.bottomSelectBag_.parentNode){this.bottomSelectBag_.textContent="";this.bottomSelectBag_.remove()}};hterm.ScrollPort.prototype.cacheRowNode_=function(rowNode){this.currentRowNodeCache_[rowNode.rowIndex]=rowNode};hterm.ScrollPort.prototype.fetchRowNode_=function(rowIndex){let node;if(this.previousRowNodeCache_&&rowIndex in this.previousRowNodeCache_){node=this.previousRowNodeCache_[rowIndex]}else{node=this.rowProvider_.getRowNode(rowIndex)}if(this.currentRowNodeCache_){this.cacheRowNode_(node)}return node};hterm.ScrollPort.prototype.selectAll=function(){let firstRow;if(this.topFold_.nextSibling.rowIndex!=0){while(this.topFold_.previousSibling){this.topFold_.previousSibling.remove()}firstRow=this.fetchRowNode_(0);this.rowNodes_.insertBefore(firstRow,this.topFold_);this.syncRowNodesDimensions_()}else{firstRow=this.topFold_.nextSibling}const lastRowIndex=this.rowProvider_.getRowCount()-1;let lastRow;if(this.bottomFold_.previousSibling.rowIndex!=lastRowIndex){while(this.bottomFold_.nextSibling){this.bottomFold_.nextSibling.remove()}lastRow=this.fetchRowNode_(lastRowIndex);this.rowNodes_.appendChild(lastRow)}else{lastRow=this.bottomFold_.previousSibling}let focusNode=lastRow;while(focusNode.lastChild){focusNode=focusNode.lastChild}const selection=this.document_.getSelection();selection.collapse(firstRow,0);selection.extend(focusNode,focusNode.length||0);this.selection.sync()};hterm.ScrollPort.prototype.getScrollMax_=function(){return this.scrollArea_.getBoundingClientRect().height+this.visibleRowTopMargin+this.visibleRowBottomMargin-this.screen_.getBoundingClientRect().height};hterm.ScrollPort.prototype.scrollRowToTop=function(rowIndex){if(rowIndex<0){rowIndex=0}this.syncScrollHeight();this.isScrolledEnd=rowIndex+this.visibleRowCount>=this.lastRowCount_;let scrollTop=rowIndex*this.characterSize.height+this.visibleRowTopMargin;const scrollMax=this.getScrollMax_();if(scrollTop>scrollMax){scrollTop=scrollMax}if(this.screen_.scrollTop==scrollTop){return}this.screen_.scrollTop=scrollTop;this.scheduleRedraw()};hterm.ScrollPort.prototype.scrollRowToBottom=function(rowIndex){this.scrollRowToTop(rowIndex-this.visibleRowCount)};hterm.ScrollPort.prototype.scrollRowToMiddle=function(rowIndex){this.scrollRowToTop(rowIndex-Math.floor(this.visibleRowCount/2))};hterm.ScrollPort.prototype.getTopRowIndex=function(){return Math.round(this.screen_.scrollTop/this.characterSize.height)};hterm.ScrollPort.prototype.getBottomRowIndex=function(topRowIndex){return topRowIndex+this.visibleRowCount-1};hterm.ScrollPort.prototype.onScroll_=function(e){const screenSize=this.getScreenSize();if(screenSize.width!=this.lastScreenWidth_||screenSize.height!=this.lastScreenHeight_){this.resize();return}this.redraw_();this.publish("scroll",{scrollPort:this})};hterm.ScrollPort.prototype.onScrollWheel=function(e){};hterm.ScrollPort.prototype.onScrollWheel_=function(e){this.onScrollWheel(e);if(e.defaultPrevented){return}const delta=this.scrollWheelDelta(e);let top=this.screen_.scrollTop-delta.y;if(top<0){top=0}const scrollMax=this.getScrollMax_();if(top>scrollMax){top=scrollMax}if(top!=this.screen_.scrollTop){this.screen_.scrollTop=top;e.preventDefault()}else if(e.ctrlKey){e.preventDefault()}};hterm.ScrollPort.prototype.scrollWheelDelta=function(e){const delta={x:0,y:0};switch(e.deltaMode){case WheelEvent.DOM_DELTA_PIXEL:delta.x=e.deltaX*this.scrollWheelMultiplier_;delta.y=e.deltaY*this.scrollWheelMultiplier_;break;case WheelEvent.DOM_DELTA_LINE:delta.x=e.deltaX*this.characterSize.width;delta.y=e.deltaY*this.characterSize.height;break;case WheelEvent.DOM_DELTA_PAGE:{const{width,height}=this.screen_.getBoundingClientRect();delta.x=e.deltaX*this.characterSize.width*width;delta.y=e.deltaY*this.characterSize.height*height;break}}delta.y*=-1;return delta};hterm.ScrollPort.prototype.onTouch=function(e){};hterm.ScrollPort.prototype.onTouch_=function(e){this.onTouch(e);if(e.defaultPrevented){return}const scrubTouch=function(t){return{id:t.identifier,y:t.clientY,x:t.clientX}};let i,touch;switch(e.type){case"touchstart":if(hterm.os=="cros"&&globalThis.chrome?.windows?.getCurrent){chrome.windows.getCurrent(win=>{if(!win.focused){chrome.windows.update(win.id,{focused:true})}})}for(i=0;i<e.changedTouches.length;++i){touch=scrubTouch(e.changedTouches[i]);this.lastTouch_[touch.id]=touch}break;case"touchcancel":case"touchend":for(i=0;i<e.changedTouches.length;++i){delete this.lastTouch_[e.changedTouches[i].identifier]}break;case"touchmove":{let delta=0;for(i=0;i<e.changedTouches.length;++i){touch=scrubTouch(e.changedTouches[i]);delta+=this.lastTouch_[touch.id].y-touch.y;this.lastTouch_[touch.id]=touch}delta*=-1;let top=this.screen_.scrollTop-delta;if(top<0){top=0}const scrollMax=this.getScrollMax_();if(top>scrollMax){top=scrollMax}if(top!=this.screen_.scrollTop){this.screen_.scrollTop=top}break}}e.preventDefault()};hterm.ScrollPort.prototype.onResize_=function(e){this.syncCharacterSize()};hterm.ScrollPort.prototype.onCopy=function(e){};hterm.ScrollPort.prototype.onCopy_=function(e){this.onCopy(e);if(e.defaultPrevented){return}this.resetSelectBags_();this.selection.sync();if(this.selection.isCollapsed||this.selection.endRow.rowIndex-this.selection.startRow.rowIndex<2){return}const topRowIndex=this.getTopRowIndex();const bottomRowIndex=this.getBottomRowIndex(topRowIndex);if(this.selection.startRow.rowIndex<topRowIndex){let endBackfillIndex;if(this.selection.endRow.rowIndex<topRowIndex){endBackfillIndex=this.selection.endRow.rowIndex}else{endBackfillIndex=this.topFold_.nextSibling.rowIndex}this.topSelectBag_.textContent=this.rowProvider_.getRowsText(this.selection.startRow.rowIndex+1,endBackfillIndex);this.rowNodes_.insertBefore(this.topSelectBag_,this.selection.startRow.nextSibling);this.syncRowNodesDimensions_()}if(this.selection.endRow.rowIndex>bottomRowIndex){let startBackfillIndex;if(this.selection.startRow.rowIndex>bottomRowIndex){startBackfillIndex=this.selection.startRow.rowIndex+1}else{startBackfillIndex=this.bottomFold_.previousSibling.rowIndex+1}this.bottomSelectBag_.textContent=this.rowProvider_.getRowsText(startBackfillIndex,this.selection.endRow.rowIndex);this.rowNodes_.insertBefore(this.bottomSelectBag_,this.selection.endRow)}};hterm.ScrollPort.prototype.onBodyKeyDown_=function(e){if(!this.ctrlVPaste){return}if((e.ctrlKey||e.metaKey)&&e.keyCode==86){this.pasteTarget_.focus()}};hterm.ScrollPort.prototype.onPaste_=function(e){this.pasteTarget_.focus();setTimeout(()=>{this.publish("paste",{text:this.pasteTarget_.value});this.pasteTarget_.value="";this.focus()})};hterm.ScrollPort.prototype.handlePasteTargetTextInput_=function(e){e.stopPropagation()};hterm.ScrollPort.prototype.onDragAndDrop_=function(e){if(!this.pasteOnDrop){return}e.preventDefault();let data;let format;if(e.shiftKey){e.dataTransfer.types.forEach(t=>{if(!format&&t!="text/plain"&&t.startsWith("text/")){format=t}});if(format){data=e.dataTransfer.getData(format)}}if(!data){data=e.dataTransfer.getData("text/plain")}if(data){this.publish("paste",{text:data})}};hterm.ScrollPort.prototype.setScrollbarVisible=function(state){if(state){this.screen_.style.overflowY="scroll";this.currentScrollbarWidthPx=hterm.ScrollPort.DEFAULT_SCROLLBAR_WIDTH;this.syncScrollbarWidth_()}else{this.screen_.style.overflowY="hidden";this.currentScrollbarWidthPx=0}};hterm.ScrollPort.prototype.setScrollWheelMoveMultipler=function(multiplier){this.scrollWheelMultiplier_=multiplier};hterm.Terminal=function({profileId,storage}={}){this.ready_=false;this.profileId_=null;this.storage_=storage||new lib.Storage.Local;this.prefs_=null;this.primaryScreen_=new hterm.Screen;this.alternateScreen_=new hterm.Screen;this.screen_=this.primaryScreen_;this.screenSize=new hterm.Size(0,0);this.scrollPort_=new hterm.ScrollPort(this);this.scrollPort_.subscribe("resize",this.onResize_.bind(this));this.scrollPort_.subscribe("scroll",this.onScroll_.bind(this));this.scrollPort_.subscribe("paste",this.onPaste_.bind(this));this.scrollPort_.subscribe("focus",this.onScrollportFocus_.bind(this));this.scrollPort_.subscribe("options",this.onOpenOptionsPage_.bind(this));this.scrollPort_.onCopy=this.onCopy_.bind(this);this.div_=null;this.notifications_=null;this.document_=globalThis.document;this.scrollbackRows_=[];this.tabStops_=[];this.defaultTabStops=true;this.vtScrollTop_=null;this.vtScrollBottom_=null;this.cursorNode_=null;this.cursorShape_=hterm.Terminal.cursorShape.BLOCK;this.cursorBlinkCycle_=[100,100];this.cursorBlinkPause_=false;this.cursorOffScreen_=false;this.myOnCursorBlink_=this.onCursorBlink_.bind(this);this.backgroundColor_=null;this.foregroundColor_=null;this.colorPaletteOverrides_=new Map;this.screenBorderSize_=0;this.scrollOnOutput_=null;this.scrollOnKeystroke_=null;this.scrollWheelArrowKeys_=null;this.defeatMouseReports_=false;this.setAutomaticMouseHiding();this.mouseHideDelay_=null;this.bellAudio_=this.document_.createElement("audio");this.bellAudio_.id="hterm:bell-audio";this.bellAudio_.setAttribute("preload","auto");this.accessibilityReader_=null;this.contextMenu=new hterm.ContextMenu;this.bellNotificationList_=[];this.bellSquelchTimeout_=null;this.desktopNotificationBell_=false;this.savedOptions_={};this.options_=new hterm.Options;this.timeouts_={};this.vt=new hterm.VT(this);this.saveCursorAndState(true);this.keyboard=new hterm.Keyboard(this);this.io=new hterm.Terminal.IO(this);this.enableMouseDragScroll=true;this.copyOnSelect=null;this.mouseRightClickPaste=null;this.mousePasteButton=null;this.useDefaultWindowCopy=false;this.clearSelectionAfterCopy=true;this.realizeSize_(80,24);this.setDefaultTabStops();this.allowImagesInline=null;this.reportFocus=false;this.alwaysUseLegacyPasting=false;this.setProfile(profileId||hterm.Terminal.DEFAULT_PROFILE_ID,()=>{hterm.initPromise.then(()=>this.onTerminalReady())});this.findBar=new hterm.FindBar(this)};hterm.Terminal.DEFAULT_PROFILE_ID="default";hterm.Terminal.cursorShape={BLOCK:"BLOCK",BEAM:"BEAM",UNDERLINE:"UNDERLINE"};hterm.Terminal.prototype.onTerminalReady=function(){};hterm.Terminal.prototype.tabWidth=8;hterm.Terminal.prototype.setProfile=function(profileId,callback=undefined){profileId=profileId.replace(/\//g,"");if(this.profileId_===profileId){if(callback){callback()}return}this.profileId_=profileId;if(this.prefs_){this.prefs_.setProfile(profileId,callback);return}this.prefs_=new hterm.PreferenceManager(this.storage_,this.profileId_);const loadKeyBindings=(bindings=null,useOsDefaults=false)=>{this.keyboard.bindings.clear();if(bindings===null){bindings={}}if(!(bindings instanceof Object)){console.error("Error in keybindings preference: Expected object");bindings={}}try{this.keyboard.bindings.addBindings(bindings,!!useOsDefaults)}catch(ex){console.error("Error in keybindings preference: "+ex)}};this.prefs_.addObservers(null,{"alt-gr-mode":v=>{if(v==null){if(navigator.language.toLowerCase()=="en-us"){v="none"}else{v="right-alt"}}else if(typeof v=="string"){v=v.toLowerCase()}else{v="none"}if(!/^(none|ctrl-alt|left-alt|right-alt)$/.test(v)){v="none"}this.keyboard.altGrMode=v},"alt-backspace-is-meta-backspace":v=>{this.keyboard.altBackspaceIsMetaBackspace=v},"alt-is-meta":v=>{this.keyboard.altIsMeta=v},"alt-sends-what":v=>{if(!/^(escape|8-bit|browser-key)$/.test(v)){v="escape"}this.keyboard.altSendsWhat=v},"audible-bell-sound":v=>{const ary=v.match(/^lib-resource:(\S+)/);if(ary){const name=ary[1];if(lib.resource.get(name)===undefined){console.warn(`Invalid resource name '${name}'`);this.prefs_.reset("audible-bell-sound");return}this.bellAudio_.setAttribute("src",lib.resource.getDataUrl(name))}else{this.bellAudio_.setAttribute("src",v)}},"desktop-notification-bell":v=>{if(v&&Notification){this.desktopNotificationBell_=Notification.permission==="granted";if(!this.desktopNotificationBell_){console.warn("desktop-notification-bell is true but we do not have "+"permission to display notifications.")}}else{this.desktopNotificationBell_=false}},"background-color":v=>{this.setBackgroundColor(v)},"background-image":v=>{this.scrollPort_.setBackgroundImage(v)},"background-size":v=>{this.scrollPort_.setBackgroundSize(v)},"background-position":v=>{this.scrollPort_.setBackgroundPosition(v)},"backspace-sends-backspace":v=>{this.keyboard.backspaceSendsBackspace=v},"character-map-overrides":v=>{if(!(v==null||v instanceof Object)){console.warn("Preference character-map-modifications is not an "+"object: "+v);return}this.vt.characterMaps.reset();this.vt.characterMaps.setOverrides(v)},"cursor-blink":v=>{this.setCursorBlink(!!v)},"cursor-shape":v=>{this.setCursorShape(v)},"cursor-blink-cycle":v=>{if(v instanceof Array&&typeof v[0]=="number"&&typeof v[1]=="number"){this.cursorBlinkCycle_=v}else if(typeof v=="number"){this.cursorBlinkCycle_=[v,v]}else{this.cursorBlinkCycle_=[100,100]}},"cursor-color":v=>{this.setCursorColor(v)},"color-palette-overrides":v=>{if(!(v==null||v instanceof Object||v instanceof Array)){console.warn("Preference color-palette-overrides is not an array or "+"object: "+v);return}lib.colors.stockPalette.forEach((c,i)=>this.setColorPalette(i,c));this.colorPaletteOverrides_.clear();if(v){for(const key in v){const i=parseInt(key,10);if(isNaN(i)||i<0||i>255){console.log("Invalid value in palette: "+key+": "+v[key]);continue}if(v[i]){const rgb=lib.colors.normalizeCSS(v[i]);if(rgb){this.setColorPalette(i,rgb);this.colorPaletteOverrides_.set(i,rgb)}}}}this.primaryScreen_.textAttributes.colorPaletteOverrides=[];this.alternateScreen_.textAttributes.colorPaletteOverrides=[]},"copy-on-select":v=>{this.copyOnSelect=!!v},"use-default-window-copy":v=>{this.useDefaultWindowCopy=!!v},"clear-selection-after-copy":v=>{this.clearSelectionAfterCopy=!!v},"ctrl-plus-minus-zero-zoom":v=>{this.keyboard.ctrlPlusMinusZeroZoom=v},"ctrl-c-copy":v=>{this.keyboard.ctrlCCopy=v},"ctrl-v-paste":v=>{this.keyboard.ctrlVPaste=v;this.scrollPort_.setCtrlVPaste(v)},"paste-on-drop":v=>{this.scrollPort_.setPasteOnDrop(v)},"east-asian-ambiguous-as-two-column":v=>{hterm.wc.regardCjkAmbiguous=v},"enable-8-bit-control":v=>{this.vt.enable8BitControl=!!v},"enable-bold":v=>{this.syncBoldSafeState()},"enable-bold-as-bright":v=>{this.primaryScreen_.textAttributes.enableBoldAsBright=!!v;this.alternateScreen_.textAttributes.enableBoldAsBright=!!v},"enable-blink":v=>{this.setTextBlink(!!v)},"enable-clipboard-write":v=>{this.vt.enableClipboardWrite=!!v},"enable-dec12":v=>{this.vt.enableDec12=!!v},"enable-csi-j-3":v=>{this.vt.enableCsiJ3=!!v},"find-result-color":v=>{this.findBar.setFindResultColor(v)},"find-result-selected-color":v=>{this.findBar.setFindResultSelectedColor(v)},"font-family":v=>{this.syncFontFamily()},"font-size":v=>{v=parseInt(v,10);if(isNaN(v)||v<=0){console.error(`Invalid font size: ${v}`);return}this.setFontSize(v)},"font-smoothing":v=>{this.syncFontFamily()},"foreground-color":v=>{this.setForegroundColor(v)},"hide-mouse-while-typing":v=>{this.setAutomaticMouseHiding(v)},"home-keys-scroll":v=>{this.keyboard.homeKeysScroll=v},keybindings:v=>{loadKeyBindings(v,this.prefs_.get("keybindings-os-defaults"))},"keybindings-os-defaults":v=>{loadKeyBindings(this.prefs_.get("keybindings"),v)},"line-height-padding-size":v=>{v=parseFloat(v);if(isNaN(v)){console.error(`Invalid line height padding size: ${v}`);return}this.setLineHeightPaddingSize(v)},"media-keys-are-fkeys":v=>{this.keyboard.mediaKeysAreFKeys=v},"meta-sends-escape":v=>{this.keyboard.metaSendsEscape=v},"mouse-right-click-paste":v=>{this.mouseRightClickPaste=v},"mouse-paste-button":v=>{this.syncMousePasteButton()},"page-keys-scroll":v=>{this.keyboard.pageKeysScroll=v},"pass-alt-number":v=>{if(v==null){v=hterm.os!=="mac"&&hterm.windowType!=="popup"&&hterm.windowType!=="app"}this.passAltNumber=v},"pass-ctrl-number":v=>{if(v==null){v=hterm.os!=="mac"&&hterm.windowType!=="popup"&&hterm.windowType!=="app"}this.passCtrlNumber=v},"pass-ctrl-n":v=>{this.passCtrlN=v},"pass-ctrl-t":v=>{this.passCtrlT=v},"pass-ctrl-tab":v=>{this.passCtrlTab=v},"pass-ctrl-w":v=>{this.passCtrlW=v},"pass-meta-number":v=>{if(v==null){v=hterm.os==="mac"&&hterm.windowType!=="popup"&&hterm.windowType!=="app"}this.passMetaNumber=v},"pass-meta-v":v=>{this.keyboard.passMetaV=v},"screen-padding-size":v=>{v=parseInt(v,10);if(isNaN(v)||v<0){console.error(`Invalid screen padding size: ${v}`);return}this.setScreenPaddingSize(v)},"screen-border-size":v=>{v=parseInt(v,10);if(isNaN(v)||v<0){console.error(`Invalid screen border size: ${v}`);return}this.setScreenBorderSize(v)},"screen-border-color":v=>{this.div_.style.borderColor=v},"scroll-on-keystroke":v=>{this.scrollOnKeystroke_=v},"scroll-on-output":v=>{this.scrollOnOutput_=v},"scrollbar-visible":v=>{this.setScrollbarVisible(v)},"scroll-wheel-may-send-arrow-keys":v=>{this.scrollWheelArrowKeys_=v},"scroll-wheel-move-multiplier":v=>{this.setScrollWheelMoveMultipler(v)},"shift-insert-paste":v=>{this.keyboard.shiftInsertPaste=v},"terminal-encoding":v=>{this.vt.setEncoding(v)},"user-css":v=>{this.scrollPort_.setUserCssUrl(v)},"user-css-text":v=>{this.scrollPort_.setUserCssText(v)},"word-break-match-left":v=>{this.primaryScreen_.wordBreakMatchLeft=v;this.alternateScreen_.wordBreakMatchLeft=v},"word-break-match-right":v=>{this.primaryScreen_.wordBreakMatchRight=v;this.alternateScreen_.wordBreakMatchRight=v},"word-break-match-middle":v=>{this.primaryScreen_.wordBreakMatchMiddle=v;this.alternateScreen_.wordBreakMatchMiddle=v},"allow-images-inline":v=>{this.allowImagesInline=v}});this.prefs_.readStorage(function(){this.prefs_.notifyAll();if(callback){this.ready_=true;callback()}}.bind(this))};hterm.Terminal.prototype.getPrefs=function(){return lib.notNull(this.prefs_)};hterm.Terminal.prototype.setBracketedPaste=function(state){this.options_.bracketedPaste=state};hterm.Terminal.prototype.setCursorColor=function(color){if(color===undefined){color=this.prefs_.getString("cursor-color")}this.setCssVar("cursor-color",color)};hterm.Terminal.prototype.getCursorColor=function(){return this.getCssVar("cursor-color")};hterm.Terminal.prototype.setSelectionEnabled=function(state){this.enableMouseDragScroll=state};hterm.Terminal.prototype.setBackgroundImage=function(cssUrl){if(cssUrl===undefined){cssUrl=this.prefs_.getString("background-image")}this.scrollPort_.setBackgroundImage(cssUrl)};hterm.Terminal.prototype.setBackgroundColor=function(color){if(color===undefined){color=this.prefs_.getString("background-color")}this.backgroundColor_=lib.colors.normalizeCSS(color);this.setRgbColorCssVar("background-color",this.backgroundColor_)};hterm.Terminal.prototype.getBackgroundColor=function(){return this.backgroundColor_};hterm.Terminal.prototype.setForegroundColor=function(color){if(color===undefined){color=this.prefs_.getString("foreground-color")}this.foregroundColor_=lib.colors.normalizeCSS(color);this.setRgbColorCssVar("foreground-color",this.foregroundColor_)};hterm.Terminal.prototype.getForegroundColor=function(){return this.foregroundColor_};hterm.Terminal.prototype.isPrimaryScreen=function(){return this.screen_==this.primaryScreen_};hterm.Terminal.prototype.installKeyboard=function(){this.keyboard.installKeyboard(this.scrollPort_.getDocument().body)};hterm.Terminal.prototype.uninstallKeyboard=function(){this.keyboard.installKeyboard(null)};hterm.Terminal.prototype.setCssVar=function(name,value,prefix="--hterm-"){this.document_.documentElement.style.setProperty(`${prefix}${name}`,value.toString())};hterm.Terminal.prototype.setRgbColorCssVar=function(name,rgb){const ary=rgb?lib.colors.crackRGB(rgb):null;if(ary){this.setCssVar(name,ary.slice(0,3).join(","))}};hterm.Terminal.prototype.setColorPalette=function(i,rgb){if(i>=0&&i<256&&rgb!=null&&rgb!=this.getColorPalette[i]){this.setRgbColorCssVar(`color-${i}`,rgb);this.screen_.textAttributes.colorPaletteOverrides[i]=rgb}};hterm.Terminal.prototype.getColorPalette=function(i){return this.screen_.textAttributes.colorPaletteOverrides[i]||this.colorPaletteOverrides_.get(i)||lib.colors.stockPalette[i]};hterm.Terminal.prototype.resetColor=function(i){this.setColorPalette(i,this.colorPaletteOverrides_.get(i)||lib.colors.stockPalette[i]);delete this.screen_.textAttributes.colorPaletteOverrides[i]};hterm.Terminal.prototype.resetColorPalette=function(){this.screen_.textAttributes.colorPaletteOverrides.forEach((c,i)=>this.resetColor(i))};hterm.Terminal.prototype.getCssVar=function(name,prefix="--hterm-"){return this.document_.documentElement.style.getPropertyValue(`${prefix}${name}`)};hterm.Terminal.prototype.getScrollPort=function(){return this.scrollPort_};hterm.Terminal.prototype.updateCssCharsize_=function(){this.setCssVar("charsize-width",this.scrollPort_.characterSize.width+"px");this.setCssVar("charsize-height",this.scrollPort_.characterSize.height+"px")};hterm.Terminal.prototype.setFontSize=function(px){if(px<=0){px=this.prefs_.getNumber("font-size")}this.scrollPort_.setFontSize(px);this.setCssVar("font-size",`${px}px`);this.updateCssCharsize_()};hterm.Terminal.prototype.getFontSize=function(){return this.scrollPort_.getFontSize()};hterm.Terminal.prototype.getFontFamily=function(){return this.scrollPort_.getFontFamily()};hterm.Terminal.prototype.syncFontFamily=function(){this.scrollPort_.setFontFamily(this.prefs_.getString("font-family"),this.prefs_.getString("font-smoothing"));this.updateCssCharsize_();this.syncBoldSafeState()};hterm.Terminal.prototype.syncMousePasteButton=function(){const button=this.prefs_.get("mouse-paste-button");if(typeof button=="number"){this.mousePasteButton=button;return}if(hterm.os!="linux"){this.mousePasteButton=1}else{this.mousePasteButton=2}};hterm.Terminal.prototype.syncBoldSafeState=function(){const enableBold=this.prefs_.get("enable-bold");if(enableBold!==null){this.primaryScreen_.textAttributes.enableBold=enableBold;this.alternateScreen_.textAttributes.enableBold=enableBold;return}const normalSize=this.scrollPort_.measureCharacterSize();const boldSize=this.scrollPort_.measureCharacterSize("bold");const isBoldSafe=normalSize.equals(boldSize);if(!isBoldSafe){console.warn("Bold characters disabled: Size of bold weight differs "+"from normal.  Font family is: "+this.scrollPort_.getFontFamily())}this.primaryScreen_.textAttributes.enableBold=isBoldSafe;this.alternateScreen_.textAttributes.enableBold=isBoldSafe};hterm.Terminal.prototype.setTextBlink=function(state){if(state===undefined){state=this.prefs_.getBoolean("enable-blink")}this.setCssVar("blink-node-duration",state?"0.7s":"0")};hterm.Terminal.prototype.syncMouseStyle=function(){this.setCssVar("mouse-cursor-style",this.vt.mouseReport==this.vt.MOUSE_REPORT_DISABLED?"var(--hterm-mouse-cursor-text)":"var(--hterm-mouse-cursor-default)")};hterm.Terminal.prototype.saveCursor=function(){return this.screen_.cursorPosition.clone()};hterm.Terminal.prototype.getTextAttributes=function(){return this.screen_.textAttributes};hterm.Terminal.prototype.setTextAttributes=function(textAttributes){this.screen_.textAttributes=textAttributes};hterm.Terminal.prototype.setWindowTitle=function(title){globalThis.document.title=title};hterm.Terminal.prototype.setWindowName=function(name){};hterm.Terminal.prototype.restoreCursor=function(cursor){const row=lib.f.clamp(cursor.row,0,this.screenSize.height-1);const column=lib.f.clamp(cursor.column,0,this.screenSize.width-1);this.screen_.setCursorPosition(row,column);if(cursor.column>column||cursor.column==column&&cursor.overflow){this.screen_.cursorPosition.overflow=true}};hterm.Terminal.prototype.clearCursorOverflow=function(){this.screen_.cursorPosition.overflow=false};hterm.Terminal.prototype.saveCursorAndState=function(both){if(both){this.primaryScreen_.saveCursorAndState(this.vt);this.alternateScreen_.saveCursorAndState(this.vt)}else{this.screen_.saveCursorAndState(this.vt)}};hterm.Terminal.prototype.restoreCursorAndState=function(both){if(both){this.primaryScreen_.restoreCursorAndState(this.vt);this.alternateScreen_.restoreCursorAndState(this.vt)}else{this.screen_.restoreCursorAndState(this.vt)}};hterm.Terminal.prototype.setCursorShape=function(shape){this.cursorShape_=shape;this.restyleCursor_()};hterm.Terminal.prototype.getCursorShape=function(){return this.cursorShape_};hterm.Terminal.prototype.setLineHeightPaddingSize=function(size){this.scrollPort_.setLineHeightPaddingSize(size)};hterm.Terminal.prototype.setScreenPaddingSize=function(size){this.setCssVar("screen-padding-size",`${size}px`);this.scrollPort_.setScreenPaddingSize(size)};hterm.Terminal.prototype.setScreenBorderSize=function(size){this.div_.style.borderWidth=`${size}px`;this.screenBorderSize_=size;this.scrollPort_.resize()};hterm.Terminal.prototype.setWidth=function(columnCount){if(columnCount==null){this.div_.style.width="100%";return}const rightPadding=Math.max(this.scrollPort_.screenPaddingSize,this.scrollPort_.currentScrollbarWidthPx);this.div_.style.width=Math.ceil(this.scrollPort_.characterSize.width*columnCount+this.scrollPort_.screenPaddingSize+rightPadding+2*this.screenBorderSize_)+"px";this.realizeSize_(columnCount,this.screenSize.height);this.scheduleSyncCursorPosition_()};hterm.Terminal.prototype.setHeight=function(rowCount){if(rowCount==null){this.div_.style.height="100%";return}this.div_.style.height=this.scrollPort_.characterSize.height*rowCount+2*this.scrollPort_.screenPaddingSize+2*this.screenBorderSize_+"px";this.realizeSize_(this.screenSize.width,rowCount);this.scheduleSyncCursorPosition_()};hterm.Terminal.prototype.realizeSize_=function(columnCount,rowCount){let notify=false;if(columnCount!=this.screenSize.width){notify=true;this.realizeWidth_(columnCount)}if(rowCount!=this.screenSize.height){notify=true;this.realizeHeight_(rowCount)}if(notify){this.io.onTerminalResize_(columnCount,rowCount)}};hterm.Terminal.prototype.realizeWidth_=function(columnCount){if(columnCount<=0){throw new Error("Attempt to realize bad width: "+columnCount)}const deltaColumns=columnCount-this.screen_.getWidth();if(deltaColumns==0){return}this.screenSize.width=columnCount;this.screen_.setColumnCount(columnCount);if(deltaColumns>0){if(this.defaultTabStops){this.setDefaultTabStops(this.screenSize.width-deltaColumns)}}else{for(let i=this.tabStops_.length-1;i>=0;i--){if(this.tabStops_[i]<columnCount){break}this.tabStops_.pop()}}this.screen_.setColumnCount(this.screenSize.width)};hterm.Terminal.prototype.realizeHeight_=function(rowCount){if(rowCount<=0){throw new Error("Attempt to realize bad height: "+rowCount)}let deltaRows=rowCount-this.screen_.getHeight();if(deltaRows==0){return}this.screenSize.height=rowCount;const cursor=this.saveCursor();if(deltaRows<0){deltaRows*=-1;while(deltaRows){const lastRow=this.getRowCount()-1;if(lastRow-this.scrollbackRows_.length==cursor.row){break}if(this.getRowText(lastRow)){break}this.screen_.popRow();deltaRows--}const ary=this.screen_.shiftRows(deltaRows);this.scrollbackRows_.push.apply(this.scrollbackRows_,ary);cursor.row=Math.max(cursor.row-deltaRows,0)}else if(deltaRows>0){if(deltaRows<=this.scrollbackRows_.length){const scrollbackCount=Math.min(deltaRows,this.scrollbackRows_.length);const rows=this.scrollbackRows_.splice(this.scrollbackRows_.length-scrollbackCount,scrollbackCount);this.screen_.unshiftRows(rows);deltaRows-=scrollbackCount;cursor.row+=scrollbackCount}if(deltaRows){this.appendRows_(deltaRows)}}this.setVTScrollRegion(null,null);this.restoreCursor(cursor)};hterm.Terminal.prototype.scrollHome=function(){this.scrollPort_.scrollRowToTop(0)};hterm.Terminal.prototype.scrollEnd=function(){this.scrollPort_.scrollRowToBottom(this.getRowCount())};hterm.Terminal.prototype.scrollPageUp=function(){this.scrollPort_.scrollPageUp()};hterm.Terminal.prototype.scrollPageDown=function(){this.scrollPort_.scrollPageDown()};hterm.Terminal.prototype.scrollLineUp=function(){const i=this.scrollPort_.getTopRowIndex();this.scrollPort_.scrollRowToTop(i-1)};hterm.Terminal.prototype.scrollLineDown=function(){const i=this.scrollPort_.getTopRowIndex();this.scrollPort_.scrollRowToTop(i+1)};hterm.Terminal.prototype.wipeContents=function(){this.clearHome(this.primaryScreen_);this.clearHome(this.alternateScreen_);this.clearScrollback()};hterm.Terminal.prototype.clearScrollback=function(){this.scrollEnd();this.scrollbackRows_.length=0;this.scrollPort_.resetCache();[this.primaryScreen_,this.alternateScreen_].forEach(screen=>{const bottom=screen.getHeight();this.renumberRows_(0,bottom,screen)});this.syncCursorPosition_();this.scrollPort_.invalidate()};hterm.Terminal.prototype.reset=function(){this.vt.reset();this.clearAllTabStops();this.setDefaultTabStops();this.resetColorPalette();const resetScreen=screen=>{screen.textAttributes.reset();screen.textAttributes.colorPaletteOverrides=[];this.clearHome(screen);screen.saveCursorAndState(this.vt)};resetScreen(this.primaryScreen_);resetScreen(this.alternateScreen_);this.options_=new hterm.Options;this.setCursorBlink(!!this.prefs_.get("cursor-blink"));this.setVTScrollRegion(null,null);this.setCursorVisible(true)};hterm.Terminal.prototype.softReset=function(){this.vt.reset();this.options_=new hterm.Options;this.options_.cursorBlink=!!this.timeouts_.cursorBlink;this.resetColorPalette();const resetScreen=screen=>{screen.textAttributes.reset();screen.textAttributes.colorPaletteOverrides=[];screen.saveCursorAndState(this.vt)};resetScreen(this.primaryScreen_);resetScreen(this.alternateScreen_);this.setVTScrollRegion(null,null);this.setCursorVisible(true)};hterm.Terminal.prototype.forwardTabStop=function(){const column=this.screen_.cursorPosition.column;for(let i=0;i<this.tabStops_.length;i++){if(this.tabStops_[i]>column){this.setCursorColumn(this.tabStops_[i]);return}}const overflow=this.screen_.cursorPosition.overflow;this.setCursorColumn(this.screenSize.width-1);this.screen_.cursorPosition.overflow=overflow};hterm.Terminal.prototype.backwardTabStop=function(){const column=this.screen_.cursorPosition.column;for(let i=this.tabStops_.length-1;i>=0;i--){if(this.tabStops_[i]<column){this.setCursorColumn(this.tabStops_[i]);return}}this.setCursorColumn(1)};hterm.Terminal.prototype.setTabStop=function(column){for(let i=this.tabStops_.length-1;i>=0;i--){if(this.tabStops_[i]==column){return}if(this.tabStops_[i]<column){this.tabStops_.splice(i+1,0,column);return}}this.tabStops_.splice(0,0,column)};hterm.Terminal.prototype.clearTabStopAtCursor=function(){const column=this.screen_.cursorPosition.column;const i=this.tabStops_.indexOf(column);if(i==-1){return}this.tabStops_.splice(i,1)};hterm.Terminal.prototype.clearAllTabStops=function(){this.tabStops_.length=0;this.defaultTabStops=false};hterm.Terminal.prototype.setDefaultTabStops=function(start=0){const w=this.tabWidth;start=start-1-(start-1)%w+w;for(let i=start;i<this.screenSize.width;i+=w){this.setTabStop(i)}this.defaultTabStops=true};hterm.Terminal.prototype.interpret=function(str){this.scheduleSyncCursorPosition_();this.vt.interpret(str)};hterm.Terminal.prototype.decorate=function(div){const charset=div.ownerDocument.characterSet.toLowerCase();if(charset!="utf-8"){console.warn(`Document encoding should be set to utf-8, not "${charset}";`+` Add <meta charset='utf-8'/> to your HTML <head> to fix.`)}this.div_=div;this.div_.style.borderStyle="solid";this.div_.style.borderWidth=0;this.div_.style.boxSizing="border-box";this.accessibilityReader_=new hterm.AccessibilityReader(div);this.scrollPort_.decorate(div,()=>this.setupScrollPort_())};hterm.Terminal.prototype.setupScrollPort_=function(){this.scrollPort_.setBackgroundImage(this.prefs_.getString("background-image"));this.scrollPort_.setBackgroundSize(this.prefs_.getString("background-size"));this.scrollPort_.setBackgroundPosition(this.prefs_.getString("background-position"));this.scrollPort_.setUserCssUrl(this.prefs_.getString("user-css"));this.scrollPort_.setUserCssText(this.prefs_.getString("user-css-text"));this.scrollPort_.setAccessibilityReader(lib.notNull(this.accessibilityReader_));this.div_.focus=this.focus.bind(this);this.setFontSize(this.prefs_.getNumber("font-size"));this.syncFontFamily();this.setScrollbarVisible(this.prefs_.getBoolean("scrollbar-visible"));this.setScrollWheelMoveMultipler(this.prefs_.getNumber("scroll-wheel-move-multiplier"));this.document_=this.scrollPort_.getDocument();this.accessibilityReader_.decorate(this.document_);this.findBar.decorate(this.document_);this.notifications_=new hterm.NotificationCenter(lib.notNull(this.document_.body),this.accessibilityReader_);this.document_.body.oncontextmenu=function(){return false};this.contextMenu.setDocument(this.document_);const onMouse=this.onMouse_.bind(this);const screenNode=this.scrollPort_.getScreenNode();screenNode.addEventListener("mousedown",onMouse);screenNode.addEventListener("mouseup",onMouse);screenNode.addEventListener("mousemove",onMouse);this.scrollPort_.onScrollWheel=onMouse;screenNode.addEventListener("keydown",this.onKeyboardActivity_.bind(this));screenNode.addEventListener("focus",this.onFocusChange_.bind(this,true));screenNode.addEventListener("mousedown",function(){setTimeout(this.onFocusChange_.bind(this,true))}.bind(this));screenNode.addEventListener("blur",this.onFocusChange_.bind(this,false));const style=this.document_.createElement("style");style.textContent=`
.cursor-node[focus="false"] {
  box-sizing: border-box;
  background-color: transparent !important;
  border-width: 2px;
  border-style: solid;
}
menu {
  background: #fff;
  border-radius: 4px;
  color: #202124;
  cursor: var(--hterm-mouse-cursor-pointer);
  display: none;
  filter: drop-shadow(0 1px 3px #3C40434D) drop-shadow(0 4px 8px #3C404326);
  margin: 0;
  padding: 8px 0;
  position: absolute;
  transition-duration: 200ms;
}
menuitem {
  display: block;
  font: var(--hterm-font-size) 'Roboto', 'Noto Sans', sans-serif;
  padding: 0.5em 1em;
  white-space: nowrap;
}
menuitem.separator {
  border-bottom: none;
  height: 0.5em;
  padding: 0;
}
menuitem:hover {
  background-color: #e2e4e6;
}
.wc-node {
  display: inline-block;
  text-align: center;
  width: calc(var(--hterm-charsize-width) * 2);
  line-height: var(--hterm-charsize-height);
}
:root {
  --hterm-charsize-width: ${this.scrollPort_.characterSize.width}px;
  --hterm-charsize-height: ${this.scrollPort_.characterSize.height}px;
  --hterm-blink-node-duration: 0.7s;
  --hterm-mouse-cursor-default: default;
  --hterm-mouse-cursor-text: text;
  --hterm-mouse-cursor-pointer: pointer;
  --hterm-mouse-cursor-style: var(--hterm-mouse-cursor-text);
  --hterm-screen-padding-size: 0;

${lib.colors.stockPalette.map((c,i)=>`
  --hterm-color-${i}: ${lib.colors.crackRGB(c).slice(0,3).join(",")};
`).join("")}
}
.uri-node:hover {
  text-decoration: underline;
  cursor: var(--hterm-mouse-cursor-pointer);
}
@keyframes blink {
  from { opacity: 1.0; }
  to { opacity: 0.0; }
}
.blink-node {
  animation-name: blink;
  animation-duration: var(--hterm-blink-node-duration);
  animation-iteration-count: infinite;
  animation-timing-function: ease-in-out;
  animation-direction: alternate;
}`;this.document_.head.insertBefore(style,this.document_.head.firstChild);this.cursorNode_=this.document_.createElement("div");this.cursorNode_.id="hterm:terminal-cursor";this.cursorNode_.className="cursor-node";this.cursorNode_.style.cssText=`
position: absolute;
left: calc(var(--hterm-screen-padding-size) +
    var(--hterm-charsize-width) * var(--hterm-cursor-offset-col));
top: calc(var(--hterm-screen-padding-size) +
    var(--hterm-charsize-height) * var(--hterm-cursor-offset-row));
display: ${this.options_.cursorVisible?"":"none"};
width: var(--hterm-charsize-width);
height: var(--hterm-charsize-height);
background-color: var(--hterm-cursor-color);
border-color: var(--hterm-cursor-color);
transition: opacity, background-color 100ms linear;`;this.setCursorColor();this.setCursorBlink(!!this.prefs_.get("cursor-blink"));this.restyleCursor_();this.document_.body.appendChild(this.cursorNode_);this.scrollBlockerNode_=this.document_.createElement("div");this.scrollBlockerNode_.id="hterm:mouse-drag-scroll-blocker";this.scrollBlockerNode_.setAttribute("aria-hidden","true");this.scrollBlockerNode_.style.cssText="position: absolute;"+"top: -99px;"+"display: block;"+"width: 10px;"+"height: 10px;";this.document_.body.appendChild(this.scrollBlockerNode_);this.scrollPort_.onScrollWheel=onMouse;["mousedown","mouseup","mousemove","click","dblclick"].forEach(function(event){this.scrollBlockerNode_.addEventListener(event,onMouse);this.cursorNode_.addEventListener(event,onMouse);this.document_.addEventListener(event,onMouse)}.bind(this));this.cursorNode_.addEventListener("mousedown",function(){setTimeout(this.focus.bind(this))}.bind(this));this.setReverseVideo(false);this.document_.fonts.addEventListener("loadingdone",()=>this.syncFontFamily());this.scrollPort_.focus();this.scrollPort_.scheduleRedraw()};hterm.Terminal.prototype.getDocument=function(){return this.document_};hterm.Terminal.prototype.focus=function(){this.scrollPort_.focus()};hterm.Terminal.prototype.blur=function(){this.scrollPort_.blur()};hterm.Terminal.prototype.getRowNode=function(index){if(index<this.scrollbackRows_.length){return this.scrollbackRows_[index]}const screenIndex=index-this.scrollbackRows_.length;return this.screen_.rowsArray[screenIndex]};hterm.Terminal.prototype.getRowsText=function(start,end){const ary=[];for(let i=start;i<end;i++){const node=this.getRowNode(i);ary.push(node.textContent);if(i<end-1&&!node.getAttribute("line-overflow")){ary.push("\n")}}return ary.join("")};hterm.Terminal.prototype.getRowText=function(index){const node=this.getRowNode(index);return node.textContent};hterm.Terminal.prototype.getRowCount=function(){return this.scrollbackRows_.length+this.screen_.rowsArray.length};hterm.Terminal.prototype.appendRows_=function(count){let cursorRow=this.screen_.rowsArray.length;const offset=this.scrollbackRows_.length+cursorRow;for(let i=0;i<count;i++){const row=this.document_.createElement("x-row");row.appendChild(this.document_.createTextNode(""));row.rowIndex=offset+i;this.screen_.pushRow(row)}const extraRows=this.screen_.rowsArray.length-this.screenSize.height;if(extraRows>0){const ary=this.screen_.shiftRows(extraRows);Array.prototype.push.apply(this.scrollbackRows_,ary);if(this.scrollPort_.isScrolledEnd){this.scheduleScrollDown_()}}if(cursorRow>=this.screen_.rowsArray.length){cursorRow=this.screen_.rowsArray.length-1}this.setAbsoluteCursorPosition(cursorRow,0)};hterm.Terminal.prototype.insertRow_=function(){const row=this.document_.createElement("x-row");row.appendChild(this.document_.createTextNode(""));this.scrollbackRows_.push(this.screen_.shiftRow());const cursorRow=this.screen_.cursorPosition.row;this.screen_.insertRow(cursorRow,row);this.renumberRows_(cursorRow,this.screen_.rowsArray.length);this.setAbsoluteCursorPosition(cursorRow,0);if(this.scrollPort_.isScrolledEnd){this.scheduleScrollDown_()}};hterm.Terminal.prototype.moveRows_=function(fromIndex,count,toIndex){const ary=this.screen_.removeRows(fromIndex,count);this.screen_.insertRows(toIndex,ary);let start,end;if(fromIndex<toIndex){start=fromIndex;end=toIndex+count}else{start=toIndex;end=fromIndex+count}this.renumberRows_(start,end);this.scrollPort_.scheduleInvalidate()};hterm.Terminal.prototype.renumberRows_=function(start,end,screen=undefined){if(!screen){screen=this.screen_}const offset=this.scrollbackRows_.length;for(let i=start;i<end;i++){screen.rowsArray[i].rowIndex=offset+i}};hterm.Terminal.prototype.print=function(str){this.scheduleSyncCursorPosition_();this.accessibilityReader_.announce(str);let startOffset=0;let strWidth=hterm.wc.strWidth(str);if(strWidth==0&&str){strWidth=1}while(startOffset<strWidth){if(this.options_.wraparound&&this.screen_.cursorPosition.overflow){this.screen_.commitLineOverflow();this.newLine(true)}let count=strWidth-startOffset;let didOverflow=false;let substr;if(this.screen_.cursorPosition.column+count>=this.screenSize.width){didOverflow=true;count=this.screenSize.width-this.screen_.cursorPosition.column}if(didOverflow&&!this.options_.wraparound){substr=hterm.wc.substr(str,startOffset,count-1)+hterm.wc.substr(str,strWidth-1);count=strWidth}else{substr=hterm.wc.substr(str,startOffset,count)}const tokens=hterm.TextAttributes.splitWidecharString(substr);for(let i=0;i<tokens.length;i++){this.screen_.textAttributes.wcNode=tokens[i].wcNode;this.screen_.textAttributes.asciiNode=tokens[i].asciiNode;if(this.options_.insertMode){this.screen_.insertString(tokens[i].str,tokens[i].wcStrWidth)}else{this.screen_.overwriteString(tokens[i].str,tokens[i].wcStrWidth)}this.screen_.textAttributes.wcNode=false;this.screen_.textAttributes.asciiNode=true}this.screen_.maybeClipCurrentRow();startOffset+=count;this.findBar.scheduleNotifyChanges(this.scrollbackRows_.length+this.screen_.cursorPosition.row)}if(this.scrollOnOutput_){this.scrollPort_.scrollRowToBottom(this.getRowCount())}};hterm.Terminal.prototype.setVTScrollRegion=function(scrollTop,scrollBottom){this.vtScrollTop_=scrollTop;this.vtScrollBottom_=scrollBottom;if(scrollBottom==this.screenSize.height-1){this.vtScrollBottom_=null;if(scrollTop==0){this.vtScrollTop_=null}}};hterm.Terminal.prototype.getVTScrollTop=function(){if(this.vtScrollTop_!=null){return this.vtScrollTop_}return 0};hterm.Terminal.prototype.getVTScrollBottom=function(){if(this.vtScrollBottom_!=null){return this.vtScrollBottom_}return this.screenSize.height-1};hterm.Terminal.prototype.newLine=function(dueToOverflow=false){if(!dueToOverflow){this.accessibilityReader_.newLine()}const cursorAtEndOfScreen=this.screen_.cursorPosition.row==this.screen_.rowsArray.length-1;const cursorAtEndOfVTRegion=this.screen_.cursorPosition.row==this.getVTScrollBottom();if(this.vtScrollTop_!=null&&cursorAtEndOfVTRegion){this.vtScrollUp(1);this.setAbsoluteCursorPosition(this.screen_.cursorPosition.row,0)}else if(cursorAtEndOfScreen){this.appendRows_(1)}else if(cursorAtEndOfVTRegion){this.insertRow_()}else{this.setAbsoluteCursorPosition(this.screen_.cursorPosition.row+1,0)}};hterm.Terminal.prototype.lineFeed=function(){const column=this.screen_.cursorPosition.column;this.newLine();this.setCursorColumn(column)};hterm.Terminal.prototype.formFeed=function(){if(this.options_.autoCarriageReturn){this.newLine()}else{this.lineFeed()}};hterm.Terminal.prototype.reverseLineFeed=function(){const scrollTop=this.getVTScrollTop();const currentRow=this.screen_.cursorPosition.row;if(currentRow==scrollTop){this.insertLines(1)}else{this.setAbsoluteCursorRow(currentRow-1)}};hterm.Terminal.prototype.eraseToLeft=function(){const cursor=this.saveCursor();this.setCursorColumn(0);const count=cursor.column+1;this.screen_.overwriteString(" ".repeat(count),count);this.findBar.scheduleNotifyChanges(this.scrollbackRows_.length+this.screen_.cursorPosition.row);this.restoreCursor(cursor)};hterm.Terminal.prototype.eraseToRight=function(count=undefined){if(this.screen_.cursorPosition.overflow){return}const maxCount=this.screenSize.width-this.screen_.cursorPosition.column;count=count?Math.min(count,maxCount):maxCount;this.findBar.scheduleNotifyChanges(this.scrollbackRows_.length+this.screen_.cursorPosition.row);if(this.screen_.textAttributes.background===this.screen_.textAttributes.DEFAULT_COLOR){const cursorRow=this.screen_.rowsArray[this.screen_.cursorPosition.row];if(hterm.TextAttributes.nodeWidth(cursorRow)<=this.screen_.cursorPosition.column+count){this.screen_.deleteChars(count);this.clearCursorOverflow();return}}const cursor=this.saveCursor();this.screen_.overwriteString(" ".repeat(count),count);this.restoreCursor(cursor);this.clearCursorOverflow()};hterm.Terminal.prototype.eraseLine=function(){const cursor=this.saveCursor();this.screen_.clearCursorRow();this.restoreCursor(cursor);this.clearCursorOverflow()};hterm.Terminal.prototype.eraseAbove=function(){const cursor=this.saveCursor();this.eraseToLeft();for(let i=0;i<cursor.row;i++){this.setAbsoluteCursorPosition(i,0);this.screen_.clearCursorRow()}this.restoreCursor(cursor);this.clearCursorOverflow()};hterm.Terminal.prototype.eraseBelow=function(){const cursor=this.saveCursor();this.eraseToRight();const bottom=this.screenSize.height-1;for(let i=cursor.row+1;i<=bottom;i++){this.setAbsoluteCursorPosition(i,0);this.screen_.clearCursorRow()}this.restoreCursor(cursor);this.clearCursorOverflow()};hterm.Terminal.prototype.fill=function(ch){const cursor=this.saveCursor();this.setAbsoluteCursorPosition(0,0);for(let row=0;row<this.screenSize.height;row++){for(let col=0;col<this.screenSize.width;col++){this.setAbsoluteCursorPosition(row,col);this.screen_.overwriteString(ch,1)}this.findBar.scheduleNotifyChanges(this.scrollbackRows_.length+row)}this.restoreCursor(cursor)};hterm.Terminal.prototype.clearHome=function(screen=undefined){if(!screen){screen=this.screen_}const bottom=screen.getHeight();this.accessibilityReader_.clear();if(bottom==0){return}for(let i=0;i<bottom;i++){screen.setCursorPosition(i,0);screen.clearCursorRow()}screen.setCursorPosition(0,0)};hterm.Terminal.prototype.clear=function(screen=undefined){if(!screen){screen=this.screen_}const cursor=screen.cursorPosition.clone();this.clearHome(screen);screen.setCursorPosition(cursor.row,cursor.column)};hterm.Terminal.prototype.insertLines=function(count){const cursorRow=this.screen_.cursorPosition.row;const bottom=this.getVTScrollBottom();count=Math.min(count,bottom-cursorRow);const moveCount=bottom-cursorRow-count+1;if(moveCount){this.moveRows_(cursorRow,moveCount,cursorRow+count)}for(let i=count-1;i>=0;i--){this.setAbsoluteCursorPosition(cursorRow+i,0);this.screen_.clearCursorRow()}};hterm.Terminal.prototype.deleteLines=function(count){const cursor=this.saveCursor();const top=cursor.row;const bottom=this.getVTScrollBottom();const maxCount=bottom-top+1;count=Math.min(count,maxCount);const moveStart=bottom-count+1;if(count!=maxCount){this.moveRows_(top,count,moveStart)}for(let i=0;i<count;i++){this.setAbsoluteCursorPosition(moveStart+i,0);this.screen_.clearCursorRow()}this.restoreCursor(cursor);this.clearCursorOverflow()};hterm.Terminal.prototype.insertSpace=function(count){const cursor=this.saveCursor();const ws=" ".repeat(count||1);this.screen_.insertString(ws,ws.length);this.screen_.maybeClipCurrentRow();this.findBar.scheduleNotifyChanges(this.scrollbackRows_.length+this.screen_.cursorPosition.row);this.restoreCursor(cursor);this.clearCursorOverflow()};hterm.Terminal.prototype.deleteChars=function(count){const deleted=this.screen_.deleteChars(count);if(deleted&&!this.screen_.textAttributes.isDefault()){const cursor=this.saveCursor();this.setCursorColumn(this.screenSize.width-deleted);this.screen_.insertString(" ".repeat(deleted));this.restoreCursor(cursor)}this.findBar.scheduleNotifyChanges(this.scrollbackRows_.length+this.screen_.cursorPosition.row);this.clearCursorOverflow()};hterm.Terminal.prototype.vtScrollUp=function(count){const cursor=this.saveCursor();this.setAbsoluteCursorRow(this.getVTScrollTop());this.deleteLines(count);this.restoreCursor(cursor)};hterm.Terminal.prototype.vtScrollDown=function(count){const cursor=this.saveCursor();this.setAbsoluteCursorPosition(this.getVTScrollTop(),0);this.insertLines(count);this.restoreCursor(cursor)};hterm.Terminal.prototype.setAccessibilityEnabled=function(enabled){this.accessibilityReader_.setAccessibilityEnabled(enabled)};hterm.Terminal.prototype.setCursorPosition=function(row,column){if(this.options_.originMode){this.setRelativeCursorPosition(row,column)}else{this.setAbsoluteCursorPosition(row,column)}};hterm.Terminal.prototype.setRelativeCursorPosition=function(row,column){const scrollTop=this.getVTScrollTop();row=lib.f.clamp(row+scrollTop,scrollTop,this.getVTScrollBottom());column=lib.f.clamp(column,0,this.screenSize.width-1);this.screen_.setCursorPosition(row,column)};hterm.Terminal.prototype.setAbsoluteCursorPosition=function(row,column){row=lib.f.clamp(row,0,this.screenSize.height-1);column=lib.f.clamp(column,0,this.screenSize.width-1);this.screen_.setCursorPosition(row,column)};hterm.Terminal.prototype.setCursorColumn=function(column){this.setAbsoluteCursorPosition(this.screen_.cursorPosition.row,column)};hterm.Terminal.prototype.getCursorColumn=function(){return this.screen_.cursorPosition.column};hterm.Terminal.prototype.setAbsoluteCursorRow=function(row){this.setAbsoluteCursorPosition(row,this.screen_.cursorPosition.column)};hterm.Terminal.prototype.getCursorRow=function(){return this.screen_.cursorPosition.row};hterm.Terminal.prototype.scheduleRedraw_=function(){if(this.timeouts_.redraw){return}this.timeouts_.redraw=setTimeout(()=>{delete this.timeouts_.redraw;this.scrollPort_.redraw_()})};hterm.Terminal.prototype.scheduleScrollDown_=function(){if(this.timeouts_.scrollDown){return}this.timeouts_.scrollDown=setTimeout(()=>{delete this.timeouts_.scrollDown;this.scrollPort_.scrollRowToBottom(this.getRowCount())},10)};hterm.Terminal.prototype.cursorUp=function(count){this.cursorDown(-(count||1))};hterm.Terminal.prototype.cursorDown=function(count){count=count||1;const minHeight=this.options_.originMode?this.getVTScrollTop():0;const maxHeight=this.options_.originMode?this.getVTScrollBottom():this.screenSize.height-1;const row=lib.f.clamp(this.screen_.cursorPosition.row+count,minHeight,maxHeight);this.setAbsoluteCursorRow(row)};hterm.Terminal.prototype.cursorLeft=function(count){count=count||1;if(count<1){return}const currentColumn=this.screen_.cursorPosition.column;if(this.options_.reverseWraparound){if(this.screen_.cursorPosition.overflow){count--;this.clearCursorOverflow();if(!count){return}}let newRow=this.screen_.cursorPosition.row;let newColumn=currentColumn-count;if(newColumn<0){newRow=newRow-Math.floor(count/this.screenSize.width)-1;if(newRow<0){newRow=this.screenSize.height+newRow%this.screenSize.height}newColumn=this.screenSize.width+newColumn%this.screenSize.width}this.setCursorPosition(Math.max(newRow,0),newColumn)}else{const newColumn=Math.max(currentColumn-count,0);this.setCursorColumn(newColumn)}};hterm.Terminal.prototype.cursorRight=function(count){count=count||1;if(count<1){return}const column=lib.f.clamp(this.screen_.cursorPosition.column+count,0,this.screenSize.width-1);this.setCursorColumn(column)};hterm.Terminal.prototype.setReverseVideo=function(state){this.options_.reverseVideo=state;if(state){this.setRgbColorCssVar("foreground-color",this.backgroundColor_);this.setRgbColorCssVar("background-color",this.foregroundColor_)}else{this.setRgbColorCssVar("foreground-color",this.foregroundColor_);this.setRgbColorCssVar("background-color",this.backgroundColor_)}};hterm.Terminal.prototype.ringBell=function(){this.cursorNode_.style.backgroundColor="rgb(var(--hterm-foreground-color))";setTimeout(()=>this.restyleCursor_(),200);if(this.bellSquelchTimeout_){return}if(this.bellAudio_.getAttribute("src")){this.bellAudio_.play();this.bellSequelchTimeout_=setTimeout(()=>{this.bellSquelchTimeout_=null},500)}else{this.bellSquelchTimeout_=null}if(this.desktopNotificationBell_&&!this.document_.hasFocus()){const n=hterm.notify();this.bellNotificationList_.push(n);n.onclick=()=>this.closeBellNotifications_()}};hterm.Terminal.prototype.setOriginMode=function(state){this.options_.originMode=state;this.setCursorPosition(0,0)};hterm.Terminal.prototype.setInsertMode=function(state){this.options_.insertMode=state};hterm.Terminal.prototype.setAutoCarriageReturn=function(state){this.options_.autoCarriageReturn=state};hterm.Terminal.prototype.setWraparound=function(state){this.options_.wraparound=state};hterm.Terminal.prototype.setReverseWraparound=function(state){this.options_.reverseWraparound=state};hterm.Terminal.prototype.setAlternateMode=function(state){if(state==(this.screen_==this.alternateScreen_)){return}const oldOverrides=this.screen_.textAttributes.colorPaletteOverrides;const cursor=this.saveCursor();this.screen_=state?this.alternateScreen_:this.primaryScreen_;const newOverrides=this.screen_.textAttributes.colorPaletteOverrides;oldOverrides.forEach((c,i)=>{if(!newOverrides.hasOwnProperty(i)){this.setRgbColorCssVar(`color-${i}`,this.getColorPalette(i))}});newOverrides.forEach((c,i)=>this.setRgbColorCssVar(`color-${i}`,c));if(this.screen_.rowsArray.length&&this.screen_.rowsArray[0].rowIndex!=this.scrollbackRows_.length){const offset=this.scrollbackRows_.length;const ary=this.screen_.rowsArray;for(let i=0;i<ary.length;i++){ary[i].rowIndex=offset+i}}this.realizeWidth_(this.screenSize.width);this.realizeHeight_(this.screenSize.height);this.scrollPort_.syncScrollHeight();this.scrollPort_.invalidate();this.restoreCursor(cursor);this.scrollPort_.resize()};hterm.Terminal.prototype.setCursorBlink=function(state){this.options_.cursorBlink=state;if(!state&&this.timeouts_.cursorBlink){clearTimeout(this.timeouts_.cursorBlink);delete this.timeouts_.cursorBlink}if(this.options_.cursorVisible){this.setCursorVisible(true)}};hterm.Terminal.prototype.setCursorVisible=function(state){this.options_.cursorVisible=state;if(!state){if(this.timeouts_.cursorBlink){clearTimeout(this.timeouts_.cursorBlink);delete this.timeouts_.cursorBlink}this.cursorNode_.style.opacity="0";return}this.syncCursorPosition_();this.cursorNode_.style.opacity="1";if(this.options_.cursorBlink){if(this.timeouts_.cursorBlink){return}this.onCursorBlink_()}else{if(this.timeouts_.cursorBlink){clearTimeout(this.timeouts_.cursorBlink);delete this.timeouts_.cursorBlink}}};hterm.Terminal.prototype.pauseCursorBlink_=function(){if(!this.options_.cursorBlink){return}this.cursorBlinkPause_=true;if(this.timeouts_.cursorBlinkPause){clearTimeout(this.timeouts_.cursorBlinkPause)}this.timeouts_.cursorBlinkPause=setTimeout(()=>{delete this.timeouts_.cursorBlinkPause;this.cursorBlinkPause_=false},500)};hterm.Terminal.prototype.syncCursorPosition_=function(){const topRowIndex=this.scrollPort_.getTopRowIndex();const bottomRowIndex=this.scrollPort_.getBottomRowIndex(topRowIndex);const cursorRowIndex=this.scrollbackRows_.length+this.screen_.cursorPosition.row;let forceSyncSelection=false;if(this.accessibilityReader_.accessibilityEnabled){const cursorColumnIndex=this.screen_.cursorPosition.column;const cursorLineText=this.screen_.rowsArray[this.screen_.cursorPosition.row].innerText;forceSyncSelection=this.accessibilityReader_.hasUserGesture;this.accessibilityReader_.afterCursorChange(cursorLineText,cursorRowIndex,cursorColumnIndex)}if(cursorRowIndex>bottomRowIndex){this.cursorOffScreen_=true;this.cursorNode_.style.display="none";return false}if(this.cursorNode_.style.display=="none"){this.cursorOffScreen_=false;this.cursorNode_.style.display=""}this.setCssVar("cursor-offset-row",`${cursorRowIndex-topRowIndex} + `+`${this.scrollPort_.visibleRowTopMargin}px`);this.setCssVar("cursor-offset-col",this.screen_.cursorPosition.column);this.cursorNode_.setAttribute("title","("+this.screen_.cursorPosition.column+", "+this.screen_.cursorPosition.row+")");if(!this.findBar.hasFocus){const selection=this.document_.getSelection();if(selection&&(selection.isCollapsed||forceSyncSelection)){this.screen_.syncSelectionCaret(selection)}}return true};hterm.Terminal.prototype.restyleCursor_=function(){let shape=this.cursorShape_;if(this.cursorNode_.getAttribute("focus")=="false"){shape=hterm.Terminal.cursorShape.BLOCK}const style=this.cursorNode_.style;switch(shape){case hterm.Terminal.cursorShape.BEAM:style.backgroundColor="transparent";style.borderBottomStyle="";style.borderLeftStyle="solid";break;case hterm.Terminal.cursorShape.UNDERLINE:style.backgroundColor="transparent";style.borderBottomStyle="solid";style.borderLeftStyle="";break;default:style.backgroundColor="var(--hterm-cursor-color)";style.borderBottomStyle="";style.borderLeftStyle="";break}};hterm.Terminal.prototype.scheduleSyncCursorPosition_=function(){if(this.timeouts_.syncCursor){return}if(this.accessibilityReader_.accessibilityEnabled){const cursorRowIndex=this.scrollbackRows_.length+this.screen_.cursorPosition.row;const cursorColumnIndex=this.screen_.cursorPosition.column;const cursorLineText=this.screen_.rowsArray[this.screen_.cursorPosition.row].innerText;this.accessibilityReader_.beforeCursorChange(cursorLineText,cursorRowIndex,cursorColumnIndex)}this.timeouts_.syncCursor=setTimeout(()=>{this.syncCursorPosition_();delete this.timeouts_.syncCursor})};hterm.Terminal.prototype.showOverlay=function(msg,timeout=1500){if(!this.ready_||!this.notifications_){return}this.notifications_.show(msg,{timeout:timeout})};hterm.Terminal.prototype.hideOverlay=function(){this.notifications_.hide()};hterm.Terminal.prototype.paste=function(){if(!this.alwaysUseLegacyPasting&&navigator.clipboard&&navigator.clipboard.readText){navigator.clipboard.readText().then(data=>this.onPasteData_(data));return null}else{try{return this.document_.execCommand("paste")}catch(firefoxException){return false}}};hterm.Terminal.prototype.copyStringToClipboard=function(str){if(this.prefs_.get("enable-clipboard-notice")){if(!this.clipboardNotice_){this.clipboardNotice_=this.document_.createElement("div");this.clipboardNotice_.style.textAlign="center";const copyImage=lib.resource.getData("hterm/images/copy");this.clipboardNotice_.innerHTML=hterm.sanitizeHtml(`${copyImage}<div>${hterm.msg("NOTIFY_COPY")}</div>`)}setTimeout(()=>this.showOverlay(this.clipboardNotice_,500),200)}hterm.copySelectionToClipboard(this.document_,str)};hterm.Terminal.prototype.displayImage=function(options,onLoad,onError){if(options.uri===undefined&&options.buffer===undefined&&options.blob===undefined){return}if(!options.name){options.name=""}if(!options.type){const ary=options.name.split(".");const ext=ary[ary.length-1].trim();switch(ext){case"svg":case"svgz":options.type="image/svg+xml";break}}if(this.allowImagesInline!==true){if(this.allowImagesInline===false){this.showOverlay(hterm.msg("POPUP_INLINE_IMAGE_DISABLED",[],"Inline Images Disabled"));return}let button;const span=this.document_.createElement("span");const label=this.document_.createElement("p");label.innerText=hterm.msg("POPUP_INLINE_IMAGE",[],"Inline Images");label.style.textAlign="center";span.appendChild(label);button=this.document_.createElement("input");button.type="button";button.value=hterm.msg("BUTTON_BLOCK",[],"block");button.addEventListener("click",()=>{this.prefs_.set("allow-images-inline",false);this.hideOverlay()});span.appendChild(button);span.appendChild(new Text(" "));button=this.document_.createElement("input");button.type="button";button.value=hterm.msg("BUTTON_ALLOW_SESSION",[],"allow this session");button.addEventListener("click",()=>{this.allowImagesInline=true;this.hideOverlay()});span.appendChild(button);span.appendChild(new Text(" "));button=this.document_.createElement("input");button.type="button";button.value=hterm.msg("BUTTON_ALLOW_ALWAYS",[],"always allow");button.addEventListener("click",()=>{this.prefs_.set("allow-images-inline",true);this.hideOverlay()});span.appendChild(button);this.showOverlay(span,null);return}if(options.inline){const io=this.io.push();io.showOverlay(hterm.msg("LOADING_RESOURCE_START",[options.name],"Loading $1 ..."));io.onVTKeystroke=io.sendString=()=>{};const img=this.document_.createElement("img");if(options.uri!==undefined){img.src=options.uri}else if(options.buffer!==undefined){const blob=new Blob([options.buffer],{type:options.type});img.src=URL.createObjectURL(blob)}else{const blob=new Blob([options.blob],{type:options.type});img.src=URL.createObjectURL(blob)}img.title=img.alt=options.name;this.document_.body.appendChild(img);img.onload=()=>{const screenSize=this.scrollPort_.getScreenSize();img.style.objectFit=options.preserveAspectRatio?"scale-down":"fill";img.style.maxWidth=`${screenSize.width}px`;img.style.maxHeight=`${screenSize.height}px`;const parseDim=(dim,maxDim,cssVar)=>{if(!dim||dim=="auto"){return""}const ary=dim.match(/^([0-9]+)(px|%)?$/);if(ary){if(ary[2]=="%"){return Math.floor(maxDim*ary[1]/100)+"px"}else if(ary[2]=="px"){return dim}else{return`calc(${dim} * var(${cssVar}))`}}return""};img.style.width=parseDim(options.width,screenSize.width,"--hterm-charsize-width");img.style.height=parseDim(options.height,screenSize.height,"--hterm-charsize-height");const padRows=Math.ceil(img.clientHeight/this.scrollPort_.characterSize.height);for(let i=0;i<padRows;++i){this.newLine()}img.style.maxHeight=`calc(${padRows} * var(--hterm-charsize-height))`;this.document_.body.removeChild(img);const div=this.document_.createElement("div");div.style.position="relative";div.style.textAlign=options.align||"";img.style.position="absolute";img.style.bottom="calc(0px - var(--hterm-charsize-height))";div.appendChild(img);const row=this.getRowNode(this.scrollbackRows_.length+this.getCursorRow()-1);row.appendChild(div);if(options.uri===undefined){URL.revokeObjectURL(img.src)}io.hideOverlay();io.pop();if(onLoad){onLoad()}};img.onerror=e=>{this.document_.body.removeChild(img);io.showOverlay(hterm.msg("LOADING_RESOURCE_FAILED",[options.name],"Loading $1 failed"));io.pop();if(onError){onError(e)}}}else{const a=this.document_.createElement("a");if(options.uri!==undefined){a.href=options.uri}else if(options.buffer!==undefined){const blob=new Blob([options.buffer]);a.href=URL.createObjectURL(blob)}else{a.href=URL.createObjectURL(lib.notNull(options.blob))}a.download=options.name;this.document_.body.appendChild(a);a.click();a.remove();if(options.uri===undefined){URL.revokeObjectURL(a.href)}}};hterm.Terminal.prototype.getSelectionText=function(){const selection=this.scrollPort_.selection;selection.sync();if(selection.isCollapsed){return null}let startOffset=selection.startOffset;let node=selection.startNode;if(!node){return null}if(node.nodeName!="X-ROW"){if(node.nodeName=="#text"&&node.parentNode.nodeName=="SPAN"){node=node.parentNode}while(node.previousSibling){node=node.previousSibling;startOffset+=hterm.TextAttributes.nodeWidth(node)}}let endOffset=hterm.TextAttributes.nodeWidth(lib.notNull(selection.endNode))-selection.endOffset;node=selection.endNode;if(node.nodeName!="X-ROW"){if(node.nodeName=="#text"&&node.parentNode.nodeName=="SPAN"){node=node.parentNode}while(node.nextSibling){node=node.nextSibling;endOffset+=hterm.TextAttributes.nodeWidth(node)}}const rv=this.getRowsText(selection.startRow.rowIndex,selection.endRow.rowIndex+1);return hterm.wc.substring(rv,startOffset,hterm.wc.strWidth(rv)-endOffset)};hterm.Terminal.prototype.copySelectionToClipboard=function(){const text=this.getSelectionText();if(text!=null){this.copyStringToClipboard(text)}};hterm.Terminal.prototype.overlaySize=function(){if(this.prefs_.get("enable-resize-status")){this.showOverlay(`${this.screenSize.width} × ${this.screenSize.height}`)}};hterm.Terminal.prototype.onVTKeystroke=function(string){if(this.scrollOnKeystroke_){this.scrollPort_.scrollRowToBottom(this.getRowCount())}this.pauseCursorBlink_();this.io.onVTKeystroke(string)};hterm.Terminal.prototype.openSelectedUrl_=function(){let str=this.getSelectionText();if(str==null){this.screen_.expandSelectionForUrl(this.document_.getSelection());str=this.getSelectionText();if(str==null){return}}if(str.length>2048||str.search(/[\s[\](){}<>"'\\^`]/)>=0){return}if(str.search("^[a-zA-Z][a-zA-Z0-9+.-]*://")<0){switch(str.split(":",1)[0]){case"mailto":break;default:str="http://"+str;break}}hterm.openUrl(str)};hterm.Terminal.prototype.setAutomaticMouseHiding=function(v=null){if(v===null){v=hterm.os!="cros"&&hterm.os!="mac"}this.mouseHideWhileTyping_=!!v};hterm.Terminal.prototype.onKeyboardActivity_=function(e){if(this.mouseHideWhileTyping_&&!this.mouseHideDelay_){this.setCssVar("mouse-cursor-style","none")}};hterm.Terminal.prototype.onMouse_=function(e){if(e.processedByTerminalHandler_){return}if(e.button>2){e.preventDefault()}const reportMouseEvents=!this.defeatMouseReports_&&this.vt.mouseReport!=this.vt.MOUSE_REPORT_DISABLED;e.processedByTerminalHandler_=true;if(this.mouseHideWhileTyping_&&!this.mouseHideDelay_){this.syncMouseStyle();this.mouseHideDelay_=setTimeout(()=>this.mouseHideDelay_=null,1e3)}const padding=this.scrollPort_.screenPaddingSize;e.terminalRow=Math.floor((e.clientY-this.scrollPort_.visibleRowTopMargin-padding)/this.scrollPort_.characterSize.height)+1;e.terminalColumn=Math.floor((e.clientX-padding)/this.scrollPort_.characterSize.width)+1;e.terminalRow=lib.f.clamp(e.terminalRow,1,this.screenSize.height);e.terminalColumn=lib.f.clamp(e.terminalColumn,1,this.screenSize.width);if(e.type=="mousedown"&&e.clientX>=this.scrollPort_.getScrollbarX()){return}if(this.options_.cursorVisible&&!reportMouseEvents&&!this.cursorOffScreen_){if(e.terminalRow-1==this.screen_.cursorPosition.row&&e.terminalColumn-1==this.screen_.cursorPosition.column){this.cursorNode_.style.display="none"}else if(this.cursorNode_.style.display=="none"){this.cursorNode_.style.display=""}}if(e.type=="mousedown"){this.contextMenu.hide();if(e.altKey||!reportMouseEvents){this.defeatMouseReports_=true;this.setSelectionEnabled(true)}else{this.defeatMouseReports_=false;this.document_.getSelection().collapseToEnd();this.setSelectionEnabled(false);e.preventDefault()}if(e.button===0){this.scrollPort_.selection.setAutoScrollEnabled(true)}}if(!reportMouseEvents){if(e.type=="dblclick"){this.screen_.expandSelection(this.document_.getSelection());if(this.copyOnSelect){this.copySelectionToClipboard()}}if(e.type=="click"&&!e.shiftKey&&(e.ctrlKey||e.metaKey)){if(e.target.className==="uri-node"){return}clearTimeout(this.timeouts_.openUrl);this.timeouts_.openUrl=setTimeout(this.openSelectedUrl_.bind(this),500);return}if(e.type=="mousedown"){if(e.ctrlKey&&e.button==2){e.preventDefault();this.contextMenu.show(e,this)}else if(e.button==this.mousePasteButton||this.mouseRightClickPaste&&e.button==2){if(this.paste()===false){console.warn("Could not paste manually due to web restrictions")}}}if(e.type=="mouseup"&&e.button==0&&this.copyOnSelect&&!this.document_.getSelection().isCollapsed){this.copySelectionToClipboard()}if((e.type=="mousemove"||e.type=="mouseup")&&this.scrollBlockerNode_.engaged){this.scrollBlockerNode_.engaged=false;this.scrollBlockerNode_.style.top="-99px"}if(this.scrollWheelArrowKeys_&&!e.shiftKey&&this.keyboard.applicationCursor&&!this.isPrimaryScreen()){if(e.type=="wheel"){const delta=this.scrollPort_.scrollWheelDelta(e);const deltaToArrows=(distance,charSize,arrowPos,arrowNeg)=>{if(distance==0){return""}const cells=lib.f.smartFloorDivide(Math.abs(distance),charSize);const data="O"+(distance<0?arrowNeg:arrowPos);return data.repeat(cells)};this.io.sendString(deltaToArrows(delta.y,this.scrollPort_.characterSize.height,"A","B")+deltaToArrows(delta.x,this.scrollPort_.characterSize.width,"C","D"));e.preventDefault()}}}else{if(!this.scrollBlockerNode_.engaged){if(e.type=="mousedown"){this.scrollBlockerNode_.engaged=true;this.scrollBlockerNode_.style.top=e.clientY-5+"px";this.scrollBlockerNode_.style.left=e.clientX-5+"px"}else if(e.type=="mousemove"){this.document_.getSelection().collapseToEnd();e.preventDefault()}}this.onMouse(e)}if(e.type=="mouseup"){if(this.document_.getSelection().isCollapsed){this.defeatMouseReports_=false}if(e.button===0){this.scrollPort_.selection.setAutoScrollEnabled(false)}}};hterm.Terminal.prototype.onMouse=function(e){};hterm.Terminal.prototype.onFocusChange_=function(focused){this.cursorNode_.setAttribute("focus",focused);this.restyleCursor_();if(this.reportFocus){this.io.sendString(focused===true?"[I":"[O")}if(focused===true){this.closeBellNotifications_()}};hterm.Terminal.prototype.onScroll_=function(){this.scheduleSyncCursorPosition_()};hterm.Terminal.prototype.onPaste_=function(e){this.onPasteData_(e.text)};hterm.Terminal.prototype.onPasteData_=function(data){data=data.replace(/\n/gm,"\r");if(this.options_.bracketedPaste){const filter=data=>data.replace(/[\x00-\x07\x0b-\x0c\x0e-\x1f]/g,"");data="[200~"+filter(data)+"[201~"}this.io.sendString(data)};hterm.Terminal.prototype.onCopy_=function(e){if(!this.useDefaultWindowCopy){e.preventDefault();setTimeout(this.copySelectionToClipboard.bind(this),0)}};hterm.Terminal.prototype.onResize_=function(){const columnCount=Math.floor(this.scrollPort_.getScreenWidth()/this.scrollPort_.characterSize.width)||0;const rowCount=lib.f.smartFloorDivide(this.scrollPort_.getScreenHeight(),this.scrollPort_.characterSize.height)||0;if(columnCount<=0||rowCount<=0){return}const isNewSize=columnCount!=this.screenSize.width||rowCount!=this.screenSize.height;const wasScrolledEnd=this.scrollPort_.isScrolledEnd;this.realizeSize_(columnCount,rowCount);this.updateCssCharsize_();if(isNewSize){this.overlaySize()}this.restyleCursor_();this.scheduleSyncCursorPosition_();if(wasScrolledEnd){this.scrollEnd()}};hterm.Terminal.prototype.onCursorBlink_=function(){if(!this.options_.cursorBlink){delete this.timeouts_.cursorBlink;return}if(this.cursorNode_.getAttribute("focus")=="false"||this.cursorNode_.style.opacity=="0"||this.cursorBlinkPause_){this.cursorNode_.style.opacity="1";this.timeouts_.cursorBlink=setTimeout(this.myOnCursorBlink_,this.cursorBlinkCycle_[0])}else{this.cursorNode_.style.opacity="0";this.timeouts_.cursorBlink=setTimeout(this.myOnCursorBlink_,this.cursorBlinkCycle_[1])}};hterm.Terminal.prototype.setScrollbarVisible=function(state){this.scrollPort_.setScrollbarVisible(state)};hterm.Terminal.prototype.setScrollWheelMoveMultipler=function(multiplier){this.scrollPort_.setScrollWheelMoveMultipler(multiplier)};hterm.Terminal.prototype.closeBellNotifications_=function(){this.bellNotificationList_.forEach(function(n){n.close()});this.bellNotificationList_.length=0};hterm.Terminal.prototype.onScrollportFocus_=function(){const topRowIndex=this.scrollPort_.getTopRowIndex();const bottomRowIndex=this.scrollPort_.getBottomRowIndex(topRowIndex);const selection=this.document_.getSelection();if(!this.syncCursorPosition_()&&selection){selection.collapse(this.getRowNode(bottomRowIndex))}};hterm.Terminal.prototype.onOpenOptionsPage=function(){};hterm.Terminal.prototype.onOpenOptionsPage_=function(){this.onOpenOptionsPage()};hterm.Terminal.prototype.onTmuxControlModeLine=function(line){};hterm.Terminal.IO=function(terminal){this.terminal_=terminal;this.previousIO_=null;this.buffered_="";this.textDecoder_=new TextDecoder};hterm.Terminal.IO.prototype.showOverlay=function(message,timeout=undefined){this.terminal_.showOverlay(message,timeout)};hterm.Terminal.IO.prototype.hideOverlay=function(){this.terminal_.hideOverlay()};hterm.Terminal.IO.prototype.createFrame=function(url,options=undefined){return new hterm.Frame(this.terminal_,url,options)};hterm.Terminal.IO.prototype.setTerminalProfile=function(profileName){this.terminal_.setProfile(profileName)};hterm.Terminal.IO.prototype.push=function(){const io=new this.constructor(this.terminal_);io.columnCount=this.columnCount;io.rowCount=this.rowCount;io.previousIO_=this.terminal_.io;this.terminal_.io=io;return io};hterm.Terminal.IO.prototype.pop=function(){this.terminal_.io=this.previousIO_;this.previousIO_.flush()};hterm.Terminal.IO.prototype.flush=function(){if(this.buffered_){this.terminal_.interpret(this.buffered_);this.buffered_=""}};hterm.Terminal.IO.prototype.sendString=function(string){console.log("Unhandled sendString: "+string)};hterm.Terminal.IO.prototype.onVTKeystroke=function(string){console.log("Unobserverd VT keystroke: "+JSON.stringify(string))};hterm.Terminal.IO.prototype.onTerminalResize_=function(width,height){let obj=this;while(obj){obj.columnCount=width;obj.rowCount=height;obj=obj.previousIO_}this.onTerminalResize(width,height)};hterm.Terminal.IO.prototype.onTerminalResize=function(width,height){};hterm.Terminal.IO.prototype.writeUTF8=function(buffer){const u8=new Uint8Array(buffer);const string=this.textDecoder_.decode(u8,{stream:true});this.print(string)};hterm.Terminal.IO.prototype.writelnUTF8=function(buffer){this.writeUTF8(buffer);this.writeUTF8([13,10])};hterm.Terminal.IO.prototype.print=hterm.Terminal.IO.prototype.writeUTF16=function(string){if(this.terminal_.io!=this){this.buffered_+=string;return}this.terminal_.interpret(string)};hterm.Terminal.IO.prototype.println=hterm.Terminal.IO.prototype.writelnUTF16=function(string){this.print(string+"\r\n")};hterm.TextAttributes=function(document){this.document_=document;this.foregroundSource=this.SRC_DEFAULT;this.backgroundSource=this.SRC_DEFAULT;this.underlineSource=this.SRC_DEFAULT;this.foreground=this.DEFAULT_COLOR;this.background=this.DEFAULT_COLOR;this.underlineColor=this.DEFAULT_COLOR;this.defaultForeground="rgb(var(--hterm-foreground-color))";this.defaultBackground="rgb(var(--hterm-background-color))";this.bold=false;this.faint=false;this.italic=false;this.blink=false;this.underline=false;this.strikethrough=false;this.inverse=false;this.invisible=false;this.wcNode=false;this.asciiNode=true;this.tileData=null;this.uri=null;this.uriId=null;this.colorPaletteOverrides=[]};hterm.TextAttributes.prototype.enableBold=true;hterm.TextAttributes.prototype.enableBoldAsBright=true;hterm.TextAttributes.prototype.DEFAULT_COLOR=Symbol("DEFAULT_COLOR");hterm.TextAttributes.prototype.SRC_DEFAULT=Symbol("SRC_DEFAULT");hterm.TextAttributes.prototype.setDocument=function(document){this.document_=document};hterm.TextAttributes.prototype.clone=function(){const rv=new hterm.TextAttributes;for(const key in this){rv[key]=this[key]}rv.colorPaletteOverrides=this.colorPaletteOverrides.concat();return rv};hterm.TextAttributes.prototype.reset=function(){this.foregroundSource=this.SRC_DEFAULT;this.backgroundSource=this.SRC_DEFAULT;this.underlineSource=this.SRC_DEFAULT;this.foreground=this.DEFAULT_COLOR;this.background=this.DEFAULT_COLOR;this.underlineColor=this.DEFAULT_COLOR;this.bold=false;this.faint=false;this.italic=false;this.blink=false;this.underline=false;this.strikethrough=false;this.inverse=false;this.invisible=false;this.wcNode=false;this.asciiNode=true;this.uri=null;this.uriId=null};hterm.TextAttributes.prototype.isDefault=function(){return this.foregroundSource==this.SRC_DEFAULT&&this.backgroundSource==this.SRC_DEFAULT&&!this.bold&&!this.faint&&!this.italic&&!this.blink&&!this.underline&&!this.strikethrough&&!this.inverse&&!this.invisible&&!this.wcNode&&this.asciiNode&&this.tileData==null&&this.uri==null};hterm.TextAttributes.prototype.createContainer=function(textContent=""){if(this.isDefault()){const node=this.document_.createTextNode(textContent);node.asciiNode=true;return node}const span=this.document_.createElement("span");const style=span.style;const classes=[];if(this.foreground!=this.DEFAULT_COLOR){style.color=this.foreground.toString()}if(this.background!=this.DEFAULT_COLOR){style.backgroundColor=this.background.toString();style.display="inline-block"}if(this.enableBold&&this.bold){style.fontWeight="bold"}if(this.faint){span.faint=true}if(this.italic){style.fontStyle="italic"}if(this.blink){classes.push("blink-node");span.blinkNode=true}let textDecorationLine="";span.underline=this.underline;if(this.underline){textDecorationLine+=" underline";style.textDecorationStyle=this.underline}if(this.underlineColor!=this.DEFAULT_COLOR){style.textDecorationColor=this.underlineColor}if(this.strikethrough){textDecorationLine+=" line-through";span.strikethrough=true}if(textDecorationLine){style.textDecorationLine=textDecorationLine}if(this.wcNode){classes.push("wc-node");span.wcNode=true}span.asciiNode=this.asciiNode;if(this.tileData!=null){classes.push("tile");classes.push("tile_"+this.tileData);span.tileNode=true}if(textContent){span.textContent=textContent}if(this.uri){classes.push("uri-node");span.uriId=this.uriId;span.title=this.uri;span.addEventListener("click",hterm.openUrl.bind(this,this.uri))}if(classes.length){span.className=classes.join(" ")}return span};hterm.TextAttributes.prototype.matchesContainer=function(obj){if(typeof obj=="string"||obj.nodeType==Node.TEXT_NODE){return this.isDefault()}const style=obj.style;return!(this.wcNode||obj.wcNode)&&this.asciiNode==obj.asciiNode&&!(this.tileData!=null||obj.tileNode)&&this.uriId==obj.uriId&&(this.foreground==this.DEFAULT_COLOR&&style.color=="")&&(this.background==this.DEFAULT_COLOR&&style.backgroundColor=="")&&(this.underlineColor==this.DEFAULT_COLOR&&style.textDecorationColor=="")&&(this.enableBold&&this.bold)==!!style.fontWeight&&this.blink==!!obj.blinkNode&&this.italic==!!style.fontStyle&&this.underline==obj.underline&&!!this.strikethrough==!!obj.strikethrough};hterm.TextAttributes.prototype.syncColors=function(){function getBrightIndex(i){if(i<8){return i+8}return i}const getDefaultColor=(color,defaultColor)=>{return color==this.DEFAULT_COLOR?defaultColor:color};if(this.enableBoldAsBright&&this.bold){if(typeof this.foregroundSource=="number"&&Number.isInteger(this.foregroundSource)){this.foregroundSource=getBrightIndex(this.foregroundSource)}}const colorFromSource=source=>{if(source==this.SRC_DEFAULT){return this.DEFAULT_COLOR}else if(typeof source=="number"&&Number.isInteger(source)){return`rgb(var(--hterm-color-${source}))`}else{return source.toString()}};this.foreground=colorFromSource(this.foregroundSource);if(this.faint){if(this.foreground==this.DEFAULT_COLOR){this.foreground="rgba(var(--hterm-foreground-color), 0.67)"}else if(typeof this.foregroundSource=="number"&&Number.isInteger(this.foregroundSource)){this.foreground=`rgba(var(--hterm-color-${this.foregroundSource}), 0.67)`}else{this.foreground=lib.colors.setAlpha(this.foreground.toString(),.67)}}this.background=colorFromSource(this.backgroundSource);if(this.inverse){const swp=getDefaultColor(this.foreground,this.defaultForeground);this.foreground=getDefaultColor(this.background,this.defaultBackground);this.background=swp}if(this.invisible){this.foreground=this.background}this.underlineColor=colorFromSource(this.underlineSource)};hterm.TextAttributes.containersMatch=function(obj1,obj2){if(typeof obj1=="string"){return hterm.TextAttributes.containerIsDefault(obj2)}if(obj1.nodeType!=obj2.nodeType){return false}if(obj1.nodeType==Node.TEXT_NODE){return true}const style1=obj1.style;const style2=obj2.style;return style1.color==style2.color&&style1.backgroundColor==style2.backgroundColor&&style1.backgroundColor==style2.backgroundColor&&style1.fontWeight==style2.fontWeight&&style1.fontStyle==style2.fontStyle&&style1.textDecoration==style2.textDecoration&&style1.textDecorationColor==style2.textDecorationColor&&style1.textDecorationStyle==style2.textDecorationStyle&&style1.textDecorationLine==style2.textDecorationLine};hterm.TextAttributes.containerIsDefault=function(obj){return typeof obj=="string"||obj.nodeType==Node.TEXT_NODE};hterm.TextAttributes.nodeWidth=function(node){if(!node.asciiNode){return hterm.wc.strWidth(node.textContent)}else{return node.textContent.length}};hterm.TextAttributes.nodeSubstr=function(node,start,width){if(!node.asciiNode){return hterm.wc.substr(node.textContent,start,width)}else{return node.textContent.substr(start,width)}};hterm.TextAttributes.nodeSubstring=function(node,start,end){if(!node.asciiNode){return hterm.wc.substring(node.textContent,start,end)}else{return node.textContent.substring(start,end)}};hterm.TextAttributes.splitWidecharString=function(str){const asciiRegex=new RegExp("^[ -]*$");if(asciiRegex.test(str)){return[{str:str,wcNode:false,asciiNode:true,wcStrWidth:str.length}]}const segmenter=new Intl.Segmenter(undefined,{type:"grapheme"});const it=segmenter.segment(str);const rv=[];for(const segment of it){const grapheme=segment.segment;const isAscii=asciiRegex.test(grapheme);const strWidth=isAscii?1:hterm.wc.strWidth(grapheme);const isWideChar=isAscii?false:hterm.wc.charWidth(grapheme.codePointAt(0))==2;const prev=rv[rv.length-1];if(prev&&!isWideChar&&!prev.wcNode){prev.str+=grapheme;prev.wcStrWidth+=strWidth;prev.asciiNode=prev.asciiNode&&isAscii}else{rv.push({str:grapheme,wcNode:isWideChar,asciiNode:isAscii,wcStrWidth:strWidth})}}return rv};hterm.VT=function(terminal){this.terminal=terminal;terminal.onMouse=this.onTerminalMouse_.bind(this);this.mouseReport=this.MOUSE_REPORT_DISABLED;this.mouseCoordinates=this.MOUSE_COORDINATES_X10;this.lastMouseDragResponse_=null;this.parseState_=new hterm.VT.ParseState(this.parseUnknown_);this.leadingModifier_="";this.trailingModifier_="";this.allowColumnWidthChanges_=false;this.oscTimeLimit_=2e4;this.enable8BitControl=false;this.enableClipboardWrite=true;this.enableDec12=false;this.enableCsiJ3=true;this.warnUnimplemented=false;this.characterMaps=new hterm.VT.CharacterMaps;this.G0=this.G1=this.G2=this.G3=this.characterMaps.getMap("B");this.GL="G0";this.GR="G0";this.codingSystemUtf8_=false;this.codingSystemLocked_=false;this.cc1Pattern_=null;this.updateEncodingState_()};hterm.VT.prototype.MOUSE_REPORT_DISABLED=0;hterm.VT.prototype.MOUSE_REPORT_PRESS=1;hterm.VT.prototype.MOUSE_REPORT_CLICK=2;hterm.VT.prototype.MOUSE_REPORT_DRAG=3;hterm.VT.prototype.MOUSE_COORDINATES_X10=0;hterm.VT.prototype.MOUSE_COORDINATES_UTF8=1;hterm.VT.prototype.MOUSE_COORDINATES_SGR=2;hterm.VT.ParseState=function(defaultFunction,buf=null){this.defaultFunction=defaultFunction;this.buf=buf;this.pos=0;this.func=defaultFunction;this.args=[];this.subargs=null};hterm.VT.ParseState.prototype.reset=function(buf=""){this.resetParseFunction();this.resetBuf(buf);this.resetArguments()};hterm.VT.ParseState.prototype.resetParseFunction=function(){this.func=this.defaultFunction};hterm.VT.ParseState.prototype.resetBuf=function(buf=null){this.buf=buf;this.pos=0};hterm.VT.ParseState.prototype.resetArguments=function(arg_zero=undefined){this.args.length=0;if(arg_zero!==undefined){this.args[0]=arg_zero}};hterm.VT.ParseState.prototype.parseInt=function(argstr,defaultValue){if(defaultValue===undefined){defaultValue=0}if(argstr){const ret=parseInt(argstr,10);return ret==0?defaultValue:ret}return defaultValue};hterm.VT.ParseState.prototype.iarg=function(argnum,defaultValue){return this.parseInt(this.args[argnum],defaultValue)};hterm.VT.ParseState.prototype.argHasSubargs=function(argnum){return!!(this.subargs&&this.subargs[argnum])};hterm.VT.ParseState.prototype.argSetSubargs=function(argnum){if(this.subargs===null){this.subargs={}}this.subargs[argnum]=true};hterm.VT.ParseState.prototype.advance=function(count){this.pos+=count};hterm.VT.ParseState.prototype.peekRemainingBuf=function(){return this.buf.substr(this.pos)};hterm.VT.ParseState.prototype.peekChar=function(){return this.buf.substr(this.pos,1)};hterm.VT.ParseState.prototype.consumeChar=function(){return this.buf.substr(this.pos++,1)};hterm.VT.ParseState.prototype.isComplete=function(){return this.buf==null||this.buf.length<=this.pos};hterm.VT.prototype.resetParseState=function(){this.parseState_.reset()};hterm.VT.prototype.reset=function(){this.G0=this.G1=this.G2=this.G3=this.characterMaps.getMap("B");this.GL="G0";this.GR="G0";this.mouseReport=this.MOUSE_REPORT_DISABLED;this.mouseCoordinates=this.MOUSE_COORDINATES_X10;this.lastMouseDragResponse_=null};hterm.VT.prototype.onTerminalMouse_=function(e){if(this.mouseReport==this.MOUSE_REPORT_DISABLED){return}else if(this.mouseReport!=this.MOUSE_REPORT_DRAG&&e.type=="mousemove"){return}let response;let mod=0;if(this.mouseReport!=this.MOUSE_REPORT_PRESS){if(e.shiftKey){mod|=4}if(e.metaKey||this.terminal.keyboard.altIsMeta&&e.altKey){mod|=8}if(e.ctrlKey){mod|=16}}let x;let y;let limit=127;switch(this.mouseCoordinates){case this.MOUSE_COORDINATES_UTF8:limit=2047;case this.MOUSE_COORDINATES_X10:x=String.fromCharCode(lib.f.clamp(e.terminalColumn+32,32,limit));y=String.fromCharCode(lib.f.clamp(e.terminalRow+32,32,limit));break;case this.MOUSE_COORDINATES_SGR:x=e.terminalColumn;y=e.terminalRow;break}let b;switch(e.type){case"wheel":b=(e.deltaY*-1>0?0:1)+64;b|=mod;if(this.mouseCoordinates==this.MOUSE_COORDINATES_SGR){response=`\x1b[<${b};${x};${y}M`}else{response="[M"+String.fromCharCode(b+32)+x+y}e.preventDefault();break;case"mousedown":b=Math.min(e.button,2);if(this.mouseCoordinates!=this.MOUSE_COORDINATES_SGR){b+=32}b|=mod;if(this.mouseCoordinates==this.MOUSE_COORDINATES_SGR){response=`\x1b[<${b};${x};${y}M`}else{response="[M"+String.fromCharCode(b)+x+y}break;case"mouseup":if(this.mouseReport!=this.MOUSE_REPORT_PRESS){if(this.mouseCoordinates==this.MOUSE_COORDINATES_SGR){response=`\x1b[<${e.button};${x};${y}m`}else{response="[M#"+x+y}}break;case"mousemove":if(this.mouseReport==this.MOUSE_REPORT_DRAG&&e.buttons){b=this.mouseCoordinates==this.MOUSE_COORDINATES_SGR?0:32;if(e.buttons&1){b+=0}else if(e.buttons&4){b+=1}else if(e.buttons&2){b+=2}else{b+=3}b+=32;b|=mod;if(this.mouseCoordinates==this.MOUSE_COORDINATES_SGR){response=`\x1b[<${b};${x};${y}M`}else{response="[M"+String.fromCharCode(b)+x+y}if(this.lastMouseDragResponse_==response){response=""}else{this.lastMouseDragResponse_=response}}break;case"click":case"dblclick":break;default:console.error("Unknown mouse event: "+e.type,e);break}if(response){this.terminal.io.sendString(response)}};hterm.VT.prototype.interpret=function(buf){this.parseState_.resetBuf(buf);while(!this.parseState_.isComplete()){const func=this.parseState_.func;const pos=this.parseState_.pos;const buf=this.parseState_.buf;this.parseState_.func.call(this,this.parseState_);if(this.parseState_.func==func&&this.parseState_.pos==pos&&this.parseState_.buf==buf){throw new Error("Parser did not alter the state!")}}};hterm.VT.prototype.setEncoding=function(encoding){switch(encoding){default:console.warn('Invalid value for "terminal-encoding": '+encoding);case"iso-2022":this.codingSystemUtf8_=false;this.codingSystemLocked_=false;break;case"utf-8-locked":this.codingSystemUtf8_=true;this.codingSystemLocked_=true;break;case"utf-8":this.codingSystemUtf8_=true;this.codingSystemLocked_=false;break}this.updateEncodingState_()};hterm.VT.prototype.updateEncodingState_=function(){const cc1=Object.keys(hterm.VT.CC1).filter(e=>!this.codingSystemUtf8_||e.charCodeAt()<128).map(e=>"\\x"+lib.f.zpad(e.charCodeAt().toString(16),2)).join("");this.cc1Pattern_=new RegExp(`[${cc1}]`)};hterm.VT.prototype.parseUnknown_=function(parseState){const print=str=>{if(!this.codingSystemUtf8_&&this[this.GL].GL){str=this[this.GL].GL(str)}this.terminal.print(str)};const buf=parseState.peekRemainingBuf();const nextControl=buf.search(this.cc1Pattern_);if(nextControl==0){this.dispatch("CC1",buf.substr(0,1),parseState);parseState.advance(1);return}if(nextControl==-1){print(buf);parseState.reset();return}print(buf.substr(0,nextControl));this.dispatch("CC1",buf.substr(nextControl,1),parseState);parseState.advance(nextControl+1)};hterm.VT.prototype.parseCSI_=function(parseState){const ch=parseState.peekChar();const args=parseState.args;const finishParsing=()=>{parseState.resetArguments();parseState.subargs=null;parseState.resetParseFunction()};if(ch>="@"&&ch<="~"){this.dispatch("CSI",this.leadingModifier_+this.trailingModifier_+ch,parseState);finishParsing()}else if(ch==";"){if(this.trailingModifier_){finishParsing()}else{if(!args.length){args.push("")}args.push("")}}else if(ch>="0"&&ch<="9"||ch==":"){if(this.trailingModifier_){finishParsing()}else{if(!args.length){args[0]=ch}else{args[args.length-1]+=ch}if(ch==":"){parseState.argSetSubargs(args.length-1)}}}else if(ch>=" "&&ch<="?"){if(!args.length){this.leadingModifier_+=ch}else{this.trailingModifier_+=ch}}else if(this.cc1Pattern_.test(ch)){this.dispatch("CC1",ch,parseState)}else{finishParsing()}parseState.advance(1)};hterm.VT.prototype.parseDCS_=function(parseState){const ch=parseState.peekChar();const args=parseState.args;const finishParsing=()=>{parseState.resetArguments();parseState.resetParseFunction()};if(ch>="@"&&ch<="~"){parseState.advance(1);this.dispatch("DCS",this.leadingModifier_+this.trailingModifier_+ch,parseState);if(parseState.func===this.parseDCS_){parseState.func=this.parseUntilStringTerminator_}return}else if(ch===";"){if(this.trailingModifier_){finishParsing()}else{if(!args.length){args.push("")}args.push("")}}else if(ch>="0"&&ch<="9"){if(this.trailingModifier_){finishParsing()}else{if(!args.length){args[0]=ch}else{args[args.length-1]+=ch}}}else if(ch>=" "&&ch<="?"){if(!args.length){this.leadingModifier_+=ch}else{this.trailingModifier_+=ch}}else if(this.cc1Pattern_.test(ch)){this.dispatch("CC1",ch,parseState)}else{finishParsing()}parseState.advance(1)};hterm.VT.prototype.parseTmuxControlModeData_=function(parseState){const args=parseState.args;if(!args.length){args[0]=""}while(true){const args0InitialLength=args[0].length;const buf=args[0]+parseState.peekRemainingBuf();args[0]="";const index=buf.search(/\x1b\\|\r\n/);if(index===-1){parseState.args[0]=buf;parseState.resetBuf();return}const data=buf.slice(0,index);parseState.advance(index+2-args0InitialLength);if(buf[index]===""){if(data){console.error(`unexpected data before ST: ${data}`)}this.terminal.onTmuxControlModeLine(null);parseState.resetArguments();parseState.resetParseFunction();return}this.terminal.onTmuxControlModeLine(data)}};hterm.VT.prototype.parseUntilStringTerminator_=function(parseState){let buf=parseState.peekRemainingBuf();const args=parseState.args;let bufInserted=0;if(!args.length){args[0]="";args[1]=(new Date).getTime()}else{if(args[0].slice(-1)==""){args[0]=args[0].slice(0,-1);buf=""+buf;bufInserted=1}}const nextTerminator=buf.search(/[\x1b\x07]/);const terminator=buf[nextTerminator];let foundTerminator;if(terminator==""&&buf[nextTerminator+1]!="\\"){foundTerminator=false}else{foundTerminator=nextTerminator!=-1}if(!foundTerminator){args[0]+=buf;let abortReason;if(terminator==""&&nextTerminator!=buf.length-1){abortReason="embedded escape: "+nextTerminator}const elapsedTime=(new Date).getTime()-args[1];if(elapsedTime>this.oscTimeLimit_){abortReason=`timeout expired: ${elapsedTime}s`}if(abortReason){if(this.warnUnimplemented){console.log("parseUntilStringTerminator_: aborting: "+abortReason,args[0])}parseState.reset(args[0]);return false}parseState.advance(buf.length-bufInserted);return true}args[0]+=buf.substr(0,nextTerminator);parseState.resetParseFunction();parseState.advance(nextTerminator+(terminator==""?2:1)-bufInserted);return true};hterm.VT.prototype.dispatch=function(type,code,parseState){const handler=hterm.VT[type][code];if(!handler){if(this.warnUnimplemented){console.warn(`Unknown ${type} code: ${JSON.stringify(code)}`)}return}if(handler==hterm.VT.ignore){if(this.warnUnimplemented){console.warn(`Ignored ${type} code: ${JSON.stringify(code)}`)}return}if(parseState.subargs&&!handler.supportsSubargs){if(this.warnUnimplemented){console.warn(`Ignored ${type} code w/subargs: ${JSON.stringify(code)}`)}return}if(type=="CC1"&&code>""&&!this.enable8BitControl){console.warn("Ignoring 8-bit control code: 0x"+code.charCodeAt(0).toString(16));return}handler.apply(this,[parseState,code])};hterm.VT.prototype.setANSIMode=function(code,state){if(code==4){this.terminal.setInsertMode(state)}else if(code==20){this.terminal.setAutoCarriageReturn(state)}else if(this.warnUnimplemented){console.warn("Unimplemented ANSI Mode: "+code)}};hterm.VT.prototype.setDECMode=function(code,state){switch(parseInt(code,10)){case 1:this.terminal.keyboard.applicationCursor=state;break;case 3:if(this.allowColumnWidthChanges_){this.terminal.setWidth(state?132:80);this.terminal.clearHome();this.terminal.setVTScrollRegion(null,null)}break;case 5:this.terminal.setReverseVideo(state);break;case 6:this.terminal.setOriginMode(state);break;case 7:this.terminal.setWraparound(state);break;case 9:this.mouseReport=state?this.MOUSE_REPORT_PRESS:this.MOUSE_REPORT_DISABLED;this.terminal.syncMouseStyle();break;case 12:if(this.enableDec12){this.terminal.setCursorBlink(state)}break;case 25:this.terminal.setCursorVisible(state);break;case 30:this.terminal.setScrollbarVisible(state);break;case 40:this.terminal.allowColumnWidthChanges_=state;break;case 45:this.terminal.setReverseWraparound(state);break;case 67:this.terminal.keyboard.backspaceSendsBackspace=state;break;case 1e3:this.mouseReport=state?this.MOUSE_REPORT_CLICK:this.MOUSE_REPORT_DISABLED;this.terminal.syncMouseStyle();break;case 1002:this.mouseReport=state?this.MOUSE_REPORT_DRAG:this.MOUSE_REPORT_DISABLED;this.terminal.syncMouseStyle();break;case 1004:this.terminal.reportFocus=state;break;case 1005:this.mouseCoordinates=state?this.MOUSE_COORDINATES_UTF8:this.MOUSE_COORDINATES_X10;break;case 1006:this.mouseCoordinates=state?this.MOUSE_COORDINATES_SGR:this.MOUSE_COORDINATES_X10;break;case 1007:this.terminal.scrollWheelArrowKeys_=state;break;case 1010:this.terminal.scrollOnOutput=state;break;case 1011:this.terminal.scrollOnKeystroke=state;break;case 1036:this.terminal.keyboard.metaSendsEscape=state;break;case 1039:if(state){if(!this.terminal.keyboard.previousAltSendsWhat_){this.terminal.keyboard.previousAltSendsWhat_=this.terminal.keyboard.altSendsWhat;this.terminal.keyboard.altSendsWhat="escape"}}else if(this.terminal.keyboard.previousAltSendsWhat_){this.terminal.keyboard.altSendsWhat=this.terminal.keyboard.previousAltSendsWhat_;this.terminal.keyboard.previousAltSendsWhat_=null}break;case 47:case 1047:this.terminal.setAlternateMode(state);break;case 1048:if(state){this.terminal.saveCursorAndState()}else{this.terminal.restoreCursorAndState()}break;case 1049:if(state){this.terminal.saveCursorAndState();this.terminal.setAlternateMode(state);this.terminal.clear()}else{this.terminal.setAlternateMode(state);this.terminal.restoreCursorAndState()}break;case 2004:this.terminal.setBracketedPaste(state);break;default:if(this.warnUnimplemented){console.warn("Unimplemented DEC Private Mode: "+code)}break}};hterm.VT.ignore=function(){};hterm.VT.CC1={};hterm.VT.ESC={};hterm.VT.CSI={};hterm.VT.DCS={};hterm.VT.OSC={};hterm.VT.VT52={};hterm.VT.CC1["\0"]=hterm.VT.ignore;hterm.VT.CC1[""]=hterm.VT.ignore;hterm.VT.CC1[""]=function(){this.terminal.ringBell()};hterm.VT.CC1["\b"]=function(){this.terminal.cursorLeft(1)};hterm.VT.CC1["\t"]=function(){this.terminal.forwardTabStop()};hterm.VT.CC1["\n"]=function(){this.terminal.formFeed()};hterm.VT.CC1["\v"]=hterm.VT.CC1["\n"];hterm.VT.CC1["\f"]=hterm.VT.CC1["\n"];hterm.VT.CC1["\r"]=function(){this.terminal.setCursorColumn(0)};hterm.VT.CC1[""]=function(){this.GL="G1"};hterm.VT.CC1[""]=function(){this.GL="G0"};hterm.VT.CC1[""]=hterm.VT.ignore;hterm.VT.CC1[""]=hterm.VT.ignore;hterm.VT.CC1[""]=function(parseState){if(this.GL=="G1"){this.GL="G0"}parseState.resetParseFunction();this.terminal.print("?")};hterm.VT.CC1[""]=hterm.VT.CC1[""];hterm.VT.CC1[""]=function(parseState){function parseESC(parseState){const ch=parseState.consumeChar();if(ch==""){return}this.dispatch("ESC",ch,parseState);if(parseState.func==parseESC){parseState.resetParseFunction()}}parseState.func=parseESC};hterm.VT.CC1[""]=hterm.VT.ignore;hterm.VT.CC1[""]=hterm.VT.ESC["D"]=function(){this.terminal.lineFeed()};hterm.VT.CC1[""]=hterm.VT.ESC["E"]=function(){this.terminal.setCursorColumn(0);this.terminal.cursorDown(1)};hterm.VT.CC1[""]=hterm.VT.ESC["H"]=function(){this.terminal.setTabStop(this.terminal.getCursorColumn())};hterm.VT.CC1[""]=hterm.VT.ESC["M"]=function(){this.terminal.reverseLineFeed()};hterm.VT.CC1[""]=hterm.VT.ESC["N"]=hterm.VT.ignore;hterm.VT.CC1[""]=hterm.VT.ESC["O"]=hterm.VT.ignore;hterm.VT.CC1[""]=hterm.VT.ESC["P"]=function(parseState){parseState.resetArguments();this.leadingModifier_="";this.trailingModifier_="";parseState.func=this.parseDCS_};hterm.VT.CC1[""]=hterm.VT.ESC["V"]=hterm.VT.ignore;hterm.VT.CC1[""]=hterm.VT.ESC["W"]=hterm.VT.ignore;hterm.VT.CC1[""]=hterm.VT.ESC["X"]=hterm.VT.ignore;hterm.VT.CC1[""]=hterm.VT.ESC["Z"]=function(){this.terminal.io.sendString("[?1;2c")};hterm.VT.CC1[""]=hterm.VT.ESC["["]=function(parseState){parseState.resetArguments();this.leadingModifier_="";this.trailingModifier_="";parseState.func=this.parseCSI_};hterm.VT.CC1[""]=hterm.VT.ESC["\\"]=hterm.VT.ignore;hterm.VT.CC1[""]=hterm.VT.ESC["]"]=function(parseState){parseState.resetArguments();function parseOSC(parseState){if(!this.parseUntilStringTerminator_(parseState)){return}if(parseState.func==parseOSC){return}const ary=parseState.args[0].match(/^(\d+);?(.*)$/);if(ary){parseState.args[0]=ary[2];this.dispatch("OSC",ary[1],parseState)}else{console.warn("Invalid OSC: "+JSON.stringify(parseState.args[0]))}parseState.resetArguments()}parseState.func=parseOSC};hterm.VT.CC1[""]=hterm.VT.ESC["^"]=function(parseState){parseState.resetArguments();parseState.func=this.parseUntilStringTerminator_};hterm.VT.CC1[""]=hterm.VT.ESC["_"]=function(parseState){parseState.resetArguments();parseState.func=this.parseUntilStringTerminator_};hterm.VT.ESC[" "]=function(parseState){parseState.func=function(parseState){const ch=parseState.consumeChar();if(this.warnUnimplemented){console.warn("Unimplemented sequence: ESC 0x20 "+ch)}parseState.resetParseFunction()}};hterm.VT.ESC["#"]=function(parseState){parseState.func=function(parseState){const ch=parseState.consumeChar();if(ch=="8"){this.terminal.setCursorPosition(0,0);this.terminal.fill("E")}parseState.resetParseFunction()}};hterm.VT.ESC["%"]=function(parseState){parseState.func=function(parseState){let ch=parseState.consumeChar();if(this.codingSystemLocked_){if(ch=="/"){parseState.consumeChar()}parseState.resetParseFunction();return}switch(ch){case"@":this.setEncoding("iso-2022");break;case"G":this.setEncoding("utf-8");break;case"/":ch=parseState.consumeChar();switch(ch){case"G":case"H":case"I":this.setEncoding("utf-8-locked");break;default:if(this.warnUnimplemented){console.warn("Unknown ESC % / argument: "+JSON.stringify(ch))}break}break;default:if(this.warnUnimplemented){console.warn("Unknown ESC % argument: "+JSON.stringify(ch))}break}parseState.resetParseFunction()}};hterm.VT.ESC["("]=hterm.VT.ESC[")"]=hterm.VT.ESC["*"]=hterm.VT.ESC["+"]=hterm.VT.ESC["-"]=hterm.VT.ESC["."]=hterm.VT.ESC["/"]=function(parseState,code){parseState.func=function(parseState){if(parseState.peekChar()===""){parseState.resetParseFunction();return}const ch=parseState.consumeChar();const map=this.characterMaps.getMap(ch);if(map!==undefined){if(code=="("){this.G0=map}else if(code==")"||code=="-"){this.G1=map}else if(code=="*"||code=="."){this.G2=map}else if(code=="+"||code=="/"){this.G3=map}}else if(this.warnUnimplemented){console.log('Invalid character set for "'+code+'": '+ch)}parseState.resetParseFunction()}};hterm.VT.ESC["6"]=hterm.VT.ignore;hterm.VT.ESC["7"]=function(){this.terminal.saveCursorAndState()};hterm.VT.ESC["8"]=function(){this.terminal.restoreCursorAndState()};hterm.VT.ESC["9"]=hterm.VT.ignore;hterm.VT.ESC["="]=function(){this.terminal.keyboard.applicationKeypad=true};hterm.VT.ESC[">"]=function(){this.terminal.keyboard.applicationKeypad=false};hterm.VT.ESC["F"]=hterm.VT.ignore;hterm.VT.ESC["c"]=function(){this.terminal.reset()};hterm.VT.ESC["k"]=function(parseState){function parse(parseState){if(!this.parseUntilStringTerminator_(parseState)){return}if(parseState.func===parse){return}this.terminal.setWindowName(parseState.args[0]);parseState.resetArguments()}parseState.resetArguments();parseState.func=parse};hterm.VT.ESC["l"]=hterm.VT.ESC["m"]=hterm.VT.ignore;hterm.VT.ESC["n"]=function(){this.GL="G2"};hterm.VT.ESC["o"]=function(){this.GL="G3"};hterm.VT.ESC["|"]=function(){this.GR="G3"};hterm.VT.ESC["}"]=function(){this.GR="G2"};hterm.VT.ESC["~"]=function(){this.GR="G1"};hterm.VT.DCS["p"]=function(parseState){if(parseState.args.length===1&&parseState.args[0]==="1000"){parseState.resetArguments();parseState.func=this.parseTmuxControlModeData_}};hterm.VT.OSC["0"]=function(parseState){this.terminal.setWindowTitle(parseState.args[0])};hterm.VT.OSC["2"]=hterm.VT.OSC["0"];hterm.VT.OSC["4"]=function(parseState){const args=parseState.args[0].split(";");const pairCount=Math.floor(args.length/2);const responseArray=[];for(let pairNumber=0;pairNumber<pairCount;++pairNumber){const colorIndex=parseInt(args[pairNumber*2],10);let colorValue=args[pairNumber*2+1];if(colorIndex>=lib.colors.stockPalette.length){continue}if(colorValue=="?"){colorValue=lib.colors.rgbToX11(this.terminal.getColorPalette(colorIndex));if(colorValue){responseArray.push(colorIndex+";"+colorValue)}continue}colorValue=lib.colors.x11ToCSS(colorValue);if(colorValue){this.terminal.setColorPalette(colorIndex,colorValue)}}if(responseArray.length){this.terminal.io.sendString("]4;"+responseArray.join(";")+"")}};hterm.VT.OSC["8"]=function(parseState){const args=parseState.args[0].split(";");let id=null;let uri=null;if(args.length!=2||args[1].length==0){}else{const params=args[0].split(":");id="";params.forEach(param=>{const idx=param.indexOf("=");if(idx==-1){return}const key=param.slice(0,idx);const value=param.slice(idx+1);switch(key){case"id":id=value;break;default:break}});uri=args[1]}const attrs=this.terminal.getTextAttributes();attrs.uri=uri;attrs.uriId=id};hterm.VT.OSC["9"]=function(parseState){hterm.notify({body:parseState.args[0]})};hterm.VT.OSC["10"]=function(parseState){const args=parseState.args[0].split(";");if(!args){return}const colorX11=lib.colors.x11ToCSS(args.shift());if(colorX11){this.terminal.setForegroundColor(colorX11)}if(args.length>0){parseState.args[0]=args.join(";");hterm.VT.OSC["11"].apply(this,[parseState])}};hterm.VT.OSC["11"]=function(parseState){const args=parseState.args[0].split(";");if(!args){return}const colorX11=lib.colors.x11ToCSS(args.shift());if(colorX11){this.terminal.setBackgroundColor(colorX11)}if(args.length>0){parseState.args[0]=args.join(";");hterm.VT.OSC["12"].apply(this,[parseState])}};hterm.VT.OSC["12"]=function(parseState){const args=parseState.args[0].split(";");if(!args){return}const colorX11=lib.colors.x11ToCSS(args.shift());if(colorX11){this.terminal.setCursorColor(colorX11)}};hterm.VT.OSC["50"]=function(parseState){const args=parseState.args[0].match(/CursorShape=(.)/i);if(!args){console.warn("Could not parse OSC 50 args: "+parseState.args[0]);return}switch(args[1]){case"1":this.terminal.setCursorShape(hterm.Terminal.cursorShape.BEAM);break;case"2":this.terminal.setCursorShape(hterm.Terminal.cursorShape.UNDERLINE);break;default:this.terminal.setCursorShape(hterm.Terminal.cursorShape.BLOCK)}};hterm.VT.OSC["52"]=function(parseState){if(!this.enableClipboardWrite){return}const args=parseState.args[0].match(/^[cps01234567]*;(.*)/);if(!args){return}let data;try{data=globalThis.atob(args[1])}catch(e){return}const decoder=new TextDecoder;const bytes=lib.codec.stringToCodeUnitArray(data);data=decoder.decode(bytes);if(data){this.terminal.copyStringToClipboard(data)}};hterm.VT.OSC["104"]=function(parseState){if(!parseState.args[0]){this.terminal.resetColorPalette();return}const args=parseState.args[0].split(";");args.forEach(c=>this.terminal.resetColor(c))};hterm.VT.OSC["110"]=function(parseState){this.terminal.setForegroundColor()};hterm.VT.OSC["111"]=function(parseState){this.terminal.setBackgroundColor()};hterm.VT.OSC["112"]=function(parseState){this.terminal.setCursorColor()};hterm.VT.OSC["1337"]=function(parseState){const args=parseState.args[0].match(/^File=([^:]*):([\s\S]*)$/m);if(!args){if(this.warnUnimplemented){console.log(`iTerm2 1337: unsupported sequence: ${args[1]}`)}return}const options={name:"",size:0,preserveAspectRatio:true,inline:false,width:"auto",height:"auto",align:"left",type:"",buffer:lib.codec.stringToCodeUnitArray(atob(args[2])).buffer};args[1].split(";").forEach(ele=>{const kv=ele.match(/^([^=]+)=(.*)$/m);if(!kv){return}switch(kv[1]){case"name":try{options.name=globalThis.atob(kv[2])}catch(e){}break;case"size":try{options.size=parseInt(kv[2],10)}catch(e){}break;case"width":options.width=kv[2];break;case"height":options.height=kv[2];break;case"preserveAspectRatio":options.preserveAspectRatio=!(kv[2]=="0");break;case"inline":options.inline=!(kv[2]=="0");break;case"align":options.align=kv[2];break;case"type":options.type=kv[2];break;default:break}});if(options.inline){const io=this.terminal.io;const queued=parseState.peekRemainingBuf();parseState.advance(queued.length);this.terminal.displayImage(options);io.print(queued)}else{this.terminal.displayImage(options)}};hterm.VT.OSC["777"]=function(parseState){let ary;const urxvtMod=parseState.args[0].split(";",1)[0];switch(urxvtMod){case"notify":{let title;let message;ary=parseState.args[0].match(/^[^;]+;([^;]*)(;([\s\S]*))?$/);if(ary){title=ary[1];message=ary[3]}hterm.notify({title:title,body:message});break}default:console.warn("Unknown urxvt module: "+parseState.args[0]);break}};hterm.VT.CSI["@"]=function(parseState){this.terminal.insertSpace(parseState.iarg(0,1))};hterm.VT.CSI["A"]=function(parseState){this.terminal.cursorUp(parseState.iarg(0,1))};hterm.VT.CSI["B"]=function(parseState){this.terminal.cursorDown(parseState.iarg(0,1))};hterm.VT.CSI["C"]=function(parseState){this.terminal.cursorRight(parseState.iarg(0,1))};hterm.VT.CSI["D"]=function(parseState){this.terminal.cursorLeft(parseState.iarg(0,1))};hterm.VT.CSI["E"]=function(parseState){this.terminal.cursorDown(parseState.iarg(0,1));this.terminal.setCursorColumn(0)};hterm.VT.CSI["F"]=function(parseState){this.terminal.cursorUp(parseState.iarg(0,1));this.terminal.setCursorColumn(0)};hterm.VT.CSI["G"]=function(parseState){this.terminal.setCursorColumn(parseState.iarg(0,1)-1)};hterm.VT.CSI["H"]=function(parseState){this.terminal.setCursorPosition(parseState.iarg(0,1)-1,parseState.iarg(1,1)-1)};hterm.VT.CSI["I"]=function(parseState){let count=parseState.iarg(0,1);count=lib.f.clamp(count,1,this.terminal.screenSize.width);for(let i=0;i<count;i++){this.terminal.forwardTabStop()}};hterm.VT.CSI["J"]=hterm.VT.CSI["?J"]=function(parseState){const arg=parseState.args[0];if(!arg||arg==0){this.terminal.eraseBelow()}else if(arg==1){this.terminal.eraseAbove()}else if(arg==2){this.terminal.clear()}else if(arg==3){if(this.enableCsiJ3){this.terminal.clearScrollback()}}};hterm.VT.CSI["K"]=hterm.VT.CSI["?K"]=function(parseState){const arg=parseState.args[0];if(!arg||arg==0){this.terminal.eraseToRight()}else if(arg==1){this.terminal.eraseToLeft()}else if(arg==2){this.terminal.eraseLine()}};hterm.VT.CSI["L"]=function(parseState){this.terminal.insertLines(parseState.iarg(0,1))};hterm.VT.CSI["M"]=function(parseState){this.terminal.deleteLines(parseState.iarg(0,1))};hterm.VT.CSI["P"]=function(parseState){this.terminal.deleteChars(parseState.iarg(0,1))};hterm.VT.CSI["S"]=function(parseState){this.terminal.vtScrollUp(parseState.iarg(0,1))};hterm.VT.CSI["T"]=function(parseState){if(parseState.args.length<=1){this.terminal.vtScrollDown(parseState.iarg(0,1))}};hterm.VT.CSI[">T"]=hterm.VT.ignore;hterm.VT.CSI["X"]=function(parseState){this.terminal.eraseToRight(parseState.iarg(0,1))};hterm.VT.CSI["Z"]=function(parseState){let count=parseState.iarg(0,1);count=lib.f.clamp(count,1,this.terminal.screenSize.width);for(let i=0;i<count;i++){this.terminal.backwardTabStop()}};hterm.VT.CSI["`"]=hterm.VT.CSI["G"];hterm.VT.CSI["a"]=function(parseState){this.terminal.setCursorColumn(this.terminal.getCursorColumn()+parseState.iarg(0,1))};hterm.VT.CSI["b"]=hterm.VT.ignore;hterm.VT.CSI["c"]=function(parseState){if(!parseState.args[0]||parseState.args[0]==0){this.terminal.io.sendString("[?1;2c")}};hterm.VT.CSI[">c"]=function(parseState){this.terminal.io.sendString("[>0;256;0c")};hterm.VT.CSI["d"]=function(parseState){this.terminal.setAbsoluteCursorRow(parseState.iarg(0,1)-1)};hterm.VT.CSI["f"]=hterm.VT.CSI["H"];hterm.VT.CSI["g"]=function(parseState){if(!parseState.args[0]||parseState.args[0]==0){this.terminal.clearTabStopAtCursor()}else if(parseState.args[0]==3){this.terminal.clearAllTabStops()}};hterm.VT.CSI["h"]=function(parseState){for(let i=0;i<parseState.args.length;i++){this.setANSIMode(parseState.args[i],true)}};hterm.VT.CSI["?h"]=function(parseState){for(let i=0;i<parseState.args.length;i++){this.setDECMode(parseState.args[i],true)}};hterm.VT.CSI["i"]=hterm.VT.CSI["?i"]=hterm.VT.ignore;hterm.VT.CSI["l"]=function(parseState){for(let i=0;i<parseState.args.length;i++){this.setANSIMode(parseState.args[i],false)}};hterm.VT.CSI["?l"]=function(parseState){for(let i=0;i<parseState.args.length;i++){this.setDECMode(parseState.args[i],false)}};hterm.VT.prototype.parseSgrExtendedColors=function(parseState,i,attrs){let ary;let usedSubargs;if(parseState.argHasSubargs(i)){ary=parseState.args[i].split(":");ary.shift();usedSubargs=true}else if(parseState.argHasSubargs(i+1)){return{skipCount:0}}else{ary=parseState.args.slice(i+1);usedSubargs=false}switch(parseInt(ary[0],10)){default:case 0:return{skipCount:0};case 1:{if(!usedSubargs){return{skipCount:0}}return{color:"rgba(0, 0, 0, 0)",skipCount:0}}case 2:{let start;if(usedSubargs){if(ary.length==4){start=1}else{start=2}}else{start=1}if(ary.length<start+3){return{skipCount:0}}const r=parseState.parseInt(ary[start+0]);const g=parseState.parseInt(ary[start+1]);const b=parseState.parseInt(ary[start+2]);return{color:`rgb(${r}, ${g}, ${b})`,skipCount:usedSubargs?0:4}}case 3:{if(!usedSubargs){return{skipCount:0}}if(ary.length<4){return{skipCount:0}}return{skipCount:0}}case 4:{if(!usedSubargs){return{skipCount:0}}if(ary.length<5){return{skipCount:0}}return{skipCount:0}}case 5:{if(ary.length<2){return{skipCount:0}}const ret={skipCount:usedSubargs?0:2};const color=parseState.parseInt(ary[1]);if(color<lib.colors.stockPalette.length){ret.color=color}return ret}}};hterm.VT.CSI["m"]=function(parseState){const attrs=this.terminal.getTextAttributes();if(!parseState.args.length){attrs.reset();return}for(let i=0;i<parseState.args.length;i++){const arg=parseState.iarg(i,0);if(arg<30){if(arg==0){attrs.reset()}else if(arg==1){attrs.bold=true}else if(arg==2){attrs.faint=true}else if(arg==3){attrs.italic=true}else if(arg==4){if(parseState.argHasSubargs(i)){const uarg=parseState.args[i].split(":")[1];if(uarg==0){attrs.underline=false}else if(uarg==1){attrs.underline="solid"}else if(uarg==2){attrs.underline="double"}else if(uarg==3){attrs.underline="wavy"}else if(uarg==4){attrs.underline="dotted"}else if(uarg==5){attrs.underline="dashed"}}else{attrs.underline="solid"}}else if(arg==5){attrs.blink=true}else if(arg==7){attrs.inverse=true}else if(arg==8){attrs.invisible=true}else if(arg==9){attrs.strikethrough=true}else if(arg==21){attrs.underline="double"}else if(arg==22){attrs.bold=false;attrs.faint=false}else if(arg==23){attrs.italic=false}else if(arg==24){attrs.underline=false}else if(arg==25){attrs.blink=false}else if(arg==27){attrs.inverse=false}else if(arg==28){attrs.invisible=false}else if(arg==29){attrs.strikethrough=false}}else if(arg<50){if(arg<38){attrs.foregroundSource=arg-30}else if(arg==38){const result=this.parseSgrExtendedColors(parseState,i,attrs);if(result.color!==undefined){attrs.foregroundSource=result.color}i+=result.skipCount}else if(arg==39){attrs.foregroundSource=attrs.SRC_DEFAULT}else if(arg<48){attrs.backgroundSource=arg-40}else if(arg==48){const result=this.parseSgrExtendedColors(parseState,i,attrs);if(result.color!==undefined){attrs.backgroundSource=result.color}i+=result.skipCount}else{attrs.backgroundSource=attrs.SRC_DEFAULT}}else if(arg==58){const result=this.parseSgrExtendedColors(parseState,i,attrs);if(result.color!==undefined){attrs.underlineSource=result.color}i+=result.skipCount}else if(arg==59){attrs.underlineSource=attrs.SRC_DEFAULT}else if(arg>=90&&arg<=97){attrs.foregroundSource=arg-90+8}else if(arg>=100&&arg<=107){attrs.backgroundSource=arg-100+8}}attrs.syncColors()};hterm.VT.CSI["m"].supportsSubargs=true;hterm.VT.CSI[">m"]=hterm.VT.ignore;hterm.VT.CSI["n"]=function(parseState){if(parseState.args[0]==5){this.terminal.io.sendString("0n")}else if(parseState.args[0]==6){const row=this.terminal.getCursorRow()+1;const col=this.terminal.getCursorColumn()+1;this.terminal.io.sendString("["+row+";"+col+"R")}};hterm.VT.CSI[">n"]=hterm.VT.ignore;hterm.VT.CSI["?n"]=function(parseState){if(parseState.args[0]==6){const row=this.terminal.getCursorRow()+1;const col=this.terminal.getCursorColumn()+1;this.terminal.io.sendString("["+row+";"+col+"R")}else if(parseState.args[0]==15){this.terminal.io.sendString("[?11n")}else if(parseState.args[0]==25){this.terminal.io.sendString("[?21n")}else if(parseState.args[0]==26){this.terminal.io.sendString("[?12;1;0;0n")}else if(parseState.args[0]==53){this.terminal.io.sendString("[?50n")}};hterm.VT.CSI[">p"]=hterm.VT.ignore;hterm.VT.CSI["!p"]=function(){this.terminal.softReset()};hterm.VT.CSI["$p"]=hterm.VT.ignore;hterm.VT.CSI["?$p"]=hterm.VT.ignore;hterm.VT.CSI['"p']=hterm.VT.ignore;hterm.VT.CSI["q"]=hterm.VT.ignore;hterm.VT.CSI[" q"]=function(parseState){const arg=parseState.args[0];if(arg==0||arg==1){this.terminal.setCursorShape(hterm.Terminal.cursorShape.BLOCK);this.terminal.setCursorBlink(true)}else if(arg==2){this.terminal.setCursorShape(hterm.Terminal.cursorShape.BLOCK);this.terminal.setCursorBlink(false)}else if(arg==3){this.terminal.setCursorShape(hterm.Terminal.cursorShape.UNDERLINE);this.terminal.setCursorBlink(true)}else if(arg==4){this.terminal.setCursorShape(hterm.Terminal.cursorShape.UNDERLINE);this.terminal.setCursorBlink(false)}else if(arg==5){this.terminal.setCursorShape(hterm.Terminal.cursorShape.BEAM);this.terminal.setCursorBlink(true)}else if(arg==6){this.terminal.setCursorShape(hterm.Terminal.cursorShape.BEAM);this.terminal.setCursorBlink(false)}else{console.warn("Unknown cursor style: "+arg)}};hterm.VT.CSI['"q']=hterm.VT.ignore;hterm.VT.CSI["r"]=function(parseState){const args=parseState.args;const top=args[0]?parseInt(args[0],10):0;const bottom=args[1]?parseInt(args[1],10):this.terminal.screenSize.height;if(top<0||bottom>this.terminal.screenSize.height||bottom<=top){return}this.terminal.setVTScrollRegion(top===0?null:top-1,bottom-1);this.terminal.setCursorPosition(0,0)};hterm.VT.CSI["?r"]=hterm.VT.ignore;hterm.VT.CSI["$r"]=hterm.VT.ignore;hterm.VT.CSI["s"]=function(){this.terminal.saveCursorAndState()};hterm.VT.CSI["?s"]=hterm.VT.ignore;hterm.VT.CSI["t"]=hterm.VT.ignore;hterm.VT.CSI["$t"]=hterm.VT.ignore;hterm.VT.CSI[">t"]=hterm.VT.ignore;hterm.VT.CSI[" t"]=hterm.VT.ignore;hterm.VT.CSI["u"]=function(){this.terminal.restoreCursorAndState()};hterm.VT.CSI[" u"]=hterm.VT.ignore;hterm.VT.CSI["$v"]=hterm.VT.ignore;hterm.VT.CSI["'w"]=hterm.VT.ignore;hterm.VT.CSI["x"]=hterm.VT.ignore;hterm.VT.CSI["*x"]=hterm.VT.ignore;hterm.VT.CSI["$x"]=hterm.VT.ignore;hterm.VT.CSI["z"]=function(parseState){if(parseState.args.length<1){return}const arg=parseState.args[0];if(arg==0){if(parseState.args.length<2){return}this.terminal.getTextAttributes().tileData=parseState.args[1]}else if(arg==1){this.terminal.getTextAttributes().tileData=null}};hterm.VT.CSI["'z"]=hterm.VT.ignore;hterm.VT.CSI["$z"]=hterm.VT.ignore;hterm.VT.CSI["'{"]=hterm.VT.ignore;hterm.VT.CSI["'|"]=hterm.VT.ignore;hterm.VT.CSI["'}"]=hterm.VT.ignore;hterm.VT.CSI["'~"]=hterm.VT.ignore;hterm.VT.CharacterMap=function(description,glmap){this.description=description;this.GL=null;this.glmapBase_=glmap;this.sync_()};hterm.VT.CharacterMap.prototype.sync_=function(glmap=undefined){if(!this.glmapBase_&&!glmap){this.GL=null;delete this.glmap_;delete this.glre_;return}if(glmap){this.glmap_=Object.assign({},this.glmapBase_,glmap)}else{this.glmap_=this.glmapBase_}const glchars=Object.keys(lib.notNull(this.glmap_)).map(key=>"\\x"+lib.f.zpad(key.charCodeAt(0).toString(16),2));this.glre_=new RegExp("["+glchars.join("")+"]","g");this.GL=str=>str.replace(this.glre_,ch=>this.glmap_[ch])};hterm.VT.CharacterMap.prototype.reset=function(){if(this.glmap_!==this.glmapBase_){this.sync_()}};hterm.VT.CharacterMap.prototype.setOverrides=function(glmap){this.sync_(glmap)};hterm.VT.CharacterMap.prototype.clone=function(){const map=new hterm.VT.CharacterMap(this.description,this.glmapBase_);if(this.glmap_!==this.glmapBase_){map.setOverrides(this.glmap_)}return map};hterm.VT.CharacterMaps=function(){this.maps_=hterm.VT.CharacterMaps.DefaultMaps;this.mapsBase_=this.maps_};hterm.VT.CharacterMaps.prototype.getMap=function(name){if(this.maps_.hasOwnProperty(name)){return this.maps_[name]}else{return undefined}};hterm.VT.CharacterMaps.prototype.addMap=function(name,map){if(this.maps_===this.mapsBase_){this.maps_=Object.assign({},this.mapsBase_)}this.maps_[name]=map};hterm.VT.CharacterMaps.prototype.reset=function(){if(this.maps_!==hterm.VT.CharacterMaps.DefaultMaps){this.maps_=hterm.VT.CharacterMaps.DefaultMaps}};hterm.VT.CharacterMaps.prototype.setOverrides=function(maps){if(this.maps_===this.mapsBase_){this.maps_=Object.assign({},this.mapsBase_)}for(const name in maps){const map=this.getMap(name);if(map!==undefined){this.maps_[name]=map.clone();this.maps_[name].setOverrides(maps[name])}else{this.addMap(name,new hterm.VT.CharacterMap("user "+name,maps[name]))}}};hterm.VT.CharacterMaps.DefaultMaps={};hterm.VT.CharacterMaps.DefaultMaps["0"]=new hterm.VT.CharacterMap("graphic",{"`":"◆",a:"▒",b:"␉",c:"␌",d:"␍",e:"␊",f:"°",g:"±",h:"␤",i:"␋",j:"┘",k:"┐",l:"┌",m:"└",n:"┼",o:"⎺",p:"⎻",q:"─",r:"⎼",s:"⎽",t:"├",u:"┤",v:"┴",w:"┬",x:"│",y:"≤",z:"≥","{":"π","|":"≠","}":"£","~":"·"});hterm.VT.CharacterMaps.DefaultMaps["A"]=new hterm.VT.CharacterMap("british",{"#":"£"});hterm.VT.CharacterMaps.DefaultMaps["B"]=new hterm.VT.CharacterMap("us",null);hterm.VT.CharacterMaps.DefaultMaps["4"]=new hterm.VT.CharacterMap("dutch",{"#":"£","@":"¾","[":"Ĳ","\\":"½","]":"|","{":"¨","|":"f","}":"¼","~":"´"});hterm.VT.CharacterMaps.DefaultMaps["C"]=hterm.VT.CharacterMaps.DefaultMaps["5"]=new hterm.VT.CharacterMap("finnish",{"[":"Ä","\\":"Ö","]":"Å","^":"Ü","`":"é","{":"ä","|":"ö","}":"å","~":"ü"});hterm.VT.CharacterMaps.DefaultMaps["R"]=new hterm.VT.CharacterMap("french",{"#":"£","@":"à","[":"°","\\":"ç","]":"§","{":"é","|":"ù","}":"è","~":"¨"});hterm.VT.CharacterMaps.DefaultMaps["Q"]=new hterm.VT.CharacterMap("french canadian",{"@":"à","[":"â","\\":"ç","]":"ê","^":"î","`":"ô","{":"é","|":"ù","}":"è","~":"û"});hterm.VT.CharacterMaps.DefaultMaps["K"]=new hterm.VT.CharacterMap("german",{"@":"§","[":"Ä","\\":"Ö","]":"Ü","{":"ä","|":"ö","}":"ü","~":"ß"});hterm.VT.CharacterMaps.DefaultMaps["Y"]=new hterm.VT.CharacterMap("italian",{"#":"£","@":"§","[":"°","\\":"ç","]":"é","`":"ù","{":"à","|":"ò","}":"è","~":"ì"});hterm.VT.CharacterMaps.DefaultMaps["E"]=hterm.VT.CharacterMaps.DefaultMaps["6"]=new hterm.VT.CharacterMap("norwegian/danish",{"@":"Ä","[":"Æ","\\":"Ø","]":"Å","^":"Ü","`":"ä","{":"æ","|":"ø","}":"å","~":"ü"});hterm.VT.CharacterMaps.DefaultMaps["Z"]=new hterm.VT.CharacterMap("spanish",{"#":"£","@":"§","[":"¡","\\":"Ñ","]":"¿","{":"°","|":"ñ","}":"ç"});hterm.VT.CharacterMaps.DefaultMaps["7"]=hterm.VT.CharacterMaps.DefaultMaps["H"]=new hterm.VT.CharacterMap("swedish",{"@":"É","[":"Ä","\\":"Ö","]":"Å","^":"Ü","`":"é","{":"ä","|":"ö","}":"å","~":"ü"});hterm.VT.CharacterMaps.DefaultMaps["="]=new hterm.VT.CharacterMap("swiss",{"#":"ù","@":"à","[":"é","\\":"ç","]":"ê","^":"î",_:"è","`":"ô","{":"ä","|":"ö","}":"ü","~":"û"});(function(global){if("Intl"in global&&"Segmenter"in global.Intl){return}global.Intl=global.Intl||{};const GRANULARITIES=["grapheme","word","sentence","line"];const RULES={grapheme:{grapheme:/^(.|\n)/},word:{letter:/^[a-z](?:'?[a-z])*/i,number:/^\d+([,.]\d+)*/},sentence:{terminator:/^[^.?!\r\n]+[.?!]+[\r\n]?/,separator:/^[^.?!\r\n]+[\r\n]?/},line:{hard:/^\S*[\r\n]/,soft:/^\S*\s*/}};function fixBreakType(value,granularity){const ruleStatus={none:0,number:100,letter:200,kana:300,ideo:400,unknown:-1}[value]||0;switch(granularity){case"character":return undefined;case"word":return value;case"sentence":return{0:"terminator",100:"separator"}[ruleStatus]||value;case"line":return{0:"soft",100:"hard"}[ruleStatus]||value;default:return value}}function segment(locale,granularity,string){const breaks=[];if("v8BreakIterator"in global.Intl){if(granularity==="grapheme"){granularity="character"}const vbi=new global.Intl.v8BreakIterator(locale,{type:granularity});vbi.adoptText(string);let last=0;let pos=vbi.next();while(pos!==-1){breaks.push({pos:vbi.current(),segment:string.slice(last,pos),breakType:fixBreakType(vbi.breakType(),granularity)});last=pos;pos=vbi.next()}}else{const rules=RULES[granularity];let pos=0;while(pos<string.length){let found=false;for(const rule of Object.keys(rules)){const re=rules[rule];const m=string.slice(pos).match(re);if(m){pos+=m[0].length;breaks.push({pos:pos,segment:m[0],breakType:granularity==="grapheme"?undefined:rule});found=true;break}}if(!found){breaks.push({pos:pos+1,segment:string.slice(pos,++pos),breakType:"none"})}}}return breaks}class $SegmentIterator${constructor(string,breaks){this._cur=-1;this._type=undefined;this._breaks=breaks}[Symbol.iterator](){return this}next(){if(this._cur<this._breaks.length){++this._cur}if(this._cur>=this._breaks.length){this._type=undefined;return{done:true,value:undefined}}this._type=this._breaks[this._cur].breakType;return{done:false,value:{segment:this._breaks[this._cur].segment,breakType:this._breaks[this._cur].breakType}}}following(index=undefined){if(!this._breaks.length){return true}if(index===undefined){if(this._cur<this._breaks.length){++this._cur}}else{for(this._cur=0;this._cur<this._breaks.length&&this._breaks[this._cur].pos<index;++this._cur){}}this._type=this._cur<this._breaks.length?this._breaks[this._cur].breakType:undefined;return this._cur+1>=this._breaks.length}preceding(index=undefined){if(!this._breaks.length){return true}if(index===undefined){if(this._cur>=this._breaks.length){--this._cur}if(this._cur>=0){--this._cur}}else{for(this._cur=this._breaks.length-1;this._cur>=0&&this._breaks[this._cur].pos>=index;--this._cur){}}this._type=this._cur+1>=this._breaks.length?undefined:this._breaks[this._cur+1].breakType;return this._cur<0}get position(){if(this._cur<0||!this._breaks.length){return 0}if(this._cur>=this._breaks.length){return this._breaks[this._breaks.length-1].pos}return this._breaks[this._cur].pos}get breakType(){return this._type}}global.Intl.Segmenter=class Segmenter{constructor(locale,{localeMatcher,granularity="grapheme"}={}){this._locale=Array.isArray(locale)?locale.map(s=>String(s)):String(locale||navigator.language);this._granularity=GRANULARITIES.includes(granularity)?granularity:"grapheme"}segment(string){return new $SegmentIterator$(string,segment(this._locale,this._granularity,string))}}})(typeof globalThis!=="undefined"?globalThis:typeof window!=="undefined"?window:typeof global!=="undefined"?global:{});hterm.wc={};hterm.wc.nulWidth=0;hterm.wc.controlWidth=0;hterm.wc.regardCjkAmbiguous=false;hterm.wc.cjkAmbiguousWidth=2;hterm.wc.combining=[[173,173],[768,879],[1155,1161],[1425,1469],[1471,1471],[1473,1474],[1476,1477],[1479,1479],[1552,1562],[1564,1564],[1611,1631],[1648,1648],[1750,1756],[1759,1764],[1767,1768],[1770,1773],[1809,1809],[1840,1866],[1958,1968],[2027,2035],[2045,2045],[2070,2073],[2075,2083],[2085,2087],[2089,2093],[2137,2139],[2200,2207],[2250,2273],[2275,2306],[2362,2362],[2364,2364],[2369,2376],[2381,2381],[2385,2391],[2402,2403],[2433,2433],[2492,2492],[2497,2500],[2509,2509],[2530,2531],[2558,2558],[2561,2562],[2620,2620],[2625,2626],[2631,2632],[2635,2637],[2641,2641],[2672,2673],[2677,2677],[2689,2690],[2748,2748],[2753,2757],[2759,2760],[2765,2765],[2786,2787],[2810,2815],[2817,2817],[2876,2876],[2879,2879],[2881,2884],[2893,2893],[2901,2902],[2914,2915],[2946,2946],[3008,3008],[3021,3021],[3072,3072],[3076,3076],[3132,3132],[3134,3136],[3142,3144],[3146,3149],[3157,3158],[3170,3171],[3201,3201],[3260,3260],[3263,3263],[3270,3270],[3276,3277],[3298,3299],[3328,3329],[3387,3388],[3393,3396],[3405,3405],[3426,3427],[3457,3457],[3530,3530],[3538,3540],[3542,3542],[3633,3633],[3636,3642],[3655,3662],[3761,3761],[3764,3772],[3784,3790],[3864,3865],[3893,3893],[3895,3895],[3897,3897],[3953,3966],[3968,3972],[3974,3975],[3981,3991],[3993,4028],[4038,4038],[4141,4144],[4146,4151],[4153,4154],[4157,4158],[4184,4185],[4190,4192],[4209,4212],[4226,4226],[4229,4230],[4237,4237],[4253,4253],[4448,4607],[4957,4959],[5906,5908],[5938,5939],[5970,5971],[6002,6003],[6068,6069],[6071,6077],[6086,6086],[6089,6099],[6109,6109],[6155,6159],[6277,6278],[6313,6313],[6432,6434],[6439,6440],[6450,6450],[6457,6459],[6679,6680],[6683,6683],[6742,6742],[6744,6750],[6752,6752],[6754,6754],[6757,6764],[6771,6780],[6783,6783],[6832,6862],[6912,6915],[6964,6964],[6966,6970],[6972,6972],[6978,6978],[7019,7027],[7040,7041],[7074,7077],[7080,7081],[7083,7085],[7142,7142],[7144,7145],[7149,7149],[7151,7153],[7212,7219],[7222,7223],[7376,7378],[7380,7392],[7394,7400],[7405,7405],[7412,7412],[7416,7417],[7616,7679],[8203,8207],[8234,8238],[8288,8292],[8294,8303],[8400,8432],[11503,11505],[11647,11647],[11744,11775],[12330,12333],[12441,12442],[42607,42610],[42612,42621],[42654,42655],[42736,42737],[43010,43010],[43014,43014],[43019,43019],[43045,43046],[43052,43052],[43204,43205],[43232,43249],[43263,43263],[43302,43309],[43335,43345],[43392,43394],[43443,43443],[43446,43449],[43452,43453],[43493,43493],[43561,43566],[43569,43570],[43573,43574],[43587,43587],[43596,43596],[43644,43644],[43696,43696],[43698,43700],[43703,43704],[43710,43711],[43713,43713],[43756,43757],[43766,43766],[44005,44005],[44008,44008],[44013,44013],[64286,64286],[65024,65039],[65056,65071],[65279,65279],[65529,65531],[66045,66045],[66272,66272],[66422,66426],[68097,68099],[68101,68102],[68108,68111],[68152,68154],[68159,68159],[68325,68326],[68900,68903],[69291,69292],[69373,69375],[69446,69456],[69506,69509],[69633,69633],[69688,69702],[69744,69744],[69747,69748],[69759,69761],[69811,69814],[69817,69818],[69826,69826],[69888,69890],[69927,69931],[69933,69940],[70003,70003],[70016,70017],[70070,70078],[70089,70092],[70095,70095],[70191,70193],[70196,70196],[70198,70199],[70206,70206],[70209,70209],[70367,70367],[70371,70378],[70400,70401],[70459,70460],[70464,70464],[70502,70508],[70512,70516],[70712,70719],[70722,70724],[70726,70726],[70750,70750],[70835,70840],[70842,70842],[70847,70848],[70850,70851],[71090,71093],[71100,71101],[71103,71104],[71132,71133],[71219,71226],[71229,71229],[71231,71232],[71339,71339],[71341,71341],[71344,71349],[71351,71351],[71453,71455],[71458,71461],[71463,71467],[71727,71735],[71737,71738],[71995,71996],[71998,71998],[72003,72003],[72148,72151],[72154,72155],[72160,72160],[72193,72202],[72243,72248],[72251,72254],[72263,72263],[72273,72278],[72281,72283],[72330,72342],[72344,72345],[72752,72758],[72760,72765],[72767,72767],[72850,72871],[72874,72880],[72882,72883],[72885,72886],[73009,73014],[73018,73018],[73020,73021],[73023,73029],[73031,73031],[73104,73105],[73109,73109],[73111,73111],[73459,73460],[73472,73473],[73526,73530],[73536,73536],[73538,73538],[78896,78912],[78919,78933],[92912,92916],[92976,92982],[94031,94031],[94095,94098],[94180,94180],[113821,113822],[113824,113827],[118528,118573],[118576,118598],[119143,119145],[119155,119170],[119173,119179],[119210,119213],[119362,119364],[121344,121398],[121403,121452],[121461,121461],[121476,121476],[121499,121503],[121505,121519],[122880,122886],[122888,122904],[122907,122913],[122915,122916],[122918,122922],[123023,123023],[123184,123190],[123566,123566],[123628,123631],[124140,124143],[125136,125142],[125252,125258],[917505,917505],[917536,917631],[917760,917999]];hterm.wc.ambiguous=[[161,161],[164,164],[167,168],[170,170],[173,174],[176,180],[182,186],[188,191],[198,198],[208,208],[215,216],[222,225],[230,230],[232,234],[236,237],[240,240],[242,243],[247,250],[252,252],[254,254],[257,257],[273,273],[275,275],[283,283],[294,295],[299,299],[305,307],[312,312],[319,322],[324,324],[328,331],[333,333],[338,339],[358,359],[363,363],[462,462],[464,464],[466,466],[468,468],[470,470],[472,472],[474,474],[476,476],[593,593],[609,609],[708,708],[711,711],[713,715],[717,717],[720,720],[728,731],[733,733],[735,735],[768,879],[913,929],[931,937],[945,961],[963,969],[1025,1025],[1040,1103],[1105,1105],[4352,4447],[8208,8208],[8211,8214],[8216,8217],[8220,8221],[8224,8226],[8228,8231],[8240,8240],[8242,8243],[8245,8245],[8251,8251],[8254,8254],[8308,8308],[8319,8319],[8321,8324],[8364,8364],[8451,8451],[8453,8453],[8457,8457],[8467,8467],[8470,8470],[8481,8482],[8486,8486],[8491,8491],[8531,8532],[8539,8542],[8544,8555],[8560,8569],[8585,8585],[8592,8601],[8632,8633],[8658,8658],[8660,8660],[8679,8679],[8704,8704],[8706,8707],[8711,8712],[8715,8715],[8719,8719],[8721,8721],[8725,8725],[8730,8730],[8733,8736],[8739,8739],[8741,8741],[8743,8748],[8750,8750],[8756,8759],[8764,8765],[8776,8776],[8780,8780],[8786,8786],[8800,8801],[8804,8807],[8810,8811],[8814,8815],[8834,8835],[8838,8839],[8853,8853],[8857,8857],[8869,8869],[8895,8895],[8978,8978],[8986,8987],[9001,9002],[9193,9196],[9200,9200],[9203,9203],[9312,9449],[9451,9547],[9552,9587],[9600,9615],[9618,9621],[9632,9633],[9635,9641],[9650,9651],[9654,9655],[9660,9661],[9664,9665],[9670,9672],[9675,9675],[9678,9681],[9698,9701],[9711,9711],[9725,9726],[9733,9734],[9737,9737],[9742,9743],[9748,9749],[9756,9756],[9758,9758],[9792,9792],[9794,9794],[9800,9811],[9824,9825],[9827,9829],[9831,9834],[9836,9837],[9839,9839],[9855,9855],[9875,9875],[9886,9887],[9889,9889],[9898,9899],[9917,9919],[9924,9953],[9955,9955],[9960,9983],[9989,9989],[9994,9995],[10024,10024],[10045,10045],[10060,10060],[10062,10062],[10067,10069],[10071,10071],[10102,10111],[10133,10135],[10160,10160],[10175,10175],[11035,11036],[11088,11088],[11093,11097],[11904,12255],[12272,12350],[12352,19903],[19968,42191],[43360,43391],[44032,55203],[57344,64255],[65024,65049],[65072,65135],[65281,65376],[65504,65510],[65533,65533],[94176,94180],[94192,94193],[94208,101589],[101632,101640],[110576,110579],[110581,110587],[110589,110590],[110592,110895],[110898,110898],[110928,110930],[110933,110933],[110948,110951],[110960,111359],[126980,126980],[127183,127183],[127232,127242],[127248,127277],[127280,127337],[127344,127404],[127488,127490],[127504,127547],[127552,127560],[127568,127569],[127584,127589],[127744,127776],[127789,127797],[127799,127868],[127870,127891],[127904,127946],[127951,127955],[127968,127984],[127988,127988],[127992,128062],[128064,128064],[128066,128252],[128255,128317],[128331,128334],[128336,128359],[128378,128378],[128405,128406],[128420,128420],[128507,128591],[128640,128709],[128716,128716],[128720,128722],[128725,128727],[128732,128735],[128747,128748],[128756,128764],[128992,129003],[129008,129008],[129292,129338],[129340,129349],[129351,129535],[129648,129660],[129664,129672],[129680,129725],[129727,129733],[129742,129755],[129760,129768],[129776,129784],[131072,196605],[196608,262141],[917760,917999],[983040,1048573],[1048576,1114109]];hterm.wc.unambiguous=[[4352,4447],[8986,8987],[9001,9002],[9193,9196],[9200,9200],[9203,9203],[9725,9726],[9748,9749],[9800,9811],[9855,9855],[9875,9875],[9889,9889],[9898,9899],[9917,9918],[9924,9925],[9934,9934],[9940,9940],[9962,9962],[9970,9971],[9973,9973],[9978,9978],[9981,9981],[9989,9989],[9994,9995],[10024,10024],[10060,10060],[10062,10062],[10067,10069],[10071,10071],[10133,10135],[10160,10160],[10175,10175],[11035,11036],[11088,11088],[11093,11093],[11904,12255],[12272,12350],[12352,12871],[12880,19903],[19968,42191],[43360,43391],[44032,55203],[63744,64255],[65040,65049],[65072,65135],[65281,65376],[65504,65510],[94176,94180],[94192,94193],[94208,101589],[101632,101640],[110576,110579],[110581,110587],[110589,110590],[110592,110895],[110898,110898],[110928,110930],[110933,110933],[110948,110951],[110960,111359],[126980,126980],[127183,127183],[127374,127374],[127377,127386],[127488,127490],[127504,127547],[127552,127560],[127568,127569],[127584,127589],[127744,127776],[127789,127797],[127799,127868],[127870,127891],[127904,127946],[127951,127955],[127968,127984],[127988,127988],[127992,128062],[128064,128064],[128066,128252],[128255,128317],[128331,128334],[128336,128359],[128378,128378],[128405,128406],[128420,128420],[128507,128591],[128640,128709],[128716,128716],[128720,128722],[128725,128727],[128732,128735],[128747,128748],[128756,128764],[128992,129003],[129008,129008],[129292,129338],[129340,129349],[129351,129535],[129648,129660],[129664,129672],[129680,129725],[129727,129733],[129742,129755],[129760,129768],[129776,129784],[131072,196605],[196608,262141]];hterm.wc.binaryTableSearch_=function(ucs,table){let min=0;let max=table.length-1;let mid;if(ucs<table[min][0]||ucs>table[max][1]){return false}while(max>=min){mid=Math.floor((min+max)/2);if(ucs>table[mid][1]){min=mid+1}else if(ucs<table[mid][0]){max=mid-1}else{return true}}return false};hterm.wc.isSpace=function(ucs){return hterm.wc.binaryTableSearch_(ucs,hterm.wc.combining)};hterm.wc.isCjkAmbiguous=function(ucs){return hterm.wc.binaryTableSearch_(ucs,hterm.wc.ambiguous)};hterm.wc.charWidth=function(ucs){if(hterm.wc.regardCjkAmbiguous){return hterm.wc.charWidthRegardAmbiguous(ucs)}else{return hterm.wc.charWidthDisregardAmbiguous(ucs)}};hterm.wc.charWidthDisregardAmbiguous=function(ucs){if(ucs<127){if(ucs>=32){return 1}else if(ucs==0){return hterm.wc.nulWidth}else{return hterm.wc.controlWidth}}if(ucs<160){return hterm.wc.controlWidth}if(hterm.wc.isSpace(ucs)){return 0}return hterm.wc.binaryTableSearch_(ucs,hterm.wc.unambiguous)?2:1};hterm.wc.charWidthRegardAmbiguous=function(ucs){if(hterm.wc.isCjkAmbiguous(ucs)){return hterm.wc.cjkAmbiguousWidth}return hterm.wc.charWidthDisregardAmbiguous(ucs)};hterm.wc.strWidth=function(str){let rv=0;for(let i=0;i<str.length;){const codePoint=str.codePointAt(i);const width=hterm.wc.charWidth(codePoint);if(width<0){return-1}rv+=width;i+=codePoint<=65535?1:2}return rv};hterm.wc.substr=function(str,start,subwidth=undefined){let startIndex=0;if(start){for(let width=0;startIndex<str.length;){const codePoint=str.codePointAt(startIndex);width+=hterm.wc.charWidth(codePoint);if(width>start){break}startIndex+=codePoint<=65535?1:2}}if(subwidth!==undefined){let endIndex=startIndex;for(let width=0;endIndex<str.length;){const codePoint=str.codePointAt(endIndex);width+=hterm.wc.charWidth(codePoint);if(width>subwidth){break}endIndex+=codePoint<=65535?1:2}return str.substring(startIndex,endIndex)}return str.substr(startIndex)};hterm.wc.substring=function(str,start,end){return hterm.wc.substr(str,start,end-start)};lib.resource.add("hterm/audio/bell","audio/ogg;base64","T2dnUwACAAAAAAAAAADhqW5KAAAAAMFvEjYBHgF2b3JiaXMAAAAAAYC7AAAAAAAAAHcBAAAAAAC4"+"AU9nZ1MAAAAAAAAAAAAA4aluSgEAAAAAesI3EC3//////////////////8kDdm9yYmlzHQAAAFhp"+"cGguT3JnIGxpYlZvcmJpcyBJIDIwMDkwNzA5AAAAAAEFdm9yYmlzKUJDVgEACAAAADFMIMWA0JBV"+"AAAQAABgJCkOk2ZJKaWUoSh5mJRISSmllMUwiZiUicUYY4wxxhhjjDHGGGOMIDRkFQAABACAKAmO"+"o+ZJas45ZxgnjnKgOWlOOKcgB4pR4DkJwvUmY26mtKZrbs4pJQgNWQUAAAIAQEghhRRSSCGFFGKI"+"IYYYYoghhxxyyCGnnHIKKqigggoyyCCDTDLppJNOOumoo4466ii00EILLbTSSkwx1VZjrr0GXXxz"+"zjnnnHPOOeecc84JQkNWAQAgAAAEQgYZZBBCCCGFFFKIKaaYcgoyyIDQkFUAACAAgAAAAABHkRRJ"+"sRTLsRzN0SRP8ixREzXRM0VTVE1VVVVVdV1XdmXXdnXXdn1ZmIVbuH1ZuIVb2IVd94VhGIZhGIZh"+"GIZh+H3f933f930gNGQVACABAKAjOZbjKaIiGqLiOaIDhIasAgBkAAAEACAJkiIpkqNJpmZqrmmb"+"tmirtm3LsizLsgyEhqwCAAABAAQAAAAAAKBpmqZpmqZpmqZpmqZpmqZpmqZpmmZZlmVZlmVZlmVZ"+"lmVZlmVZlmVZlmVZlmVZlmVZlmVZlmVZlmVZQGjIKgBAAgBAx3Ecx3EkRVIkx3IsBwgNWQUAyAAA"+"CABAUizFcjRHczTHczzHczxHdETJlEzN9EwPCA1ZBQAAAgAIAAAAAABAMRzFcRzJ0SRPUi3TcjVX"+"cz3Xc03XdV1XVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVYHQkFUAAAQAACGdZpZq"+"gAgzkGEgNGQVAIAAAAAYoQhDDAgNWQUAAAQAAIih5CCa0JrzzTkOmuWgqRSb08GJVJsnuamYm3PO"+"OeecbM4Z45xzzinKmcWgmdCac85JDJqloJnQmnPOeRKbB62p0ppzzhnnnA7GGWGcc85p0poHqdlY"+"m3POWdCa5qi5FJtzzomUmye1uVSbc84555xzzjnnnHPOqV6czsE54Zxzzonam2u5CV2cc875ZJzu"+"zQnhnHPOOeecc84555xzzglCQ1YBAEAAAARh2BjGnYIgfY4GYhQhpiGTHnSPDpOgMcgppB6NjkZK"+"qYNQUhknpXSC0JBVAAAgAACEEFJIIYUUUkghhRRSSCGGGGKIIaeccgoqqKSSiirKKLPMMssss8wy"+"y6zDzjrrsMMQQwwxtNJKLDXVVmONteaec645SGultdZaK6WUUkoppSA0ZBUAAAIAQCBkkEEGGYUU"+"UkghhphyyimnoIIKCA1ZBQAAAgAIAAAA8CTPER3RER3RER3RER3RER3P8RxREiVREiXRMi1TMz1V"+"VFVXdm1Zl3Xbt4Vd2HXf133f141fF4ZlWZZlWZZlWZZlWZZlWZZlCUJDVgEAIAAAAEIIIYQUUkgh"+"hZRijDHHnINOQgmB0JBVAAAgAIAAAAAAR3EUx5EcyZEkS7IkTdIszfI0T/M00RNFUTRNUxVd0RV1"+"0xZlUzZd0zVl01Vl1XZl2bZlW7d9WbZ93/d93/d93/d93/d939d1IDRkFQAgAQCgIzmSIimSIjmO"+"40iSBISGrAIAZAAABACgKI7iOI4jSZIkWZImeZZniZqpmZ7pqaIKhIasAgAAAQAEAAAAAACgaIqn"+"mIqniIrniI4oiZZpiZqquaJsyq7ruq7ruq7ruq7ruq7ruq7ruq7ruq7ruq7ruq7ruq7ruq7rukBo"+"yCoAQAIAQEdyJEdyJEVSJEVyJAcIDVkFAMgAAAgAwDEcQ1Ikx7IsTfM0T/M00RM90TM9VXRFFwgN"+"WQUAAAIACAAAAAAAwJAMS7EczdEkUVIt1VI11VItVVQ9VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV"+"VVVVVVVVVVVV1TRN0zSB0JCVAAAZAAAjQQYZhBCKcpBCbj1YCDHmJAWhOQahxBiEpxAzDDkNInSQ"+"QSc9uJI5wwzz4FIoFURMg40lN44gDcKmXEnlOAhCQ1YEAFEAAIAxyDHEGHLOScmgRM4xCZ2UyDkn"+"pZPSSSktlhgzKSWmEmPjnKPSScmklBhLip2kEmOJrQAAgAAHAIAAC6HQkBUBQBQAAGIMUgophZRS"+"zinmkFLKMeUcUko5p5xTzjkIHYTKMQadgxAppRxTzinHHITMQeWcg9BBKAAAIMABACDAQig0ZEUA"+"ECcA4HAkz5M0SxQlSxNFzxRl1xNN15U0zTQ1UVRVyxNV1VRV2xZNVbYlTRNNTfRUVRNFVRVV05ZN"+"VbVtzzRl2VRV3RZV1bZl2xZ+V5Z13zNNWRZV1dZNVbV115Z9X9ZtXZg0zTQ1UVRVTRRV1VRV2zZV"+"17Y1UXRVUVVlWVRVWXZlWfdVV9Z9SxRV1VNN2RVVVbZV2fVtVZZ94XRVXVdl2fdVWRZ+W9eF4fZ9"+"4RhV1dZN19V1VZZ9YdZlYbd13yhpmmlqoqiqmiiqqqmqtm2qrq1bouiqoqrKsmeqrqzKsq+rrmzr"+"miiqrqiqsiyqqiyrsqz7qizrtqiquq3KsrCbrqvrtu8LwyzrunCqrq6rsuz7qizruq3rxnHrujB8"+"pinLpqvquqm6um7runHMtm0co6rqvirLwrDKsu/rui+0dSFRVXXdlF3jV2VZ921fd55b94WybTu/"+"rfvKceu60vg5z28cubZtHLNuG7+t+8bzKz9hOI6lZ5q2baqqrZuqq+uybivDrOtCUVV9XZVl3zdd"+"WRdu3zeOW9eNoqrquirLvrDKsjHcxm8cuzAcXds2jlvXnbKtC31jyPcJz2vbxnH7OuP2daOvDAnH"+"jwAAgAEHAIAAE8pAoSErAoA4AQAGIecUUxAqxSB0EFLqIKRUMQYhc05KxRyUUEpqIZTUKsYgVI5J"+"yJyTEkpoKZTSUgehpVBKa6GU1lJrsabUYu0gpBZKaS2U0lpqqcbUWowRYxAy56RkzkkJpbQWSmkt"+"c05K56CkDkJKpaQUS0otVsxJyaCj0kFIqaQSU0mptVBKa6WkFktKMbYUW24x1hxKaS2kEltJKcYU"+"U20txpojxiBkzknJnJMSSmktlNJa5ZiUDkJKmYOSSkqtlZJSzJyT0kFIqYOOSkkptpJKTKGU1kpK"+"sYVSWmwx1pxSbDWU0lpJKcaSSmwtxlpbTLV1EFoLpbQWSmmttVZraq3GUEprJaUYS0qxtRZrbjHm"+"GkppraQSW0mpxRZbji3GmlNrNabWam4x5hpbbT3WmnNKrdbUUo0txppjbb3VmnvvIKQWSmktlNJi"+"ai3G1mKtoZTWSiqxlZJabDHm2lqMOZTSYkmpxZJSjC3GmltsuaaWamwx5ppSi7Xm2nNsNfbUWqwt"+"xppTS7XWWnOPufVWAADAgAMAQIAJZaDQkJUAQBQAAEGIUs5JaRByzDkqCULMOSepckxCKSlVzEEI"+"JbXOOSkpxdY5CCWlFksqLcVWaykptRZrLQAAoMABACDABk2JxQEKDVkJAEQBACDGIMQYhAYZpRiD"+"0BikFGMQIqUYc05KpRRjzknJGHMOQioZY85BKCmEUEoqKYUQSkklpQIAAAocAAACbNCUWByg0JAV"+"AUAUAABgDGIMMYYgdFQyKhGETEonqYEQWgutddZSa6XFzFpqrbTYQAithdYySyXG1FpmrcSYWisA"+"AOzAAQDswEIoNGQlAJAHAEAYoxRjzjlnEGLMOegcNAgx5hyEDirGnIMOQggVY85BCCGEzDkIIYQQ"+"QuYchBBCCKGDEEIIpZTSQQghhFJK6SCEEEIppXQQQgihlFIKAAAqcAAACLBRZHOCkaBCQ1YCAHkA"+"AIAxSjkHoZRGKcYglJJSoxRjEEpJqXIMQikpxVY5B6GUlFrsIJTSWmw1dhBKaS3GWkNKrcVYa64h"+"pdZirDXX1FqMteaaa0otxlprzbkAANwFBwCwAxtFNicYCSo0ZCUAkAcAgCCkFGOMMYYUYoox55xD"+"CCnFmHPOKaYYc84555RijDnnnHOMMeecc845xphzzjnnHHPOOeecc44555xzzjnnnHPOOeecc845"+"55xzzgkAACpwAAAIsFFkc4KRoEJDVgIAqQAAABFWYowxxhgbCDHGGGOMMUYSYowxxhhjbDHGGGOM"+"McaYYowxxhhjjDHGGGOMMcYYY4wxxhhjjDHGGGOMMcYYY4wxxhhjjDHGGGOMMcYYY4wxxhhjjDHG"+"GFtrrbXWWmuttdZaa6211lprrQBAvwoHAP8HG1ZHOCkaCyw0ZCUAEA4AABjDmHOOOQYdhIYp6KSE"+"DkIIoUNKOSglhFBKKSlzTkpKpaSUWkqZc1JSKiWlllLqIKTUWkottdZaByWl1lJqrbXWOgiltNRa"+"a6212EFIKaXWWostxlBKSq212GKMNYZSUmqtxdhirDGk0lJsLcYYY6yhlNZaazHGGGstKbXWYoy1"+"xlprSam11mKLNdZaCwDgbnAAgEiwcYaVpLPC0eBCQ1YCACEBAARCjDnnnHMQQgghUoox56CDEEII"+"IURKMeYcdBBCCCGEjDHnoIMQQgghhJAx5hx0EEIIIYQQOucchBBCCKGEUkrnHHQQQgghlFBC6SCE"+"EEIIoYRSSikdhBBCKKGEUkopJYQQQgmllFJKKaWEEEIIoYQSSimllBBCCKWUUkoppZQSQgghlFJK"+"KaWUUkIIoZRQSimllFJKCCGEUkoppZRSSgkhhFBKKaWUUkopIYQSSimllFJKKaUAAIADBwCAACPo"+"JKPKImw04cIDUGjISgCADAAAcdhq6ynWyCDFnISWS4SQchBiLhFSijlHsWVIGcUY1ZQxpRRTUmvo"+"nGKMUU+dY0oxw6yUVkookYLScqy1dswBAAAgCAAwECEzgUABFBjIAIADhAQpAKCwwNAxXAQE5BIy"+"CgwKx4Rz0mkDABCEyAyRiFgMEhOqgaJiOgBYXGDIB4AMjY20iwvoMsAFXdx1IIQgBCGIxQEUkICD"+"E2544g1PuMEJOkWlDgIAAAAA4AAAHgAAkg0gIiKaOY4Ojw+QEJERkhKTE5QAAAAAALABgA8AgCQF"+"iIiIZo6jw+MDJERkhKTE5AQlAAAAAAAAAAAACAgIAAAAAAAEAAAACAhPZ2dTAAQYOwAAAAAAAOGp"+"bkoCAAAAmc74DRgyNjM69TAzOTk74dnLubewsbagmZiNp4d0KbsExSY/I3XUTwJgkeZdn1HY4zoj"+"33/q9DFtv3Ui1/jmx7lCUtPt18/sYf9MkgAsAGRBd3gMGP4sU+qCPYBy9VrA3YqJosW3W2/ef1iO"+"/u3cg8ZG/57jU+pPmbGEJUgkfnaI39DbPqxddZphbMRmCc5rKlkUMkyx8iIoug5dJv1OYH9a59c+"+"3Gevqc7Z2XFdDjL/qHztRfjWEWxJ/aiGezjohu9HsCZdQBKbiH0VtU/3m85lDG2T/+xkZcYnX+E+"+"aqzv/xTgOoTFG+x7SNqQ4N+oAABSxuVXw77Jd5bmmTmuJakX7509HH0kGYKvARPpwfOSAPySPAc2"+"EkneDwB2HwAAJlQDYK5586N79GJCjx4+p6aDUd27XSvRyXLJkIC5YZ1jLv5lpOhZTz0s+DmnF1di"+"ptrnM6UDgIW11Xh8cHTd0/SmbgOAdxcyWwMAAGIrZ3fNSfZbzKiYrK4+tPqtnMVLOeWOG2kVvUY+"+"p2PJ/hkCl5aFRO4TLGYPZcIU3vYM1hohS4jHFlnyW/2T5J7kGsShXWT8N05V+3C/GPqJ1QdWisGP"+"xEzHqXISBPIinWDUt7IeJv/f5OtzBxpTzZZQ+CYEhHXfqG4aABQli72GJhN4oJv+hXcApAJSErAW"+"8G2raAX4NUcABnVt77CzZAB+LsHcVe+Q4h+QB1wh/ZrJTPxSBdI8mgTeAdTsQOoFUEng9BHcVPhx"+"SRRYkKWZJXOFYP6V4AEripJoEjXgA2wJRZHSExmJDm8F0A6gEXsg5a4ZsALItrMB7+fh7UKLvYWS"+"dtsDwFf1mzYzS1F82N1h2Oyt2e76B1QdS0SAsQigLPMOgJS9JRC7hFXA6kUsLFNKD5cA5cTRvgSq"+"Pc3Fl99xW3QTi/MHR8DEm6WnvaVQATwRqRKjywQ9BrrhugR2AKTsPQeQckrAOgDOhbTESyrXQ50C"+"kNpXdtWjW7W2/3UjeX3U95gIdalfRAoAmqUEiwp53hCdcCwlg47fcbfzlmQMAgaBkh7c+fcDgF+i"+"fwDXfzegLPcLYJsAAJQArTXjnh/uXGy3v1Hk3pV6/3t5ruW81f6prfbM2Q3WNVy98BwUtbCwhFhA"+"WuPev6Oe/4ZaFQUcgKrVs4defzh1TADA1DEh5b3VlDaECw5b+bPfkKos3tIAue3vJZOih3ga3l6O"+"3PSfIkrLv0PAS86PPdL7g8oc2KteNFKKzKRehOv2gJoFLBPXmaXvPBQILgJon0bbWBszrYZYYwE7"+"jl2j+vTdU7Vpk21LiU0QajPkywAAHqbUC0/YsYOdb4e6BOp7E0cCi04Ao/TgD8ZVAMid6h/A8IeB"+"Nkp6/xsAACZELEYIk+yvI6Qz1NN6lIftB/6IMWjWJNOqPTMedAmyaj6Es0QBklJpiSWWHnQ2CoYb"+"GWAmt+0gLQBFKCBnp2QUUQZ/1thtZDBJUpFWY82z34ocorB62oX7qB5y0oPAv/foxH25wVmgIHf2"+"xFOr8leZcBq1Kx3ZvCq9Bga639AxuHuPNL/71YCF4EywJpqHFAX6XF0sjVbuANnvvdLcrufYwOM/"+"iDa6iA468AYAAB6mNBMXcgTD8HSRqJ4vw8CjAlCEPACASlX/APwPOJKl9xQAAAPmnev2eWp33Xgy"+"w3Dvfz6myGk3oyP8YTKsCOvzAgALQi0o1c6Nzs2O2Pg2h4ACIJAgAGP0aNn5x0BDgVfH7u2TtyfD"+"cRIuYAyQhBF/lvSRAttgA6TPbWZA9gaUrZWAUEAA+Dx47Q3/r87HxUUqZmB0BmUuMlojFjHt1gDu"+"nnvuX8MImsjSq5WkzSzGS62OEIlOufWWezxWpv6FBgDgJVltfXFYtNAAnqU0xQoD0YLiXo5cF5QV"+"4CnY1tBLAkZCOABAhbk/AM+/AwSCCdlWAAAMcFjS7owb8GVDzveDiZvznbt2tF4bL5odN1YKl88T"+"AEABCZvufq9YCTBtMwVAQUEAwGtNltzSaHvADYC3TxLVjqiRA+OZAMhzcqEgRcAOwoCgvdTxsTHL"+"QEF6+oOb2+PAI8ciPQcXg7pOY+LjxQSv2fjmFuj34gGwz310/bGK6z3xgT887eomWULEaDd04wHe"+"tYxdjcgV2SxvSwn0VoZXJRqkRC5ASQ/muVoAUsX7AgAQMBNaVwAAlABRxT/1PmfqLqSRNDbhXb07"+"berpB3b94jpuWEZjBCD2OcdXFpCKEgCDfcFPMw8AAADUwT4lnUm50lmwrpMMhPQIKj6u0E8fr2vG"+"BngMNdIlrZsigjahljud6AFVg+tzXwUnXL3TJLpajaWKA4VAAAAMiFfqJgKAZ08XrtS3dxtQNYcp"+"PvYEG8ClvrQRJgBephwnNWJjtGqmp6VEPSvBe7EBiU3qgJbQAwD4Le8LAMDMhHbNAAAlgK+tFs5O"+"+YyJc9yCnJa3rxLPulGnxwsXV9Fsk2k4PisCAHC8FkwbGE9gJQAAoMnyksj0CdFMZLLgoz8M+Fxz"+"iwYBgIx+zHiCBAKAlBKNpF1sO9JpVcyEi9ar15YlHgrut5fPJnkdJ6vEwZPyAHQBIEDUrlMcBAAd"+"2KAS0Qq+JwRsE4AJZtMnAD6GnOYwYlOIZvtzUNdjreB7fiMkWI0CmBB6AIAKc38A9osEFlTSGECB"+"+cbeRDC0aRpLHqNPplcK/76Lxn2rpmqyXsYJWRi/FQAAAKBQk9MCAOibrQBQADCDsqpooPutd+05"+"Ce9g6iEdiYXgVmQAI4+4wskEBEiBloNQ6Ki0/KTQ0QjWfjxzi+AeuXKoMjEVfQOZzr0y941qLgM2"+"AExvbZOqcxZ6J6krlrj4y2j9AdgKDx6GnJsVLhbc42uq584+ouSdNBpoCiCVHrz+WzUA/DDtD8AT"+"gA3h0lMCAAzcFv+S+fSSNkeYWlTpb34mf2RfmqqJeMeklhHAfu7VoAEACgAApKRktL+KkQDWMwYC"+"UAAAAHCKsp80xhp91UjqQBw3x45cetqkjQEyu3G9B6N+R650Uq8OVig7wOm6Wun0ea4lKDPoabJs"+"6aLqgbhPzpv4KR4iODilw88ZpY7q1IOMcbASAOAVtmcCnobcrkG4KGS7/ZnskVWRNF9J0RUHKOnB"+"yy9WA8Dv6L4AAARMCQUA4GritfVM2lcZfH3Q3T/vZ47J2YHhcmBazjfdyuV25gLAzrc0cwAAAAAY"+"Ch6PdwAAAGyWjFW4yScjaWa2mGcofHxWxewKALglWBpLUvwwk+UOh5eNGyUOs1/EF+pZr+ud5Ozo"+"GwYdAABg2p52LiSgAY/ZVlOmilEgHn6G3OcwYjzI7vOj1t6xsx4S3lBY96EUQBF6AIBAmPYH4PoG"+"YCoJAADWe+OZJZi7/x76/yH7Lzf9M5XzRKnFPmveMsilQHwVAAAAAKB3LQD8PCIAAADga0QujBLy"+"wzeJ4a6Z/ERVBAUlAEDqvoM7BQBAuAguzFqILtmjH3Kd4wfKobnOhA3z85qWoRPm9hwoOHoDAAlC"+"bwDAA56FHAuXflHo3fe2ttG9XUDeA9YmYCBQ0oPr/1QC8IvuCwAAApbUAQCK22MmE3O78VAbHQT9"+"PIPNoT9zNc3l2Oe7TAVLANBufT8MAQAAAGzT4PS8AQAAoELGHb2uaCwwEv1EWhFriUkbAaAZ27/f"+"VZnTZXbWz3BwWpjUaMZKRj7dZ0J//gUeTdpVEwAAZOFsNxKAjQSgA+ABPoY8Jj5y2wje81jsXc/1"+"TOQWTDYZBmAkNDiqVwuA2NJ9AQAAEBKAt9Vrsfs/2N19MO91S9rd8EHTZHnzC5MYmfQEACy/FBcA"+"AADA5c4gi4z8RANs/m6FNXVo9DV46JG1BBDukqlw/Va5G7QbuGVSI+2aZaoLXJrdVj2zlC9Z5QEA"+"EFz/5QzgVZwAAAAA/oXcxyC6WfTu+09Ve/c766J4VTAGUFmA51+VANKi/QPoPwYgYAkA715OH4S0"+"s5KDHvj99MMq8TPFc3roKZnGOoT1bmIhVgc7XAMBAAAAAMAW1VbQw3gapzOpJd+Kd2fc4iSO62fJ"+"v9+movui1wUNPAj059N3OVxzk4gV73PmE8FIA2F5mRq37Evc76vLXfF4rD5UJJAw46hW6LZCb5sN"+"Ldx+kzMCAAB+hfy95+965ZCLP7B3/VlTHCvDEKtQhTm4KiCgAEAbrfbWTPssAAAAXpee1tVrozYY"+"n41wD1aeYtkKfswN5/SXPO0JDnhO/4laUortv/s412fybe/nONdncoCHnBVliu0CQGBWlPY/5Kwo"+"m2L/kruPM6Q7oz4tvDQy+bZ3HzOi+gNHA4DZEgA=");lib.resource.add("hterm/images/copy","image/svg+xml;utf8",'<svg xmlns="http://www.w3.org/2000/svg" width="2em" height="2em" viewBox="0 0 48 48" fill="currentColor">'+'  <path d="M32 2H8C5.79 2 4 3.79 4 6v28h4V6h24V2zm6 8H16c-2.21 0-4 1.79-4 4v28c0 2.21 1.79 4 4 4h22c2.21 0 4-1.79 4-4V14c0-2.21-1.79-4-4-4zm0 32H16V14h22v28z"/>'+"</svg>");lib.resource.add("hterm/images/close","image/svg+xml;utf8",'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">'+'  <path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>'+"</svg>");lib.resource.add("hterm/images/keyboard_arrow_down","image/svg+xml;utf8",'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">'+'  <path d="M7.41 7.84L12 12.42l4.59-4.58L18 9.25l-6 6-6-6z"/>'+"</svg>");lib.resource.add("hterm/images/keyboard_arrow_up","image/svg+xml;utf8",'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">'+'  <path d="M7.41 15.41L12 10.83l4.59 4.58L18 14l-6-6-6 6z"/>'+"</svg>");lib.resource.add("hterm/html/find_bar","text/html;utf8","<meta charset='utf-8'/>"+"<style>"+":root {"+"  --hterm-grey-200-rgb: 232, 234, 237;  /* #e8eaed */"+"  --hterm-grey-200: rgb(var(--hterm-grey-200-rgb));"+"  --hterm-grey-400-rgb: 189, 193, 198;  /* #bdc1c6 */"+"  --hterm-grey-400: rgb(var(--hterm-grey-400-rgb));"+"  --hterm-grey-600-rgb: 128, 134, 139;  /* #80868b */"+"  --hterm-grey-600: rgb(var(--hterm-grey-600-rgb));"+"  --hterm-grey-800-rgb: 60, 64, 67;  /* #3c4043 */"+"  --hterm-grey-800: rgb(var(--hterm-grey-800-rgb));"+"}"+""+"#hterm\\:find-bar {"+"  align-items: center;"+"  background: white;"+"  border: 1px solid var(--hterm-grey-600);"+"  border-radius: 2px;"+"  box-shadow: 0 2px 2px 1px rgba(var(--hterm-grey-600-rgb), .1);"+"  display: none;"+"  font-family: sans-serif;"+"  padding: 5px 15px;"+"  position: fixed;"+"  right: 16px;"+"  top : 0;"+"  z-index: 1;"+"}"+"#hterm\\:find-bar.enabled {"+"  display: flex;"+"}"+"#hterm\\:find-bar > input {"+"  border: 0;"+"  margin: 8px 0;"+"  outline: none;"+"  width: 200px;"+"}"+"#hterm\\:find-bar-vertical-separator {"+"  align-self: stretch;"+"  border-left: 1px solid var(--hterm-grey-400);"+"  margin-left: 10px;"+"}"+"#hterm\\:find-bar > .button {"+"  align-items: center;"+"  border-radius: 50%;"+"  cursor: var(--hterm-mouse-cursor-pointer);"+"  display: flex;"+"  height: 24px;"+"  justify-content: center;"+"  margin-left: 8px;"+"  transition: background-color 0.3s linear;"+"  width: 24px;"+"}"+"#hterm\\:find-bar > .button.enabled:hover {"+"  background-color: var(--hterm-grey-200);"+"}"+"#hterm\\:find-bar > .button.enabled:active {"+"  background-color: var(--hterm-grey-400);"+"  transition: background-color 0s;"+"}"+"#hterm\\:find-bar > .button.enabled > svg {"+"  fill: var(--hterm-grey-800);"+"}"+"#hterm\\:find-bar > .button > svg {"+"  height: 20px;"+"  fill: var(--hterm-grey-400);"+"  width: 20px;"+"}"+"#hterm\\:find-bar-count {"+"  color: var(--hterm-grey-600);"+"}"+"</style>"+"<input type='text'>"+"<div id='hterm:find-bar-count'>0/0</div>"+"<div id='hterm:find-bar-vertical-separator' tabindex='-1'></div>"+"<div id='hterm:find-bar-up' class='button' role='button'></div>"+"<div id='hterm:find-bar-down' class='button' role='button'></div>"+"<div id='hterm:find-bar-close' class='button enabled' role='button'></div>");lib.resource.add("hterm/html/find_screen","text/html;utf8","<meta charset='utf-8'/>"+"<style>"+"#hterm\\:find-result-screen {"+"  height: 100%;"+"  left: var(--hterm-screen-padding-size);"+"  pointer-events: none;"+"  position: absolute;"+"  top: var(--hterm-screen-padding-size);"+"  width: 100%;"+"}"+"#hterm\\:find-result-screen > find-row {"+"  display: block;"+"  height: var(--hterm-charsize-height);"+"  line-height: var(--hterm-charsize-height);"+"}"+"#hterm\\:find-result-screen > find-row > .find-highlighter {"+"  background-color: var(--hterm-find-result-color);"+"  height: var(--hterm-charsize-height);"+"  position: absolute;"+"}"+"#hterm\\:find-result-screen > find-row > .find-highlighter.selected {"+"  background-color: var(--hterm-find-result-selected-color);"+"}"+"</style>");lib.resource.add("hterm/images/icon-96","image/png;base64","iVBORw0KGgoAAAANSUhEUgAAAGAAAABgCAYAAADimHc4AAAStklEQVR42u1dBXjrupL+RzIGmjIf"+"vAcu42NmZub3lpmZmZmZmRkuMzPDYaYyJG0Sa9b2p2z1eQtp7bzefpv/nKnkkSw7Gg1IshNsDtpo"+"o4022mijDWp/tlTgzbpJSqYvMoFTC9vjRD5JLb9RYaRkpk22SS28P8pacAaPdZ41KYMCI89YB6wN"+"3JzQJM3UIGqurfTlKQTAZtqENid5SlNdU804VmbbWQtA6HMkAAdADsBeAJ7mxwIhIhFSXJ9iRPw4"+"JYDEcqmGWEp1HhCI8gAtpXF7scB1ZRH9E3HObANCNy1AoGTegNDnCdE41tfQDH2t+CINQEpJ9Xp9"+"7oUDh3+nXK48DYAMIWQmANIkNTn6vP69e3d/zctfeu0nXNexmVn3F0gDAMxMlBoHuht0qnsEEekC"+"42SdGHmNxgVjgk4bPN04Yui8bhc534cQBH35RKrPN9sGdLnB1/Wuv+HW4f+6/tZvBHAaAJvmKr0A"+"jJGvyQMw8pLrrvqeT378Ax8UwrKeevoFgEhfjcGGO2JO+iuTt1SW5DHzyraDExyTlWwHjCQ/CAJc"+"ecU+XHn5xWDmVCGQFAKljsLbx8Ynvv3Bhx7/EQCzurimU04jADLsvK3r73/7W1//g1/6hU++uVqt"+"0X/dcBcKxRIsy9Ji34DPow2et6FzgcXFKk6fOY83vu4VEFKkDiYHB3roSz73sc+Oj08eOHzk+B9o"+"MyQABGk0gCIyOt9xHPvaD3/wnT/5VV/+meumpmbwD/98A0qdvVEBNhvMDCJaVXtM01GtVlEs+LBt"+"C1ngzW98tX/m7Llv/emf+83HarX6vbrfGECQRgBmlLP9Ix961499+zd/5XVj45P407/8FxQ7uiGl"+"QK1Ww1ZCvR6gXq3AsgQ8zwYzUkMIgXe+/Q1Dd9x5/6duv/P+R7QjprQaIHQd/8orLvnCJz/2/pfm"+"cj7+6rf+DK5XgOu6sT3dQtBawqjW6lhYXIRlSTAjE/T39eLSS/ZeEwqgE8CiYUV4vQIgTULTyFve"+"9Or3WJZN/3n9HTh3fgrFjhJmZmawFaGUwkJlEffc9xh83wMYqcFg7Noxinw+l9OBikirAabz7eju"+"6sxJKTE7W4bn5+D7PrYmtI/gAFJasCwb4IzaBMHzXE8LgBJC4I1GQRKAa4Xo6upEsZiH53nIRYLe"+"olDMCIIq+nq70dFRAGckgFKpAD+UgBaAgfRRkGvbliwUcoh8ABHFYSfWMnBrxOzL12PwKufzSvV5"+"5Tpmi5a0IASBQCgWcujs7ABn5AQic+b5rhNlAVAmTliTEwnA990wIxEEdUQYnxjHidMnAUIcBYAB"+"RqNDdC7BM8t0VtfTnGRd8FKdRIjJcVlCsAbPPA5UAK4rXLJjP7aNbkO9XoPrOrEQWHEm69Kua0ca"+"YEspvCBQ5toSp9EASCkt27ZF1PlCxBOZOPo5feY0Xpg8jHe/7V3YNjhqjDRac3mMVl1Oo40vtREt"+"W+2FYwdw/S03YHJ6EkODQ1hcXIQUcaeBlUIWsCwZ+QDLdZxcubKAtBpgNmzZliUa6yLMKiRGoBR2"+"79yN6666FlJYABgvRhAIncUSHn/iCdQrAZjjSAiKFQQRVEhZIRJASJEACICmlAKQUtqhBETjw5ij"+"uFqr4oWjBwHmF7/jVUHc6aRNXxAoZA3PdYXruvlldJfTaIATaQA4KU/CzNwMDp84DOYXf+hZXiij"+"hJz+DK0QAEd+RYTOOAcgMw0g24oskNYAIoCXxDpbnsOxM8fB5qacwKZD+3WQcS+VxQrYYXNVNGMh"+"I1odiIRQSHb8BmbCpgZYjmVLYi0ANmxQNKpOj50FFOB3WnDzEpOnFkGbuOXPimG5Ap0jLqZOLiKo"+"MyIsVhfB9lLEpFSQ+S26jh2Fo/n0YagRCUlLRhpAAIMIyWl9vBinAkbfoIPXf+0wnrlxAs/dPInK"+"VB1CUOsFkdhD6Nnp49oP98EvWfjvnzqGak0hVlwwFJsaoADK9vq2Y0eOOKUGJLTAjjQgFgBAy/gT"+"vbGIyXC0nX66jJd+YgC7X1nCo39/AccfmUVQU1F5y0d9rsvGJW/txuXv7oGqMx7+2/OoVxWIzE5S"+"OkfaBBGyhGPHc4G8YYjT+wDLDgUgJbQPWDGuL0/VcefvnMLRB2dw3Uf78dZv345D90zjsX++gPGj"+"C7peC8yNI7DjpSVcE476rlEPB++awmP/dCEaEMtqbAP1Fqzkhn0VaUAegMzABJkaIMG8epNEiE3R"+"0funce75Mi4NR+MV7+3B6NUFPPnvY3jupslISJkKoW9PDld/sA+7Xt6B8SMV3Pjzx3Di0TkENQaJ"+"5A1qM8VRljKPgpg58pcNHyCz0ADSTnhNDTBBglCZruPhvz+PY4/M4Jqwg6772AB2vqwDd/zmKYwd"+"WQAJpMalb+vGSz81AA6Ah/76HJ69KfI7tej6K7RPUKwaWQT1FmiAlJEJykXZZh5cE02FoaEJkpYE"+"wGsKwNQGAnDhQAUP/915TJ5YwPCleZSG3WwWvwgYvryAYr8Tm5wn/2Mc5cm481c9RzXWobQPyBpS"+"ikgDGgJAVvMARzY0AARwc7Y5Ckn3vK4TV7+/D5YncN+fnsWpJ+cgsnDICnj0n85DSOCSUBO6Rl08"+"8g8XcObZ+VgjSKweKRG1xgcIEQnA9QE46aMgwwlHAmBuOFFepeMRd8rI1cU4FBzYn8exh2bw6D9e"+"wNihCjgrR0wI21vAzb9yIrT/pfha7/y+nXj+5gk8EWrDzJlF/WxQUgMUwEtREGW/5RlpgJdaABq0"+"pAGicYFVFaBzxMGV7+vFvtd3YfpsFbf+6ok4KqovxqFoph+YBBAsMg7cPonTT83jsnd247J39IQR"+"UUcceR28cxrVcrBUX2sAa1Nar7dCAwhevCkDN7UADB9gSyEBaBVYYeT37PTw9u/aAbcg8Pi/XMAz"+"109gfqLhFAktgX46LbrOg395DscemAnD0X68+suGQ+3L4Y7fOhVHRA00nDBRa3wAEGuAA8DbqABI"+"kyEA2xFSrBHHM2xf4Ozz82HIOb5kbgSh1TDv69wLZdz0S8dxUTgRHLwkD2HRkgCIdBi6NBPmVpgg"+"L7krBkrnA6xIA0Qjfl4x9Bw7XInDzHo1hblJbZYoNkvP3zqFw/fPIKgqGNC7aNoEtUQDEJkg23Ec"+"v1qtrhkFiWYeTYzCUCEEeI15QDTSgjpnMerTmyUB1CsKrGACyvABQb1VAnAt13V8NAHRxGqotEMI"+"QUbJFgGtMhNuqQa4Ui9HbEgDKFknioKIhC4kbGUwFBhsOGHO/AqhCxAh5dOsBZFBMoqCGhpARJv7"+"ihul35oEt84E6U0ZCv1APp0T1tACsIhEpquZQhJsT2C9UAGjtqA2vDnPzOD/NUEqymcOJ94TcPJZ"+"zYSFHYKIjHlA+iXk/kvyeO1XDENYtK6J16kn53H375+OBbFukBkFtWoewHAdJ1qQKwAQWcyEtQaQ"+"4QPSmk6KZ6gXDlVAcn0x9vTpxTSjdhkBcOYmSO+KNTZlKK0GWHYoASJkZoJIABPHFnDbb5zEFxts"+"hqEtMkG2rfcEtAZsJAoimBpgGRqg062KVmsAmBH2V2NfWKZ1woxYAyIBwFABXma+nE30wytV4rU/"+"OK9xLWaGUmpJAHE+awEDUsrGnoCERsooyJYALfPaOEHNByBl7BGwKQsy8kYLUZ1kOTXyZprgUYJH"+"SBzrctLHDZ6huflCLt61qtWDWAMawsgOWgCe5+v+JYN4vT6AtAbIpSCIGuEcRoaG8TrXRcwzCeZ7"+"u2gcm4QIZn0QEudC5wGYdYxUt2PyjRSAyWsc6mvW6hW0CnpXzAdgQ6NZAdByJsgKBQAQGCp+oQFQ"+"8ePdhUIBxWJxXfrJYKQHNRUMMK9kuwhzc3O4eO+eeLQqpbLfFfMaAgAnhdDccrSpAZYtAUApxujI"+"EN725lfg3//7bvT19cOyLJhg44/ZCTo1y40yI79qmT4/5un2jTx0+XLtmAOAlUJXVx6ve83LdFkr"+"dsWMTZkUTpikjFyAJUxHFr6oDc918cDDT6KyMB8xzVFpmBpAGGZHiCgVZgoRphSlQkCQTvXxEhFk"+"lMolXnyseY28NMtlIjXaCzsHO7aPoFDIQ6nWCMDzXS2AdJvybMl4HiaSLyK89S2vxRte/wrU6vXG"+"IFrzOxdWTZcaMNtCgq15a9vNtWyTMjUncwEguSu2ISesO3vp3YDkE2ZSypiyQMO0JO331gTFryoJ"+"IXylVLrFOCtEpAHmaG5jbQ3Qb8r45XKFN2qCOCJpSUsxi/n5SlOP8rXB0WpoUgC8HgGwQYqI7AMH"+"j1G9zk2Ea20wgI5iPhqs8dMk6/26GrOyiqharc16nlffvn3EaWtAc/BcBw8+/Ojc+PjkKaMvuWkN"+"ME+YnZ17+rnnDxweHOi9iCM+gzbLOXLrG8piu46JIO5/4NHD9XpwbEPfEqjJ01R0XecDYcz8lvhF"+"MSEkwJIBaU76AZA+SsST5oHOmidqvsHQieYk6ya/ucysT/pPon6yLum/5tXN4uV45ocAKHEeWFdQ"+"YcpKKb4wNnH/xMTUjwGYArBofLHfuhfjeO+eXbu+/ms+946JyWl16NAxWmV80AZGImW+M0z/dxWU"+"NbvJNQzaqNK4ro13v/NN9C//doP4gz/+mxKAWWNQb2hHzL/s0n1XDfT3W3fe8wRAVmLytCE56HM3"+"LL/E+bRqb+niFZ9rSvD0nnHzd2Y+M3vs5Ckwc/S9QQMABgGc0cvS9fU8migi0uUDey7asfvQ4eMQ"+"louuzs74Am0sL4TZQhHHTpzG8FB/qdRR3DU9M/sUgJqmphfjhJaa9H1v9/Ztw/1PPn0QtWoNs7Oz"+"WBltATiOixMnzuCS/bvtgTBwCQXg6s5fNLdTmnkuSAKww0WrS7q6St7E5Ax6egbWWHpow3EcnDs/"+"EX8v6fDw4J4XDhzxASwAEOvSAF2Wu2j3jssAQqVSQ6+ULTQ/W3+pQy/dYHauEi9Sbhsd2gGgqB2x"+"BEDN+gCpy3rCCGjP5OQ0FHO0idGeDTexHRkoxvjEJHZsGxkE0APgnO5TYc6x1hKAIKJtu3dtGzp1"+"+hyKxY5oB6wpDWibIRenTp3D6OhQl5RyMAiC5w0TRCtpACW+rM8aGR7cPzTYX3ziqQPw/dzmm4gt"+"YOaYGZ7n4cTJs3jVK67xw++l23723AVtURLhaFIDEuGnG47+S33fo8mpWZQ6XUxPT6ONtfeD7dgR"+"j6NQyNHQ0MCOUAA2ANmMBpAhhGJo//eFy6lgFsjn823zsw6cnhyHUhw74kcfe8ozfMCKAkjOAYb2"+"7tk5cubsBTiuF3v35h1w2xwpRmgxZrBj+/AIgA4AY7pfsZYGyIi6uzv3hHOArocefQbMwNTUVFsD"+"mjdDIUmcDgfv6OhwH4CIjie0gJfVAF3J2bVjWzgB65TnL0ygs7NrnROwthZUqzWcPHUOV1y2txiu"+"JA/Pzc0/spYJEob5ye/Zs/NiZka5XEVPr4821gfP9xAN3nA9yB4c6Nt+cG5eLvPGDCdNUKNS7769"+"u3ZGX1NfqwfR+s//C/PDnH5TRq+kxun8fBkdxQJGhgd2Hjx01BBAwgQl7L/I5fyd4RJE3+TUdNjI"+"PKSc0AJg/T+JxNNnK5Uly3VuterJOpzh3hmts5DWKExy3/j6l2J4eAAjI4PbjG9UF6YQrMaBWRCu"+"fu4fHRn0Bvp7USzkUS4vmD9as+IP3cSHWL5eXGTUizk6v/IDubodM7+++qs+ENbsg2RxLlE/5pr1"+"Ew8H25aFnp6u2CFvGx0e0JHQGdMEJTWgkTo7d4xe3NfXg1KpiLe86TWg9ONtc3eKuVX3yatei5m1"+"AIa6pRT9QaCeb2YporBzx7Zd0chnRkgKbaSLsMLZcK6/rzecU53n5TSAEkw/HPkFy86BpJtq3LRB"+"IK6jq7NDhPOqPi0A0+cuuxq6EMas5bGJaVQWFWgTbrqVTdEX9f4ZvmfB9/3Il5bW2hNmnZbDB4om"+"Lpw/h7n5RYCa+3E0ToY4Jp9XiGSYk/WMvHmlxDEn7yN5ffN4mTzrM808G+0leJqVbG81njbfjFJH"+"Hr4no4lZ3fjRT06GoWxQ+eFHn7rTz/1Tv5QSrBQpZrAmfVMaQJyNOXHOPESjztJfs54uxFJWl5q1"+"zYuZRzD+RzAPEufoJFln2TyMv8axwUheJPGRVSMFEHe4ZckqMy8cOXLin5f7xVUyyPypwhKAHp13"+"IjJCVW4iHGAz30Q5mmx3I+dwyvbWE36x0ck1AFW9Gb+g06qmWkMQVuLEQEtuVldyjR/vFJqyjxNb"+"6+mTA6DV96HMvkx0ej2pAZZxoBL5QJ8oDKIW3jxnfA5twj1xUhPMjjd9wGpOOEgIgUzaxFG8RZ4F"+"Tgxos9N1atajtd+S1LytA26p8NKbQE7/0+BtpNakNtpoo4022vgf7lRPtKCE39oAAAAASUVORK5C"+"YII=");lib.resource.add("hterm/concat/date","text/plain","Mon, 01 Apr 2024 19:43:41 +0000");lib.resource.add("hterm/changelog/version","text/plain","1.92.1");lib.resource.add("hterm/changelog/date","text/plain","2022-03-04");lib.resource.add("hterm/git/HEAD","text/plain","d282bc164a38c1b3ff25cf0e64c640a506c749ea");
