
<p align="center">
  <img src="assets/images/contribution_cover.png" width="700" align="center"/>
</p><br>

# Contributing to the Project

> First of all, thanks for considering or taking the time to contribute!

The following is a simple guide on contributing to this Project. These are mostly guidelines, so feel free to use your best judgement and propose changes to this document in a pull request.

### Did you fix whitespace, format code, or make a purely cosmetic patch?

- Changes that are cosmetic in nature and do not add anything substantial to the stability, functionality, or testability of the project will generally not be accepted.

### Do you intend to add a new feature or change an existing one?

- Suggest your idea to [my email](mailto:saad01.1999@gmail.com) and start development on your idea.
- Do not open an issue on GitHub until you have collected positive feedback about the change. GitHub issues are primarily intended for bug reports and fixes.
- If you want to add to this project, I have a list of features to add in the future [here](README.md#future-improvements). It would be best if you pick a feature from this list to develop on.
- Once development is complete, make a pull request to this project's master branch. Ensure the Pull Request's description clearly (and in detail) defines the goal, functionality and purpose of the new feature as well as details on the changes in original Project files.

### Did you find a bug?

- Ensure the bug was not already reported by searching on GitHub under Issues.
- If you're unable to find an open issue addressing the problem, open a [new one](https://github.com/msaad1999/PHP-Login-System/issues/new). Be sure to include a title and clear description, as much relevant information as possible, and a code sample or an executable test case demonstrating the expected behavior that is not occurring.

### Did you write a patch that fixes a bug?

- Open a new GitHub pull request with the patch.
- Ensure the Pull Request description clearly describes the problem and solution.

### Do you have questions about the source code?

- Ask any questions related to the Project to [my email](mailto:saad01.1999@gmail.com).


> Any contribution from you guys would be greatly appreciated and welcomed.
