/*
 * Decompiled with CFR 0.152.
 */
package dev.zomboid.util;

import dev.zomboid.FailedFindMethodException;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class Inject {
    public static MethodNode findMethodSafe(ClassNode node, String name, String desc) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals(name) || !method.desc.equals(desc)) continue;
            return method;
        }
        return null;
    }

    public static MethodNode findMethod(ClassNode node, String name, String desc) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals(name) || !method.desc.equals(desc)) continue;
            return method;
        }
        throw new FailedFindMethodException("Failed to find " + name + desc + " in " + node.name);
    }

    public static void injectVirtualCallsBeforeReturns(MethodNode node, String owner, String name, String desc) {
        for (AbstractInsnNode ain : node.instructions.toArray()) {
            if (ain.getOpcode() < 172 || ain.getOpcode() > 177) continue;
            node.instructions.insertBefore(ain, new VarInsnNode(25, 0));
            node.instructions.insertBefore(ain, new MethodInsnNode(184, owner, name, desc));
        }
    }

    public static void injectStaticCallsBeforeReturns(MethodNode node, String owner, String name, String desc) {
        for (AbstractInsnNode ain : node.instructions.toArray()) {
            if (ain.getOpcode() < 172 || ain.getOpcode() > 177) continue;
            node.instructions.insertBefore(ain, new MethodInsnNode(184, owner, name, desc));
        }
    }

    public static void injectVirtualCallsBegin(MethodNode node, String owner, String name, String desc) {
        node.instructions.insert(new MethodInsnNode(184, owner, name, desc));
        node.instructions.insert(new VarInsnNode(25, 0));
    }

    public static void injectStaticCallsBegin(MethodNode node, String owner, String name, String desc) {
        node.instructions.insert(new MethodInsnNode(184, owner, name, desc));
    }

    private Inject() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

