/*
 * Decompiled with CFR 0.152.
 */
package dev.zomboid.interp;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ThreadLocalRandom;
import zombie.GameWindow;
import zombie.core.raknet.UdpConnection;
import zombie.core.raknet.UdpEngine;
import zombie.debug.DebugLog;
import zombie.network.GameClient;
import zombie.network.ZomboidNetData;
import zombie.network.ZomboidNetDataPool;

public final class NetworkingStub {
    public static void addIncomingServer(short opcode, ByteBuffer data, UdpConnection connection) {
        ZomboidNetData packet = ZomboidNetDataPool.instance.getLong(data.limit());
        data.mark();
        packet.read(opcode, data, connection);
        data.reset();
    }

    public static void addIncomingClient(short opcode, ByteBuffer data) {
        ZomboidNetData packet = ZomboidNetDataPool.instance.getLong(data.limit());
        data.mark();
        packet.read(opcode, data, GameClient.connection);
        data.reset();
        int id = packet.buffer.getInt();
        String table = GameWindow.ReadString((ByteBuffer)packet.buffer);
        DebugLog.log((String)("Received database query '" + table + "'"));
        int rows = packet.buffer.getInt();
        for (int i = 0; i < rows; ++i) {
            int columns = packet.buffer.getInt();
            for (int j = 0; j < columns; ++j) {
                String key = GameWindow.ReadString((ByteBuffer)packet.buffer);
                String val = GameWindow.ReadString((ByteBuffer)packet.buffer);
                DebugLog.log((String)(" -> " + key + ":" + val));
            }
        }
    }

    public static void decode(UdpEngine engine, ByteBuffer b) {
        b.mark();
        int type = b.get() & 0xFF;
        System.out.println("... " + type);
        if (type == 16) {
            int i;
            int index = b.get() & 0xFF;
            long guid = engine.getPeer().getGuidOfPacket();
            GameClient.connection = new UdpConnection(engine, guid, index);
            ThreadLocalRandom r = ThreadLocalRandom.current();
            LinkedList<Integer> rnd = new LinkedList<Integer>();
            for (i = 0; i < 255; ++i) {
                rnd.add(i);
            }
            for (i = 0; i < 1000; ++i) {
                int xi = r.nextInt(rnd.size());
                int x = (Integer)rnd.get(xi);
                int yi = r.nextInt(rnd.size());
                int y = (Integer)rnd.get(yi);
                rnd.set(xi, y);
                rnd.set(yi, x);
            }
            Iterator iterator = rnd.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
            }
        }
        b.reset();
    }

    private NetworkingStub() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

