/*
 * Decompiled with CFR 0.152.
 */
package dev.zomboid;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public final class ZomboidClassPath {
    private final Path root;

    public ZomboidClassPath(String root) {
        this.root = Paths.get(root, new String[0]);
    }

    private String normalize(String dir) {
        dir = ((String)dir).replace('/', '\\');
        dir = (String)dir + ".class";
        return dir;
    }

    private boolean isInjected(String dir) throws IOException {
        ClassReader cr = new ClassReader(Files.readAllBytes(this.root.resolve(dir)));
        ClassNode cn = new ClassNode();
        cr.accept(cn, 0);
        for (AnnotationNode node : cn.visibleAnnotations) {
            if (!node.desc.equals("Ldev/zomboid/Injected;")) continue;
            return true;
        }
        return false;
    }

    public ClassNode readClass(String dir) throws IOException {
        Path bkup = this.root.resolve((String)(dir = this.normalize((String)dir)) + ".bkup");
        if (Files.exists(bkup, new LinkOption[0]) && this.isInjected((String)dir)) {
            dir = (String)dir + ".bkup";
        }
        ClassReader cr = new ClassReader(Files.readAllBytes(this.root.resolve((String)dir)));
        ClassNode cn = new ClassNode();
        cr.accept(cn, 0);
        return cn;
    }

    public void replaceClass(String dir, ClassNode node) throws IOException {
        dir = this.normalize(dir);
        Path orig = this.root.resolve(dir);
        Path bkup = this.root.resolve(dir + ".bkup");
        if (!Files.exists(bkup, new LinkOption[0]) || !this.isInjected(dir)) {
            Files.copy(orig, bkup, new CopyOption[0]);
        }
        ClassWriter cw = new ClassWriter(0);
        node.accept(cw);
        Files.write(orig, cw.toByteArray(), new OpenOption[0]);
    }
}

