/*
 * Decompiled with CFR 0.152.
 */
package dev.zomboid;

import dev.zomboid.GamePatcher;
import dev.zomboid.GamePatcherCfg;
import dev.zomboid.ZomboidClassPath;
import java.io.IOException;

public final class ToolEp {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println("Please specify either -install or -uninstall.");
            return;
        }
        ZomboidClassPath cp = new ZomboidClassPath(".");
        GamePatcher patcher = new GamePatcher(cp);
        switch (args[0]) {
            case "-install": {
                GamePatcherCfg cfg = new GamePatcherCfg();
                for (String s : args) {
                    if (s.equals("-client")) {
                        cfg.setClient(true);
                        continue;
                    }
                    if (!s.equals("-server")) continue;
                    cfg.setServer(true);
                }
                if (!cfg.isClient() && !cfg.isServer()) {
                    System.out.println("Please specify either -client or -server to enable all features.");
                }
                System.out.println("Installing...");
                patcher.install(cfg);
                break;
            }
            case "-uninstall": {
                System.out.println("Uninstalling...");
                patcher.uninstall();
                break;
            }
            default: {
                System.out.println("Unknown command line argument '" + args[0] + "'");
            }
        }
    }

    private ToolEp() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

