/*
 * Decompiled with CFR 0.152.
 */
package dev.zomboid;

import zombie.characters.IsoPlayer;
import zombie.commands.AltCommandArgs;
import zombie.commands.CommandArgs;
import zombie.commands.CommandHelp;
import zombie.commands.CommandName;
import zombie.commands.CommandNames;
import zombie.commands.RequiredRight;
import zombie.core.network.ByteBufferWriter;
import zombie.network.GameClient;
import zombie.network.PacketTypes;
import zombie.network.packets.PlayerPacket;

@CommandNames(value={@CommandName(name="teleport"), @CommandName(name="tp")})
@AltCommandArgs(value={@CommandArgs(required={"(.+)"}, argName="just port to user"), @CommandArgs(required={"(.+)", "(.+)"}, argName="teleport user1 to user 2")})
@CommandHelp(helpText="UI_ServerOptionDesc_Teleport")
@RequiredRight(requiredRights=62)
public class TeleportToCommand {
    public static IsoPlayer primaryPlayer() {
        return GameClient.connection.players[0];
    }

    public static void TeleportToCommand(IsoPlayer player, float x, float y, float z) {
        ByteBufferWriter startPacket = GameClient.connection.startPacket();
        PacketTypes.PacketType.Teleport.doPacket(startPacket);
        float deltaX = x - player.x;
        float deltaY = y - player.y;
        float deltaZ = z - player.z;
        float remX = Math.abs(deltaX);
        float remY = Math.abs(deltaY);
        float remZ = Math.abs(deltaZ);
        while (remX > 0.0f || remY > 0.0f || remZ > 0.0f) {
            float moveX = Math.min(remX, 3.9f);
            float moveY = Math.min(remY, 3.9f);
            float moveZ = Math.min(remZ, 3.9f);
            remX -= moveX;
            remY -= moveY;
            remZ -= moveZ;
            if (deltaX < 0.0f) {
                moveX = -moveX;
            }
            if (deltaY < 0.0f) {
                moveY = -moveY;
            }
            if (deltaZ < 0.0f) {
                moveZ = -moveZ;
            }
            startPacket.putFloat(player.x + moveX);
            startPacket.putFloat(player.y + moveY);
            startPacket.putFloat(player.z + moveZ);
            player.setLx(player.getX());
            player.setLy(player.getY());
            player.setLz(player.getZ());
            GameClient.instance.sendPlayer(player);
            if (!PlayerPacket.l_send.playerPacket.set(player)) continue;
            ByteBufferWriter writer = GameClient.connection.startPacket();
            PacketTypes.PacketType.Teleport.doPacket(startPacket);
            PacketTypes.PacketType.PlayerUpdateReliable.doPacket(writer);
            PlayerPacket.l_send.playerPacket.write(writer);
            PacketTypes.PacketType.PlayerUpdateReliable.send(GameClient.connection);
        }
    }
}

