/*
 * Decompiled with CFR 0.152.
 */
package dev.zomboid;

import dev.zomboid.GamePatcherCfg;
import dev.zomboid.ZomboidClassPath;
import dev.zomboid.util.Inject;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class GamePatcher {
    private final ZomboidClassPath cp;
    private static final String INJECTED_ANNOTATION = "Ldev/zomboid/Injected;";
    private static final String[] RESTORATION_FILES = new String[]{"zombie/core/Core", "zombie/network/GameClient", "zombie/network/GameServer", "zombie/core/raknet/UdpEngine"};

    private void markInjected(ClassNode cl) {
        if (cl.visibleAnnotations == null) {
            cl.visibleAnnotations = new LinkedList<AnnotationNode>();
        }
        cl.visibleAnnotations.add(new AnnotationNode(INJECTED_ANNOTATION));
    }

    private boolean injectCore() throws IOException {
        String name = "zombie/core/Core";
        ClassNode cl = this.cp.readClass(name);
        this.markInjected(cl);
        MethodNode mt = Inject.findMethod(cl, "EndFrameUI", "()V");
        Inject.injectVirtualCallsBegin(mt, "dev/zomboid/interp/RenderingStub", "endFrameUi", "(Lzombie/core/Core;)V");
        this.cp.replaceClass(name, cl);
        return true;
    }

    private boolean injectGameClient() throws IOException {
        String name = "zombie/network/GameClient";
        ClassNode cl = this.cp.readClass(name);
        this.markInjected(cl);
        MethodNode addIncoming = Inject.findMethod(cl, "addIncoming", "(SLjava/nio/ByteBuffer;)V");
        addIncoming.instructions.insert(new MethodInsnNode(184, "dev/zomboid/interp/NetworkingStub", "addIncomingClient", "(SLjava/nio/ByteBuffer;)V"));
        addIncoming.instructions.insert(new VarInsnNode(25, 2));
        addIncoming.instructions.insert(new VarInsnNode(21, 1));
        this.cp.replaceClass(name, cl);
        return true;
    }

    private boolean injectUdpEngine() throws IOException {
        String name = "zombie/core/raknet/UdpEngine";
        ClassNode cl = this.cp.readClass(name);
        this.markInjected(cl);
        MethodNode decode = Inject.findMethod(cl, "decode", "(Ljava/nio/ByteBuffer;)V");
        decode.instructions.insert(new MethodInsnNode(184, "dev/zomboid/interp/NetworkingStub", "decode", "(Lzombie/core/raknet/UdpEngine;Ljava/nio/ByteBuffer;)V"));
        decode.instructions.insert(new VarInsnNode(25, 1));
        decode.instructions.insert(new VarInsnNode(25, 0));
        this.cp.replaceClass(name, cl);
        return true;
    }

    private boolean injectGameServer() throws IOException {
        String name = "zombie/network/GameServer";
        ClassNode cl = this.cp.readClass(name);
        this.markInjected(cl);
        MethodNode addIncoming = Inject.findMethod(cl, "addIncoming", "(SLjava/nio/ByteBuffer;Lzombie/core/raknet/UdpConnection;)V");
        MethodNode main = Inject.findMethod(cl, "main", "([Ljava/lang/String;)V");
        addIncoming.instructions.insert(new MethodInsnNode(184, "dev/zomboid/interp/NetworkingStub", "addIncomingServer", "(SLjava/nio/ByteBuffer;Lzombie/core/raknet/UdpConnection;)V"));
        addIncoming.instructions.insert(new VarInsnNode(25, 2));
        addIncoming.instructions.insert(new VarInsnNode(25, 1));
        addIncoming.instructions.insert(new VarInsnNode(21, 0));
        Inject.injectStaticCallsBegin(main, "dev/zomboid/interp/CoreStub", "serverMain", "()V");
        this.cp.replaceClass(name, cl);
        return true;
    }

    private void extractSelf(String path) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(new FileInputStream(path));
        while ((entry = zis.getNextEntry()) != null) {
            int read;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] tmp = new byte[4096];
            while ((read = zis.read(tmp)) != -1) {
                bos.write(tmp, 0, read);
            }
            Path p = Paths.get(entry.getName(), new String[0]);
            if (entry.isDirectory()) {
                Files.createDirectories(p, new FileAttribute[0]);
                continue;
            }
            if (p.getParent() != null) {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
            }
            Files.write(Paths.get(entry.getName(), new String[0]), bos.toByteArray(), new OpenOption[0]);
        }
    }

    public void install(GamePatcherCfg cfg) throws IOException {
        System.out.println("Removing old installation");
        this.uninstall();
        System.out.println("Injecting into Core");
        this.injectCore();
        System.out.println("Injecting into UdpEngine");
        this.injectUdpEngine();
        if (cfg.isClient()) {
            System.out.println("Injecting into GameClient");
            this.injectGameClient();
        }
        if (cfg.isServer()) {
            System.out.println("Injecting into GameServer");
            this.injectGameServer();
        }
        System.out.println("Extracting dependencies from self");
        this.extractSelf(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        System.out.println("Done!");
    }

    private void removeBackup(String name) throws IOException {
        Path modified = Paths.get(name + ".class", new String[0]);
        Path backup = Paths.get(name + ".class.bkup", new String[0]);
        if (Files.exists(modified, new LinkOption[0]) && Files.exists(backup, new LinkOption[0])) {
            Files.delete(modified);
            Files.move(backup, modified, new CopyOption[0]);
        }
    }

    public void uninstall() throws IOException {
        for (String s : RESTORATION_FILES) {
            System.out.println("Replacing '" + s + "' with backup");
            this.removeBackup(s);
        }
    }

    public GamePatcher(ZomboidClassPath cp) {
        this.cp = cp;
    }
}

