/*
 * Decompiled with CFR 0.152.
 */
package dev.zomboid;

import dev.zomboid.AntiCheatAction;
import dev.zomboid.AntiCheatCfg;
import dev.zomboid.DiscordWebhook;
import dev.zomboid.util.RateLimiter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import zombie.GameWindow;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.chat.ChatMessage;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.network.ServerWorldDatabase;
import zombie.network.ZomboidNetData;
import zombie.network.chat.ChatServer;
import zombie.network.packets.DeadPlayerPacket;
import zombie.network.packets.hit.HitCharacterPacket;
import zombie.network.packets.hit.Player;
import zombie.network.packets.hit.PlayerHitPlayerPacket;
import zombie.network.packets.hit.PlayerHitSquarePacket;
import zombie.network.packets.hit.PlayerHitZombiePacket;
import zombie.network.packets.hit.Square;
import zombie.network.packets.hit.Zombie;

public class AntiCheat {
    private final Map<String, CustomNetworkData> customNetworkDataMap = new HashMap<String, CustomNetworkData>();
    private Field playerHitZombiePacketTarget;
    private Field zombieZombie;
    private Field playerHitPlayerPacketTarget;
    private Field playerHitPlayerPacketHit;
    private Field playerPlayer;
    private Field playerHitSquarePacketSquare;
    private Field squareX;
    private Field squareY;
    private Field squareZ;
    private AntiCheatCfg cfg = new AntiCheatCfg();

    public AntiCheat() {
        try {
            this.playerHitPlayerPacketTarget = PlayerHitPlayerPacket.class.getDeclaredField("target");
            this.playerHitPlayerPacketTarget.setAccessible(true);
            this.playerHitPlayerPacketHit = PlayerHitPlayerPacket.class.getDeclaredField("hit");
            this.playerHitPlayerPacketHit.setAccessible(true);
            this.playerPlayer = Player.class.getDeclaredField("player");
            this.playerPlayer.setAccessible(true);
            this.playerHitZombiePacketTarget = PlayerHitZombiePacket.class.getDeclaredField("target");
            this.playerHitZombiePacketTarget.setAccessible(true);
            this.zombieZombie = Zombie.class.getDeclaredField("zombie");
            this.zombieZombie.setAccessible(true);
            this.playerHitSquarePacketSquare = PlayerHitSquarePacket.class.getDeclaredField("square");
            this.playerHitSquarePacketSquare.setAccessible(true);
            this.squareX = Square.class.getDeclaredField("positionX");
            this.squareX.setAccessible(true);
            this.squareY = Square.class.getDeclaredField("positionY");
            this.squareY.setAccessible(true);
            this.squareZ = Square.class.getDeclaredField("positionZ");
            this.squareZ.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            DebugLog.log((String)"Failed to initialized hidden field access");
        }
    }

    private boolean distanceCheck(IsoPlayer a, IsoPlayer b, float distance) {
        return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0)) < (double)distance;
    }

    private boolean distanceCheck(UdpConnection a, IsoPlayer b, float distance) {
        for (IsoPlayer a2 : a.players) {
            if (a2 == null || !this.distanceCheck(a2, b, distance)) continue;
            return true;
        }
        return false;
    }

    private boolean distanceCheck(IsoPlayer a, float x, float y, float z, float distance) {
        return Math.sqrt(Math.pow(a.x - x, 2.0) + Math.pow(a.y - y, 2.0) + Math.pow(a.z - z, 2.0)) < (double)distance;
    }

    private boolean distanceCheck(UdpConnection a, float x, float y, float z, float distance) {
        for (IsoPlayer a2 : a.players) {
            if (a2 == null || !this.distanceCheck(a2, x, y, z, distance)) continue;
            return true;
        }
        return false;
    }

    private CustomNetworkData getCustomNetworkData(UdpConnection con, String name) {
        CustomNetworkData data = this.customNetworkDataMap.computeIfAbsent(name, n -> new CustomNetworkData());
        data.connection = con;
        return data;
    }

    private CustomNetworkData getCustomNetworkData(UdpConnection con) {
        for (CustomNetworkData data : this.customNetworkDataMap.values()) {
            if (data.connection != con) continue;
            return data;
        }
        return null;
    }

    private CustomNetworkData getCustomNetworkDataAny(UdpConnection con) {
        for (IsoPlayer p : con.players) {
            if (p == null) continue;
            return this.getCustomNetworkData(con, p.getUsername());
        }
        return null;
    }

    private IsoPlayer getPlayerFromConnection(UdpConnection con, int index) {
        if (index < 0) {
            return null;
        }
        if (index >= 4) {
            return null;
        }
        return con.players[index];
    }

    private IsoPlayer anyPlayerFromConnection(UdpConnection con) {
        for (IsoPlayer p : con.players) {
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private boolean playerBelongsToConnection(UdpConnection con, IsoPlayer p) {
        for (IsoPlayer p2 : con.players) {
            if (p2 != p) continue;
            return true;
        }
        return false;
    }

    private boolean canCheat(UdpConnection con) {
        return true;
    }

    private void reportToDiscord(String msg) {
        DiscordWebhook hook = new DiscordWebhook(this.cfg.getDiscordApi());
        hook.setContent(StringEscapeUtils.escapeJava(msg));
        hook.setTts(false);
        try {
            hook.execute();
        }
        catch (IOException e) {
            DebugLog.log((String)"Failed to execute discord hook");
        }
    }

    public void handleMalformedPacket(UdpConnection con, ZomboidNetData packet, String reason) {
        if (this.canCheat(con)) {
            return;
        }
        Object name = "No associated player";
        IsoPlayer p = this.anyPlayerFromConnection(con);
        if (p != null) {
            name = p.getUsername() + " (" + p.getSurname() + " " + p.getForname() + ") Steam: " + p.getSteamID();
        }
        this.reportToDiscord("## Malformed packet for player __" + (String)name + "__  \nReason: __" + reason + "__");
        DebugLog.log((String)("Handling malformed packet on " + con));
    }

    private void enforceActionBanSteamId(UdpConnection con, String reason) throws SQLException {
        for (IsoPlayer p : con.players) {
            if (p == null) continue;
            ServerWorldDatabase.instance.banSteamID(Long.toString(p.getSteamID()), reason, true);
        }
    }

    private void enforceActionBanIp(UdpConnection con, String reason) throws SQLException {
        for (IsoPlayer p : con.players) {
            if (p == null) continue;
            ServerWorldDatabase.instance.banIp(con.ip, p.getUsername(), reason, true);
        }
    }

    private void enforceAction(UdpConnection con, String reason, AntiCheatAction action) {
        try {
            switch (action) {
                case BAN_STEAM_ID: {
                    this.enforceActionBanSteamId(con, reason);
                    break;
                }
                case BAN_IP: {
                    this.enforceActionBanIp(con, reason);
                    break;
                }
                case BAN_ALL: {
                    this.enforceActionBanSteamId(con, reason);
                    this.enforceActionBanIp(con, reason);
                    break;
                }
            }
        }
        catch (Throwable e) {
            DebugLog.log((String)"[enforceAction] Exception occurred during action.");
        }
    }

    private void handleViolation(UdpConnection con, String reason, AntiCheatAction action) {
        if (this.canCheat(con)) {
            return;
        }
        DebugLog.log((String)("Handling violation on " + con + " for '" + reason + "'"));
        Object name = "No associated player";
        String steam = "No associated steam";
        IsoPlayer p = this.anyPlayerFromConnection(con);
        if (p != null) {
            name = p.getUsername() + " (" + p.getSurname() + " " + p.getForname() + ")";
            steam = Long.toString(p.getSteamID());
        }
        this.reportToDiscord("## Violation generated for player __" + (String)name + "__  \nSteam: __" + steam + "__  \nReason: __" + reason + "__");
        this.enforceAction(con, reason, action);
    }

    private boolean validateSyncPerk(CustomNetworkData data, Perk perk, int v) {
        if (data.lastKnownPerks.containsKey((Object)perk)) {
            int diff = Math.abs(data.lastKnownPerks.get((Object)perk) - v);
            return diff <= this.cfg.getSyncPerksRule().getThreshold();
        }
        return true;
    }

    private void enforceSyncPerks(UdpConnection con, ZomboidNetData packet) {
        ByteBuffer b = packet.buffer;
        byte index = b.get();
        int sneak = b.getInt();
        int str = b.getInt();
        int fit = b.getInt();
        IsoPlayer player = this.getPlayerFromConnection(con, index);
        if (player == null) {
            return;
        }
        CustomNetworkData data = this.getCustomNetworkData(con, player.getUsername());
        if (this.cfg.getSyncPerksRule().isEnabled()) {
            if (!data.validatePlayer(player)) {
                this.handleViolation(con, "[enforceSyncPerks] Failed to validate player", this.cfg.getSyncPerksRule().getAction());
                return;
            }
            if (!this.validateSyncPerk(data, Perk.SNEAK, sneak)) {
                this.handleViolation(con, "[enforceSyncPerks] Failed to validate sneak", this.cfg.getSyncPerksRule().getAction());
                return;
            }
            if (!this.validateSyncPerk(data, Perk.STR, str)) {
                this.handleViolation(con, "[enforceSyncPerks] Failed to validate str", this.cfg.getSyncPerksRule().getAction());
                return;
            }
            if (!this.validateSyncPerk(data, Perk.FIT, fit)) {
                this.handleViolation(con, "[enforceSyncPerks] Failed to validate fit", this.cfg.getSyncPerksRule().getAction());
                return;
            }
        }
        data.lastKnownPerks.put(Perk.SNEAK, sneak);
        data.lastKnownPerks.put(Perk.STR, str);
        data.lastKnownPerks.put(Perk.FIT, fit);
    }

    private void enforceExtraInfo(UdpConnection con, ZomboidNetData packet) {
        if (this.cfg.getExtraInfoRule().isEnabled()) {
            this.handleViolation(con, "[enforceExtraInfo] Not allowed to send extra info", this.cfg.getExtraInfoRule().getAction());
            return;
        }
    }

    private void enforceSendPlayerDeath(UdpConnection con, ZomboidNetData packet) {
        DeadPlayerPacket dp = new DeadPlayerPacket();
        IsoPlayer target = dp.getPlayer();
        if (this.cfg.getPlayerDeathsRule().isEnabled() && !this.playerBelongsToConnection(con, target)) {
            this.handleViolation(con, "[enforceSendPlayerDeath] Sending player death to other player", this.cfg.getPlayerDeathsRule().getAction());
            return;
        }
        if (this.cfg.getDistanceRule().isEnabled() && !this.distanceCheck(con, target.x, target.y, target.z, 100.0f)) {
            this.handleViolation(con, "[enforceSendPlayerDeath] Player too far from death", this.cfg.getDistanceRule().getAction());
            return;
        }
    }

    private void enforceKillZombie(UdpConnection con, ZomboidNetData packet) {
        short index = packet.buffer.getShort();
        boolean fall = packet.buffer.get() != 0;
        IsoZombie z = (IsoZombie)ServerMap.instance.ZombieMap.get(index);
        if (z == null) {
            return;
        }
        if (this.cfg.getDistanceRule().isEnabled() && !this.distanceCheck(con, z.x, z.y, z.z, 100.0f)) {
            this.handleViolation(con, "[enforceKillZombie] Player too far from death", this.cfg.getDistanceRule().getAction());
            return;
        }
    }

    private void enforceAdditionalPain(UdpConnection con, ZomboidNetData packet) {
        short id = packet.buffer.getShort();
        IsoPlayer target = (IsoPlayer)GameServer.IDToPlayerMap.get(id);
        if (this.cfg.getAdditionalPainRule().isEnabled()) {
            this.handleViolation(con, "[enforceAdditionalPain] Sending additional pain packet", this.cfg.getAdditionalPainRule().getAction());
            return;
        }
        if (target == null) {
            this.handleMalformedPacket(con, packet, "[enforceAdditionalPain] Attempting to inflict additional pain to non-existent player");
            return;
        }
        if (this.cfg.getDistanceRule().isEnabled() && !this.distanceCheck(con, target.x, target.y, target.z, this.cfg.getDistanceRule().getThreshold())) {
            this.handleViolation(con, "[enforceAdditionalPain] Player too far away", this.cfg.getDistanceRule().getAction());
            return;
        }
    }

    private void enforceRemoveGlass(UdpConnection con, ZomboidNetData packet) {
        short id = packet.buffer.getShort();
        IsoPlayer target = (IsoPlayer)GameServer.IDToPlayerMap.get(id);
        if (target == null) {
            this.handleMalformedPacket(con, packet, "[enforceRemoveGlass] Attempting to remove glass from non-existent player");
            return;
        }
        if (this.cfg.getDistanceRule().isEnabled() && !this.distanceCheck(con, target.x, target.y, target.z, this.cfg.getDistanceRule().getThreshold())) {
            this.handleViolation(con, "[enforceRemoveGlass] Player too far away", this.cfg.getDistanceRule().getAction());
            return;
        }
    }

    private void enforceRemoveBullet(UdpConnection con, ZomboidNetData packet) {
        short id = packet.buffer.getShort();
        IsoPlayer target = (IsoPlayer)GameServer.IDToPlayerMap.get(id);
        if (target == null) {
            this.handleMalformedPacket(con, packet, "[enforceRemoveBullet] Attempting to remove bullet from non-existent player");
            return;
        }
        if (this.cfg.getDistanceRule().isEnabled() && !this.distanceCheck(con, target.x, target.y, target.z, this.cfg.getDistanceRule().getThreshold())) {
            this.handleViolation(con, "[enforceRemoveBullet] Player too far away", this.cfg.getDistanceRule().getAction());
            return;
        }
    }

    private void enforceCleanBurn(UdpConnection con, ZomboidNetData packet) {
        short id = packet.buffer.getShort();
        IsoPlayer target = (IsoPlayer)GameServer.IDToPlayerMap.get(id);
        if (target == null) {
            this.handleMalformedPacket(con, packet, "[enforceCleanBurn] Attempting to clean burn of non-existent player");
            return;
        }
        if (this.cfg.getDistanceRule().isEnabled() && !this.distanceCheck(con, target.x, target.y, target.z, 100.0f)) {
            this.handleViolation(con, "[enforceCleanBurn] Player too far away", this.cfg.getDistanceRule().getAction());
            return;
        }
    }

    private void enforceSyncClothing(UdpConnection con, ZomboidNetData packet) {
        short id = packet.buffer.getShort();
        IsoPlayer target = (IsoPlayer)GameServer.IDToPlayerMap.get(id);
        if (target == null) {
            this.handleMalformedPacket(con, packet, "[enforceSyncClothing] Attempting to sync clothing of non-existent player");
            return;
        }
        if (this.cfg.getSyncClothingRule().isEnabled() && !this.playerBelongsToConnection(con, target)) {
            this.handleViolation(con, "[enforceSyncClothing] Sending clothing change to other player", this.cfg.getSyncClothingRule().getAction());
            return;
        }
    }

    private void enforcePlayerHitSquarePacket(UdpConnection con, ZomboidNetData packet, HitCharacterPacket hcp) {
        PlayerHitSquarePacket hp = (PlayerHitSquarePacket)hcp;
        try {
            Square sq = (Square)this.playerHitSquarePacketSquare.get(hp);
            float x = ((Float)this.squareX.get(sq)).floatValue();
            float y = ((Float)this.squareY.get(sq)).floatValue();
            float z = ((Float)this.squareZ.get(sq)).floatValue();
            if (this.cfg.getDistanceRule().isEnabled() && !this.distanceCheck(con, x, y, z, 100.0f)) {
                this.handleViolation(con, "[enforcePlayerHitSquarePacket] Player too far from hit", this.cfg.getDistanceRule().getAction());
                return;
            }
        }
        catch (IllegalAccessException e) {
            DebugLog.log((String)"Failed to read square info");
        }
    }

    private void enforcePlayerHitPlayerPacket(UdpConnection con, ZomboidNetData packet, HitCharacterPacket hcp) {
        PlayerHitPlayerPacket hp = (PlayerHitPlayerPacket)hcp;
        try {
            Player plr = (Player)this.playerHitPlayerPacketTarget.get(hp);
            IsoPlayer pl = (IsoPlayer)this.playerPlayer.get(plr);
            if (this.cfg.getDistanceRule().isEnabled() && !this.distanceCheck(con, pl.x, pl.y, pl.z, 100.0f)) {
                this.handleViolation(con, "[enforcePlayerHitPlayerPacket] Player too far from hit", this.cfg.getDistanceRule().getAction());
                return;
            }
        }
        catch (IllegalAccessException e) {
            DebugLog.log((String)"Failed to read player info");
        }
    }

    private void enforcePlayerHitZombiePacket(UdpConnection con, ZomboidNetData packet, HitCharacterPacket hcp) {
        PlayerHitZombiePacket hp = (PlayerHitZombiePacket)hcp;
        try {
            Zombie zombie = (Zombie)this.playerHitZombiePacketTarget.get(hp);
            IsoZombie zm = (IsoZombie)this.zombieZombie.get(zombie);
            if (this.cfg.getDistanceRule().isEnabled() && !this.distanceCheck(con, zm.x, zm.y, zm.z, 100.0f)) {
                this.handleViolation(con, "[enforcePlayerHitZombiePacket] Player too far from hit", this.cfg.getDistanceRule().getAction());
                return;
            }
        }
        catch (IllegalAccessException e) {
            DebugLog.log((String)"Failed to read zombie info");
        }
    }

    private void enforceWorldMessage(UdpConnection con, ZomboidNetData packet) {
        String author = GameWindow.ReadStringUTF((ByteBuffer)packet.buffer);
        String msg = GameWindow.ReadString((ByteBuffer)packet.buffer);
        if (this.cfg.getChatRule().isEnabled()) {
            boolean valid = false;
            for (IsoPlayer p : con.players) {
                if (p == null || !p.getUsername().equals(author)) continue;
                valid = true;
                break;
            }
            if (!valid) {
                this.handleViolation(con, "[enforceWorldMessage] Player sent message with wrong username", this.cfg.getChatRule().getAction());
                return;
            }
        }
    }

    private void enforceChatMessageFromPlayer(UdpConnection con, ZomboidNetData packet) {
        ChatMessage chatMessage = ChatServer.getInstance().unpackChatMessage(packet.buffer);
        String author = chatMessage.getAuthor();
        if (this.cfg.getChatRule().isEnabled()) {
            boolean valid = false;
            for (IsoPlayer p : con.players) {
                if (p == null || !p.getUsername().equals(author)) continue;
                valid = true;
                break;
            }
            if (!valid) {
                this.handleViolation(con, "[enforceChatMessageFromPlayer] Player sent message with wrong username", this.cfg.getChatRule().getAction());
                return;
            }
        }
    }

    public AntiCheatCfg getCfg() {
        return this.cfg;
    }

    public void setCfg(AntiCheatCfg cfg) {
        this.cfg = cfg;
    }

    private class CustomNetworkData {
        private final Map<Perk, Integer> lastKnownPerks = new HashMap<Perk, Integer>();
        private final Map<Short, RateLimiter> rateLimiters = new HashMap<Short, RateLimiter>();
        private UdpConnection connection;
        private IsoPlayer player;

        private CustomNetworkData() {
        }

        public RateLimiter createRateLimiter(short type, long delay) {
            return this.rateLimiters.computeIfAbsent(type, t -> new RateLimiter(delay));
        }

        public boolean validatePlayer(IsoPlayer p) {
            if (this.player == null) {
                this.player = p;
            }
            return this.player.getUsername().equals(p.getUsername());
        }
    }

    private static enum Perk {
        SNEAK,
        STR,
        FIT;

    }
}

