/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.writer;

import cn.maxpixel.mcdecompiler.asm.ClassifiedMappingRemapper;
import cn.maxpixel.mcdecompiler.deps.asm.Type;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectArrayList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectLists;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSet;
import cn.maxpixel.mcdecompiler.mapping.NamespacedMapping;
import cn.maxpixel.mcdecompiler.mapping.PairedMapping;
import cn.maxpixel.mcdecompiler.mapping.collection.ClassMapping;
import cn.maxpixel.mcdecompiler.mapping.component.Descriptor;
import cn.maxpixel.mcdecompiler.mapping.component.Documented;
import cn.maxpixel.mcdecompiler.mapping.component.LineNumber;
import cn.maxpixel.mcdecompiler.mapping.component.LocalVariableTable;
import cn.maxpixel.mcdecompiler.mapping.component.Owned;
import cn.maxpixel.mcdecompiler.mapping.component.StaticIdentifiable;
import cn.maxpixel.mcdecompiler.mapping.type.MappingType;
import cn.maxpixel.mcdecompiler.mapping.type.MappingTypes;
import cn.maxpixel.mcdecompiler.util.MappingUtil;
import cn.maxpixel.mcdecompiler.util.NamingUtil;
import cn.maxpixel.mcdecompiler.util.Utils;
import cn.maxpixel.mcdecompiler.writer.MappingGenerator;

public interface MappingGenerators {
    public static final MappingGenerator.Classified<PairedMapping> SRG = new MappingGenerator.Classified<PairedMapping>(){

        @Override
        public MappingType<PairedMapping, ObjectList<ClassMapping<PairedMapping>>> getType() {
            return MappingTypes.SRG;
        }

        @Override
        public ObjectList<String> generate(ObjectList<ClassMapping<PairedMapping>> mappings, ClassifiedMappingRemapper remapper) {
            ObjectArrayList<String> lines = new ObjectArrayList<String>();
            if (mappings.isEmpty()) {
                return lines;
            }
            mappings.parallelStream().forEach(cls -> {
                PairedMapping classMapping = (PairedMapping)cls.mapping;
                ObjectArrayList objectArrayList = lines;
                synchronized (objectArrayList) {
                    lines.add("CL: " + classMapping.getUnmappedName() + " " + classMapping.getMappedName());
                }
                cls.getFields().parallelStream().forEach(field -> {
                    if (!field.hasComponent(Owned.class)) {
                        throw new UnsupportedOperationException();
                    }
                    MappingUtil.checkOwner(field.getOwned(), cls);
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        lines.add("FD: " + classMapping.getUnmappedName() + "/" + field.getUnmappedName() + " " + classMapping.getMappedName() + "/" + field.getMappedName());
                    }
                });
                cls.getMethods().parallelStream().forEach(method -> {
                    String mappedDesc;
                    String unmappedDesc;
                    if (!method.hasComponent(Owned.class)) {
                        throw new UnsupportedOperationException();
                    }
                    MappingUtil.checkOwner(method.getOwned(), cls);
                    if (method.hasComponent(Descriptor.class)) {
                        unmappedDesc = method.getComponent(Descriptor.class).getUnmappedDescriptor();
                        if (method.hasComponent(Descriptor.Mapped.class)) {
                            mappedDesc = method.getComponent(Descriptor.Mapped.class).getMappedDescriptor();
                        } else {
                            if (remapper == null) throw new UnsupportedOperationException();
                            mappedDesc = remapper.getMappedDescByUnmappedDesc(unmappedDesc);
                        }
                    } else {
                        if (!method.hasComponent(Descriptor.Mapped.class)) throw new UnsupportedOperationException();
                        mappedDesc = method.getComponent(Descriptor.Mapped.class).getMappedDescriptor();
                        if (remapper == null) throw new UnsupportedOperationException();
                        unmappedDesc = remapper.getUnmappedDescByMappedDesc(mappedDesc);
                    }
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        lines.add("MD: " + classMapping.getUnmappedName() + "/" + method.getUnmappedName() + " " + unmappedDesc + " " + classMapping.getMappedName() + "/" + method.getMappedName() + " " + mappedDesc);
                        return;
                    }
                });
            });
            return lines;
        }

        @Override
        public ObjectList<String> generatePackages(ObjectList<PairedMapping> packages) {
            if (packages.isEmpty()) {
                return ObjectLists.emptyList();
            }
            ObjectArrayList<String> lines = new ObjectArrayList<String>();
            packages.parallelStream().forEach(pkg -> {
                ObjectArrayList objectArrayList = lines;
                synchronized (objectArrayList) {
                    lines.add("PK: " + pkg.getUnmappedName() + " " + pkg.getMappedName());
                }
            });
            return lines;
        }
    };
    public static final MappingGenerator.Classified<PairedMapping> CSRG = new MappingGenerator.Classified<PairedMapping>(){

        @Override
        public MappingType<PairedMapping, ObjectList<ClassMapping<PairedMapping>>> getType() {
            return MappingTypes.CSRG;
        }

        @Override
        public ObjectList<String> generate(ObjectList<ClassMapping<PairedMapping>> mappings, ClassifiedMappingRemapper remapper) {
            ObjectArrayList<String> lines = new ObjectArrayList<String>();
            if (mappings.isEmpty()) {
                return lines;
            }
            mappings.parallelStream().forEach(cls -> {
                PairedMapping classMapping = (PairedMapping)cls.mapping;
                ObjectArrayList objectArrayList = lines;
                synchronized (objectArrayList) {
                    lines.add(classMapping.getUnmappedName() + " " + classMapping.getMappedName());
                }
                cls.getFields().parallelStream().forEach(field -> {
                    if (!field.hasComponent(Owned.class)) {
                        throw new UnsupportedOperationException();
                    }
                    MappingUtil.checkOwner(field.getOwned(), cls);
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        lines.add(classMapping.getUnmappedName() + " " + field.getUnmappedName() + " " + field.getMappedName());
                    }
                });
                cls.getMethods().parallelStream().forEach(method -> {
                    String unmappedDesc = MappingUtil.Paired.checkSlimSrgMethod(cls, method, remapper);
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        lines.add(classMapping.getUnmappedName() + " " + method.getUnmappedName() + " " + unmappedDesc + " " + method.getMappedName());
                    }
                });
            });
            return lines;
        }

        @Override
        public ObjectList<String> generatePackages(ObjectList<PairedMapping> packages) {
            if (packages.isEmpty()) {
                return ObjectLists.emptyList();
            }
            ObjectArrayList<String> lines = new ObjectArrayList<String>();
            packages.parallelStream().forEach(pkg -> {
                ObjectArrayList objectArrayList = lines;
                synchronized (objectArrayList) {
                    lines.add(pkg.getUnmappedName() + "/ " + pkg.getMappedName() + "/");
                }
            });
            return lines;
        }
    };
    public static final MappingGenerator.Classified<PairedMapping> TSRG_V1 = new MappingGenerator.Classified<PairedMapping>(){

        @Override
        public MappingType<PairedMapping, ObjectList<ClassMapping<PairedMapping>>> getType() {
            return MappingTypes.TSRG_V1;
        }

        @Override
        public ObjectList<String> generate(ObjectList<ClassMapping<PairedMapping>> mappings, ClassifiedMappingRemapper remapper) {
            ObjectArrayList<String> lines = new ObjectArrayList<String>();
            if (mappings.isEmpty()) {
                return lines;
            }
            mappings.forEach(cls -> {
                lines.add(((PairedMapping)cls.mapping).getUnmappedName() + " " + ((PairedMapping)cls.mapping).getMappedName());
                cls.getFields().parallelStream().forEach(field -> {
                    if (!field.hasComponent(Owned.class)) {
                        throw new UnsupportedOperationException();
                    }
                    MappingUtil.checkOwner(field.getOwned(), cls);
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        lines.add("\t" + field.getUnmappedName() + " " + field.getMappedName());
                    }
                });
                cls.getMethods().parallelStream().forEach(method -> {
                    String unmappedDesc = MappingUtil.Paired.checkSlimSrgMethod(cls, method, remapper);
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        lines.add("\t" + method.getUnmappedName() + " " + unmappedDesc + " " + method.getMappedName());
                    }
                });
            });
            return lines;
        }

        @Override
        public ObjectList<String> generatePackages(ObjectList<PairedMapping> packages) {
            if (packages.isEmpty()) {
                return ObjectLists.emptyList();
            }
            ObjectArrayList<String> lines = new ObjectArrayList<String>();
            packages.parallelStream().forEach(pkg -> {
                ObjectArrayList objectArrayList = lines;
                synchronized (objectArrayList) {
                    lines.add(pkg.getUnmappedName() + "/ " + pkg.getMappedName() + "/");
                }
            });
            return lines;
        }
    };
    public static final MappingGenerator.Classified<NamespacedMapping> TSRG_V2 = new MappingGenerator.Classified<NamespacedMapping>(){

        @Override
        public MappingType<NamespacedMapping, ObjectList<ClassMapping<NamespacedMapping>>> getType() {
            return MappingTypes.TSRG_V2;
        }

        @Override
        public ObjectList<String> generate(ObjectList<ClassMapping<NamespacedMapping>> mappings, ClassifiedMappingRemapper remapper) {
            ObjectArrayList<String> lines = new ObjectArrayList<String>();
            if (mappings.isEmpty()) {
                return lines;
            }
            ObjectSet<String> namespaces = ((NamespacedMapping)((ClassMapping)mappings.get((int)0)).mapping).getNamespaces();
            String namespace0 = (String)namespaces.iterator().next();
            lines.add("tsrg2 " + String.join((CharSequence)" ", namespaces));
            mappings.forEach(cls -> {
                lines.add(NamingUtil.concatNamespaces(namespaces, ((NamespacedMapping)cls.mapping)::getName, " "));
                cls.getFields().parallelStream().forEach(field -> {
                    if (!field.hasComponent(Owned.class)) {
                        throw new UnsupportedOperationException();
                    }
                    MappingUtil.checkOwner(field.getOwned(), cls);
                    String names = NamingUtil.concatNamespaces(namespaces, field::getName, " ");
                    if (field.hasComponent(Descriptor.Namespaced.class)) {
                        ObjectArrayList objectArrayList = lines;
                        synchronized (objectArrayList) {
                            4.genDescriptorLine(lines, namespace0, field, names);
                        }
                    }
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        lines.add("\t" + names);
                    }
                });
                cls.getMethods().parallelStream().forEach(method -> {
                    if (!(method.hasComponent(Owned.class) && method.hasComponent(Descriptor.Namespaced.class) && method.hasComponent(StaticIdentifiable.class))) {
                        throw new UnsupportedOperationException();
                    }
                    MappingUtil.checkOwner(method.getOwned(), cls);
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        4.genDescriptorLine(lines, namespace0, method, NamingUtil.concatNamespaces(namespaces, method::getName, " "));
                        if (method.getComponent(StaticIdentifiable.class).isStatic) {
                            lines.add("\t\tstatic");
                        }
                        if (method.hasComponent(LocalVariableTable.Namespaced.class)) {
                            LocalVariableTable.Namespaced lvt = method.getComponent(LocalVariableTable.Namespaced.class);
                            lvt.getLocalVariableIndexes().forEach(index -> {
                                String names = NamingUtil.concatNamespaces(namespaces, namespace -> {
                                    String name = lvt.getLocalVariable(index).getName((String)namespace);
                                    if (name != null && name.isBlank()) {
                                        return "o";
                                    }
                                    return name;
                                }, " ");
                                lines.add("\t\t" + index + " " + names);
                            });
                        }
                    }
                });
            });
            return lines;
        }

        private static void genDescriptorLine(ObjectArrayList<String> lines, String namespace0, NamespacedMapping method, String names) {
            Descriptor.Namespaced desc = method.getComponent(Descriptor.Namespaced.class);
            if (!namespace0.equals(desc.getDescriptorNamespace())) {
                throw new IllegalArgumentException();
            }
            int i = names.indexOf(32);
            lines.add("\t" + names.substring(0, i + 1) + desc.getUnmappedDescriptor() + names.substring(i));
        }

        @Override
        public ObjectList<String> generatePackages(ObjectList<NamespacedMapping> packages) {
            if (packages.isEmpty()) {
                return ObjectLists.emptyList();
            }
            ObjectArrayList<String> lines = new ObjectArrayList<String>();
            ObjectSet<String> namespaces = ((NamespacedMapping)packages.get(0)).getNamespaces();
            packages.parallelStream().forEach(pkg -> {
                ObjectArrayList objectArrayList = lines;
                synchronized (objectArrayList) {
                    lines.add(NamingUtil.concatNamespaces(namespaces, pkg::getName, " "));
                }
            });
            return lines;
        }
    };
    public static final MappingGenerator.Classified<PairedMapping> PROGUARD = new MappingGenerator.Classified<PairedMapping>(){

        @Override
        public MappingType<PairedMapping, ObjectList<ClassMapping<PairedMapping>>> getType() {
            return MappingTypes.PROGUARD;
        }

        @Override
        public ObjectList<String> generate(ObjectList<ClassMapping<PairedMapping>> mappings, ClassifiedMappingRemapper remapper) {
            ObjectArrayList<String> lines = new ObjectArrayList<String>();
            if (mappings.isEmpty()) {
                return lines;
            }
            mappings.forEach(cls -> {
                PairedMapping mapping = (PairedMapping)cls.mapping;
                lines.add(NamingUtil.asJavaName(mapping.getMappedName()) + " -> " + NamingUtil.asJavaName(mapping.getUnmappedName()) + ":");
                cls.getFields().parallelStream().forEach(field -> {
                    String mappedDesc;
                    if (!field.hasComponent(Owned.class)) {
                        throw new UnsupportedOperationException();
                    }
                    MappingUtil.checkOwner(field.getOwned(), cls);
                    if (field.hasComponent(Descriptor.Mapped.class)) {
                        mappedDesc = field.getComponent(Descriptor.Mapped.class).getMappedDescriptor();
                    } else if (remapper != null && field.hasComponent(Descriptor.class)) {
                        mappedDesc = remapper.mapToMapped(Type.getType(field.getComponent(Descriptor.class).getUnmappedDescriptor()));
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        lines.add("    " + Type.getType(mappedDesc).getClassName() + " " + field.getMappedName() + " -> " + field.getUnmappedName());
                    }
                });
                cls.getMethods().parallelStream().forEach(method -> {
                    String mappedDesc;
                    if (!method.hasComponent(Owned.class)) {
                        throw new UnsupportedOperationException();
                    }
                    MappingUtil.checkOwner(method.getOwned(), cls);
                    if (method.hasComponent(Descriptor.Mapped.class)) {
                        mappedDesc = method.getComponent(Descriptor.Mapped.class).getMappedDescriptor();
                    } else if (remapper != null && method.hasComponent(Descriptor.class)) {
                        mappedDesc = remapper.getMappedDescByUnmappedDesc(method.getComponent(Descriptor.class).getUnmappedDescriptor());
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    String args = String.join((CharSequence)",", Utils.mapArray(Type.getArgumentTypes(mappedDesc), String[]::new, Type::getClassName));
                    if (method.hasComponent(LineNumber.class)) {
                        LineNumber lineNumber = method.getComponent(LineNumber.class);
                        ObjectArrayList objectArrayList = lines;
                        synchronized (objectArrayList) {
                            lines.add("    " + lineNumber.getStartLineNumber() + ":" + lineNumber.getEndLineNumber() + ":" + Type.getReturnType(mappedDesc).getClassName() + " " + method.getMappedName() + "(" + args + ") -> " + method.getUnmappedName());
                        }
                    }
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        lines.add("    " + Type.getReturnType(mappedDesc).getClassName() + " " + method.getMappedName() + "(" + args + ") -> " + method.getUnmappedName());
                    }
                });
            });
            return lines;
        }
    };
    public static final MappingGenerator.Classified<NamespacedMapping> TINY_V1 = new MappingGenerator.Classified<NamespacedMapping>(){

        @Override
        public MappingType<NamespacedMapping, ObjectList<ClassMapping<NamespacedMapping>>> getType() {
            return MappingTypes.TINY_V1;
        }

        @Override
        public ObjectList<String> generate(ObjectList<ClassMapping<NamespacedMapping>> mappings, ClassifiedMappingRemapper remapper) {
            ObjectArrayList<String> lines = new ObjectArrayList<String>();
            if (mappings.isEmpty()) {
                return lines;
            }
            ObjectSet<String> namespaces = ((NamespacedMapping)((ClassMapping)mappings.get((int)0)).mapping).getNamespaces();
            String namespace0 = (String)namespaces.iterator().next();
            lines.add("v1\t" + String.join((CharSequence)"\t", namespaces));
            mappings.parallelStream().forEach(cls -> {
                NamespacedMapping classMapping = (NamespacedMapping)cls.mapping;
                ObjectArrayList objectArrayList = lines;
                synchronized (objectArrayList) {
                    lines.add("CLASS\t" + NamingUtil.concatNamespaces(namespaces, classMapping::getName, "\t"));
                }
                cls.getFields().parallelStream().forEach(field -> {
                    String desc = MappingUtil.Namespaced.checkTiny(namespace0, cls, field);
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        lines.add("FIELD\t" + classMapping.getName(namespace0) + "\t" + desc + "\t" + NamingUtil.concatNamespaces(namespaces, field::getName, "\t"));
                    }
                });
                cls.getMethods().parallelStream().forEach(method -> {
                    String desc = MappingUtil.Namespaced.checkTiny(namespace0, cls, method);
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        lines.add("METHOD\t" + classMapping.getName(namespace0) + "\t" + desc + "\t" + NamingUtil.concatNamespaces(namespaces, method::getName, "\t"));
                    }
                });
            });
            return lines;
        }
    };
    public static final MappingGenerator.Classified<NamespacedMapping> TINY_V2 = new MappingGenerator.Classified<NamespacedMapping>(){

        @Override
        public MappingType<NamespacedMapping, ObjectList<ClassMapping<NamespacedMapping>>> getType() {
            return MappingTypes.TINY_V2;
        }

        @Override
        public ObjectList<String> generate(ObjectList<ClassMapping<NamespacedMapping>> mappings, ClassifiedMappingRemapper remapper) {
            ObjectArrayList<String> lines = new ObjectArrayList<String>();
            if (mappings.isEmpty()) {
                return lines;
            }
            ObjectSet<String> namespaces = ((NamespacedMapping)((ClassMapping)mappings.get((int)0)).mapping).getNamespaces();
            String namespace0 = (String)namespaces.iterator().next();
            lines.add("tiny\t2\t0\t" + String.join((CharSequence)"\t", namespaces));
            mappings.forEach(cls -> {
                lines.add("c\t" + NamingUtil.concatNamespaces(namespaces, ((NamespacedMapping)cls.mapping)::getName, "\t"));
                cls.getFields().parallelStream().forEach(field -> {
                    String desc = MappingUtil.Namespaced.checkTiny(namespace0, cls, field);
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        String doc;
                        lines.add("\tf\t" + desc + "\t" + NamingUtil.concatNamespaces(namespaces, field::getName, "\t"));
                        if (field.hasComponent(Documented.class) && (doc = field.getComponent(Documented.class).getDoc()) != null && !doc.isBlank()) {
                            lines.add("\t\tc\t" + doc);
                        }
                    }
                });
                cls.getMethods().parallelStream().forEach(method -> {
                    String desc = MappingUtil.Namespaced.checkTiny(namespace0, cls, method);
                    ObjectArrayList objectArrayList = lines;
                    synchronized (objectArrayList) {
                        String doc;
                        lines.add("\tm\t" + desc + "\t" + NamingUtil.concatNamespaces(namespaces, method::getName, "\t"));
                        if (method.hasComponent(Documented.class) && (doc = method.getComponent(Documented.class).getDoc()) != null && !doc.isBlank()) {
                            lines.add("\t\tc\t" + doc);
                        }
                        if (method.hasComponent(LocalVariableTable.Namespaced.class)) {
                            LocalVariableTable.Namespaced lvt = method.getComponent(LocalVariableTable.Namespaced.class);
                            boolean omittedThis = method.hasComponent(StaticIdentifiable.class) && !method.getComponent(StaticIdentifiable.class).isStatic;
                            lvt.getLocalVariableIndexes().forEach(index -> {
                                String doc;
                                NamespacedMapping localVariable = lvt.getLocalVariable(omittedThis ? index + 1 : index);
                                String names = NamingUtil.concatNamespaces(namespaces, namespace -> {
                                    String name = localVariable.getName((String)namespace);
                                    if (name == null || name.isBlank()) {
                                        return "";
                                    }
                                    return name;
                                }, "\t");
                                lines.add("\t\tp\t" + index + "\t" + names);
                                if (localVariable.hasComponent(Documented.class) && (doc = localVariable.getComponent(Documented.class).getDoc()) != null && !doc.isBlank()) {
                                    lines.add("\t\t\tc\t" + doc);
                                }
                            });
                        }
                    }
                });
            });
            return lines;
        }
    };
}

