/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.writer;

import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectArrayList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectLists;
import cn.maxpixel.mcdecompiler.mapping.Mapping;
import cn.maxpixel.mcdecompiler.mapping.type.MappingType;
import cn.maxpixel.mcdecompiler.util.Logging;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMappingWriter<M extends Mapping, C, T extends MappingType<M, C>> {
    protected static final Logger LOGGER = Logging.getLogger("Mapping Writer");
    protected final T type;
    private final ObjectList<M> packages;

    public AbstractMappingWriter(@NotNull T type) {
        this.type = type;
        this.packages = type.getGenerator().supportPackage() ? new ObjectArrayList() : ObjectLists.emptyList();
    }

    public abstract void addMappings(@NotNull C var1);

    public final void addPackage(@NotNull M pkg) {
        if (!this.type.getGenerator().supportPackage()) {
            throw new UnsupportedOperationException();
        }
        this.packages.add(pkg);
    }

    public final void addPackages(@NotNull Collection<M> packages) {
        if (!this.type.getGenerator().supportPackage()) {
            throw new UnsupportedOperationException();
        }
        this.packages.addAll(packages);
    }

    public final void addPackages(@NotNull ObjectList<M> packages) {
        if (!this.type.getGenerator().supportPackage()) {
            throw new UnsupportedOperationException();
        }
        this.packages.addAll(packages);
    }

    protected abstract C getCollection();

    protected abstract void clearCollection();

    private ObjectList<String> generate() {
        ObjectList<String> output = this.type.getGenerator().generate(this.getCollection());
        if (this.type.supportPackage() && !this.packages.isEmpty()) {
            output.addAll(this.type.getGenerator().generatePackages(this.packages));
        }
        this.clearCollection();
        this.packages.clear();
        return output;
    }

    private ObjectList<String>[] generateMulti() {
        ObjectList<String>[] output = this.type.getGenerator().generateMulti(this.getCollection());
        if (this.type.supportPackage()) {
            ObjectList<String>[] outputPackages = this.type.getGenerator().generatePackagesMulti(this.packages);
            if (output.length != outputPackages.length) {
                throw new UnsupportedOperationException("The length of the generated mappings array and the generated packages array must be the same.");
            }
            for (int i = 0; i < output.length; ++i) {
                output[i].addAll(outputPackages[i]);
            }
        }
        this.clearCollection();
        this.packages.clear();
        return output;
    }

    public final void writeTo(@NotNull OutputStream os) throws IOException {
        if (this.type.getGenerator().requireMultiFiles()) {
            throw new UnsupportedOperationException("Use writeTo(OutputStream...) instead.");
        }
        os.write(String.join((CharSequence)"\n", this.generate()).getBytes(StandardCharsets.UTF_8));
    }

    public final void writeTo(@NotNull Writer writer) throws IOException {
        if (this.type.getGenerator().requireMultiFiles()) {
            throw new UnsupportedOperationException("Use writeTo(Writer...) instead.");
        }
        writer.write(String.join((CharSequence)"\n", this.generate()));
    }

    public final void writeTo(@NotNull WritableByteChannel ch) throws IOException {
        if (this.type.getGenerator().requireMultiFiles()) {
            throw new UnsupportedOperationException("Use writeTo(WritableByteChannel...) instead.");
        }
        ch.write(ByteBuffer.wrap(String.join((CharSequence)"\n", this.generate()).getBytes(StandardCharsets.UTF_8)));
    }

    public final void writeTo(OutputStream ... os) throws IOException {
        if (!this.type.getGenerator().requireMultiFiles()) {
            throw new UnsupportedOperationException("Use writeTo(OutputStream) instead.");
        }
        ObjectList<String>[] output = this.generateMulti();
        if (output.length != os.length) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < output.length; ++i) {
            os[i].write(String.join((CharSequence)"\n", output[i]).getBytes(StandardCharsets.UTF_8));
        }
    }

    public final void writeTo(Writer ... writer) throws IOException {
        if (!this.type.getGenerator().requireMultiFiles()) {
            throw new UnsupportedOperationException("Use writeTo(Writer) instead.");
        }
        ObjectList<String>[] output = this.generateMulti();
        if (output.length != writer.length) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < output.length; ++i) {
            writer[i].write(String.join((CharSequence)"\n", output[i]));
        }
    }

    public final void writeTo(WritableByteChannel ... ch) throws IOException {
        if (!this.type.getGenerator().requireMultiFiles()) {
            throw new UnsupportedOperationException("Use writeTo(WritableByteChannel) instead.");
        }
        ObjectList<String>[] output = this.generateMulti();
        if (output.length != ch.length) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < output.length; ++i) {
            ch[i].write(ByteBuffer.wrap(String.join((CharSequence)"\n", output[i]).getBytes(StandardCharsets.UTF_8)));
        }
    }
}

