/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.util;

import cn.maxpixel.mcdecompiler.MinecraftDecompiler;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.Object2ObjectOpenHashMap;
import cn.maxpixel.mcdecompiler.deps.gson.JsonArray;
import cn.maxpixel.mcdecompiler.deps.gson.JsonElement;
import cn.maxpixel.mcdecompiler.deps.gson.JsonObject;
import cn.maxpixel.mcdecompiler.deps.gson.JsonParser;
import cn.maxpixel.mcdecompiler.util.Logging;
import cn.maxpixel.mcdecompiler.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NonBlocking;
import org.jetbrains.annotations.NotNull;

public class VersionManifest {
    private static final Logger LOGGER = Logging.getLogger();
    public static final CompletableFuture<String> LATEST_RELEASE;
    public static final CompletableFuture<String> LATEST_SNAPSHOT;
    private static final CompletableFuture<Object2ObjectOpenHashMap<String, URI>> VERSIONS;
    private static final Object2ObjectOpenHashMap<String, CompletableFuture<JsonObject>> CACHE;

    @Blocking
    public static JsonObject getSync(String versionId) {
        return VersionManifest.get(versionId).join();
    }

    @NonBlocking
    public static CompletableFuture<JsonObject> get(@Async.Schedule @NotNull String versionId) {
        return switch (Objects.requireNonNull(versionId, "versionId cannot be null!")) {
            case "latest_release" -> LATEST_RELEASE.thenCompose(VersionManifest::get);
            case "latest_snapshot" -> LATEST_SNAPSHOT.thenCompose(VersionManifest::get);
            default -> CACHE.computeIfAbsent(versionId, id -> ((CompletableFuture)((CompletableFuture)VERSIONS.thenCompose(versions -> {
                if (!versions.containsKey(id)) {
                    throw new IllegalArgumentException("Game ID \"" + id + "\" does not exists!");
                }
                return MinecraftDecompiler.HTTP_CLIENT.sendAsync(HttpRequest.newBuilder((URI)versions.get(id)).build(), HttpResponse.BodyHandlers.ofInputStream());
            })).thenApplyAsync(VersionManifest::parse)).whenComplete((o, t) -> {
                if (t != null) {
                    LOGGER.log(Level.SEVERE, "Error fetching Minecraft version JSON", (Throwable)t);
                }
            }));
        };
    }

    private static JsonObject parse(HttpResponse<InputStream> response) {
        JsonObject jsonObject;
        InputStreamReader isr = new InputStreamReader(response.body(), StandardCharsets.UTF_8);
        try {
            jsonObject = JsonParser.parseReader(isr).getAsJsonObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        }
        isr.close();
        return jsonObject;
    }

    static {
        CACHE = new Object2ObjectOpenHashMap();
        CompletionStage versionManifest = ((CompletableFuture)MinecraftDecompiler.HTTP_CLIENT.sendAsync(HttpRequest.newBuilder(URI.create("https://piston-meta.mojang.com/mc/game/version_manifest.json")).build(), HttpResponse.BodyHandlers.ofInputStream()).thenApplyAsync(VersionManifest::parse)).whenComplete((o, t) -> {
            if (t != null) {
                LOGGER.log(Level.SEVERE, "Error fetching Minecraft version manifest", (Throwable)t);
            }
        });
        CompletionStage latest = ((CompletableFuture)versionManifest).thenApply(obj -> obj.getAsJsonObject("latest"));
        LATEST_RELEASE = ((CompletableFuture)latest).thenApply(obj -> obj.get("release").getAsString());
        LATEST_SNAPSHOT = ((CompletableFuture)latest).thenApply(obj -> obj.get("snapshot").getAsString());
        VERSIONS = ((CompletableFuture)versionManifest).thenApplyAsync(o -> {
            JsonArray versions = o.getAsJsonArray("versions");
            return StreamSupport.stream(Spliterators.spliterator(versions.iterator(), (long)versions.size(), 1281), true).map(JsonElement::getAsJsonObject).collect(Collectors.toMap(obj -> obj.get("id").getAsString(), obj -> URI.create(obj.get("url").getAsString()), Utils::onKeyDuplicate, Object2ObjectOpenHashMap::new));
        });
    }
}

