/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.util;

import cn.maxpixel.mcdecompiler.mapping.Mapping;
import cn.maxpixel.mcdecompiler.mapping.type.MappingType;
import cn.maxpixel.mcdecompiler.mapping.type.MappingTypes;
import cn.maxpixel.mcdecompiler.util.LambdaUtil;
import cn.maxpixel.mcdecompiler.util.Logging;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class Utils {
    public static RuntimeException wrapInRuntime(Throwable e) {
        return new RuntimeException(e);
    }

    public static <I, O, E extends Throwable> O[] mapArray(I[] input, IntFunction<O[]> outputGenerator, LambdaUtil.Function_WithThrowable<I, O, E> func) throws E {
        Objects.requireNonNull(input);
        Objects.requireNonNull(outputGenerator);
        Objects.requireNonNull(func);
        O[] output = outputGenerator.apply(input.length);
        for (int i = 0; i < input.length; ++i) {
            output[i] = Objects.requireNonNull(func.apply(Objects.requireNonNull(input[i])));
        }
        return output;
    }

    public static void waitForProcess(Process pro) {
        Logger logger = Logging.getLogger("Process PID: " + pro.pid());
        try (BufferedReader in = new BufferedReader(new InputStreamReader(pro.getInputStream()));
             BufferedReader err = new BufferedReader(new InputStreamReader(pro.getErrorStream()));){
            Thread inT = new Thread(() -> {
                try {
                    String ins;
                    while ((ins = in.readLine()) != null) {
                        logger.fine(ins);
                    }
                }
                catch (Throwable e) {
                    logger.throwing("Utils", "waitForProcess", e);
                }
            });
            Thread errT = new Thread(() -> {
                try {
                    String ins;
                    while ((ins = err.readLine()) != null) {
                        logger.warning(ins);
                    }
                }
                catch (Throwable e) {
                    logger.throwing("Utils", "waitForProcess", e);
                }
            });
            inT.setDaemon(true);
            errT.setDaemon(true);
            inT.start();
            errT.start();
            pro.waitFor();
        }
        catch (IOException | InterruptedException e) {
            logger.throwing("Utils", "waitForProcess", e);
        }
    }

    public static <T> T onKeyDuplicate(T t, T u) {
        throw new IllegalArgumentException("Key duplicated for \"" + t + "\" and \"" + u + "\"");
    }

    public static MappingType.Classified<? extends Mapping> tryIdentifyingMappingType(String mappingPath) {
        MappingType.Classified<? extends Mapping> classified;
        block8: {
            Stream<String> lines = Files.lines(Path.of(mappingPath, new String[0]), StandardCharsets.UTF_8).filter(s -> !s.startsWith("#"));
            try {
                classified = Utils.tryIdentifyingMappingType(lines);
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Utils.wrapInRuntime(e);
                }
            }
            lines.close();
        }
        return classified;
    }

    public static MappingType.Classified<? extends Mapping> tryIdentifyingMappingType(BufferedReader reader) {
        try {
            reader.mark(512);
            MappingType.Classified<? extends Mapping> result = Utils.tryIdentifyingMappingType(reader.lines().filter(s -> !s.startsWith("#")));
            reader.reset();
            return result;
        }
        catch (IOException e) {
            throw Utils.wrapInRuntime(e);
        }
    }

    public static MappingType.Classified<? extends Mapping> tryIdentifyingMappingType(Stream<String> lines) {
        List<String> list = lines.limit(2L).toList();
        String s = list.get(0);
        if (s.startsWith("PK: ") || s.startsWith("CL: ") || s.startsWith("FD: ") || s.startsWith("MD: ")) {
            return MappingTypes.SRG;
        }
        if (s.startsWith("v1")) {
            return MappingTypes.TINY_V1;
        }
        if (s.startsWith("tiny\t2\t0")) {
            return MappingTypes.TINY_V2;
        }
        if (s.startsWith("tsrg2")) {
            return MappingTypes.TSRG_V2;
        }
        s = list.get(1);
        if (s.startsWith("    ")) {
            return MappingTypes.PROGUARD;
        }
        if (s.startsWith("\t")) {
            return MappingTypes.TSRG_V1;
        }
        return MappingTypes.CSRG;
    }

    public static StringBuilder createHashString(MessageDigest md) {
        StringBuilder out = new StringBuilder();
        for (byte b : md.digest()) {
            String hex = Integer.toHexString(Byte.toUnsignedInt(b));
            if (hex.length() < 2) {
                out.append('0');
            }
            out.append(hex);
        }
        return out;
    }
}

