/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.util;

import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectList;
import cn.maxpixel.mcdecompiler.deps.fastutil.objects.ObjectSet;
import cn.maxpixel.mcdecompiler.mapping.NamespacedMapping;
import cn.maxpixel.mcdecompiler.mapping.collection.ClassMapping;
import cn.maxpixel.mcdecompiler.mapping.component.Descriptor;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class NamingUtil {
    public static int getDimension(@NotNull String javaName) {
        int arrDimension = 0;
        int i = javaName.indexOf("[]");
        while (i != -1) {
            ++arrDimension;
            i = javaName.indexOf("[]", i + 2);
        }
        return arrDimension;
    }

    public static String findSourceNamespace(@NotNull ObjectList<ClassMapping<NamespacedMapping>> mappings) {
        return mappings.parallelStream().map(mapping -> ((NamespacedMapping)mapping.mapping).getUnmappedNamespace()).filter(Objects::nonNull).findAny().or(() -> mappings.parallelStream().flatMap(cm -> cm.getMethods().parallelStream()).filter(mapping -> mapping.hasComponent(Descriptor.Namespaced.class)).map(mapping -> mapping.getComponent(Descriptor.Namespaced.class).descriptorNamespace).findAny()).orElseThrow(() -> new NullPointerException("No source namespace found"));
    }

    public static String concatNamespaces(@NotNull ObjectSet<String> namespaces, @NotNull Function<String, String> namespaceMapper, @NotNull String delimiter) {
        return namespaces.stream().map(namespaceMapper).peek(name -> {
            if (name == null) {
                throw new IllegalArgumentException("Namespace mismatch");
            }
        }).collect(Collectors.joining(delimiter));
    }

    public static String asJavaName(@NotNull String pureNativeName) {
        return pureNativeName.replace('/', '.');
    }

    public static String asNativeName(@NotNull String javaName) {
        return javaName.replace('.', '/');
    }

    public static String file2Native(@NotNull String fileName) {
        return fileName.replace('\\', '/').replace(".class", "");
    }

    public static String java2Descriptor(@NotNull String javaName) {
        if (javaName.isBlank()) {
            return "";
        }
        if (!javaName.contains("[]")) {
            return switch (javaName) {
                case "boolean" -> "Z";
                case "byte" -> "B";
                case "char" -> "C";
                case "double" -> "D";
                case "float" -> "F";
                case "int" -> "I";
                case "long" -> "J";
                case "short" -> "S";
                case "void" -> "V";
                default -> "L" + NamingUtil.asNativeName(javaName) + ";";
            };
        }
        String dim = "[".repeat(NamingUtil.getDimension(javaName));
        return switch (javaName = javaName.replace("[]", "")) {
            case "boolean" -> dim + "Z";
            case "byte" -> dim + "B";
            case "char" -> dim + "C";
            case "double" -> dim + "D";
            case "float" -> dim + "F";
            case "int" -> dim + "I";
            case "long" -> dim + "J";
            case "short" -> dim + "S";
            case "void" -> dim + "V";
            default -> dim + "L" + NamingUtil.asNativeName(javaName) + ";";
        };
    }
}

