/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.util;

import cn.maxpixel.mcdecompiler.asm.ClassifiedMappingRemapper;
import cn.maxpixel.mcdecompiler.deps.asm.Type;
import java.util.StringJoiner;
import org.jetbrains.annotations.Nullable;

public record MixinTargetSelector(@Nullable Type owner, @Nullable String name, @Nullable String quantifier, @Nullable String descriptor, boolean field) {
    public static MixinTargetSelector parse(String pattern) {
        String p = pattern;
        Type owner = null;
        if (p.charAt(0) == 'L') {
            int i = p.indexOf(59);
            int j = p.indexOf(40);
            int k = p.indexOf(58);
            if (!(i == -1 || j != -1 && i >= j || j != -1 && i >= k)) {
                owner = Type.getType(p.substring(0, i + 1));
                p = p.substring(i + 1);
            }
        } else if (p.indexOf(46) != -1) {
            String[] sa = p.split("\\.");
            StringJoiner joiner = new StringJoiner("/");
            for (int i = 0; i < sa.length - 1; ++i) {
                joiner.add(sa[i]);
            }
            owner = Type.getObjectType(joiner.toString());
            p = sa[sa.length - 1];
        }
        String name = null;
        String quantifier = null;
        String descriptor = null;
        boolean field = false;
        int i = 0;
        i = p.indexOf(42);
        if (i != -1) {
            if (i > 0) {
                name = p.substring(0, i);
            }
            quantifier = "*";
            p = p.substring(i + 1);
        } else {
            i = p.indexOf(43);
            if (i != -1) {
                if (i > 0) {
                    name = p.substring(0, i);
                }
                quantifier = "+";
                p = p.substring(i + 1);
            } else {
                i = p.indexOf(123);
                if (i != -1) {
                    int end = p.indexOf(125);
                    if (i > 0) {
                        name = p.substring(0, i);
                    }
                    quantifier = p.substring(i, end + 1);
                    p = p.substring(end + 1);
                } else {
                    i = p.indexOf(40);
                    if (i != -1) {
                        name = p.substring(0, i);
                        p = p.substring(i);
                    } else {
                        i = p.indexOf(58);
                        if (i != -1) {
                            field = true;
                            name = p.substring(0, i);
                            p = p.substring(i + 1);
                        } else {
                            name = p;
                            p = "";
                        }
                    }
                }
            }
        }
        if (!p.isEmpty()) {
            if (p.charAt(0) == '(' || field) {
                descriptor = p;
            } else {
                throw new IllegalArgumentException("Cannot parse pattern: " + pattern);
            }
        }
        return new MixinTargetSelector(owner, name, quantifier, descriptor, field);
    }

    public MixinTargetSelector remap(ClassifiedMappingRemapper remapper, String mappedName) {
        return new MixinTargetSelector(this.owner == null ? null : Type.getType(remapper.mapToMapped(this.owner)), mappedName, this.quantifier, this.descriptor == null ? null : (this.field ? remapper.mapToMapped(Type.getType(this.descriptor)) : remapper.getMappedDescByUnmappedDesc(this.descriptor)), this.field);
    }

    public String toSelectorString() {
        StringBuilder builder = new StringBuilder();
        if (this.owner != null) {
            builder.append(this.owner.getDescriptor());
        }
        if (this.name != null) {
            builder.append(this.name);
        }
        if (this.quantifier != null) {
            builder.append(this.quantifier);
        }
        if (this.descriptor != null) {
            if (this.field) {
                builder.append(':');
            }
            builder.append(this.descriptor);
        }
        return builder.toString();
    }
}

