/*
 * Decompiled with CFR 0.152.
 */
package cn.maxpixel.mcdecompiler.util;

import cn.maxpixel.mcdecompiler.asm.ClassifiedMappingRemapper;
import cn.maxpixel.mcdecompiler.mapping.Mapping;
import cn.maxpixel.mcdecompiler.mapping.NamespacedMapping;
import cn.maxpixel.mcdecompiler.mapping.PairedMapping;
import cn.maxpixel.mcdecompiler.mapping.collection.ClassMapping;
import cn.maxpixel.mcdecompiler.mapping.component.Descriptor;
import cn.maxpixel.mcdecompiler.mapping.component.Documented;
import cn.maxpixel.mcdecompiler.mapping.component.LineNumber;
import cn.maxpixel.mcdecompiler.mapping.component.LocalVariableTable;
import cn.maxpixel.mcdecompiler.mapping.component.Owned;
import cn.maxpixel.mcdecompiler.mapping.component.StaticIdentifiable;

public final class MappingUtil {
    public static <T extends Mapping> void checkOwner(Owned<T> owned, ClassMapping<T> owner) {
        if (owned.owner != owner) {
            throw new IllegalArgumentException("Owner mismatch");
        }
    }

    public static final class Namespaced {
        public static String checkTiny(String namespace0, ClassMapping<NamespacedMapping> cls, NamespacedMapping mapping) {
            if (!mapping.hasComponent(Owned.class) || !mapping.hasComponent(Descriptor.Namespaced.class)) {
                throw new UnsupportedOperationException();
            }
            MappingUtil.checkOwner(mapping.getOwned(), cls);
            Descriptor.Namespaced desc = mapping.getComponent(Descriptor.Namespaced.class);
            if (!namespace0.equals(desc.getDescriptorNamespace())) {
                throw new IllegalArgumentException("Descriptor namespace mismatch");
            }
            return desc.getUnmappedDescriptor();
        }

        public static NamespacedMapping o(String[] namespaces, String[] names) {
            return new NamespacedMapping(namespaces, names, new Owned()).setUnmappedNamespace(namespaces[0]);
        }

        public static NamespacedMapping d(String[] namespaces, String[] names, int start) {
            return new NamespacedMapping(namespaces, names, start, new Documented()).setUnmappedNamespace(namespaces[0]);
        }

        public static NamespacedMapping duo(String[] namespaces, String[] names, int start, String descNamespace, String desc) {
            return new NamespacedMapping(namespaces, names, start, new Owned(), new Descriptor.Namespaced(desc, descNamespace)).setUnmappedNamespace(namespaces[0]);
        }

        public static NamespacedMapping dduo(String[] namespaces, String[] names, int start, String descNamespace, String desc) {
            return new NamespacedMapping(namespaces, names, start, new Owned(), new Descriptor.Namespaced(desc, descNamespace), new Documented()).setUnmappedNamespace(namespaces[0]);
        }

        public static NamespacedMapping slduo(String[] namespaces, String[] names, int start, String descNamespace, String desc) {
            return new NamespacedMapping(namespaces, names, start, new Owned(), new Descriptor.Namespaced(desc, descNamespace), new StaticIdentifiable(), new LocalVariableTable.Namespaced().setUnmappedNamespace(namespaces[0])).setUnmappedNamespace(namespaces[0]);
        }

        public static NamespacedMapping dlduo(String[] namespaces, String[] names, int start, String descNamespace, String desc) {
            return new NamespacedMapping(namespaces, names, start, new Owned(), new Descriptor.Namespaced(desc, descNamespace), new Documented(), new LocalVariableTable.Namespaced().setUnmappedNamespace(namespaces[0])).setUnmappedNamespace(namespaces[0]);
        }
    }

    public static final class Paired {
        public static String checkSlimSrgMethod(ClassMapping<PairedMapping> cls, PairedMapping method, ClassifiedMappingRemapper remapper) {
            if (!method.hasComponent(Owned.class)) {
                throw new UnsupportedOperationException();
            }
            MappingUtil.checkOwner(method.getOwned(), cls);
            if (method.hasComponent(Descriptor.class)) {
                return method.getComponent(Descriptor.class).getUnmappedDescriptor();
            }
            if (remapper != null && method.hasComponent(Descriptor.Mapped.class)) {
                return remapper.getUnmappedDescByMappedDesc(method.getComponent(Descriptor.Mapped.class).getMappedDescriptor());
            }
            throw new UnsupportedOperationException();
        }

        public static PairedMapping o(String unmapped, String mapped) {
            return new PairedMapping(unmapped, mapped, new Owned());
        }

        public static PairedMapping duo(String unmapped, String mapped, String unmappedDesc) {
            return new PairedMapping(unmapped, mapped, new Descriptor(unmappedDesc), new Owned());
        }

        public static PairedMapping dmo(String unmapped, String mapped, String mappedDesc) {
            return new PairedMapping(unmapped, mapped, new Descriptor.Mapped(mappedDesc), new Owned());
        }

        public static PairedMapping ldmo(String unmapped, String mapped, String mappedDesc, int start, int end) {
            return new PairedMapping(unmapped, mapped, new LineNumber(start, end), new Descriptor.Mapped(mappedDesc), new Owned());
        }

        public static PairedMapping d2o(String unmapped, String mapped, String unmappedDesc, String mappedDesc) {
            return new PairedMapping(unmapped, mapped, new Descriptor(unmappedDesc), new Descriptor.Mapped(mappedDesc), new Owned());
        }
    }
}

